/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Lists;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.cost.Cost;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Map;

public class CountersPutAllAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        boolean chance;
        int amount;
        CardCollection cList;
        CardCollection hList;
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        String type = sa.getParam("CounterType");
        String amountStr = sa.getParamOrDefault("CounterNum", "1");
        String valid = sa.getParam("ValidCards");
        String logic = sa.getParamOrDefault("AILogic", "");
        boolean curse = sa.isCurse();
        TargetRestrictions tgt = sa.getTargetRestrictions();
        if ("OwnCreatsAndOtherPWs".equals(logic)) {
            hList = CardLists.getValidCards((Iterable<Card>)ai.getWeakestOpponent().getCardsIn(ZoneType.Battlefield), "Creature.YouCtrl,Planeswalker.YouCtrl+Other", source.getController(), source, (CardTraitBase)sa);
            cList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), "Creature.YouCtrl,Planeswalker.YouCtrl+Other", source.getController(), source, (CardTraitBase)sa);
        } else {
            hList = CardLists.getValidCards((Iterable<Card>)ai.getWeakestOpponent().getCardsIn(ZoneType.Battlefield), valid, source.getController(), source, (CardTraitBase)sa);
            cList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), valid, source.getController(), source, (CardTraitBase)sa);
        }
        if (abCost != null) {
            if (!ComputerUtilCost.checkLifeCost(ai, abCost, source, 8, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkDiscardCost(ai, abCost, source, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkSacrificeCost(ai, abCost, source, sa)) {
                return false;
            }
        }
        if (logic.equals("AtEOTOrBlock") ? !ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN) && !ai.getGame().getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS) : logic.equals("AtOppEOT") && (!ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN) || ai.getGame().getPhaseHandler().getNextTurn() != ai)) {
            return false;
        }
        if (tgt != null) {
            Player pl = curse ? ai.getWeakestOpponent() : ai;
            sa.getTargets().add(pl);
            hList = CardLists.filterControlledBy((Iterable<Card>)hList, pl);
            cList = CardLists.filterControlledBy((Iterable<Card>)cList, pl);
        }
        if (amountStr.equals("X") && sa.getSVar(amountStr).equals("Count$xPaid")) {
            amount = ComputerUtilCost.getMaxXValue(sa, ai, sa.isTrigger());
            sa.setXManaCostPaid(amount);
        } else {
            amount = AbilityUtils.calculateAmount(source, amountStr, sa);
        }
        boolean bl = chance = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        if (curse) {
            CardCollection killable;
            if (type.equals("M1M1") ? (killable = CardLists.filter((Iterable<Card>)hList, c -> c.getNetToughness() <= amount)).size() <= 2 : cList.size() > hList.size()) {
                return false;
            }
        } else {
            if (hList.size() >= cList.size()) {
                return false;
            }
            PhaseHandler phase = ai.getGame().getPhaseHandler();
            if (type.equals("P1P1") && sa.isAbility() && source.isCreature() && sa.getPayCosts().hasTapCost() && sa instanceof AbilitySub && (!phase.getNextTurn().equals(ai) || phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS))) {
                boolean combatants = false;
                for (Card c2 : hList) {
                    if (c2.equals(source) || !c2.isUntapped()) continue;
                    combatants = true;
                    break;
                }
                if (!combatants) {
                    return false;
                }
            }
        }
        if (CountersPutAllAi.playReusable(ai, sa)) {
            return chance;
        }
        return (double)MyRandom.getRandom().nextFloat() < 0.6667 && chance;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player ai) {
        return this.canPlayAI(ai, sa);
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        return player.getCreaturesInPlay().size() >= player.getWeakestOpponent().getCreaturesInPlay().size();
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        if (sa.usesTargeting()) {
            ArrayList<Player> players = Lists.newArrayList();
            if (!sa.isCurse()) {
                players.add(aiPlayer);
            }
            players.addAll(aiPlayer.getOpponents());
            players.addAll(aiPlayer.getAllies());
            if (sa.isCurse()) {
                players.add(aiPlayer);
            }
            for (Player p : players) {
                if (!sa.canTarget(p)) continue;
                boolean preferred = false;
                preferred = sa.isCurse() && p.isOpponentOf(aiPlayer) || !sa.isCurse() && p == aiPlayer;
                sa.resetTargets();
                sa.getTargets().add(p);
                return preferred || mandatory;
            }
        }
        return mandatory || this.canPlayAI(aiPlayer, sa);
    }
}

