/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCost;
import forge.ai.SpellAbilityAi;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class CountersMultiplyAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        CounterType counterType = this.getCounterType(sa);
        if (!sa.usesTargeting()) {
            CardCollection list = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            if ((list = CardLists.filter((Iterable<Card>)list, c -> {
                if (!c.hasCounters()) {
                    return false;
                }
                if (counterType != null) {
                    if (c.getCounters(counterType) <= 0) {
                        return false;
                    }
                    if (!c.canReceiveCounters(counterType)) {
                        return false;
                    }
                } else {
                    for (Map.Entry<CounterType, Integer> e : c.getCounters().entrySet()) {
                        if (!ComputerUtil.isNegativeCounter(e.getKey(), c)) continue;
                        return false;
                    }
                }
                return true;
            })).isEmpty()) {
                return false;
            }
        } else {
            return this.setTargets(ai, sa);
        }
        return super.checkApiLogic(ai, sa);
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        CounterType counterType = this.getCounterType(sa);
        if (counterType != null && !counterType.is(CounterEnumType.P1P1) && !sa.hasParam("ActivationPhases")) {
            if (ph.getPhase().isBefore(PhaseType.MAIN2) && !ComputerUtil.castSpellInMain1(ai, sa)) {
                return false;
            }
            if (ph.isPlayerTurn(ai) && !CountersMultiplyAi.isSorcerySpeed(sa, ai)) {
                return false;
            }
        }
        return !ComputerUtil.waitForBlocking(sa);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        if (!sa.usesTargeting()) {
            return true;
        }
        if (this.setTargets(ai, sa)) {
            return true;
        }
        if (mandatory) {
            CardCollection list = CardLists.getTargetableCards(ai.getGame().getCardsIn(ZoneType.Battlefield), sa);
            if (list.isEmpty()) {
                return false;
            }
            Card safeMatch = Iterables.getFirst(Iterables.filter(list, Predicates.not(CardPredicates.hasCounters())), null);
            sa.getTargets().add(safeMatch == null ? (GameObject)list.getFirst() : safeMatch);
            return true;
        }
        return mandatory;
    }

    private CounterType getCounterType(SpellAbility sa) {
        if (sa.hasParam("CounterType")) {
            try {
                return CounterType.getType(sa.getParam("CounterType"));
            }
            catch (Exception e) {
                System.out.println("Counter type doesn't match, nor does an SVar exist with the type name.");
                return null;
            }
        }
        return null;
    }

    private boolean setTargets(Player ai, SpellAbility sa) {
        CardCollection oppList;
        CounterType counterType = this.getCounterType(sa);
        Game game = ai.getGame();
        CardCollection list = CardLists.getTargetableCards(game.getCardsIn(ZoneType.Battlefield), sa);
        CardCollection aiList = CardLists.filterControlledBy((Iterable<Card>)(list = CardLists.filter((Iterable<Card>)list, c -> {
            if (!c.hasCounters()) {
                return false;
            }
            if (counterType != null) {
                if (c.getCounters(counterType) <= 0) {
                    return false;
                }
                if (!c.canReceiveCounters(counterType)) {
                    return false;
                }
            }
            return true;
        })), ai);
        if (!aiList.isEmpty()) {
            ArrayList<CounterEnumType> typeList = Lists.newArrayList(CounterEnumType.LOYALTY, CounterEnumType.P1P1, CounterEnumType.CHARGE);
            for (CounterEnumType type : typeList) {
                if (!sa.canAddMoreTarget()) break;
                if (counterType != null && !counterType.is(type)) continue;
                this.addTargetsByCounterType(ai, sa, aiList, CounterType.get(type));
            }
        }
        if (!(oppList = CardLists.filterControlledBy((Iterable<Card>)list, ai.getOpponents())).isEmpty() && sa.canAddMoreTarget()) {
            CounterType type = CounterType.get(CounterEnumType.M1M1);
            if (counterType == null || counterType == type) {
                this.addTargetsByCounterType(ai, sa, oppList, type);
            }
        }
        if (!sa.isTargetNumberValid() || sa.getTargets().size() == 0) {
            sa.resetTargets();
            return false;
        }
        return true;
    }

    private void addTargetsByCounterType(Player ai, SpellAbility sa, CardCollection list, CounterType type) {
        CardCollection newList = CardLists.filter((Iterable<Card>)list, CardPredicates.hasCounter(type));
        if (newList.isEmpty()) {
            return;
        }
        newList.sort(Collections.reverseOrder(CardPredicates.compareByCounterType(type)));
        while (sa.canAddMoreTarget() && !newList.isEmpty()) {
            Card c = (Card)newList.remove(0);
            sa.getTargets().add(c);
            if (!sa.isSpell() || !sa.getHostCard().hasKeyword(Keyword.STRIVE) || ComputerUtilCost.canPayCost(sa, ai, false)) continue;
            sa.getTargets().remove(c);
            break;
        }
    }
}

