/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.AiController;
import forge.ai.AiProps;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.effects.CounterEffect;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostExile;
import forge.game.cost.CostSacrifice;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CounterAi
extends SpellAbilityAi {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        String unlessCost;
        boolean toReturn = true;
        Cost abCost = sa.getPayCosts();
        Card source = sa.getHostCard();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        Game game = ai.getGame();
        int tgtCMC = 0;
        SpellAbility tgtSA = null;
        if (game.getStack().isEmpty()) {
            return false;
        }
        if (abCost != null) {
            if (!ComputerUtilCost.checkSacrificeCost(ai, abCost, source, sa)) {
                return false;
            }
            if (!ComputerUtilCost.checkLifeCost(ai, abCost, source, 4, sa)) {
                return false;
            }
        }
        if ("Force of Will".equals(sourceName) && !SpecialCardAi.ForceOfWill.consider(ai, sa)) {
            return false;
        }
        if (!sa.usesTargeting()) return false;
        SpellAbility topSA = ComputerUtilAbility.getTopSpellAbilityOnStack(game, sa);
        if (topSA.isSpell() && !topSA.isCounterableBy(sa) || ai.getYourTeam().contains(topSA.getActivatingPlayer())) {
            return false;
        }
        if (sa.hasParam("ConditionWouldDestroy") && !CounterEffect.checkForConditionWouldDestroy(sa, topSA)) {
            return false;
        }
        if (sa.hasParam("AITgts") && (topSA.getHostCard() == null || !topSA.getHostCard().isValid(sa.getParam("AITgts"), sa.getActivatingPlayer(), source, (CardTraitBase)sa))) {
            return false;
        }
        if (sa.hasParam("CounterNoManaSpell") && topSA.getTotalManaSpent() > 0) {
            return false;
        }
        if ("OppDiscardsHand".equals(sa.getParam("AILogic")) && topSA.getActivatingPlayer().getCardsIn(ZoneType.Hand).size() < 2) {
            return false;
        }
        sa.resetTargets();
        if (!sa.canTargetSpellAbility(topSA)) return false;
        sa.getTargets().add(topSA);
        if (topSA.getPayCosts().getTotalMana() != null) {
            tgtSA = topSA;
            tgtCMC = topSA.getPayCosts().getTotalMana().getCMC();
            tgtCMC += topSA.getPayCosts().getTotalMana().countX() > 0 ? 3 : 0;
        }
        String string = unlessCost = sa.hasParam("UnlessCost") ? sa.getParam("UnlessCost").trim() : null;
        if (unlessCost != null && !unlessCost.endsWith(">")) {
            Player opp = tgtSA.getActivatingPlayer();
            int usableManaSources = ComputerUtilMana.getAvailableManaEstimate(opp);
            int toPay = 0;
            boolean setPayX = false;
            if (unlessCost.equals("X") && sa.getSVar(unlessCost).equals("Count$xPaid")) {
                setPayX = true;
                toPay = Math.min(ComputerUtilCost.getMaxXValue(sa, ai, true), usableManaSources + 1);
            } else {
                toPay = AbilityUtils.calculateAmount(source, unlessCost, sa);
            }
            if (toPay == 0) {
                return false;
            }
            if (toPay <= usableManaSources && !CounterAi.playReusable(ai, sa)) {
                return false;
            }
            if (setPayX) {
                sa.setXManaCostPaid(toPay);
            }
        }
        if (sa.hasParam("AILogic")) {
            int minCMC;
            String logic = sa.getParam("AILogic");
            if ("Never".equals(logic)) {
                return false;
            }
            if (logic.startsWith("MinCMC.") ? tgtCMC < (minCMC = Integer.parseInt(logic.substring(7))) : "NullBrooch".equals(logic) && !SpecialCardAi.NullBrooch.consider(ai, sa)) {
                return false;
            }
        }
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        boolean ctrCmc0ManaPerms = aic.getBooleanProperty(AiProps.ALWAYS_COUNTER_CMC_0_MANA_MAKING_PERMS);
        boolean ctrDamageSpells = aic.getBooleanProperty(AiProps.ALWAYS_COUNTER_DAMAGE_SPELLS);
        boolean ctrRemovalSpells = aic.getBooleanProperty(AiProps.ALWAYS_COUNTER_REMOVAL_SPELLS);
        boolean ctrPumpSpells = aic.getBooleanProperty(AiProps.ALWAYS_COUNTER_PUMP_SPELLS);
        boolean ctrAuraSpells = aic.getBooleanProperty(AiProps.ALWAYS_COUNTER_AURAS);
        boolean ctrOtherCounters = aic.getBooleanProperty(AiProps.ALWAYS_COUNTER_OTHER_COUNTERSPELLS);
        int ctrChanceCMC1 = aic.getIntProperty(AiProps.CHANCE_TO_COUNTER_CMC_1);
        int ctrChanceCMC2 = aic.getIntProperty(AiProps.CHANCE_TO_COUNTER_CMC_2);
        int ctrChanceCMC3 = aic.getIntProperty(AiProps.CHANCE_TO_COUNTER_CMC_3);
        String ctrNamed = aic.getProperty(AiProps.ALWAYS_COUNTER_SPELLS_FROM_NAMED_CARDS);
        boolean dontCounter = false;
        if (tgtCMC == 1 && !MyRandom.percentTrue(ctrChanceCMC1)) {
            dontCounter = true;
        } else if (tgtCMC == 2 && !MyRandom.percentTrue(ctrChanceCMC2)) {
            dontCounter = true;
        } else if (tgtCMC == 3 && !MyRandom.percentTrue(ctrChanceCMC3)) {
            dontCounter = true;
        }
        if (tgtSA != null && tgtCMC < aic.getIntProperty(AiProps.MIN_SPELL_CMC_TO_COUNTER)) {
            int validTgtCMC;
            dontCounter = true;
            Card tgtSource = tgtSA.getHostCard();
            if (tgtSource != null && tgtCMC == 0 && tgtSource.isPermanent() && !tgtSource.getManaAbilities().isEmpty() && ctrCmc0ManaPerms || tgtSA.getApi() == ApiType.DealDamage || tgtSA.getApi() == ApiType.LoseLife || tgtSA.getApi() == ApiType.DamageAll && ctrDamageSpells || tgtSA.getApi() == ApiType.Counter && ctrOtherCounters || (tgtSA.getApi() == ApiType.Pump || tgtSA.getApi() == ApiType.PumpAll) && ctrPumpSpells || tgtSA.getApi() == ApiType.Attach && ctrAuraSpells || tgtSA.getApi() == ApiType.Destroy || tgtSA.getApi() == ApiType.DestroyAll || tgtSA.getApi() == ApiType.Sacrifice || tgtSA.getApi() == ApiType.SacrificeAll && ctrRemovalSpells) {
                dontCounter = false;
            }
            if (tgtSource != null && !ctrNamed.isEmpty() && !"none".equalsIgnoreCase(ctrNamed)) {
                for (String name : StringUtils.split(ctrNamed, ";")) {
                    if (!name.equals(tgtSource.getName())) continue;
                    dontCounter = false;
                }
            }
            if (sa.getParamOrDefault("ValidTgts", "").startsWith("Card.cmcEQ") && tgtCMC == (validTgtCMC = AbilityUtils.calculateAmount(source, sa.getParam("ValidTgts").substring(10), sa))) {
                dontCounter = false;
            }
        }
        if (sa.isAbility() && !sa.getPayCosts().hasSpecificCostType(CostDiscard.class) && !sa.getPayCosts().hasSpecificCostType(CostSacrifice.class) && !sa.getPayCosts().hasSpecificCostType(CostExile.class)) {
            dontCounter = false;
        }
        if (sa.hasParam("AILogic") && "NullBrooch".equals(sa.getParam("AILogic"))) {
            dontCounter = false;
        }
        if (!dontCounter) return toReturn;
        return false;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        return this.doTriggerAINoCost(aiPlayer, sa, true);
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        Game game = ai.getGame();
        if (sa.usesTargeting()) {
            if (game.getStack().isEmpty()) {
                return false;
            }
            sa.resetTargets();
            Pair<SpellAbility, Boolean> pair = this.chooseTargetSpellAbility(game, sa, ai, mandatory);
            SpellAbility tgtSA = pair.getLeft();
            if (tgtSA == null) {
                return false;
            }
            sa.getTargets().add(tgtSA);
            if (!mandatory && !pair.getRight().booleanValue()) {
                return false;
            }
            String unlessCost = sa.hasParam("UnlessCost") ? sa.getParam("UnlessCost").trim() : null;
            Card source = sa.getHostCard();
            if (unlessCost != null) {
                Player opp = tgtSA.getActivatingPlayer();
                int usableManaSources = ComputerUtilMana.getAvailableManaEstimate(opp);
                int toPay = 0;
                boolean setPayX = false;
                if (unlessCost.equals("X") && sa.getSVar(unlessCost).equals("Count$xPaid")) {
                    setPayX = true;
                    toPay = ComputerUtilCost.getMaxXValue(sa, ai, true);
                } else {
                    toPay = AbilityUtils.calculateAmount(source, unlessCost, sa);
                }
                if (!mandatory) {
                    if (toPay == 0) {
                        return false;
                    }
                    if (toPay <= usableManaSources && (!CounterAi.playReusable(ai, sa) || (double)MyRandom.getRandom().nextFloat() < 0.4)) {
                        return false;
                    }
                }
                if (setPayX) {
                    sa.setXManaCostPaid(toPay);
                }
            }
        }
        return true;
    }

    public Pair<SpellAbility, Boolean> chooseTargetSpellAbility(Game game, SpellAbility sa, Player ai, boolean mandatory) {
        SpellAbility leastBadOption = null;
        SpellAbility bestOption = null;
        Iterator<SpellAbilityStackInstance> it = game.getStack().iterator();
        SpellAbilityStackInstance si = null;
        while (it.hasNext()) {
            si = it.next();
            SpellAbility tgtSA = si.getSpellAbility();
            if (!sa.canTargetSpellAbility(tgtSA)) continue;
            if (leastBadOption == null) {
                leastBadOption = tgtSA;
            }
            if (tgtSA.isSpell() && !tgtSA.isCounterableBy(sa) || tgtSA.getActivatingPlayer() == ai || !tgtSA.getActivatingPlayer().isOpponentOf(ai)) {
                if (leastBadOption.getActivatingPlayer().isOpponentOf(ai) || !sa.getActivatingPlayer().isOpponentOf(ai)) continue;
                leastBadOption = tgtSA;
                continue;
            }
            if (bestOption == null) {
                bestOption = tgtSA;
                continue;
            }
            boolean betterThanBest = false;
            if (!betterThanBest) continue;
            bestOption = tgtSA;
        }
        return new ImmutablePair<Object, Boolean>((bestOption != null ? bestOption : leastBadOption), bestOption != null);
    }
}

