/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.base.Predicates;
import forge.ai.ComputerUtilCard;
import forge.ai.SpellAbilityAi;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.Map;

public class CloneAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        boolean useAbility = true;
        if (!this.checkPhaseRestrictions(ai, sa, game.getPhaseHandler())) {
            return false;
        }
        PhaseHandler phase = game.getPhaseHandler();
        if (!sa.usesTargeting()) {
            CardCollection defined = AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa);
            boolean bFlag = false;
            for (Card c : defined) {
                bFlag |= !c.isCreature() && !c.isTapped() && c.getTurnInZone() != phase.getTurn();
                if (!c.isCreature() || sa.hasParam("Duration") && (c.isTapped() || c.isSick())) continue;
                int power = -5;
                if (sa.hasParam("Power")) {
                    power = AbilityUtils.calculateAmount(source, sa.getParam("Power"), sa);
                }
                int toughness = -5;
                if (sa.hasParam("Toughness")) {
                    toughness = AbilityUtils.calculateAmount(source, sa.getParam("Toughness"), sa);
                }
                if (power + toughness <= c.getCurrentPower() + c.getCurrentToughness()) continue;
                bFlag = true;
            }
            if (!bFlag) {
                return false;
            }
        } else {
            sa.resetTargets();
            useAbility &= this.cloneTgtAI(sa);
        }
        return useAbility;
    }

    @Override
    public boolean chkAIDrawback(SpellAbility sa, Player aiPlayer) {
        boolean chance = true;
        if (sa.usesTargeting()) {
            chance = this.cloneTgtAI(sa);
        }
        return chance;
    }

    @Override
    protected boolean doTriggerAINoCost(Player aiPlayer, SpellAbility sa, boolean mandatory) {
        Card host = sa.getHostCard();
        boolean chance = true;
        if (sa.usesTargeting()) {
            chance = this.cloneTgtAI(sa);
        } else if (sa.hasParam("Choices")) {
            CardCollection choices = CardLists.getValidCards((Iterable<Card>)host.getGame().getCardsIn(ZoneType.Battlefield), sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
            chance = !choices.isEmpty();
        }
        return chance || mandatory;
    }

    private boolean cloneTgtAI(SpellAbility sa) {
        if ("CloneAttacker".equals(sa.getParam("AILogic"))) {
            CardCollection valid = CardLists.getValidCards((Iterable<Card>)sa.getHostCard().getController().getCardsIn(ZoneType.Battlefield), sa.getParam("ValidTgts"), sa.getHostCard().getController(), sa.getHostCard(), (CardTraitBase)sa);
            sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(valid));
            return true;
        }
        if ("CloneBestCreature".equals(sa.getParam("AILogic"))) {
            CardCollection valid = CardLists.getValidCards((Iterable<Card>)sa.getHostCard().getController().getGame().getCardsIn(ZoneType.Battlefield), sa.getParam("ValidTgts"), sa.getHostCard().getController(), sa.getHostCard(), (CardTraitBase)sa);
            sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(valid));
            return true;
        }
        return false;
    }

    @Override
    public boolean confirmAction(Player player, SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        if (sa.hasParam("AILogic") && (!sa.usesTargeting() || sa.isTargetNumberValid())) {
            if ("CloneBestCreature".equals(sa.getParam("AILogic"))) {
                return ComputerUtilCard.evaluateCreature(sa.getTargetCard()) > ComputerUtilCard.evaluateCreature(sa.getHostCard());
            }
            if ("IfDefinedCreatureIsBetter".equals(sa.getParam("AILogic"))) {
                CardCollection defined = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
                Card bestDefined = ComputerUtilCard.getBestCreatureAI(defined);
                return ComputerUtilCard.evaluateCreature(bestDefined) > ComputerUtilCard.evaluateCreature(sa.getHostCard());
            }
        }
        return false;
    }

    @Override
    protected Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        String logic;
        CardCollection newOptions;
        String filter;
        Card host = sa.getHostCard();
        String name = host.getName();
        Player ctrl = host.getController();
        Card cloneTarget = this.getCloneTarget(sa);
        boolean isOpp = cloneTarget.getController().isOpponentOf(sa.getActivatingPlayer());
        boolean isVesuva = "Vesuva".equals(name) || "Sculpting Steel".equals(name);
        boolean canCloneLegendary = "True".equalsIgnoreCase(sa.getParam("NonLegendary"));
        String string = filter = !isVesuva ? "Permanent.YouDontCtrl,Permanent.nonLegendary" : "Permanent.YouDontCtrl+notnamed" + name + ",Permanent.nonLegendary+notnamed" + name;
        if (canCloneLegendary) {
            filter = filter.replace(".nonLegendary+", ".").replace(".nonLegendary", "");
        }
        if (!(newOptions = CardLists.getValidCards(options, filter, ctrl, host, (CardTraitBase)sa)).isEmpty()) {
            options = newOptions;
        }
        if (sa.hasParam("AiChoiceLogic") && "BestOppCtrl".equals(logic = sa.getParam("AiChoiceLogic"))) {
            options = CardLists.filterControlledBy((Iterable<Card>)options, ctrl.getOpponents());
        }
        if (isVesuva) {
            options = CardLists.filter((Iterable<Card>)options, Predicates.not(CardPredicates.sharesNameWith(host)));
        }
        Card choice = isOpp ? ComputerUtilCard.getWorstAI(options) : ComputerUtilCard.getBestAI(options);
        return choice;
    }

    protected Card getCloneTarget(SpellAbility sa) {
        Card host;
        Card tgtCard = host = sa.getHostCard();
        if (sa.hasParam("CloneTarget")) {
            CardCollection cloneTargets = AbilityUtils.getDefinedCards(host, sa.getParam("CloneTarget"), sa);
            if (!cloneTargets.isEmpty()) {
                tgtCard = (Card)cloneTargets.get(0);
            }
        } else if (sa.hasParam("Choices") && sa.usesTargeting()) {
            tgtCard = sa.getTargetCard();
        }
        return tgtCard;
    }

    @Override
    protected boolean checkPhaseRestrictions(Player ai, SpellAbility sa, PhaseHandler ph) {
        if (!ph.is(PhaseType.COMBAT_BEGIN) && ph.isPlayerTurn(ai) && !CloneAi.isSorcerySpeed(sa, ai) && !sa.hasParam("ActivationPhases") && sa.hasParam("Duration")) {
            return false;
        }
        if (!ph.is(PhaseType.COMBAT_DECLARE_ATTACKERS) || ph.isPlayerTurn(ai) || ph.getCombat().getAttackers().isEmpty()) {
            return false;
        }
        return !ph.is(PhaseType.MAIN2) || !sa.hasParam("Duration");
    }
}

