/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ability.ManifestBaseAi;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;

public class CloakAi
extends ManifestBaseAi {
    @Override
    protected boolean shouldApply(Card card, Player ai, SpellAbility sa) {
        Card topCopy = CardCopyService.getLKICopy(card);
        topCopy.turnFaceDownNoUpdate();
        topCopy.setCloaked(true);
        if (ComputerUtil.isETBprevented(topCopy)) {
            return false;
        }
        if (card.getView().canBeShownTo(ai.getView())) {
            if (!card.isPermanent()) {
                return false;
            }
            if (card.getManaCost().countX() > 0) {
                return false;
            }
            if (card.isCreature() && card.getNetToughness() <= 0) {
                return false;
            }
            if (card.hasETBTrigger(false) || card.hasETBReplacement()) {
                return false;
            }
        }
        return true;
    }
}

