/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import forge.ai.AiCardMemory;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellAbilityAi;
import forge.card.CardType;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import java.util.Arrays;
import java.util.HashSet;

public class ChooseTypeAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (aiLogic.isEmpty()) {
            return false;
        }
        if ("MostProminentComputerControls".equals(aiLogic)) {
            if (ComputerUtilAbility.getAbilitySourceName(sa).equals("Mirror Entity Avatar")) {
                return this.doMirrorEntityLogic(aiPlayer, sa);
            }
            return !this.chooseType(sa, aiPlayer.getCardsIn(ZoneType.Battlefield)).isEmpty();
        }
        if ("MostProminentComputerControlsOrOwns".equals(aiLogic)) {
            return !this.chooseType(sa, aiPlayer.getCardsIn(Arrays.asList(ZoneType.Hand, ZoneType.Battlefield))).isEmpty();
        }
        if ("MostProminentOppControls".equals(aiLogic)) {
            return !this.chooseType(sa, aiPlayer.getOpponents().getCardsIn(ZoneType.Battlefield)).isEmpty();
        }
        return this.doTriggerAINoCost(aiPlayer, sa, false);
    }

    private boolean doMirrorEntityLogic(Player aiPlayer, SpellAbility sa) {
        CardCollection cre;
        if (AiCardMemory.isRememberedCard(aiPlayer, sa.getHostCard(), AiCardMemory.MemorySet.ANIMATED_THIS_TURN)) {
            return false;
        }
        if (!aiPlayer.getGame().getPhaseHandler().is(PhaseType.MAIN1, aiPlayer)) {
            return false;
        }
        String chosenType = this.chooseType(sa, aiPlayer.getCardsIn(ZoneType.Battlefield));
        if (chosenType.isEmpty()) {
            return false;
        }
        int maxX = ComputerUtilMana.determineLeftoverMana(sa, aiPlayer, false);
        int avgPower = 0;
        CardCollection oppCreatures = CardLists.filter((Iterable<Card>)aiPlayer.getOpponents().getCreaturesInPlay(), CardPredicates.Presets.UNTAPPED);
        int maxOppPower = 0;
        int maxOppToughness = 0;
        int oppUsefulCreatures = 0;
        for (Object oppCre : oppCreatures) {
            if (ComputerUtilCard.isUselessCreature(aiPlayer, (Card)oppCre)) continue;
            if (((Card)oppCre).getNetPower() > maxOppPower) {
                maxOppPower = ((Card)oppCre).getNetPower();
            }
            if (((Card)oppCre).getNetToughness() > maxOppToughness) {
                maxOppToughness = ((Card)oppCre).getNetToughness();
            }
            ++oppUsefulCreatures;
        }
        if (maxX > 1 && !(cre = CardLists.filter(aiPlayer.getCardsIn(ZoneType.Battlefield), CardPredicates.isType(chosenType), CardPredicates.Presets.UNTAPPED)).isEmpty()) {
            boolean overpower;
            for (Card c : cre) {
                avgPower += c.getNetPower();
            }
            avgPower /= cre.size();
            boolean bl = overpower = cre.size() > oppUsefulCreatures;
            if (!overpower) {
                maxX = Math.max(0, maxX - 3);
            }
            if (maxX > avgPower && maxX > maxOppPower && maxX >= maxOppToughness) {
                sa.setXManaCostPaid(maxX);
                AiCardMemory.rememberCard(aiPlayer, sa.getHostCard(), AiCardMemory.MemorySet.ANIMATED_THIS_TURN);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        boolean isCurse = sa.isCurse();
        if (sa.usesTargeting()) {
            PlayerCollection oppList = ai.getOpponents().filter(PlayerPredicates.isTargetableBy(sa));
            PlayerCollection alliesList = ai.getAllies().filter(PlayerPredicates.isTargetableBy(sa));
            sa.resetTargets();
            if (isCurse) {
                if (!oppList.isEmpty()) {
                    sa.getTargets().add((GameObject)Iterables.getFirst(oppList, null));
                } else if (mandatory) {
                    if (!alliesList.isEmpty()) {
                        sa.getTargets().add((GameObject)Iterables.getFirst(alliesList, null));
                    } else if (ai.canBeTargetedBy(sa)) {
                        sa.getTargets().add(ai);
                    }
                }
            } else if (ai.canBeTargetedBy(sa)) {
                sa.getTargets().add(ai);
            } else if (!alliesList.isEmpty()) {
                sa.getTargets().add((GameObject)Iterables.getFirst(alliesList, null));
            } else if (!oppList.isEmpty() && mandatory) {
                sa.getTargets().add((GameObject)Iterables.getFirst(oppList, null));
            }
            if (!sa.isTargetNumberValid()) {
                return false;
            }
        } else {
            for (Player p : AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Defined"), sa)) {
                if (!p.isOpponentOf(ai) || mandatory || isCurse) continue;
                return false;
            }
        }
        return true;
    }

    private String chooseType(SpellAbility sa, CardCollectionView cards) {
        HashSet<String> valid = new HashSet<String>();
        if (sa.getSubAbility() != null && sa.getSubAbility().getApi() == ApiType.PumpAll && sa.getSubAbility().isCurse() && sa.getSubAbility().hasParam("NumDef")) {
            AbilitySub pumpSa = sa.getSubAbility();
            int defense = AbilityUtils.calculateAmount(sa.getHostCard(), pumpSa.getParam("NumDef"), pumpSa);
            for (Card c : cards) {
                if (!c.isCreature() || c.getNetToughness() > -defense) continue;
                valid.addAll(c.getType().getCreatureTypes());
            }
        } else {
            valid.addAll(CardType.getAllCreatureTypes());
        }
        String chosenType = ComputerUtilCard.getMostProminentType(cards, valid);
        if (chosenType.isEmpty()) {
            boolean allChangeling = false;
            for (Card c : cards) {
                if (!c.isCreature() || !c.hasKeyword(Keyword.CHANGELING)) continue;
                chosenType = Aggregates.random(valid);
                allChangeling = true;
                break;
            }
            if (!allChangeling) {
                return "";
            }
        }
        return chosenType;
    }
}

