/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class ChooseColorAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        String sourceName = ComputerUtilAbility.getAbilitySourceName(sa);
        PhaseHandler ph = game.getPhaseHandler();
        if (!sa.hasParam("AILogic")) {
            return false;
        }
        String logic = sa.getParam("AILogic");
        if (ComputerUtil.preventRunAwayActivations(sa)) {
            return false;
        }
        if ("Nykthos, Shrine to Nyx".equals(sourceName)) {
            return SpecialCardAi.NykthosShrineToNyx.consider(ai, sa);
        }
        if ("Oona, Queen of the Fae".equals(sourceName)) {
            if (ph.isPlayerTurn(ai) || ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
                return false;
            }
            sa.setXManaCostPaid(ComputerUtilCost.getMaxXValue(sa, ai, false));
            return true;
        }
        if ("Addle".equals(sourceName)) {
            return !ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && !ai.getWeakestOpponent().getCardsIn(ZoneType.Hand).isEmpty();
        }
        if (logic.equals("MostExcessOpponentControls")) {
            for (byte color : MagicColor.WUBRG) {
                CardCollectionView ailist = ai.getColoredCardsInPlay(color);
                CardCollectionView opplist = ai.getStrongestOpponent().getColoredCardsInPlay(color);
                int excess = ComputerUtilCard.evaluatePermanentList(opplist) - ComputerUtilCard.evaluatePermanentList(ailist);
                if (excess <= 4) continue;
                return true;
            }
            return false;
        }
        if (logic.equals("MostProminentInComputerDeck")) {
            if ("Astral Cornucopia".equals(sourceName)) {
                CardCollection permanents = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.NONLAND_PERMANENTS);
                return permanents.size() > 0 && ph.is(PhaseType.MAIN2, ai);
            }
        } else if (logic.equals("HighestDevotionToColor") && !ph.is(PhaseType.MAIN2, ai)) {
            return false;
        }
        boolean chance = (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
        return chance;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        return mandatory || this.canPlayAI(ai, sa);
    }
}

