/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.ai.AiAttackController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.card.CardDb;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.card.CardStateName;
import forge.card.ICardFace;
import forge.game.CardTraitBase;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetRestrictions;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChooseCardNameAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player ai, SpellAbility sa) {
        if (sa.hasParam("AILogic")) {
            if (ComputerUtil.waitForBlocking(sa)) {
                return false;
            }
            String logic = sa.getParam("AILogic");
            if (logic.equals("CursedScroll")) {
                return SpecialCardAi.CursedScroll.consider(ai, sa);
            }
            TargetRestrictions tgt = sa.getTargetRestrictions();
            if (tgt != null) {
                sa.resetTargets();
                if (tgt.canOnlyTgtOpponent()) {
                    sa.getTargets().add(AiAttackController.choosePreferredDefenderPlayer(ai));
                } else {
                    sa.getTargets().add(ai);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean doTriggerAINoCost(Player ai, SpellAbility sa, boolean mandatory) {
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if ("PithingNeedle".equals(aiLogic)) {
            CardCollection oppPerms = CardLists.getValidCards((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), "Card.OppCtrl+hasNonManaActivatedAbility", ai, sa.getHostCard(), (CardTraitBase)sa);
            if (oppPerms.isEmpty()) {
                return false;
            }
            Card card = ComputerUtilCard.getBestPlaneswalkerAI(oppPerms);
            if (card != null) {
                return true;
            }
            return (double)MyRandom.getRandom().nextFloat() <= 0.05 * (double)oppPerms.size();
        }
        return mandatory;
    }

    @Override
    public Card chooseSingleCard(Player ai, SpellAbility sa, Iterable<Card> options, boolean isOptional, Player targetedPlayer, Map<String, Object> params) {
        return ComputerUtilCard.getBestAI(options);
    }

    @Override
    public String chooseCardName(Player ai, SpellAbility sa, List<ICardFace> faces) {
        if (faces.isEmpty()) {
            return "";
        }
        if (faces.size() == 1) {
            return ((ICardFace)Iterables.getFirst(faces, null)).getName();
        }
        ArrayList<Card> cards = Lists.newArrayList();
        CardDb cardDb = StaticData.instance().getCommonCards();
        for (ICardFace face : faces) {
            CardRules rules = cardDb.getRules(face.getName());
            boolean isOther = rules.getOtherPart() == face;
            PaperCard paper = cardDb.getCard(rules.getName());
            Card card = Card.fromPaperCard(paper, ai);
            if (rules.getSplitType() == CardSplitType.Split) {
                Card copy = CardCopyService.getLKICopy(card);
                if (isOther) {
                    copy.getCurrentState().copyFrom(card.getState(CardStateName.RightSplit), true);
                } else {
                    copy.getCurrentState().copyFrom(card.getState(CardStateName.LeftSplit), true);
                }
                copy.updateStateForView();
                cards.add(copy);
                continue;
            }
            if (isOther) continue;
            cards.add(card);
        }
        return ComputerUtilCard.getBestAI(cards).getName();
    }
}

