/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import com.google.common.collect.Lists;
import forge.ai.AiController;
import forge.ai.AiPlayDecision;
import forge.ai.ComputerUtilAbility;
import forge.ai.PlayerControllerAi;
import forge.ai.SpellAbilityAi;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.CharmEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.util.Aggregates;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CharmAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        List<AbilitySub> chosenList;
        int num;
        int min2;
        Card source = sa.getHostCard();
        List<AbilitySub> choices = CharmEffect.makePossibleOptions(sa);
        if (sa.isEntwine()) {
            num = min2 = choices.size();
        } else {
            num = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("CharmNum", "1"), sa);
            min2 = sa.hasParam("MinCharmNum") ? AbilityUtils.calculateAmount(source, sa.getParam("MinCharmNum"), sa) : num;
        }
        boolean timingRight = sa.isTrigger();
        sa.setChosenList(null);
        sa.setSubAbility(null);
        if (!ai.equals(sa.getActivatingPlayer())) {
            chosenList = choices.subList(1, choices.size());
        } else if ("Triskaidekaphobia".equals(ComputerUtilAbility.getAbilitySourceName(sa))) {
            chosenList = this.chooseTriskaidekaphobia(choices, ai);
        } else {
            if (num < choices.size()) {
                Collections.shuffle(choices);
            }
            List<AbilitySub> list = chosenList = min2 > 1 ? this.chooseMultipleOptionsAi(choices, ai, min2) : this.chooseOptionsAi(sa, choices, ai, timingRight, num, min2);
        }
        if (chosenList.isEmpty()) {
            if (timingRight) {
                chosenList = this.chooseOptionsAi(sa, choices, ai, true, num, min2);
                if (chosenList.isEmpty() && min2 != 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        sa.setChosenList(chosenList);
        if (sa.isSpell()) {
            CharmEffect.chainAbilities(sa, chosenList);
        }
        return (double)MyRandom.getRandom().nextFloat() <= Math.pow(0.6667, sa.getActivationsThisTurn());
    }

    private List<AbilitySub> chooseOptionsAi(SpellAbility sa, List<AbilitySub> choices, Player ai, boolean isTrigger, int num, int min2) {
        int pawprintLimit;
        ArrayList<AbilitySub> chosenList = Lists.newArrayList();
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        boolean allowRepeat = sa.hasParam("CanRepeatModes");
        int n = pawprintLimit = sa.hasParam("Pawprint") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Pawprint"), sa) : 0;
        if (pawprintLimit > 0) {
            Collections.reverse(choices);
        }
        int pawprintAmount = 0;
        for (AbilitySub sub : choices) {
            sub.setActivatingPlayer(ai, true);
            if (AiPlayDecision.WillPlay != aic.canPlaySa(sub)) continue;
            if (pawprintLimit > 0) {
                int curPawprintAmount = AbilityUtils.calculateAmount(sub.getHostCard(), sub.getParamOrDefault("Pawprint", "0"), sub);
                if (pawprintAmount + curPawprintAmount > pawprintLimit) continue;
                pawprintAmount += curPawprintAmount;
            }
            chosenList.add(sub);
            if (chosenList.size() != num) continue;
            return chosenList;
        }
        if (isTrigger && chosenList.size() < min2) {
            choices.removeAll(chosenList);
            for (AbilitySub sub : choices) {
                if (!aic.doTrigger(sub, false)) continue;
                chosenList.add(sub);
                if (chosenList.size() != min2) continue;
                return chosenList;
            }
            if (chosenList.size() < min2) {
                choices.removeAll(chosenList);
                for (AbilitySub sub : choices) {
                    if (!aic.doTrigger(sub, true)) continue;
                    chosenList.add(sub);
                    if (chosenList.size() != min2) continue;
                    break;
                }
            }
        }
        if (chosenList.size() < min2) {
            chosenList.clear();
        }
        return chosenList;
    }

    private List<AbilitySub> chooseTriskaidekaphobia(List<AbilitySub> choices, Player ai) {
        ArrayList<AbilitySub> chosenList = Lists.newArrayList();
        if (choices == null || choices.isEmpty()) {
            return chosenList;
        }
        AbilitySub gain = choices.get(0);
        AbilitySub lose = choices.get(1);
        PlayerCollection opponents = ai.getOpponents();
        boolean oppTainted = false;
        boolean allyTainted = ai.isCardInPlay("Tainted Remedy");
        int aiLife = ai.getLife();
        for (Player p : opponents) {
            if (!p.isCardInPlay("Tainted Remedy")) continue;
            oppTainted = true;
            break;
        }
        if (!allyTainted) {
            for (Player p : ai.getAllies()) {
                if (!p.isCardInPlay("Tainted Remedy")) continue;
                allyTainted = true;
                break;
            }
        }
        if (!ai.canLoseLife() || ai.cantLose()) {
            chosenList.add(allyTainted ? gain : lose);
        } else if (oppTainted || ai.getGame().isCardInPlay("Rain of Gore")) {
            chosenList.add(ai.canGainLife() ? lose : gain);
        } else if (ai.getGame().isCardInPlay("Sulfuric Vortex")) {
            if (aiLife >= 17) {
                chosenList.add(lose);
            } else if (aiLife < 13 || (aiLife - 13) % 2 == 1) {
                chosenList.add(gain);
            } else {
                chosenList.add(lose);
            }
        } else if (ai.canGainLife() && aiLife <= 5) {
            chosenList.add(gain);
        } else if (!ai.canGainLife() && aiLife == 14) {
            chosenList.add(oppTainted ? lose : gain);
        } else if (allyTainted) {
            boolean oppCritical = false;
            if (aiLife != 14) {
                for (Player p : opponents) {
                    if (p.getLife() != 14 || p.canGainLife() || !p.canLoseLife()) continue;
                    oppCritical = true;
                    break;
                }
            }
            chosenList.add(aiLife == 12 || oppCritical ? lose : gain);
        } else {
            boolean oppCritical = false;
            if (aiLife != 12) {
                for (Player p : opponents) {
                    if (p.getLife() != 12 || !p.canGainLife()) continue;
                    oppCritical = true;
                    break;
                }
            }
            chosenList.add(aiLife == 14 || aiLife <= 10 || oppCritical ? gain : lose);
        }
        return chosenList;
    }

    private List<AbilitySub> chooseMultipleOptionsAi(List<AbilitySub> choices, Player ai, int min2) {
        AbilitySub goodChoice = null;
        ArrayList<AbilitySub> chosenList = Lists.newArrayList();
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        for (AbilitySub sub : choices) {
            sub.setActivatingPlayer(ai, true);
            if ("Good".equals(sub.getParam("AILogic")) && aic.doTrigger(sub, false)) {
                goodChoice = sub;
                continue;
            }
            sub.setActivatingPlayer(ai, true);
            if (AiPlayDecision.WillPlay != aic.canPlaySa(sub)) continue;
            chosenList.add(sub);
            if (chosenList.size() != min2) continue;
            break;
        }
        if (chosenList.size() == min2 - 1 && goodChoice != null) {
            chosenList.add(0, goodChoice);
        }
        if (chosenList.size() != min2) {
            chosenList.clear();
        }
        return chosenList;
    }

    @Override
    public Player chooseSinglePlayer(Player ai, SpellAbility sa, Iterable<Player> opponents, Map<String, Object> params) {
        return Aggregates.random(opponents);
    }

    @Override
    public boolean chkDrawbackWithSubs(Player aiPlayer, AbilitySub ab) {
        if (ab.getRootAbility().getChosenList() != null) {
            return true;
        }
        return super.chkDrawbackWithSubs(aiPlayer, ab);
    }
}

