/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellAbilityAi;
import forge.card.mana.ManaCost;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetChoices;

public class ChangeTargetsAi
extends SpellAbilityAi {
    @Override
    protected boolean checkApiLogic(Player ai, SpellAbility sa) {
        SpellAbility topSa;
        Game game = sa.getHostCard().getGame();
        SpellAbility spellAbility = topSa = game.getStack().isEmpty() ? null : ComputerUtilAbility.getTopSpellAbilityOnStack(game, sa);
        if ("Self".equals(sa.getParam("DefinedMagnet"))) {
            return this.doSpellMagnet(sa, topSa, ai);
        }
        return sa.isMandatory();
    }

    private boolean doSpellMagnet(SpellAbility sa, SpellAbility topSa, Player aiPlayer) {
        Card firstCard;
        if (topSa == null) {
            return false;
        }
        TargetChoices topTargets = topSa.getTargets();
        Card topHost = topSa.getHostCard();
        if (sa.getTargets().size() != 0 && sa.isTrigger()) {
            return true;
        }
        if (!topSa.usesTargeting() || topTargets.getTargetCards().contains(sa.getHostCard())) {
            return false;
        }
        for (Card tgt : topTargets.getTargetCards()) {
            if (!ComputerUtilAbility.getAbilitySourceName(sa).equals(tgt.getName()) || !tgt.getController().equals(aiPlayer)) continue;
            return false;
        }
        if (topHost != null && !topHost.getController().isOpponentOf(aiPlayer)) {
            return false;
        }
        if (!topSa.canTarget(sa.getHostCard())) {
            return false;
        }
        if (!sa.canTarget(topSa)) {
            return false;
        }
        if (sa.getPayCosts().getCostMana() != null && sa.getPayCosts().getCostMana().getMana().hasPhyrexian()) {
            ManaCost manaCost = sa.getPayCosts().getCostMana().getMana();
            int payDamage = manaCost.getPhyrexianCount() * 2;
            int potentialDmg = ComputerUtil.predictDamageFromSpell(topSa, aiPlayer);
            ManaCost normalizedMana = manaCost.getNormalizedMana();
            boolean canPay = ComputerUtilMana.canPayManaCost(new ManaCostBeingPaid(normalizedMana), sa, aiPlayer, false);
            if (potentialDmg != -1 && potentialDmg <= payDamage && !canPay && topTargets.contains(aiPlayer)) {
                return false;
            }
        }
        if (!((firstCard = topTargets.getFirstTargetedCard()) == null || aiPlayer.equals(firstCard.getController()) || topHost.getController().equals(firstCard.getController()) || topHost.getController().getAllies().contains(firstCard.getController()))) {
            return false;
        }
        Player firstPlayer = topTargets.getFirstTargetedPlayer();
        if (firstPlayer != null && !aiPlayer.equals(firstPlayer)) {
            return false;
        }
        sa.resetTargets();
        sa.getTargets().add(topSa);
        return true;
    }
}

