/*
 * Decompiled with CFR 0.152.
 */
package forge.ai.ability;

import forge.ai.SpellAbilityAi;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;

public class BalanceAi
extends SpellAbilityAi {
    @Override
    protected boolean canPlayAI(Player aiPlayer, SpellAbility sa) {
        String logic = sa.getParam("AILogic");
        int diff = 0;
        Player opp = aiPlayer.getWeakestOpponent();
        CardCollectionView compPerms = aiPlayer.getCardsIn(ZoneType.Battlefield);
        for (Player min2 : aiPlayer.getOpponents()) {
            if (min2.getCardsIn(ZoneType.Battlefield).size() >= opp.getCardsIn(ZoneType.Battlefield).size()) continue;
            opp = min2;
        }
        CardCollectionView humPerms = opp.getCardsIn(ZoneType.Battlefield);
        if ("BalanceCreaturesAndLands".equals(logic)) {
            diff += CardLists.filter((Iterable<Card>)humPerms, CardPredicates.Presets.LANDS).size() - CardLists.filter((Iterable<Card>)compPerms, CardPredicates.Presets.LANDS).size();
            diff = (int)((double)diff + 1.5 * (double)(CardLists.filter((Iterable<Card>)humPerms, CardPredicates.Presets.CREATURES).size() - CardLists.filter((Iterable<Card>)compPerms, CardPredicates.Presets.CREATURES).size()));
        } else if ("BalancePermanents".equals(logic)) {
            diff += humPerms.size() - compPerms.size();
        }
        if (diff < 0) {
            return false;
        }
        CardCollectionView humHand = opp.getCardsIn(ZoneType.Hand);
        CardCollectionView compHand = aiPlayer.getCardsIn(ZoneType.Hand);
        return (diff = (int)((double)diff + 0.5 * (double)(humHand.size() - compHand.size()))) > 2 && MyRandom.getRandom().nextInt(100) < diff * 10;
    }
}

