/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiPlayDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.ability.AnimateAi;
import forge.ai.ability.FightAi;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameType;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.CostPart;
import forge.game.keyword.Keyword;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.SpellPermanent;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.maps.LinkedHashMapToAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class SpecialCardAi {

    public static class YawgmothsWill {
        public static boolean consider(Player ai, SpellAbility sa) {
            CardCollectionView cardsInGY = ai.getCardsIn(ZoneType.Graveyard);
            if (cardsInGY.size() == 0) {
                return false;
            }
            if (ai.getGame().getPhaseHandler().getPlayerTurn() != ai) {
                return false;
            }
            int minManaAdj = 2;
            float minCastableInGY = 3.0f;
            List<SpellAbility> saList = ComputerUtilAbility.getSpellAbilities(cardsInGY, ai);
            int selfCMC = sa.getPayCosts().getCostMana().getMana().getCMC();
            float numCastable = 0.0f;
            for (SpellAbility ab : saList) {
                int Xcount;
                boolean willPlayAb;
                Card src = ab.getHostCard();
                if (ab.getApi() == ApiType.Counter || ComputerUtilAbility.getAbilitySourceName(ab).equals(ComputerUtilAbility.getAbilitySourceName(sa)) && !(ab instanceof SpellPermanent) || ab.hasParam("AINoRecursiveCheck")) continue;
                SpellAbility testAb = ab.copy();
                testAb.getRestrictions().setZone(ZoneType.Graveyard);
                testAb.setActivatingPlayer(ai);
                boolean bl = willPlayAb = ((PlayerControllerAi)ai.getController()).getAi().canPlaySa(testAb) == AiPlayDecision.WillPlay;
                if (src.getType().isLand() || !willPlayAb) continue;
                int CMC = ab.getPayCosts().getTotalMana() != null ? ab.getPayCosts().getTotalMana().getCMC() : 0;
                int n = Xcount = ab.getPayCosts().getTotalMana() != null ? ab.getPayCosts().getTotalMana().countX() : 0;
                if ((Xcount != 0 || CMC != 0) && !ComputerUtilMana.canPayManaCost(ab, ai, selfCMC + minManaAdj, false)) continue;
                if (src.isInstant() || src.isSorcery()) {
                    numCastable += 0.5f;
                    continue;
                }
                numCastable += 1.0f;
            }
            return numCastable >= minCastableInGY;
        }
    }

    public static class YawgmothsBargain {
        public static boolean consider(Player ai, SpellAbility sa) {
            Game game = ai.getGame();
            PhaseHandler ph = game.getPhaseHandler();
            if (ai.getCardsIn(ZoneType.Library).isEmpty()) {
                return false;
            }
            int computerHandSize = ai.getZone(ZoneType.Hand).size();
            int maxHandSize = ai.getMaxHandSize();
            boolean blackViseOTB = Iterables.any(game.getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Black Vise"));
            if (ph.getNextTurn().equals(ai) && ph.is(PhaseType.END_OF_TURN) && ai.getSpellsCastLastTurn() == 0 && ai.getSpellsCastThisTurn() == 0 && ai.getLandsPlayedLastTurn() == 0) {
                if (!blackViseOTB) {
                    return computerHandSize == maxHandSize;
                }
                return computerHandSize + 1 <= maxHandSize;
            }
            if (blackViseOTB && computerHandSize + 1 > 4) {
                return false;
            }
            if (computerHandSize + 1 > maxHandSize) {
                return false;
            }
            return ph.isPlayerTurn(ai);
        }
    }

    public static class UginTheSpiritDragon {
        public static boolean considerPWAbilityPriority(Player ai, SpellAbility sa, ZoneType origin, CardCollectionView oppType, CardCollectionView computerType) {
            SpellAbility ugin_burn;
            Card source = sa.getHostCard();
            Game game = source.getGame();
            int loyalty = source.getCounters(CounterEnumType.LOYALTY);
            int x = -1;
            int best = 0;
            Card single = null;
            for (int i = 0; i < loyalty; ++i) {
                sa.setXManaCostPaid(i);
                oppType = CardLists.filterControlledBy((Iterable<Card>)game.getCardsIn(origin), ai.getOpponents());
                oppType = AbilityUtils.filterListByType(oppType, sa.getParam("ChangeType"), sa);
                computerType = AbilityUtils.filterListByType(ai.getCardsIn(origin), sa.getParam("ChangeType"), sa);
                int net = ComputerUtilCard.evaluatePermanentList(oppType) - ComputerUtilCard.evaluatePermanentList(computerType) - i;
                if (net <= best) continue;
                x = i;
                best = net;
                single = oppType.size() == 1 ? (Card)oppType.getFirst() : null;
            }
            if (single != null && (ugin_burn = (SpellAbility)Iterables.find(source.getSpellAbilities(), SpellAbilityPredicates.isApi(ApiType.DealDamage), null)) != null && ugin_burn.canTarget(single)) {
                boolean can_kill;
                boolean bl = can_kill = single.getSVar("Targeting").equals("Dies") || ComputerUtilCombat.getEnoughDamageToKill(single, 3, source, false, false) <= 3 && !ComputerUtil.canRegenerate(ai, single) && single.getSVar("SacMe").length() <= 0;
                if (can_kill) {
                    return false;
                }
                if (single.isPlaneswalker() && single.getCurrentLoyalty() <= 3) {
                    return false;
                }
            }
            if (x == -1) {
                return false;
            }
            sa.setXManaCostPaid(x);
            return true;
        }
    }

    public static class VolrathsShapeshifter {
        public static boolean consider(Player ai, SpellAbility sa) {
            PhaseHandler ph = ai.getGame().getPhaseHandler();
            if (ph.getPhase().isBefore(PhaseType.COMBAT_BEGIN)) {
                return false;
            }
            CardCollectionView aiGY = ai.getCardsIn(ZoneType.Graveyard);
            Card topGY = null;
            Card creatHand = ComputerUtilCard.getBestCreatureAI(ai.getCardsIn(ZoneType.Hand));
            int numCreatsInHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.CREATURES).size();
            if (!aiGY.isEmpty()) {
                topGY = (Card)ai.getCardsIn(ZoneType.Graveyard).get(false);
            }
            if (!(creatHand == null || topGY != null && topGY.isCreature() && ComputerUtilCard.evaluateCreature(creatHand) <= ComputerUtilCard.evaluateCreature(topGY) + 80)) {
                return numCreatsInHand > 1 || !ComputerUtilMana.canPayManaCost(creatHand.getSpellPermanent(), ai, 0, false);
            }
            return false;
        }

        public static CardCollection targetBestCreature(Player ai, SpellAbility sa) {
            Card creatHand = ComputerUtilCard.getBestCreatureAI(ai.getCardsIn(ZoneType.Hand));
            if (creatHand != null) {
                CardCollection cc = new CardCollection();
                cc.add(creatHand);
                return cc;
            }
            System.err.println("Volrath's Shapeshifter AI: Could not find a discard target despite the previous confirmation to proceed!");
            return null;
        }
    }

    public static class VeilOfSummer {
        public static boolean consider(Player ai, SpellAbility sa) {
            Game game = ai.getGame();
            if (game.getStack().isEmpty()) {
                return false;
            }
            SpellAbility topSA = game.getStack().peekAbility();
            if (topSA.usesTargeting() && topSA.getActivatingPlayer().isOpponentOf(ai)) {
                if (topSA.getApi() == ApiType.Counter) {
                    SpellAbility tgtSpell = topSA.getTargets().getFirstTargetedSpell();
                    if (tgtSpell != null && tgtSpell.getActivatingPlayer().equals(ai)) {
                        return true;
                    }
                } else if (topSA.getHostCard().isBlack() || topSA.getHostCard().isBlue()) {
                    for (Player tgtP : topSA.getTargets().getTargetPlayers()) {
                        if (!tgtP.equals(ai)) continue;
                        return true;
                    }
                    for (Card tgtC : topSA.getTargets().getTargetCards()) {
                        if (!tgtC.getController().equals(ai)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class TimmerianFiends {
        public static boolean consider(Player ai, SpellAbility sa) {
            Card targeted = sa.getParentTargetingCard().getTargetCard();
            if (targeted == null) {
                return false;
            }
            if (targeted.isCreature()) {
                if (ComputerUtil.aiLifeInDanger(ai, true, 0)) {
                    return true;
                }
                return ComputerUtilCard.evaluateCreature(targeted) >= 200;
            }
            return ComputerUtilCard.evaluatePermanentList(new CardCollection(targeted)) >= 3;
        }
    }

    public static class Timetwister {
        public static boolean consider(Player ai, SpellAbility sa) {
            int aiHandSize = ai.getCardsIn(ZoneType.Hand).size();
            int maxOppHandSize = 0;
            int HAND_SIZE_THRESHOLD = 3;
            for (Player p : ai.getOpponents()) {
                int handSize = p.getCardsIn(ZoneType.Hand).size();
                if (handSize <= maxOppHandSize) continue;
                maxOppHandSize = handSize;
            }
            return aiHandSize < 3 || maxOppHandSize - aiHandSize > 3;
        }
    }

    public static class TheScarabGod {
        public static boolean consider(Player ai, SpellAbility sa) {
            Card bestOppCreat = ComputerUtilCard.getBestAI(CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES));
            Card worstOwnCreat = ComputerUtilCard.getWorstAI(CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES));
            sa.resetTargets();
            if (bestOppCreat != null) {
                sa.getTargets().add(bestOppCreat);
            } else if (worstOwnCreat != null) {
                sa.getTargets().add(worstOwnCreat);
            }
            return sa.getTargets().size() > 0;
        }
    }

    public static class TheOneRing {
        public static boolean consider(Player ai, SpellAbility sa) {
            if (!ai.canLoseLife() || ai.cantLoseForZeroOrLessLife()) {
                return true;
            }
            AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
            int lifeInDanger = aic.getIntProperty(AiProps.AI_IN_DANGER_THRESHOLD);
            int numCtrs = sa.getHostCard().getCounters(CounterEnumType.BURDEN);
            return ai.getLife() > numCtrs + 1 && ai.getLife() > lifeInDanger && ai.getMaxHandSize() >= ai.getCardsIn(ZoneType.Hand).size() + numCtrs + 1;
        }
    }

    public static class SurvivalOfTheFittest {
        public static Card considerDiscardTarget(Player ai) {
            CardCollection creatsInLib = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), CardPredicates.Presets.CREATURES);
            CardCollection creatsInHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.CREATURES);
            CardCollection manaSrcsInHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.LANDS_PRODUCING_MANA);
            if (creatsInHand.isEmpty() || creatsInLib.isEmpty()) {
                return null;
            }
            int numManaSrcs = ComputerUtilMana.getAvailableManaEstimate(ai, false) + Math.min(1, manaSrcsInHand.size());
            CardCollection atTargetCMCInLib = CardLists.filter((Iterable<Card>)creatsInLib, card -> ComputerUtilMana.hasEnoughManaSourcesToCast(card.getSpellPermanent(), ai));
            if (atTargetCMCInLib.isEmpty()) {
                atTargetCMCInLib = CardLists.filter((Iterable<Card>)creatsInLib, CardPredicates.greaterCMC(numManaSrcs));
            }
            atTargetCMCInLib.sort(CardLists.CmcComparatorInv);
            if (atTargetCMCInLib.isEmpty()) {
                return null;
            }
            CardCollection belowMaxCMC = CardLists.filter((Iterable<Card>)creatsInHand, CardPredicates.lessCMC(numManaSrcs - 1));
            belowMaxCMC.sort(Collections.reverseOrder(CardLists.CmcComparatorInv));
            CardCollection aboveMaxCMC = CardLists.filter((Iterable<Card>)creatsInHand, CardPredicates.greaterCMC(numManaSrcs + 1));
            aboveMaxCMC.sort(CardLists.CmcComparatorInv);
            Card maxCMC = !aboveMaxCMC.isEmpty() ? (Card)aboveMaxCMC.getFirst() : null;
            Card minCMC = !belowMaxCMC.isEmpty() ? (Card)belowMaxCMC.getFirst() : null;
            Card bestInLib = !atTargetCMCInLib.isEmpty() ? (Card)atTargetCMCInLib.getFirst() : null;
            int maxCMCdiff = 0;
            if (maxCMC != null) {
                maxCMCdiff = maxCMC.getCMC() - numManaSrcs;
            }
            if (maxCMCdiff >= 3) {
                return maxCMC;
            }
            if (maxCMCdiff <= 0 && minCMC != null && ComputerUtilCard.evaluateCreature(bestInLib) > ComputerUtilCard.evaluateCreature(minCMC)) {
                return minCMC;
            }
            if (maxCMC != null && bestInLib != null && maxCMC.getCMC() < bestInLib.getCMC() && bestInLib.getCMC() >= 3) {
                return maxCMC;
            }
            if (ComputerUtil.isPlayingReanimator(ai) && !creatsInLib.isEmpty()) {
                CardCollection creatsInHandByCMC = new CardCollection(creatsInHand);
                creatsInHandByCMC.sort(CardLists.CmcComparatorInv);
                return (Card)creatsInHandByCMC.getFirst();
            }
            return null;
        }

        public static Card considerCardToGet(Player ai, SpellAbility sa) {
            Card bestInLib;
            CardCollection creatsInLib = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), CardPredicates.Presets.CREATURES);
            if (creatsInLib.isEmpty()) {
                return null;
            }
            CardCollection manaSrcsInHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.Presets.LANDS_PRODUCING_MANA);
            int numManaSrcs = ComputerUtilMana.getAvailableManaEstimate(ai, false) + Math.min(1, manaSrcsInHand.size());
            CardCollection atTargetCMCInLib = CardLists.filter((Iterable<Card>)creatsInLib, card -> ComputerUtilMana.hasEnoughManaSourcesToCast(card.getSpellPermanent(), ai));
            if (atTargetCMCInLib.isEmpty()) {
                atTargetCMCInLib = CardLists.filter((Iterable<Card>)creatsInLib, CardPredicates.greaterCMC(numManaSrcs));
            }
            atTargetCMCInLib.sort(CardLists.CmcComparatorInv);
            Card card2 = bestInLib = atTargetCMCInLib != null ? (Card)atTargetCMCInLib.getFirst() : null;
            if (bestInLib == null && ComputerUtil.isPlayingReanimator(ai)) {
                CardCollection creatsInLibByCMC = new CardCollection(creatsInLib);
                creatsInLibByCMC.sort(CardLists.CmcComparatorInv);
                return (Card)creatsInLibByCMC.getFirst();
            }
            return bestInLib;
        }
    }

    public static class SorinVengefulBloodlord {
        public static boolean consider(Player ai, SpellAbility sa) {
            int loyalty = sa.getHostCard().getCounters(CounterEnumType.LOYALTY);
            CardCollection creaturesToGet = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), Predicates.and(CardPredicates.Presets.CREATURES, CardPredicates.lessCMC(loyalty - 1), card -> {
                Card copy = CardCopyService.getLKICopy(card);
                ComputerUtilCard.applyStaticContPT(ai.getGame(), copy, null);
                return copy.getNetToughness() > 0;
            }));
            CardLists.sortByCmcDesc(creaturesToGet);
            if (creaturesToGet.isEmpty()) {
                return false;
            }
            Card best = (Card)creaturesToGet.getFirst();
            for (Card c : creaturesToGet) {
                if (best == c || ComputerUtilCard.evaluateCreature(c, true, false) <= ComputerUtilCard.evaluateCreature(best, true, false)) continue;
                best = c;
            }
            if (best != null) {
                sa.resetTargets();
                sa.getTargets().add(best);
                return true;
            }
            return false;
        }
    }

    public static class SaviorOfOllenbock {
        public static boolean consider(Player ai, SpellAbility sa) {
            boolean threatened;
            CardCollection oppTargetables = CardLists.getTargetableCards(ai.getOpponents().getCreaturesInPlay(), sa);
            CardCollection threats = CardLists.filter((Iterable<Card>)oppTargetables, card -> !ComputerUtilCard.isUselessCreature(card.getController(), card));
            CardCollection ownTgts = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES);
            int lifeInDanger = ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.AI_IN_DANGER_THRESHOLD);
            boolean bl = threatened = !threats.isEmpty() && (ai.getLife() <= lifeInDanger && !ai.cantLoseForZeroOrLessLife() || ai.getLifeLostLastTurn() + ai.getLifeLostThisTurn() > 0);
            if (threatened) {
                sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(threats));
            } else if (!ownTgts.isEmpty()) {
                Card target = ComputerUtilCard.getBestCreatureAI(ownTgts);
                sa.getTargets().add(target);
                int ownExiledValue = ComputerUtilCard.evaluateCreature(target);
                int oppExiledValue = 0;
                for (Card c : ai.getGame().getCardsIn(ZoneType.Exile)) {
                    if (c.getExiledWith() != sa.getHostCard()) continue;
                    if (c.getOwner() == ai) {
                        ownExiledValue += ComputerUtilCard.evaluateCreature(c);
                        continue;
                    }
                    oppExiledValue += ComputerUtilCard.evaluateCreature(c);
                }
                if (ownExiledValue > oppExiledValue + 150) {
                    sa.getHostCard().setSVar("SacMe", "5");
                } else {
                    sa.getHostCard().removeSVar("SacMe");
                }
            } else if (!threats.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestCreatureAI(threats));
            }
            return sa.isTargetNumberValid();
        }
    }

    public static class SarkhanTheMad {
        public static boolean considerDig(Player ai, SpellAbility sa) {
            return sa.getHostCard().getCounters(CounterEnumType.LOYALTY) == 1;
        }

        public static boolean considerMakeDragon(Player ai, SpellAbility sa) {
            boolean hasValidTgt;
            CardCollection creatures = ai.getCreaturesInPlay();
            boolean bl = hasValidTgt = !CardLists.filter((Iterable<Card>)creatures, t2 -> t2.getNetPower() < 5 && t2.getNetToughness() < 5).isEmpty();
            if (hasValidTgt) {
                Card worstCreature = ComputerUtilCard.getWorstCreatureAI(creatures);
                sa.getTargets().add(worstCreature);
                return true;
            }
            return false;
        }

        public static boolean considerUltimate(Player ai, SpellAbility sa, Player weakestOpp) {
            int minLife = weakestOpp.getLife();
            int dragonPower = 0;
            CardCollection dragons = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), CardPredicates.isType("Dragon"));
            for (Card c : dragons) {
                dragonPower += c.getNetPower();
            }
            return dragonPower >= minLife;
        }
    }

    public static class PriceOfProgress {
        public static boolean consider(Player ai, SpellAbility sa) {
            if (ai.getGame().getPhaseHandler().getTurn() < 10) {
                return false;
            }
            int aiLands = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), Predicates.and(CardPredicates.Presets.LANDS, Predicates.not(CardPredicates.Presets.BASIC_LANDS))).size();
            boolean hasBridge = false;
            for (Card c : ai.getCardsIn(ZoneType.Battlefield)) {
                if (!c.hasSVar("PreferredHandSize") || ai.getCardsIn(ZoneType.Hand).size() <= Integer.parseInt(c.getSVar("PreferredHandSize"))) continue;
                hasBridge = true;
                break;
            }
            if (hasBridge && ai.getGame().getPhaseHandler().getTurn() >= 10) {
                return true;
            }
            for (Player opp : ai.getOpponents()) {
                int oppLands = CardLists.filter((Iterable<Card>)opp.getCardsIn(ZoneType.Battlefield), Predicates.and(CardPredicates.Presets.LANDS, Predicates.not(CardPredicates.Presets.BASIC_LANDS))).size();
                if (ai.getLife() <= aiLands * 2 && !ComputerUtil.aiLifeInDanger(ai, true, 0) && ai.getOpponentsSmallestLifeTotal() <= oppLands * 2) {
                    return false;
                }
                if (ai.getOpponentsSmallestLifeTotal() <= oppLands * 2) {
                    return true;
                }
                if ((double)aiLands / (double)ai.getLife() > (double)oppLands / (double)ai.getOpponentsSmallestLifeTotal()) {
                    return false;
                }
                if (oppLands == 0) {
                    return false;
                }
                if ((double)aiLands / (double)ai.getLife() != (double)oppLands / (double)ai.getOpponentsSmallestLifeTotal() || aiLands <= oppLands) continue;
                return false;
            }
            return true;
        }
    }

    public static class PowerStruggle {
        public static boolean considerFirstTarget(Player ai, SpellAbility sa) {
            Card firstTgt = (Card)Aggregates.random(sa.getTargetRestrictions().getAllCandidates(sa, true));
            if (firstTgt != null) {
                sa.getTargets().add(firstTgt);
                return true;
            }
            return false;
        }

        public static boolean considerSecondTarget(Player ai, SpellAbility sa) {
            Card firstTgt = sa.getParent().getTargetCard();
            Iterable<Card> candidates = Iterables.filter(ai.getOpponents().getCardsIn(ZoneType.Battlefield), Predicates.and(CardPredicates.sharesCardTypeWith(firstTgt), CardPredicates.isTargetableBy(sa)));
            Card secondTgt = Aggregates.random(candidates);
            if (secondTgt != null) {
                sa.resetTargets();
                sa.getTargets().add(secondTgt);
                return true;
            }
            return false;
        }
    }

    public static class PhyrexianDreadnought {
        public static CardCollection reviseCreatureSacList(Player ai, SpellAbility sa, CardCollection choices) {
            choices.sort(Collections.reverseOrder(ComputerUtilCard.EvaluateCreatureComparator));
            int power = 0;
            ArrayList<Card> toKeep = Lists.newArrayList();
            for (Card c : choices) {
                if (c.getName().equals(ComputerUtilAbility.getAbilitySourceName(sa)) || c.getNetPower() < 1) continue;
                if (power >= 12) break;
                toKeep.add(c);
                power += c.getNetPower();
            }
            return new CardCollection((Iterable<Card>)toKeep);
        }
    }

    public static class NykthosShrineToNyx {
        public static boolean consider(Player ai, SpellAbility sa) {
            int activationCost;
            Game game = ai.getGame();
            PhaseHandler ph = game.getPhaseHandler();
            if (!ph.isPlayerTurn(ai) || ph.getPhase().isBefore(PhaseType.MAIN2)) {
                return false;
            }
            String prominentColor = ComputerUtilCard.getMostProminentColor(ai.getCardsIn(ZoneType.Battlefield));
            int devotion = AbilityUtils.calculateAmount(sa.getHostCard(), "Count$Devotion." + prominentColor, sa);
            if (devotion < (activationCost = sa.getPayCosts().getTotalMana().getCMC() + (sa.getPayCosts().hasTapCost() ? 1 : 0)) + 1) {
                return false;
            }
            CardCollectionView cards = ai.getCardsIn(Arrays.asList(ZoneType.Hand, ZoneType.Battlefield, ZoneType.Command));
            List<SpellAbility> all = ComputerUtilAbility.getSpellAbilities(cards, ai);
            int numManaSrcs = CardLists.filter((Iterable<Card>)ComputerUtilMana.getAvailableManaSources(ai, true), CardPredicates.Presets.UNTAPPED).size();
            for (SpellAbility testSa : ComputerUtilAbility.getOriginalAndAltCostAbilities(all, ai)) {
                ManaCost cost = testSa.getPayCosts().getTotalMana();
                boolean canPayWithAvailableColors = cost.canBePaidWithAvailable(ColorSet.fromNames(ComputerUtilCost.getAvailableManaColors(ai, sa.getHostCard())).getColor());
                byte colorProfile = cost.getColorProfile();
                if (cost.getCMC() == 0 && cost.countX() == 0 || colorProfile != 0 && !canPayWithAvailableColors && (cost.getColorProfile() & MagicColor.fromName(prominentColor)) == 0 || testSa.getPayCosts().getTotalMana().getCMC() > devotion + numManaSrcs - activationCost || ComputerUtilAbility.getAbilitySourceName(testSa).equals(ComputerUtilAbility.getAbilitySourceName(sa)) || testSa.hasParam("AINoRecursiveCheck")) continue;
                testSa.setActivatingPlayer(ai);
                if (((PlayerControllerAi)ai.getController()).getAi().canPlaySa(testSa) != AiPlayDecision.WillPlay) continue;
                return true;
            }
            return false;
        }
    }

    public static class NullBrooch {
        public static boolean consider(Player ai, SpellAbility sa) {
            boolean hasEnsnaringBridgeEffect = false;
            block0: for (Card otb : ai.getCardsIn(ZoneType.Battlefield)) {
                for (StaticAbility stab : otb.getStaticAbilities()) {
                    if (!"CARDNAME can't attack.".equals(stab.getParam("AddHiddenKeyword")) || !"Creature.powerGTX".equals(stab.getParam("Affected")) || !"Count$InYourHand".equals(otb.getSVar("X"))) continue;
                    hasEnsnaringBridgeEffect = true;
                    continue block0;
                }
            }
            return ai.getCardsIn(ZoneType.Hand).size() <= 1 || hasEnsnaringBridgeEffect;
        }
    }

    public static class Necropotence {
        public static boolean consider(Player ai, SpellAbility sa) {
            Game game = ai.getGame();
            int computerHandSize = ai.getZone(ZoneType.Hand).size();
            int maxHandSize = ai.getMaxHandSize();
            if (ai.getCardsIn(ZoneType.Library).isEmpty()) {
                return false;
            }
            if (Iterables.any(ai.getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Yawgmoth's Bargain"))) {
                return false;
            }
            PhaseHandler ph = game.getPhaseHandler();
            int exiledWithNecro = 1;
            for (Card c : ai.getCardsIn(ZoneType.Exile)) {
                if (c.getExiledWith() == null || !"Necropotence".equals(c.getExiledWith().getName()) || !c.isFaceDown()) continue;
                ++exiledWithNecro;
            }
            boolean blackViseOTB = Iterables.any(game.getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Black Vise"));
            if (ph.getNextTurn().equals(ai) && ph.is(PhaseType.MAIN2) && ai.getSpellsCastLastTurn() == 0 && ai.getSpellsCastThisTurn() == 0 && ai.getLandsPlayedLastTurn() == 0) {
                if (!blackViseOTB) {
                    return computerHandSize + exiledWithNecro - 1 == maxHandSize;
                }
                return computerHandSize + exiledWithNecro <= maxHandSize;
            }
            if (blackViseOTB && computerHandSize + exiledWithNecro - 1 >= 4) {
                return false;
            }
            if (computerHandSize + exiledWithNecro - 1 >= maxHandSize) {
                return false;
            }
            return ph.isPlayerTurn(ai) && ph.is(PhaseType.MAIN2);
        }
    }

    public static class MultipleChoice {
        public static boolean consider(Player ai, SpellAbility sa) {
            boolean canDoAll;
            int maxX = ComputerUtilCost.getMaxXValue(sa, ai, false);
            if (maxX == 0) {
                return false;
            }
            boolean canScryDraw = maxX >= 1 && ai.getCardsIn(ZoneType.Library).size() >= 3;
            boolean canBounce = maxX >= 2 && !ai.getOpponents().getCreaturesInPlay().isEmpty();
            boolean shouldBounce = canBounce && ComputerUtilCard.evaluateCreature(ComputerUtilCard.getWorstCreatureAI(ai.getOpponents().getCreaturesInPlay())) > 210;
            boolean canMakeToken = maxX >= 3;
            boolean bl = canDoAll = maxX >= 4 && canScryDraw && shouldBounce;
            if (canDoAll) {
                sa.setXManaCostPaid(4);
                return true;
            }
            if (canMakeToken) {
                sa.setXManaCostPaid(3);
                return true;
            }
            if (shouldBounce) {
                sa.setXManaCostPaid(2);
                return true;
            }
            if (canScryDraw) {
                sa.setXManaCostPaid(1);
                return true;
            }
            return false;
        }
    }

    public static class MomirVigAvatar {
        public static boolean consider(Player ai, SpellAbility sa) {
            int tokenSize;
            Card source = sa.getHostCard();
            if (source.getGame().getPhaseHandler().getPhase().isBefore(PhaseType.MAIN1)) {
                return false;
            }
            if (source.getGame().getRules().hasAppliedVariant(GameType.MoJhoSto) && CardLists.filter((Iterable<Card>)ai.getLandsInPlay(), CardPredicates.Presets.UNTAPPED).size() >= 3) {
                AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
                int chanceToPrefJhoira = aic.getIntProperty(AiProps.MOJHOSTO_CHANCE_TO_PREFER_JHOIRA_OVER_MOMIR);
                int numLandsForJhoira = aic.getIntProperty(AiProps.MOJHOSTO_NUM_LANDS_TO_ACTIVATE_JHOIRA);
                if (ai.getLandsInPlay().size() >= numLandsForJhoira && MyRandom.percentTrue(chanceToPrefJhoira)) {
                    return false;
                }
            }
            if ((tokenSize = ComputerUtilCost.getMaxXValue(sa, ai, false)) < 2) {
                return false;
            }
            if (tokenSize > 11) {
                tokenSize = 11;
            }
            sa.setXManaCostPaid(tokenSize);
            return true;
        }
    }

    public static class MimicVat {
        public static boolean considerExile(Player ai, SpellAbility sa) {
            Card source = sa.getHostCard();
            Card exiledWith = source.getImprintedCards().isEmpty() ? null : (Card)source.getImprintedCards().getFirst();
            CardCollection defined = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            Card tgt = defined.isEmpty() ? null : (Card)defined.get(0);
            return exiledWith == null || tgt != null && ComputerUtilCard.evaluateCreature(tgt) > ComputerUtilCard.evaluateCreature(exiledWith);
        }

        public static boolean considerCopy(Player ai, SpellAbility sa) {
            Card exiledWith;
            Card source = sa.getHostCard();
            Card card = exiledWith = source.getImprintedCards().isEmpty() ? null : (Card)source.getImprintedCards().getFirst();
            if (exiledWith == null) {
                return false;
            }
            return ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, exiledWith) || ai.getGame().getPhaseHandler().getPlayerTurn().isOpponentOf(ai) && ai.getGame().getCombat() != null && !ai.getGame().getCombat().getAttackers().isEmpty();
        }
    }

    public static class MairsilThePretender {
        public static Card considerCardFromList(CardCollection fetchList) {
            for (Card c : CardLists.filter((Iterable<Card>)fetchList, Predicates.or(CardPredicates.Presets.ARTIFACTS, CardPredicates.Presets.CREATURES))) {
                for (SpellAbility ab : c.getSpellAbilities()) {
                    if (!ab.isActivatedAbility()) continue;
                    Player controller = c.getController();
                    boolean wasCaged = false;
                    for (Card caged : CardLists.filter((Iterable<Card>)controller.getCardsIn(ZoneType.Exile), CardPredicates.hasCounter(CounterEnumType.CAGE))) {
                        if (!c.getName().equals(caged.getName())) continue;
                        wasCaged = true;
                        break;
                    }
                    if (wasCaged) continue;
                    return c;
                }
            }
            return null;
        }
    }

    public static class MazesEnd {
        public static boolean consider(Player ai, SpellAbility sa) {
            PhaseHandler ph = ai.getGame().getPhaseHandler();
            CardCollection availableGates = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), CardPredicates.isType("Gate"));
            return ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn() == ai && !availableGates.isEmpty();
        }

        public static Card considerCardToGet(Player ai, SpellAbility sa) {
            CardCollection currentGates = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.isType("Gate"));
            CardCollection availableGates = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), CardPredicates.isType("Gate"));
            if (availableGates.isEmpty()) {
                return null;
            }
            for (Card gate : availableGates) {
                if (Iterables.any(currentGates, CardPredicates.nameEquals(gate.getName()))) continue;
                return gate;
            }
            return Aggregates.random(availableGates);
        }
    }

    public static class LivingDeath {
        public static boolean consider(Player ai, SpellAbility sa) {
            for (Card ex : ai.getCardsIn(ZoneType.Exile)) {
                if (!ex.hasSVar("IsReanimatorCard") || ex.getCounters(CounterEnumType.TIME) <= 0) continue;
                return false;
            }
            int aiBattlefieldPower = 0;
            int aiGraveyardPower = 0;
            int threshold = 320;
            CardCollection aiCreaturesInGY = CardLists.filter((Iterable<Card>)ai.getZone(ZoneType.Graveyard).getCards(), CardPredicates.Presets.CREATURES);
            if (aiCreaturesInGY.isEmpty()) {
                return false;
            }
            for (Card c : ai.getCreaturesInPlay()) {
                if (ComputerUtilCard.isUselessCreature(ai, c)) continue;
                aiBattlefieldPower += ComputerUtilCard.evaluateCreature(c);
            }
            for (Card c : aiCreaturesInGY) {
                aiGraveyardPower += ComputerUtilCard.evaluateCreature(c);
            }
            int oppBattlefieldPower = 0;
            int oppGraveyardPower = 0;
            PlayerCollection opponents = ai.getOpponents();
            for (Player p : opponents) {
                int playerPower = 0;
                int tempGraveyardPower = 0;
                for (Card c : p.getCreaturesInPlay()) {
                    playerPower += ComputerUtilCard.evaluateCreature(c);
                }
                for (Card c : CardLists.filter((Iterable<Card>)p.getZone(ZoneType.Graveyard).getCards(), CardPredicates.Presets.CREATURES)) {
                    tempGraveyardPower += ComputerUtilCard.evaluateCreature(c);
                }
                if (playerPower > oppBattlefieldPower) {
                    oppBattlefieldPower = playerPower;
                }
                if (tempGraveyardPower <= oppGraveyardPower) continue;
                oppGraveyardPower = tempGraveyardPower;
            }
            return aiGraveyardPower - aiBattlefieldPower > oppGraveyardPower - oppBattlefieldPower + threshold;
        }
    }

    public static class Intuition {
        public static CardCollection considerMultiple(Player ai, SpellAbility sa) {
            CardCollection chosen;
            block19: {
                CardCollection libLowPriorityList;
                int changeNum;
                block20: {
                    CardCollection libPriorityList;
                    block18: {
                        if (ai.getController().isAI() && !((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.INTUITION_ALTERNATIVE_LOGIC)) {
                            return new CardCollection();
                        }
                        changeNum = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParamOrDefault("ChangeNum", "1"), sa);
                        CardCollection lib = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), Predicates.not(CardPredicates.nameEquals(sa.getHostCard().getName())));
                        lib.sort(CardLists.CmcComparatorInv);
                        ArrayList<String> highPriorityNamedCards = Lists.newArrayList("Accumulated Knowledge", "Take Inventory");
                        LinkedHashMapToAmount cardAmount = new LinkedHashMapToAmount();
                        for (Card c : lib) {
                            cardAmount.add(c.getName());
                        }
                        boolean donateComboMightWin = false;
                        int numIllusionsOTB = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.nameEquals("Illusions of Grandeur")).size();
                        if (ai.getOpponentsSmallestLifeTotal() < 20 || numIllusionsOTB > 0) {
                            donateComboMightWin = true;
                            int numIllusionsInHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.nameEquals("Illusions of Grandeur")).size();
                            int numDonateInHand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.nameEquals("Donate")).size();
                            int numIllusionsInLib = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), CardPredicates.nameEquals("Illusions of Grandeur")).size();
                            int numDonateInLib = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), CardPredicates.nameEquals("Donate")).size();
                            CardCollection comboList = new CardCollection();
                            if ((numIllusionsInHand > 0 || numIllusionsOTB > 0) && numDonateInHand == 0 && numDonateInLib >= 3) {
                                for (Card c : lib) {
                                    if (!c.getName().equals("Donate")) continue;
                                    comboList.add(c);
                                }
                                return comboList;
                            }
                            if (numDonateInHand > 0 && numIllusionsInHand == 0 && numIllusionsInLib >= 3) {
                                for (Card c : lib) {
                                    if (!c.getName().equals("Illusions of Grandeur")) continue;
                                    comboList.add(c);
                                }
                                return comboList;
                            }
                        }
                        libPriorityList = new CardCollection();
                        CardCollection libHighPriorityList = new CardCollection();
                        libLowPriorityList = new CardCollection();
                        ArrayList<String> processed = Lists.newArrayList();
                        for (int i = 4; i > 0; --i) {
                            for (Card c : lib) {
                                if (!donateComboMightWin && (c.getName().equals("Illusions of Grandeur") || c.getName().equals("Donate")) || (Integer)cardAmount.get(c.getName()) != i || c.isLand() || processed.contains(c.getName())) continue;
                                boolean canRetFromGrave = false;
                                String name = c.getName().replace(',', ';');
                                for (Trigger t2 : c.getTriggers()) {
                                    SpellAbility ab = t2.ensureAbility();
                                    if (ab == null) continue;
                                    if (ab.getApi() == ApiType.ChangeZone && "Self".equals(ab.getParam("Defined")) && "Graveyard".equals(ab.getParam("Origin")) && "Battlefield".equals(ab.getParam("Destination"))) {
                                        canRetFromGrave = true;
                                    }
                                    if (ab.getApi() != ApiType.ChangeZoneAll || !TextUtil.concatNoSpace("Creature.named", name).equals(ab.getParam("ChangeType")) || !"Graveyard".equals(ab.getParam("Origin")) || !"Battlefield".equals(ab.getParam("Destination"))) continue;
                                    canRetFromGrave = true;
                                }
                                boolean isGoodToPutInGrave = c.hasSVar("DiscardMe") || canRetFromGrave || ComputerUtil.isPlayingReanimator(ai) && c.isCreature();
                                for (Card c1 : lib) {
                                    if (!c1.getName().equals(c.getName())) continue;
                                    if (!Iterables.any(ai.getCardsIn(ZoneType.Hand), CardPredicates.nameEquals(c1.getName())) && ComputerUtilMana.hasEnoughManaSourcesToCast(c1.getFirstSpellAbility(), ai)) {
                                        libPriorityList.add(c1);
                                    } else {
                                        libLowPriorityList.add(c1);
                                    }
                                    if (!isGoodToPutInGrave && !highPriorityNamedCards.contains(c.getName())) continue;
                                    libHighPriorityList.add(c1);
                                }
                                processed.add(c.getName());
                            }
                        }
                        if (ComputerUtil.isPlayingReanimator(ai)) {
                            libHighPriorityList.sort(CardLists.CmcComparatorInv);
                        }
                        chosen = new CardCollection();
                        if (libHighPriorityList.size() < changeNum) break block18;
                        for (int i = 0; i < changeNum; ++i) {
                            chosen.add((Card)libHighPriorityList.get(i));
                        }
                        break block19;
                    }
                    if (libPriorityList.size() < changeNum) break block20;
                    for (int i = 0; i < changeNum; ++i) {
                        chosen.add((Card)libPriorityList.get(i));
                    }
                    break block19;
                }
                if (libLowPriorityList.size() < changeNum) break block19;
                for (int i = 0; i < changeNum; ++i) {
                    chosen.add((Card)libLowPriorityList.get(i));
                }
            }
            return chosen;
        }
    }

    public static class GuiltyConscience {
        public static Card getBestAttachTarget(Player ai, SpellAbility sa, List<Card> list) {
            Card chosen = null;
            CardCollection aiStuffies = CardLists.filter(list, c -> {
                if (!c.getController().equals(ai)) {
                    return false;
                }
                String name = c.getName();
                return name.equals("Stuffy Doll") || name.equals("Boros Reckoner") || name.equals("Spitemare");
            });
            if (!aiStuffies.isEmpty()) {
                chosen = (Card)aiStuffies.get(0);
            } else {
                CardCollection creatures = CardLists.filterControlledBy(list, ai.getOpponents());
                creatures = CardLists.filter((Iterable<Card>)creatures, c -> c.canBeDestroyed() && c.getNetCombatDamage() >= c.getNetToughness() && !c.isEnchantedBy("Guilty Conscience"));
                chosen = ComputerUtilCard.getBestCreatureAI(creatures);
            }
            return chosen;
        }
    }

    public static class GrothamaAllDevouring {
        public static boolean consider(Player ai, SpellAbility sa) {
            Card fighter = sa.getHostCard();
            Card devourer = sa.getOriginalHost();
            if (ai.getTeamMates(true).contains(devourer.getController())) {
                return false;
            }
            boolean goodTradeOrNoTrade = devourer.canBeDestroyed() && (devourer.getNetPower() < fighter.getNetToughness() || !fighter.canBeDestroyed() || ComputerUtilCard.evaluateCreature(devourer) > ComputerUtilCard.evaluateCreature(fighter));
            return goodTradeOrNoTrade && fighter.getNetPower() >= devourer.getNetToughness();
        }
    }

    public static class GrislySigil {
        public static boolean consider(Player ai, SpellAbility sa) {
            CardCollection potentialTgts = CardLists.filterControlledBy(CardUtil.getValidCardsToTarget(sa), ai.getOpponents());
            for (Card c : potentialTgts) {
                int damageToDeal;
                int potentialDamage;
                int n = potentialDamage = c.getAssignedDamage(false, null) > 0 ? 3 : 1;
                if (!c.canBeDestroyed() || (damageToDeal = c.isCreature() ? c.getNetToughness() : c.getCurrentLoyalty()) > c.getAssignedDamage() + potentialDamage) continue;
                potentialTgts.add(c);
            }
            if (!potentialTgts.isEmpty()) {
                sa.resetTargets();
                sa.getTargets().add(ComputerUtilCard.getBestAI(potentialTgts));
                return true;
            }
            return false;
        }
    }

    public static class GoblinPolkaBand {
        public static boolean consider(Player ai, SpellAbility sa) {
            int maxPotentialTgts = Lists.newArrayList(Iterables.filter(ai.getOpponents().getCreaturesInPlay(), CardPredicates.Presets.UNTAPPED)).size();
            int maxPotentialPayment = ComputerUtilMana.determineLeftoverMana(sa, ai, "R", false);
            int numTgts = Math.min(maxPotentialPayment, maxPotentialTgts);
            if (numTgts == 0) {
                return false;
            }
            sa.getHostCard().setSVar("TgtNum", String.valueOf(numTgts));
            List<GameEntity> validTgts = sa.getTargetRestrictions().getAllCandidates(sa, true);
            sa.resetTargets();
            sa.getTargets().addAll(Aggregates.random(validTgts, numTgts));
            return true;
        }
    }

    public static class GideonBlackblade {
        public static boolean consider(Player ai, SpellAbility sa) {
            sa.resetTargets();
            CardCollection otb = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.isTargetableBy(sa));
            if (!otb.isEmpty()) {
                sa.getTargets().add(ComputerUtilCard.getBestAI(otb));
            }
            return true;
        }
    }

    public static class ForceOfWill {
        public static boolean consider(Player ai, SpellAbility sa) {
            CardCollection blueCards = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), CardPredicates.isColor((byte)2));
            boolean isExileMode = false;
            for (CostPart c : sa.getPayCosts().getCostParts()) {
                if (!c.toString().contains("Exile")) continue;
                isExileMode = true;
                break;
            }
            if (isExileMode) {
                if (blueCards.size() < 2) {
                    return false;
                }
                if (!Iterables.any(blueCards, CardPredicates.lessCMC(3))) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class FellTheMighty {
        public static boolean consider(Player ai, SpellAbility sa) {
            CardCollection aiList = ai.getCreaturesInPlay();
            if (aiList.isEmpty()) {
                return false;
            }
            CardLists.sortByPowerAsc(aiList);
            Card lowest = (Card)aiList.get(false);
            if (!sa.canTarget(lowest)) {
                return false;
            }
            CardCollection oppList = CardLists.filter(ai.getGame().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES, CardPredicates.isControlledByAnyOf(ai.getOpponents()));
            if (ComputerUtilCard.evaluateCreatureList(oppList = CardLists.filterPower(oppList, lowest.getNetPower() + 1)) > 200) {
                sa.resetTargets();
                sa.getTargets().add(lowest);
                return true;
            }
            return false;
        }
    }

    public static class ExtraplanarLens {
        public static boolean consider(Player ai, SpellAbility sa) {
            Card bestBasic = null;
            Card bestBasicSelfOnly = null;
            CardCollection aiLands = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA);
            CardCollection oppLands = CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA);
            int bestCount = 0;
            int bestSelfOnlyCount = 0;
            for (String landType : MagicColor.Constant.BASIC_LANDS) {
                CardCollection landsOfType = CardLists.filter((Iterable<Card>)aiLands, CardPredicates.nameEquals(landType));
                CardCollection oppLandsOfType = CardLists.filter((Iterable<Card>)oppLands, CardPredicates.nameEquals(landType));
                int numCtrl = CardLists.filter((Iterable<Card>)aiLands, CardPredicates.nameEquals(landType)).size();
                if (numCtrl > bestCount) {
                    bestCount = numCtrl;
                    bestBasic = ComputerUtilCard.getWorstLand(landsOfType);
                }
                if (numCtrl <= bestSelfOnlyCount || numCtrl <= 1 || !oppLandsOfType.isEmpty() || bestBasicSelfOnly != null) continue;
                bestSelfOnlyCount = numCtrl;
                bestBasicSelfOnly = ComputerUtilCard.getWorstLand(landsOfType);
            }
            sa.resetTargets();
            if (bestBasicSelfOnly != null) {
                sa.getTargets().add(bestBasicSelfOnly);
                return true;
            }
            if (bestBasic != null) {
                sa.getTargets().add(bestBasic);
                return true;
            }
            return false;
        }
    }

    public static class ElectrostaticPummeler {
        public static boolean consider(Player ai, SpellAbility sa) {
            SpellAbility saTop;
            Card source = sa.getHostCard();
            Game game = ai.getGame();
            Combat combat = game.getCombat();
            Pair<Integer, Integer> predictedPT = ElectrostaticPummeler.getPumpedPT(ai, source.getNetCombatDamage(), source.getNetToughness());
            if (ComputerUtil.predictThreatenedObjects(ai, null, true).contains(source) && ((saTop = game.getStack().peekAbility()).getApi() == ApiType.DealDamage || saTop.getApi() == ApiType.DamageAll)) {
                int dmg = AbilityUtils.calculateAmount(saTop.getHostCard(), saTop.getParam("NumDmg"), saTop);
                if (source.getNetToughness() - source.getDamage() <= dmg && predictedPT.getRight() - source.getDamage() > dmg) {
                    return true;
                }
            }
            if (source.staticDamagePrevention(predictedPT.getLeft(), 0, source, true) == 0) {
                return false;
            }
            if (game.getPhaseHandler().is(PhaseType.COMBAT_BEGIN)) {
                if (ElectrostaticPummeler.predictOverwhelmingDamage(ai, sa)) {
                    AiCardMemory.rememberCard(ai, source, AiCardMemory.MemorySet.MANDATORY_ATTACKERS);
                    return false;
                }
            } else if (!game.getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                return false;
            }
            if (combat == null || !combat.isAttacking(source) && !combat.isBlocking(source)) {
                return false;
            }
            boolean isBlocking = combat.isBlocking(source);
            boolean cantDie = ComputerUtilCombat.combatantCantBeDestroyed(ai, source);
            CardCollection opposition = isBlocking ? combat.getAttackersBlockedBy(source) : combat.getBlockers(source);
            int oppP = Aggregates.sum(opposition, Card::getNetCombatDamage);
            int oppT = Aggregates.sum(opposition, Card::getNetToughness);
            boolean oppHasFirstStrike = false;
            boolean oppCantDie = true;
            boolean unblocked = opposition.isEmpty();
            boolean canTrample = source.hasKeyword(Keyword.TRAMPLE);
            if (!isBlocking && combat.getDefenderByAttacker(source) instanceof Card) {
                int loyalty = combat.getDefenderByAttacker(source).getCounters(CounterEnumType.LOYALTY);
                int totalDamageToPW = 0;
                for (Card atk : combat.getAttackersOf(combat.getDefenderByAttacker(source))) {
                    if (!combat.isUnblocked(atk)) continue;
                    totalDamageToPW += atk.getNetCombatDamage();
                }
                if (totalDamageToPW >= oppT + loyalty) {
                    return false;
                }
                if ((unblocked || canTrample) && predictedPT.getLeft() >= oppT + loyalty) {
                    return true;
                }
            }
            for (Card c : opposition) {
                if (c.hasKeyword(Keyword.FIRST_STRIKE) || c.hasKeyword(Keyword.DOUBLE_STRIKE)) {
                    oppHasFirstStrike = true;
                }
                if (ComputerUtilCombat.combatantCantBeDestroyed(c.getController(), c)) continue;
                oppCantDie = false;
            }
            if (!isBlocking) {
                int oppLife = combat.getDefendingPlayerRelatedTo(source).getLife();
                if ((unblocked || canTrample) && predictedPT.getLeft() - oppT > oppLife / 2 || canTrample && predictedPT.getLeft() - oppT > 0 && predictedPT.getRight() > oppP) {
                    AiCardMemory.rememberCard(ai, source, AiCardMemory.MemorySet.MANDATORY_ATTACKERS);
                    return true;
                }
            }
            if (predictedPT.getRight() - source.getDamage() <= oppP && oppHasFirstStrike && !cantDie) {
                return false;
            }
            if (!(predictedPT.getLeft() >= oppT || cantDie && predictedPT.getRight() - source.getDamage() > oppP)) {
                return false;
            }
            if (source.getNetCombatDamage() > oppT && source.getNetToughness() > oppP) {
                return false;
            }
            return !oppCantDie || source.hasKeyword(Keyword.TRAMPLE) || source.isWitherDamage() || predictedPT.getLeft() > oppT;
        }

        public static boolean predictOverwhelmingDamage(Player ai, SpellAbility sa) {
            Card source = sa.getHostCard();
            int oppLife = ai.getWeakestOpponent().getLife();
            CardCollection oppInPlay = ai.getWeakestOpponent().getCreaturesInPlay();
            CardCollection potentialBlockers = new CardCollection();
            for (Card b : oppInPlay) {
                if (!CombatUtil.canBlock(source, b)) continue;
                potentialBlockers.add(b);
            }
            Pair<Integer, Integer> predictedPT = ElectrostaticPummeler.getPumpedPT(ai, source.getNetCombatDamage(), source.getNetToughness());
            int oppT = Aggregates.sum(potentialBlockers, Card::getNetToughness);
            return potentialBlockers.isEmpty() || source.hasKeyword(Keyword.TRAMPLE) && predictedPT.getLeft() - oppT >= oppLife;
        }

        public static Pair<Integer, Integer> getPumpedPT(Player ai, int power, int toughness) {
            int energy = ai.getCounters(CounterEnumType.ENERGY);
            if (energy > 0) {
                int numActivations = energy / 3;
                for (int i = 0; i < numActivations; ++i) {
                    power *= 2;
                    toughness *= 2;
                }
            }
            return Pair.of(power, toughness);
        }
    }

    public static class Donate {
        public static boolean considerTargetingOpponent(Player ai, SpellAbility sa) {
            Card donateTarget = ComputerUtil.getCardPreference(ai, sa.getHostCard(), "DonateMe", CardLists.filter(ai.getCardsIn(ZoneType.Battlefield).threadSafeIterable(), CardPredicates.hasSVar("DonateMe")));
            if (donateTarget != null) {
                Player opp;
                Iterable<Player> oppList = Iterables.filter(ai.getOpponents(), PlayerPredicates.isTargetableBy(sa));
                if (Iterables.isEmpty(oppList)) {
                    return false;
                }
                Iterable<Player> oppTarget = Iterables.filter(oppList, PlayerPredicates.isNotCardInPlay(donateTarget.getName()));
                if (Iterables.isEmpty(oppTarget)) {
                    oppTarget = oppList;
                }
                if ((opp = Collections.min(Lists.newArrayList(oppTarget), PlayerPredicates.compareByZoneSize(ZoneType.Battlefield, CardPredicates.Presets.LANDS))) != null) {
                    sa.resetTargets();
                    sa.getTargets().add(opp);
                    return true;
                }
                return true;
            }
            return false;
        }

        public static boolean considerDonatingPermanent(Player ai, SpellAbility sa) {
            Card donateTarget = ComputerUtil.getCardPreference(ai, sa.getHostCard(), "DonateMe", CardLists.filter(ai.getCardsIn(ZoneType.Battlefield).threadSafeIterable(), CardPredicates.hasSVar("DonateMe")));
            if (donateTarget != null) {
                sa.resetTargets();
                sa.getTargets().add(donateTarget);
                return true;
            }
            System.err.println("Warning: Donate AI failed at SpecialCardAi.Donate#targetPermanentToDonate despite successfully targeting an opponent first.");
            return false;
        }
    }

    public static class DesecrationDemon {
        private static final int demonSacThreshold = Integer.MAX_VALUE;

        public static boolean considerSacrificingCreature(Player ai, SpellAbility sa) {
            CardCollection flyingCreatures = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), Predicates.and(CardPredicates.Presets.UNTAPPED, Predicates.or(CardPredicates.hasKeyword(Keyword.FLYING), CardPredicates.hasKeyword(Keyword.REACH))));
            boolean hasUsefulBlocker = false;
            for (Card c : flyingCreatures) {
                if (ComputerUtilCard.isUselessCreature(ai, c)) continue;
                hasUsefulBlocker = true;
            }
            return ai.getLife() <= sa.getHostCard().getNetPower() && !hasUsefulBlocker;
        }

        public static int getSacThreshold() {
            return Integer.MAX_VALUE;
        }
    }

    public static class DeathgorgeScavenger {
        public static boolean consider(Player ai, SpellAbility sa) {
            Card worstCreat = ComputerUtilCard.getWorstAI(CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES));
            Card worstNonCreat = ComputerUtilCard.getWorstAI(CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Graveyard), Predicates.not(CardPredicates.Presets.CREATURES)));
            if (worstCreat == null) {
                worstCreat = ComputerUtilCard.getWorstAI(CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), CardPredicates.Presets.CREATURES));
            }
            if (worstNonCreat == null) {
                worstNonCreat = ComputerUtilCard.getWorstAI(CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Graveyard), Predicates.not(CardPredicates.Presets.CREATURES)));
            }
            sa.resetTargets();
            if (worstCreat != null && ai.getLife() <= ai.getStartingLife() / 4) {
                sa.getTargets().add(worstCreat);
            } else if (worstNonCreat != null && ai.getGame().getCombat() != null && ai.getGame().getCombat().isAttacking(sa.getHostCard())) {
                sa.getTargets().add(worstNonCreat);
            } else if (worstCreat != null) {
                sa.getTargets().add(worstCreat);
            }
            return sa.getTargets().size() > 0;
        }
    }

    public static class PithingNeedle {
        public static String chooseCard(Player ai, SpellAbility sa) {
            CardCollection oppPerms = CardLists.getValidCards((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), "Card.OppCtrl+hasNonManaActivatedAbility", ai, sa.getHostCard(), (CardTraitBase)sa);
            if (!oppPerms.isEmpty()) {
                return PithingNeedle.chooseCardFromList(oppPerms).getName();
            }
            CardCollection visibleZones = CardLists.getValidCards((Iterable<Card>)ai.getOpponents().getCardsIn(Lists.newArrayList(ZoneType.Graveyard, ZoneType.Exile)), "Card.OppCtrl+hasNonmanaAbilities", ai, sa.getHostCard(), (CardTraitBase)sa);
            if (!visibleZones.isEmpty()) {
                return PithingNeedle.chooseCardFromList(visibleZones).getName();
            }
            return PithingNeedle.chooseNonBattlefieldName();
        }

        public static Card chooseCardFromList(CardCollection cardlist) {
            Card best = ComputerUtilCard.getBestPlaneswalkerAI(cardlist);
            if (best != null) {
                return best;
            }
            best = ComputerUtilCard.getBestCreatureAI(cardlist);
            if (best == null) {
                Collections.shuffle(cardlist);
                best = (Card)cardlist.getFirst();
            }
            return best;
        }

        public static String chooseNonBattlefieldName() {
            return "Liliana of the Veil";
        }
    }

    public static class CursedScroll {
        public static boolean consider(Player ai, SpellAbility sa) {
            CardCollectionView hand = ai.getCardsIn(ZoneType.Hand);
            if (hand.isEmpty()) {
                return false;
            }
            return CardLists.filter((Iterable<Card>)hand, CardPredicates.nameEquals(((Card)hand.getFirst()).getName())).size() == hand.size();
        }

        public static String chooseCard(Player ai, SpellAbility sa) {
            int maxCount = 0;
            Card best = null;
            CardCollectionView hand = ai.getCardsIn(ZoneType.Hand);
            for (Card c : ai.getCardsIn(ZoneType.Hand)) {
                int count = CardLists.filter((Iterable<Card>)hand, CardPredicates.nameEquals(c.getName())).size();
                if (count <= maxCount) continue;
                maxCount = count;
                best = c;
            }
            return best != null ? best.getName() : "";
        }
    }

    public static class CrawlingBarrens {
        public static boolean consider(Player ai, SpellAbility sa) {
            PhaseHandler ph = ai.getGame().getPhaseHandler();
            Combat combat = ai.getGame().getCombat();
            Card animated = AnimateAi.becomeAnimated(sa.getHostCard(), sa.getSubAbility());
            if (sa.getHostCard().canReceiveCounters(CounterEnumType.P1P1)) {
                animated.addCounterInternal(CounterEnumType.P1P1, 2, ai, false, null, null);
            }
            boolean isOppEOT = ph.is(PhaseType.END_OF_TURN) && ph.getNextTurn() == ai;
            boolean isValuableAttacker = ph.is(PhaseType.MAIN1, ai) && ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, animated);
            boolean isValuableBlocker = combat != null && combat.getDefendingPlayers().contains(ai) && ComputerUtilCard.doesSpecifiedCreatureBlock(ai, animated);
            return isOppEOT || isValuableAttacker || isValuableBlocker;
        }
    }

    public static class ChainOfSmog {
        public static boolean consider(Player ai, SpellAbility sa) {
            if (ai.getCardsIn(ZoneType.Hand).isEmpty()) {
                Player targOpp = Aggregates.random(ai.getOpponents());
                for (Player opp : ai.getOpponents()) {
                    if (opp.getCardsIn(ZoneType.Hand).isEmpty()) continue;
                    targOpp = opp;
                    break;
                }
                sa.getParent().resetTargets();
                sa.getParent().getTargets().add(targOpp);
                return true;
            }
            return false;
        }
    }

    public static class ChainOfAcid {
        public static boolean consider(Player ai, SpellAbility sa) {
            CardCollection AiLandsOnly = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS);
            CardCollection OppPerms = CardLists.filter((Iterable<Card>)ai.getOpponents().getCardsIn(ZoneType.Battlefield), Predicates.not(CardPredicates.Presets.CREATURES));
            return !OppPerms.isEmpty() && AiLandsOnly.size() > OppPerms.size() + 2;
        }
    }

    public static class BrainInAJar {
        public static boolean consider(Player ai, SpellAbility sa) {
            CardCollection library;
            Card source = sa.getHostCard();
            int counterNum = source.getCounters(CounterEnumType.CHARGE);
            if (counterNum == 0) {
                return false;
            }
            int libsize = ai.getCardsIn(ZoneType.Library).size();
            CardCollection hand = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Hand), Predicates.or(CardPredicates.isType("Instant"), CardPredicates.isType("Sorcery")));
            if (!hand.isEmpty()) {
                if (Iterables.any(hand, CardPredicates.hasCMC(counterNum + 1))) {
                    return false;
                }
                if (Iterables.any(hand, CardPredicates.hasCMC(counterNum))) {
                    sa.setXManaCostPaid(1);
                    return true;
                }
            }
            if (!(library = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Library), Predicates.or(CardPredicates.isType("Instant"), CardPredicates.isType("Sorcery")))).isEmpty()) {
                int maxCMC = 0;
                for (Card c : library) {
                    int v = c.getCMC();
                    if (c.isSplitCard()) {
                        v = Math.max(c.getCMC(Card.SplitCMCMode.LeftSplitCMC), c.getCMC(Card.SplitCMCMode.RightSplitCMC));
                    }
                    if (v <= maxCMC) continue;
                    maxCMC = v;
                }
                if (counterNum + 1 < maxCMC) {
                    return false;
                }
                int maxToRemove = counterNum - maxCMC + 1;
                if (maxToRemove <= 0) {
                    return false;
                }
                sa.setXManaCostPaid(maxToRemove);
            } else {
                sa.setXManaCostPaid(Math.min(counterNum, libsize));
            }
            return true;
        }
    }

    public static class BlackLotus {
        public static boolean consider(Player ai, SpellAbility sa, ManaCostBeingPaid cost) {
            CardCollection manaSources = ComputerUtilMana.getAvailableManaSources(ai, true);
            int numManaSrcs = manaSources.size();
            CardCollection allCards = CardLists.filter((Iterable<Card>)ai.getAllCards(), Arrays.asList(CardPredicates.Presets.NON_TOKEN, Predicates.not(CardPredicates.Presets.LANDS), CardPredicates.isOwner(ai)));
            int numHighCMC = CardLists.count(allCards, CardPredicates.greaterCMC(5));
            int numLowCMC = CardLists.count(allCards, CardPredicates.lessCMC(3));
            boolean isLowCMCDeck = numHighCMC <= 6 && numLowCMC >= 25;
            int minCMC = isLowCMCDeck ? 3 : 4;
            int paidCMC = cost.getConvertedManaCost();
            if (paidCMC < minCMC) {
                return paidCMC == 3 && numManaSrcs < 3;
            }
            return true;
        }
    }

    public static class Arena {
        public static boolean consider(Player ai, SpellAbility sa) {
            Game game = ai.getGame();
            if (!game.getPhaseHandler().is(PhaseType.END_OF_TURN) || game.getPhaseHandler().getNextTurn() != ai) {
                return false;
            }
            CardCollection aiCreatures = ai.getCreaturesInPlay();
            if (aiCreatures.isEmpty()) {
                return false;
            }
            for (Player opp : ai.getOpponents()) {
                CardCollection oppCreatures = opp.getCreaturesInPlay();
                if (oppCreatures.isEmpty()) continue;
                for (Card aiCreature : aiCreatures) {
                    boolean canKillAll = true;
                    for (Card oppCreature : oppCreatures) {
                        if (FightAi.canKill(oppCreature, aiCreature, 0)) {
                            canKillAll = false;
                            break;
                        }
                        if (FightAi.canKill(aiCreature, oppCreature, 0)) continue;
                        canKillAll = false;
                        break;
                    }
                    if (!canKillAll) continue;
                    sa.getTargets().clear();
                    sa.getTargets().add(aiCreature);
                    return true;
                }
            }
            return sa.isTargetNumberValid();
        }
    }
}

