/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilMana;
import forge.ai.SpellApiToAi;
import forge.ai.ability.TokenAi;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Expressions;
import java.util.List;

public class SpecialAiLogic {
    public static boolean doPongifyLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        PhaseHandler ph = game.getPhaseHandler();
        boolean isDestroy = ApiType.Destroy.equals((Object)sa.getApi());
        SpellAbility tokenSA = sa.findSubAbilityByType(ApiType.Token);
        if (tokenSA == null) {
            return false;
        }
        List<Card> targetable = CardUtil.getValidCardsToTarget(sa);
        CardCollection listOpp = CardLists.filterControlledBy(targetable, ai.getOpponents());
        if (isDestroy) {
            listOpp = CardLists.getNotKeyword((Iterable<Card>)listOpp, Keyword.INDESTRUCTIBLE);
        }
        Card choice = null;
        if (!listOpp.isEmpty() && (choice = ComputerUtilCard.getMostExpensivePermanentAI(listOpp)) != null) {
            Card token = TokenAi.spawnToken(choice.getController(), tokenSA);
            if (!token.isCreature() || token.getNetToughness() < 1) {
                sa.resetTargets();
                sa.getTargets().add(choice);
                return true;
            }
            if (choice.isPlaneswalker()) {
                if (choice.getCurrentLoyalty() * 35 > ComputerUtilCard.evaluateCreature(token)) {
                    sa.resetTargets();
                    sa.getTargets().add(choice);
                    return true;
                }
                return false;
            }
            if ((!choice.isCreature() || choice.isTapped()) && ph.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS) && ph.isPlayerTurn(ai) || (double)ComputerUtilCard.evaluateCreature(choice) < 1.5 * (double)ComputerUtilCard.evaluateCreature(token)) {
                choice = null;
            }
        }
        if (choice == null) {
            CardCollection listOwn = CardLists.filterControlledBy(targetable, ai);
            Card token = TokenAi.spawnToken(ai, tokenSA);
            Card bestOwnCardToUpgrade = null;
            if (isDestroy) {
                bestOwnCardToUpgrade = Iterables.getFirst(CardLists.getKeyword((Iterable<Card>)listOwn, Keyword.INDESTRUCTIBLE), null);
            }
            if (bestOwnCardToUpgrade == null) {
                bestOwnCardToUpgrade = ComputerUtilCard.getWorstCreatureAI(CardLists.filter((Iterable<Card>)listOwn, card -> card.isCreature() && (ComputerUtilCard.isUselessCreature(ai, card) || ComputerUtilCard.evaluateCreature(token) > 2 * ComputerUtilCard.evaluateCreature(card))));
            }
            if (bestOwnCardToUpgrade != null && (ComputerUtilCard.isUselessCreature(ai, bestOwnCardToUpgrade) || ph.getPhase().isAfter(PhaseType.COMBAT_END) || !ph.isPlayerTurn(ai))) {
                choice = bestOwnCardToUpgrade;
            }
        }
        if (choice != null) {
            sa.resetTargets();
            sa.getTargets().add(choice);
            return true;
        }
        return false;
    }

    public static boolean doAristocratLogic(Player ai, SpellAbility sa) {
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        Card source = sa.getHostCard();
        int numOtherCreats = Math.max(0, ai.getCreaturesInPlay().size() - 1);
        int powerBonus = sa.hasParam("NumAtt") ? AbilityUtils.calculateAmount(source, sa.getParam("NumAtt"), sa) : 0;
        int toughnessBonus = sa.hasParam("NumDef") ? AbilityUtils.calculateAmount(source, sa.getParam("NumDef"), sa) : 0;
        boolean indestructible = sa.hasParam("KW") && sa.getParam("KW").contains("Indestructible");
        int selfEval = ComputerUtilCard.evaluateCreature(source);
        boolean isThreatened = ComputerUtil.predictThreatenedObjects(ai, null, true).contains(source);
        if (numOtherCreats == 0) {
            return false;
        }
        if (isThreatened && (toughnessBonus > 0 || indestructible)) {
            SpellAbility saTop = game.getStack().peekAbility();
            if (saTop.getApi() == ApiType.DealDamage || saTop.getApi() == ApiType.DamageAll) {
                int numCreatsToSac;
                int dmg = AbilityUtils.calculateAmount(saTop.getHostCard(), saTop.getParam("NumDmg"), saTop) + source.getDamage();
                int n = numCreatsToSac = indestructible ? 1 : Math.max(1, (int)Math.ceil((dmg - source.getNetToughness() + 1) / toughnessBonus));
                if (numCreatsToSac > 1) {
                    return false;
                }
                if (indestructible || source.getNetToughness() <= dmg && source.getNetToughness() + toughnessBonus * numCreatsToSac > dmg) {
                    CardCollection sacFodder = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), card -> ComputerUtilCard.isUselessCreature(ai, card) || card.hasSVar("SacMe") || ComputerUtilCard.evaluateCreature(card) < selfEval);
                    return sacFodder.size() >= numCreatsToSac;
                }
            }
            return false;
        }
        if (combat == null) {
            return false;
        }
        if (combat.isAttacking(source)) {
            if (combat.getBlockers(source).isEmpty()) {
                int numCreatsToSac;
                int lethalDmg;
                Player defPlayer = combat.getDefendingPlayerRelatedTo(source);
                boolean defTappedOut = ComputerUtilMana.getAvailableManaEstimate(defPlayer) == 0;
                boolean isInfect = source.hasKeyword(Keyword.INFECT);
                int n = lethalDmg = isInfect ? 10 - defPlayer.getPoisonCounters() : defPlayer.getLife();
                if (isInfect && !combat.getDefenderByAttacker(source).canReceiveCounters(CounterType.get(CounterEnumType.POISON))) {
                    lethalDmg = Integer.MAX_VALUE;
                }
                int n2 = indestructible ? 1 : (numCreatsToSac = (lethalDmg - source.getNetCombatDamage()) / (powerBonus != 0 ? powerBonus : 1));
                if (defTappedOut || numCreatsToSac < numOtherCreats / 2) {
                    return source.getNetCombatDamage() < lethalDmg && source.getNetCombatDamage() + numOtherCreats * powerBonus >= lethalDmg;
                }
                return false;
            }
            CardCollection sacTgts = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), card -> ComputerUtilCard.isUselessCreature(ai, card) || ComputerUtilCard.evaluateCreature(card) < selfEval);
            if (sacTgts.isEmpty()) {
                return false;
            }
            int minDefT = Aggregates.min(combat.getBlockers(source), Card::getNetToughness);
            int DefP = indestructible ? 0 : Aggregates.sum(combat.getBlockers(source), Card::getNetPower);
            return source.getNetToughness() - source.getDamage() <= DefP || source.getNetCombatDamage() < minDefT;
        }
        CardCollection sacFodder = CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), card -> ComputerUtilCard.isUselessCreature(ai, card) || card.hasSVar("SacMe") || ComputerUtilCard.evaluateCreature(card) < selfEval);
        return !sacFodder.isEmpty();
    }

    public static boolean doAristocratWithCountersLogic(Player ai, SpellAbility sa) {
        Card source = sa.getHostCard();
        String logic = sa.getParam("AILogic");
        boolean isDeclareBlockers = ai.getGame().getPhaseHandler().is(PhaseType.COMBAT_DECLARE_BLOCKERS);
        int numOtherCreats = Math.max(0, ai.getCreaturesInPlay().size() - 1);
        if (numOtherCreats == 0) {
            return false;
        }
        boolean isThreatened = ComputerUtil.predictThreatenedObjects(ai, null, true).contains(source);
        if ((isDeclareBlockers || isThreatened) && SpecialAiLogic.doAristocratLogic(ai, sa)) {
            return true;
        }
        SpellAbility countersSa = null;
        if (sa.getSubAbility() == null || sa.getSubAbility().getApi() != ApiType.PutCounter) {
            if (sa.getApi() == ApiType.PutCounter) {
                countersSa = sa;
            }
        } else {
            countersSa = sa.getSubAbility();
        }
        if (countersSa == null) {
            System.err.println("Warning: AILogic AristocratCounters was specified on " + source + ", but there was no PutCounter SA in chain!");
            return false;
        }
        Game game = ai.getGame();
        Combat combat = game.getCombat();
        int selfEval = ComputerUtilCard.evaluateCreature(source);
        String typeToGainCtr = "";
        if (logic.contains(".")) {
            typeToGainCtr = logic.substring(logic.indexOf(".") + 1);
        }
        CardCollection relevantCreats = typeToGainCtr.isEmpty() ? ai.getCreaturesInPlay() : CardLists.filter((Iterable<Card>)ai.getCreaturesInPlay(), CardPredicates.isType(typeToGainCtr));
        relevantCreats.remove(source);
        if (relevantCreats.isEmpty()) {
            return false;
        }
        int numCtrs = AbilityUtils.calculateAmount(source, countersSa.getParam("CounterNum"), countersSa);
        if (combat != null && combat.isAttacking(source) && isDeclareBlockers) {
            if (combat.getBlockers(source).isEmpty()) {
                CardCollection forcedSacTgts;
                int lethalDmg;
                Player defPlayer = combat.getDefendingPlayerRelatedTo(source);
                boolean defTappedOut = ComputerUtilMana.getAvailableManaEstimate(defPlayer) == 0;
                boolean isInfect = source.hasKeyword(Keyword.INFECT);
                int n = lethalDmg = isInfect ? 10 - defPlayer.getPoisonCounters() : defPlayer.getLife();
                if (isInfect && !combat.getDefenderByAttacker(source).canReceiveCounters(CounterType.get(CounterEnumType.POISON))) {
                    lethalDmg = Integer.MAX_VALUE;
                }
                if (!(forcedSacTgts = CardLists.filter((Iterable<Card>)relevantCreats, card -> ComputerUtil.predictThreatenedObjects(ai, null, true).contains(card) || combat.isAttacking((Card)card) && combat.isBlocked((Card)card) && ComputerUtilCombat.combatantWouldBeDestroyed(ai, card, combat))).isEmpty()) {
                    return true;
                }
                int numCreatsToSac = Math.max(0, (lethalDmg - source.getNetCombatDamage()) / numCtrs);
                if (defTappedOut || numCreatsToSac < relevantCreats.size() / 2) {
                    return source.getNetCombatDamage() < lethalDmg && source.getNetCombatDamage() + relevantCreats.size() * numCtrs >= lethalDmg;
                }
                return false;
            }
            CardCollection sacTgts = CardLists.filter((Iterable<Card>)relevantCreats, card -> ComputerUtilCard.isUselessCreature(ai, card) || ComputerUtilCard.evaluateCreature(card) < selfEval || ComputerUtil.predictThreatenedObjects(ai, null, true).contains(card));
            if (sacTgts.isEmpty()) {
                return false;
            }
            boolean sourceCantDie = ComputerUtilCombat.combatantCantBeDestroyed(ai, source);
            int minDefT = Aggregates.min(combat.getBlockers(source), Card::getNetToughness);
            int DefP = sourceCantDie ? 0 : Aggregates.sum(combat.getBlockers(source), Card::getNetPower);
            return source.getNetToughness() - source.getDamage() <= DefP || source.getNetCombatDamage() < minDefT;
        }
        boolean isBlocking = combat != null && combat.isBlocking(source);
        CardCollection sacFodder = CardLists.filter((Iterable<Card>)relevantCreats, card -> ComputerUtilCard.isUselessCreature(ai, card) || card.hasSVar("SacMe") || isBlocking && ComputerUtilCard.evaluateCreature(card) < selfEval || ComputerUtil.predictThreatenedObjects(ai, null, true).contains(card));
        return !sacFodder.isEmpty();
    }

    public static boolean doBranchCounterspellLogic(Player ai, SpellAbility sa) {
        SpellAbility top = ComputerUtilAbility.getTopSpellAbilityOnStack(ai.getGame(), sa);
        if (top == null || !sa.canTarget(top)) {
            return false;
        }
        Card host = sa.getHostCard();
        sa.getTargets().add(top);
        int value = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("BranchConditionSVar"), sa);
        sa.resetTargets();
        String branchCompare = sa.getParamOrDefault("BranchConditionSVarCompare", "GE1");
        String operator = branchCompare.substring(0, 2);
        String operand = branchCompare.substring(2);
        int operandValue = AbilityUtils.calculateAmount(host, operand, sa);
        boolean conditionMet = Expressions.compare(value, operator, operandValue);
        SpellAbility falseSub = sa.getAdditionalAbility("FalseSubAbility");
        boolean willPlay = false;
        if (!conditionMet && falseSub.hasParam("UnlessCost")) {
            sa.getMapParams().put("UnlessCost", falseSub.getParam("UnlessCost"));
            willPlay = SpellApiToAi.Converter.get(ApiType.Counter).canPlayAIWithSubs(ai, sa);
            sa.getMapParams().remove("UnlessCost");
        } else {
            willPlay = SpellApiToAi.Converter.get(ApiType.Counter).canPlayAIWithSubs(ai, sa);
        }
        return willPlay;
    }

    public static boolean preferHasteForRiot(SpellAbility sa, Player player) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        Card copy = CardCopyService.getLKICopy(host);
        copy.setLastKnownZone(player.getZone(ZoneType.Battlefield));
        CardCollection preList = new CardCollection(copy);
        game.getAction().checkStaticAbilities(false, Sets.newHashSet(copy), preList);
        game.getAction().checkStaticAbilities(false);
        if (!copy.canReceiveCounters(CounterEnumType.P1P1)) {
            return true;
        }
        if (copy.hasKeyword(Keyword.HASTE)) {
            return false;
        }
        if (!game.getPhaseHandler().isPlayerTurn(player)) {
            return false;
        }
        if (!game.getPhaseHandler().getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS)) {
            return false;
        }
        Player opp = player.getWeakestOpponent();
        if (opp != null) {
            return opp.getLife() < copy.getNetPower();
        }
        return false;
    }
}

