/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Function;
import forge.ai.ComputerUtilCard;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CounterEnumType;
import forge.game.cost.CostPayEnergy;
import forge.game.keyword.Keyword;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityAssignCombatDamageAsUnblocked;
import forge.game.staticability.StaticAbilityCantAttackBlock;
import forge.game.staticability.StaticAbilityMustAttack;
import java.util.List;

public class CreatureEvaluator
implements Function<Card, Integer> {
    @Override
    public Integer apply(Card c) {
        return this.evaluateCreature(c);
    }

    public int evaluateCreature(Card c) {
        return this.evaluateCreature(c, true, true);
    }

    public int evaluateCreature(Card c, boolean considerPT, boolean considerCMC) {
        int value = 80;
        if (!c.isToken()) {
            value += this.addValue(20, "non-token");
        }
        int power = c.getNetCombatDamage();
        int toughness = c.getNetToughness();
        if (c.hasKeyword("Prevent all combat damage that would be dealt by CARDNAME.") || c.hasKeyword("Prevent all damage that would be dealt by CARDNAME.") || c.hasKeyword("Prevent all combat damage that would be dealt to and dealt by CARDNAME.") || c.hasKeyword("Prevent all damage that would be dealt to and dealt by CARDNAME.")) {
            power = 0;
        }
        if (considerPT) {
            value += this.addValue(power * 15, "power");
            value += this.addValue(toughness * 10, "toughness: " + toughness);
            if (c.hasKeyword(Keyword.DAYBOUND) && c.isDoubleFaced()) {
                value += this.addValue(power * 10, "transforming");
            }
        }
        if (considerCMC) {
            value += this.addValue(c.getCMC() * 5, "cmc");
        }
        if (c.hasKeyword(Keyword.FLYING)) {
            value += this.addValue(power * 10, "flying");
        }
        if (c.hasKeyword(Keyword.HORSEMANSHIP)) {
            value += this.addValue(power * 10, "horses");
        }
        if (StaticAbilityCantAttackBlock.cantBlockBy(c, null)) {
            value += this.addValue(power * 10, "unblockable");
        } else {
            if (StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(c) || StaticAbilityAssignCombatDamageAsUnblocked.assignCombatDamageAsUnblocked(c, false)) {
                value += this.addValue(power * 6, "thorns");
            }
            if (c.hasKeyword(Keyword.FEAR)) {
                value += this.addValue(power * 6, "fear");
            }
            if (c.hasKeyword(Keyword.INTIMIDATE)) {
                value += this.addValue(power * 6, "intimidate");
            }
            if (c.hasKeyword(Keyword.MENACE)) {
                value += this.addValue(power * 4, "menace");
            }
            if (c.hasKeyword(Keyword.SKULK)) {
                value += this.addValue(power * 3, "skulk");
            }
        }
        if (power > 0) {
            if (c.hasKeyword(Keyword.DOUBLE_STRIKE)) {
                value += this.addValue(10 + power * 15, "ds");
            } else if (c.hasKeyword(Keyword.FIRST_STRIKE)) {
                value += this.addValue(10 + power * 5, "fs");
            }
            if (c.hasKeyword(Keyword.DEATHTOUCH)) {
                value += this.addValue(25, "dt");
            }
            if (c.hasKeyword(Keyword.LIFELINK)) {
                value += this.addValue(power * 10, "lifelink");
            }
            if (power > 1 && c.hasKeyword(Keyword.TRAMPLE)) {
                value += this.addValue((power - 1) * 5, "trample");
            }
            if (c.hasKeyword(Keyword.VIGILANCE)) {
                value += this.addValue(power * 5 + toughness * 5, "vigilance");
            }
            if (c.hasKeyword(Keyword.INFECT)) {
                value += this.addValue(power * 15, "infect");
            } else if (c.hasKeyword(Keyword.WITHER)) {
                value += this.addValue(power * 10, "wither");
            }
            value += this.addValue(c.getKeywordMagnitude(Keyword.TOXIC) * 5, "toxic");
            value += this.addValue(c.getKeywordMagnitude(Keyword.AFFLICT) * 5, "afflict");
            value += this.addValue(c.getKeywordMagnitude(Keyword.RAMPAGE), "rampage");
        }
        value += this.addValue(c.getKeywordMagnitude(Keyword.ANNIHILATOR) * 50, "eldrazi");
        value += this.addValue(c.getKeywordMagnitude(Keyword.ABSORB) * 11, "absorb");
        if (c.hasKeyword(Keyword.OUTLAST)) {
            value += this.addValue(10, "outlast");
        }
        value += this.addValue(c.getKeywordMagnitude(Keyword.BUSHIDO) * 16, "bushido");
        value += this.addValue(c.getAmountOfKeyword(Keyword.FLANKING) * 15, "flanking");
        value += this.addValue(c.getAmountOfKeyword(Keyword.EXALTED) * 15, "exalted");
        value += this.addValue(c.getAmountOfKeyword(Keyword.MELEE) * 18, "melee");
        value += this.addValue(c.getAmountOfKeyword(Keyword.PROWESS) * 5, "prowess");
        if (c.hasKeyword(Keyword.REACH) && !c.hasKeyword(Keyword.FLYING)) {
            value += this.addValue(5, "reach");
        }
        if (c.hasKeyword("CARDNAME can block creatures with shadow as though they didn't have shadow.")) {
            value += this.addValue(3, "shadow-block");
        }
        value = c.hasKeyword(Keyword.INDESTRUCTIBLE) ? (value += this.addValue(70, "darksteel")) : (value += this.addValue(20 * c.getCounters(CounterEnumType.SHIELD), "shielded"));
        if (c.hasKeyword("Prevent all damage that would be dealt to CARDNAME.")) {
            value += this.addValue(60, "cho-manno");
        } else if (c.hasKeyword("Prevent all combat damage that would be dealt to CARDNAME.")) {
            value += this.addValue(50, "fogbank");
        }
        if (c.hasKeyword(Keyword.HEXPROOF)) {
            value += this.addValue(35, "hexproof");
        } else if (c.hasKeyword(Keyword.SHROUD)) {
            value += this.addValue(30, "shroud");
        } else if (c.hasKeyword(Keyword.WARD)) {
            value += this.addValue(10, "ward");
        }
        if (c.hasKeyword(Keyword.PROTECTION)) {
            value += this.addValue(20, "protection");
        }
        for (SpellAbility sa : c.getSpellAbilities()) {
            if (!sa.isAbility()) continue;
            value += this.addValue(this.evaluateSpellAbility(sa), "sa: " + sa);
        }
        if (c.isPaired()) {
            value += this.addValue(14, "paired");
        }
        if (c.hasEncodedCard()) {
            value += this.addValue(24, "encoded");
        }
        if (ComputerUtilCard.hasActiveUndyingOrPersist(c)) {
            value += this.addValue(30, "revive");
        }
        if (c.hasKeyword(Keyword.DEFENDER) || c.hasKeyword("CARDNAME can't attack.")) {
            value -= this.subValue(power * 9 + 40, "defender");
        } else if (c.getSVar("SacrificeEndCombat").equals("True")) {
            value -= this.subValue(40, "sac-end");
        }
        if (c.hasKeyword("CARDNAME can't attack or block.")) {
            value = this.addValue(50 + c.getCMC() * 5, "useless");
        } else if (c.hasKeyword("CARDNAME can't block.")) {
            value -= this.subValue(10, "cant-block");
        } else if (c.isGoaded()) {
            value -= this.subValue(5, "goaded");
        } else {
            List<GameEntity> mAEnt = StaticAbilityMustAttack.entitiesMustAttack(c);
            if (mAEnt.contains(c)) {
                value -= this.subValue(10, "must-attack");
            } else if (!mAEnt.isEmpty()) {
                value -= this.subValue(10, "must-attack-player");
            }
        }
        if (c.hasSVar("DestroyWhenDamaged")) {
            value -= this.subValue((toughness - 1) * 9, "dies-to-dmg");
        }
        if (c.getSVar("Targeting").equals("Dies")) {
            value -= this.subValue(25, "dies");
        }
        if (c.isUntapped()) {
            value += this.addValue(1, "untapped");
        }
        if (!c.getManaAbilities().isEmpty()) {
            value += this.addValue(10, "manadork");
        }
        value = c.hasKeyword("CARDNAME doesn't untap during your untap step.") ? (c.isTapped() ? this.addValue(50 + c.getCMC() * 5, "tapped-useless") : (value -= this.subValue(50, "doesnt-untap"))) : (value -= this.subValue(10 * c.getCounters(CounterEnumType.STUN), "stunned"));
        if (c.hasSVar("EndOfTurnLeavePlay")) {
            value -= this.subValue(50, "eot-leaves");
        } else if (c.hasKeyword(Keyword.CUMULATIVE_UPKEEP)) {
            value -= this.subValue(30, "cupkeep");
        } else if (c.hasStartOfKeyword("UpkeepCost")) {
            value -= this.subValue(20, "sac-unless");
        } else if (c.hasKeyword(Keyword.ECHO) && c.cameUnderControlSinceLastUpkeep()) {
            value -= this.subValue(10, "echo-unpaid");
        }
        if (c.hasKeyword(Keyword.FADING)) {
            value -= this.subValue(20 / Math.max(1, c.getCounters(CounterEnumType.FADE)), "fading");
        }
        if (c.hasKeyword(Keyword.VANISHING)) {
            value -= this.subValue(20 / Math.max(1, c.getCounters(CounterEnumType.TIME)), "vanishing");
        }
        if (c.hasKeyword(Keyword.PHASING)) {
            value -= this.subValue(Math.max(20, value / 2), "phasing");
        }
        if (c.hasStartOfKeyword("At the beginning of your upkeep, CARDNAME deals")) {
            value -= this.subValue(20, "upkeep-dmg");
        }
        if (c.hasSVar("AIEvaluationModifier")) {
            value += AbilityUtils.calculateAmount(c, c.getSVar("AIEvaluationModifier"), null);
        }
        return value;
    }

    private int evaluateSpellAbility(SpellAbility sa) {
        if (sa.getApi() == ApiType.Pump && "+X".equals(sa.getParam("NumAtt")) && "+X".equals(sa.getParam("NumDef")) && !sa.usesTargeting() && (!sa.hasParam("Defined") || "Self".equals(sa.getParam("Defined"))) && sa.getPayCosts().hasOnlySpecificCostType(CostPayEnergy.class)) {
            int initPower;
            int pumpedPower = initPower = sa.getHostCard().getNetPower();
            int energy = sa.getHostCard().getController().getCounters(CounterEnumType.ENERGY);
            if (energy > 0) {
                int numActivations = energy / 3;
                for (int i = 0; i < numActivations; ++i) {
                    pumpedPower *= 2;
                }
                return (pumpedPower - initPower) * 15;
            }
        }
        return 10;
    }

    protected int addValue(int value, String text) {
        return value;
    }

    protected int subValue(int value, String text) {
        return -this.addValue(-value, text);
    }
}

