/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiCostDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellApiToAi;
import forge.ai.ability.AnimateAi;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.card.mana.ManaCostShard;
import forge.game.CardTraitPredicates;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPlayOption;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostAdjustment;
import forge.game.cost.CostPart;
import forge.game.cost.CostPartMana;
import forge.game.cost.CostPayEnergy;
import forge.game.cost.CostPayment;
import forge.game.cost.CostSacrifice;
import forge.game.keyword.Keyword;
import forge.game.mana.Mana;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.mana.ManaPool;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerPredicates;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityManaConvert;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ComputerUtilMana {
    private static final boolean DEBUG_MANA_PAYMENT = false;

    public static boolean canPayManaCost(ManaCostBeingPaid cost, SpellAbility sa, Player ai, boolean effect) {
        cost = new ManaCostBeingPaid(cost);
        return ComputerUtilMana.payManaCost(cost, sa, ai, true, true, effect);
    }

    public static boolean canPayManaCost(SpellAbility sa, Player ai, int extraMana, boolean effect) {
        return ComputerUtilMana.payManaCost(sa, ai, true, extraMana, true, effect);
    }

    public static boolean payManaCost(ManaCostBeingPaid cost, SpellAbility sa, Player ai, boolean effect) {
        return ComputerUtilMana.payManaCost(cost, sa, ai, false, true, effect);
    }

    public static boolean payManaCost(Player ai, SpellAbility sa, boolean effect) {
        return ComputerUtilMana.payManaCost(sa, ai, false, 0, true, effect);
    }

    private static boolean payManaCost(SpellAbility sa, Player ai, boolean test, int extraMana, boolean checkPlayable, boolean effect) {
        ManaCostBeingPaid cost = ComputerUtilMana.calculateManaCost(sa, test, extraMana);
        return ComputerUtilMana.payManaCost(cost, sa, ai, test, checkPlayable, effect);
    }

    public static int getConvergeCount(SpellAbility sa, Player ai) {
        ManaCostBeingPaid cost = ComputerUtilMana.calculateManaCost(sa, true, 0);
        if (ComputerUtilMana.payManaCost(cost, sa, ai, true, true, false)) {
            return cost.getSunburst();
        }
        return 0;
    }

    public static boolean hasEnoughManaSourcesToCast(SpellAbility sa, Player ai) {
        if (ai == null || sa == null) {
            return false;
        }
        sa.setActivatingPlayer(ai, true);
        return ComputerUtilMana.payManaCost(sa, ai, true, 0, false, false);
    }

    private static Integer scoreManaProducingCard(Card card) {
        int score = 0;
        for (SpellAbility ability : card.getSpellAbilities()) {
            ability.setActivatingPlayer(card.getController(), true);
            if (ability.isManaAbility()) {
                score += ability.calculateScoreForManaAbility();
                continue;
            }
            if (ability.isTrigger() || !ability.isPossible()) continue;
            score += 13;
        }
        if (card.isCreature()) {
            if (CombatUtil.canAttack(card)) {
                score += 13;
            }
            if (CombatUtil.canBlock(card)) {
                score += 13;
            }
        }
        return score;
    }

    private static void sortManaAbilities(Multimap<ManaCostShard, SpellAbility> manaAbilityMap, SpellAbility sa) {
        HashMap<Card, Integer> manaCardMap = Maps.newHashMap();
        ArrayList<Card> orderedCards = Lists.newArrayList();
        for (ManaCostShard shard : manaAbilityMap.keySet()) {
            for (SpellAbility ability : manaAbilityMap.get(shard)) {
                Card hostCard = ability.getHostCard();
                if (manaCardMap.containsKey(hostCard)) continue;
                manaCardMap.put(hostCard, ComputerUtilMana.scoreManaProducingCard(hostCard));
                orderedCards.add(hostCard);
            }
        }
        orderedCards.sort(Comparator.comparingInt(manaCardMap::get));
        for (ManaCostShard shard : manaAbilityMap.keySet()) {
            int preferredShardAmount;
            Collection<SpellAbility> abilities = manaAbilityMap.get(shard);
            ArrayList<SpellAbility> newAbilities = new ArrayList<SpellAbility>(abilities);
            newAbilities.sort((ability1, ability2) -> {
                int preOrder = orderedCards.indexOf(ability1.getHostCard()) - orderedCards.indexOf(ability2.getHostCard());
                if (preOrder != 0) {
                    return preOrder;
                }
                String shardMana = shard.toString().replaceAll("\\{", "").replaceAll("\\}", "");
                boolean payWithAb1 = ability1.getManaPart().mana((SpellAbility)ability1).contains(shardMana);
                boolean payWithAb2 = ability2.getManaPart().mana((SpellAbility)ability2).contains(shardMana);
                if (payWithAb1 && !payWithAb2) {
                    return -1;
                }
                if (payWithAb2 && !payWithAb1) {
                    return 1;
                }
                return ability1.compareTo((SpellAbility)ability2);
            });
            manaAbilityMap.replaceValues(shard, newAbilities);
            String manaPref = sa.getParamOrDefault("AIManaPref", "");
            if (manaPref.isEmpty() && sa.getHostCard() != null && sa.getHostCard().hasSVar("AIManaPref")) {
                manaPref = sa.getHostCard().getSVar("AIManaPref");
            }
            if (manaPref.isEmpty()) continue;
            String[] prefShardInfo = manaPref.split(":");
            String preferredShard = prefShardInfo[0];
            int n = preferredShardAmount = prefShardInfo.length > 1 ? Integer.parseInt(prefShardInfo[1]) : 3;
            if (preferredShard.isEmpty()) continue;
            ArrayList<SpellAbility> prefSortedAbilities = new ArrayList<SpellAbility>(newAbilities);
            ArrayList<SpellAbility> otherSortedAbilities = new ArrayList<SpellAbility>(newAbilities);
            prefSortedAbilities.sort((ability1, ability2) -> {
                if (ability1.getManaPart().mana((SpellAbility)ability1).contains(preferredShard)) {
                    return -1;
                }
                if (ability2.getManaPart().mana((SpellAbility)ability2).contains(preferredShard)) {
                    return 1;
                }
                return 0;
            });
            otherSortedAbilities.sort((ability1, ability2) -> {
                if (ability1.getManaPart().mana((SpellAbility)ability1).contains(preferredShard)) {
                    return 1;
                }
                if (ability2.getManaPart().mana((SpellAbility)ability2).contains(preferredShard)) {
                    return -1;
                }
                return 0;
            });
            ArrayList<SpellAbility> finalAbilities = new ArrayList<SpellAbility>();
            for (int i = 0; i < preferredShardAmount && i < prefSortedAbilities.size(); ++i) {
                finalAbilities.add((SpellAbility)prefSortedAbilities.get(i));
            }
            for (SpellAbility ab : otherSortedAbilities) {
                if (finalAbilities.contains(ab)) continue;
                finalAbilities.add(ab);
            }
            manaAbilityMap.replaceValues(shard, finalAbilities);
        }
    }

    public static SpellAbility chooseManaAbility(ManaCostBeingPaid cost, SpellAbility sa, Player ai, ManaCostShard toPay, Collection<SpellAbility> saList, boolean checkCosts) {
        Card saHost = sa.getHostCard();
        String manaSourceType = "";
        if (saHost.hasSVar("AIPreference")) {
            String condition = saHost.getSVar("AIPreference");
            if (condition.startsWith("ManaFrom")) {
                manaSourceType = TextUtil.split(condition, '$')[1];
            }
        } else if (sa.hasParam("AIManaPref")) {
            manaSourceType = sa.getParam("AIManaPref");
        }
        if (manaSourceType != "") {
            ArrayList<SpellAbility> filteredList = Lists.newArrayList(saList);
            switch (manaSourceType) {
                case "Snow": {
                    filteredList.sort((ab1, ab2) -> ab1.getHostCard() != null && ab1.getHostCard().isSnow() && ab2.getHostCard() != null && !ab2.getHostCard().isSnow() ? -1 : 1);
                    saList = filteredList;
                    break;
                }
                case "Treasure": {
                    filteredList.sort((ab1, ab2) -> ab1.getHostCard() != null && ab1.getHostCard().getType().hasSubtype("Treasure") && ab2.getHostCard() != null && !ab2.getHostCard().getType().hasSubtype("Treasure") ? -1 : 1);
                    SpellAbility first = (SpellAbility)filteredList.get(0);
                    if (first.getHostCard() == null || !first.getHostCard().getType().hasSubtype("Treasure")) break;
                    saList.remove(first);
                    ArrayList<SpellAbility> updatedList = Lists.newArrayList();
                    updatedList.add(first);
                    updatedList.addAll(saList);
                    saList = updatedList;
                    break;
                }
                case "TreasureMax": {
                    filteredList.sort((ab1, ab2) -> ab1.getHostCard() != null && ab1.getHostCard().getType().hasSubtype("Treasure") && ab2.getHostCard() != null && !ab2.getHostCard().getType().hasSubtype("Treasure") ? -1 : 1);
                    saList = filteredList;
                    break;
                }
                case "NotSameCard": {
                    saList = Lists.newArrayList(Iterables.filter(filteredList, saPay -> !saPay.getHostCard().getName().equals(sa.getHostCard().getName())));
                    break;
                }
            }
        }
        for (SpellAbility ma : saList) {
            if (ma.getHostCard() == saHost || ma.getPayCosts().hasTapCost() && AiCardMemory.isRememberedCard(ai, ma.getHostCard(), AiCardMemory.MemorySet.PAYS_TAP_COST) || !ComputerUtilCost.checkTapTypeCost(ai, ma.getPayCosts(), ma.getHostCard(), sa, new CardCollection()) || (sa.getApi() == ApiType.Animate ? saHost.isAura() && "Enchanted".equals(sa.getParam("Defined")) && ma.getHostCard() == saHost.getEnchantingCard() && ma.getPayCosts().hasTapCost() || saHost.isLand() && ma.getHostCard().isLand() && ai.getController().isAI() && AnimateAi.isAnimatedThisTurn(ai, ma.getHostCard()) : (sa.getApi() == ApiType.Pump ? (saHost.isInstant() || saHost.isSorcery()) && ma.getHostCard().isCreature() && ai.getController().isAI() && ma.getPayCosts().hasTapCost() && sa.getTargets().getTargetCards().contains(ma.getHostCard()) : sa.getApi() == ApiType.Attach && "AvoidPayingWithAttachTarget".equals(saHost.getSVar("AIPaymentPreference")) && ma.getHostCard().equals(sa.getTargetCard()) && CardLists.count(ai.getCardsIn(ZoneType.Battlefield), Predicates.and(CardPredicates.nameEquals(ma.getHostCard().getName()), CardPredicates.Presets.UNTAPPED)) > 1))) continue;
            SpellAbility paymentChoice = ma;
            if (ComputerUtilAbility.getAbilitySourceName(ma).equals("Cavern of Souls") && saHost.getType().hasCreatureType(ma.getHostCard().getChosenType())) {
                if (toPay == ManaCostShard.COLORLESS && cost.getUnpaidShards().contains((Object)ManaCostShard.GENERIC)) continue;
                if (toPay == ManaCostShard.GENERIC || toPay == ManaCostShard.X) {
                    for (SpellAbility ab : saList) {
                        if (!ab.isManaAbility() || !ab.getManaPart().isAnyMana() || !ab.hasParam("AddsNoCounter") || ab.getHostCard().isTapped()) continue;
                        paymentChoice = ab;
                        break;
                    }
                }
            }
            if (!ComputerUtilMana.canPayShardWithSpellAbility(toPay, ai, paymentChoice, sa, checkCosts, cost.getXManaCostPaidByColor()) || !ComputerUtilCost.checkForManaSacrificeCost(ai, ma.getPayCosts(), ma, ma.isTrigger())) continue;
            return paymentChoice;
        }
        return null;
    }

    public static String predictManaReplacement(SpellAbility saPayment, Player ai, ManaCostShard toPay) {
        Card hostCard = saPayment.getHostCard();
        Game game = hostCard.getGame();
        String manaProduced = toPay.isSnow() && hostCard.isSnow() ? "S" : GameActionUtil.generatedTotalMana(saPayment);
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(hostCard);
        repParams.put(AbilityKey.Mana, manaProduced);
        repParams.put(AbilityKey.Activator, ai);
        repParams.put(AbilityKey.AbilityMana, saPayment);
        List<ReplacementEffect> reList = game.getReplacementHandler().getReplacementList(ReplacementType.ProduceMana, repParams, ReplacementLayer.Other);
        ArrayList<SpellAbility> replaceMana = Lists.newArrayList();
        ArrayList<SpellAbility> replaceType = Lists.newArrayList();
        ArrayList<SpellAbility> replaceAmount = Lists.newArrayList();
        for (ReplacementEffect re : reList) {
            SpellAbility o = re.getOverridingAbility();
            if (o == null || o.getApi() != ApiType.ReplaceMana) continue;
            if (o.hasParam("ReplaceMana")) {
                replaceMana.add(o);
                continue;
            }
            if (o.hasParam("ReplaceType") || o.hasParam("ReplaceColor")) {
                replaceType.add(o);
                continue;
            }
            if (!o.hasParam("ReplaceAmount")) continue;
            replaceAmount.add(o);
        }
        if (!replaceMana.isEmpty()) {
            for (SpellAbility saMana : replaceMana) {
                String m4 = saMana.getParam("ReplaceMana");
                if ("Any".equals(m4)) {
                    byte rs = 16;
                    for (byte by : MagicColor.WUBRGC) {
                        if (!toPay.canBePaidWithManaOfColor(by)) continue;
                        rs = by;
                        break;
                    }
                    manaProduced = MagicColor.toShortString(rs);
                    continue;
                }
                manaProduced = m4;
            }
        }
        if (!replaceType.isEmpty()) {
            for (SpellAbility saMana : replaceAmount) {
                String color;
                Card card = saMana.getHostCard();
                if (saMana.hasParam("ReplaceType")) {
                    color = saMana.getParam("ReplaceType");
                    if ("Any".equals(color)) {
                        byte rs = 16;
                        byte[] byArray = MagicColor.WUBRGC;
                        int n = byArray.length;
                        for (int i = 0; i < n; ++i) {
                            byte c2 = byArray[i];
                            if (!toPay.canBePaidWithManaOfColor(c2)) continue;
                            rs = c2;
                            break;
                        }
                        color = MagicColor.toShortString(rs);
                    }
                    for (int i : MagicColor.WUBRGC) {
                        String s2 = MagicColor.toShortString((byte)i);
                        manaProduced = manaProduced.replace(s2, color);
                    }
                    continue;
                }
                if (!saMana.hasParam("ReplaceColor")) continue;
                color = saMana.getParam("ReplaceColor");
                if ("Chosen".equals(color) && card.hasChosenColor()) {
                    color = MagicColor.toShortString(card.getChosenColor());
                }
                if (saMana.hasParam("ReplaceOnly")) {
                    manaProduced = manaProduced.replace(saMana.getParam("ReplaceOnly"), color);
                    continue;
                }
                for (int i : MagicColor.WUBRG) {
                    String s3 = MagicColor.toShortString((byte)i);
                    manaProduced = manaProduced.replace(s3, color);
                }
            }
        }
        if (!replaceAmount.isEmpty()) {
            int totalAmount = 1;
            for (SpellAbility saMana : replaceAmount) {
                totalAmount *= Integer.parseInt(saMana.getParam("ReplaceAmount"));
            }
            manaProduced = StringUtils.repeat(manaProduced, " ", totalAmount);
        }
        return manaProduced;
    }

    public static String predictManafromSpellAbility(SpellAbility saPayment, Player ai, ManaCostShard toPay) {
        Card hostCard = saPayment.getHostCard();
        String manaProduced = ComputerUtilMana.predictManaReplacement(saPayment, ai, toPay);
        String originalProduced = manaProduced;
        if (originalProduced.isEmpty()) {
            return manaProduced;
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(hostCard);
        runParams.put(AbilityKey.Activator, ai);
        runParams.put(AbilityKey.AbilityMana, saPayment);
        runParams.put(AbilityKey.Produced, manaProduced);
        block0: for (Trigger tr : ai.getGame().getTriggerHandler().getActiveTrigger(TriggerType.TapsForMana, runParams)) {
            SpellAbility trSA = tr.ensureAbility();
            if (trSA == null) continue;
            if (ApiType.Mana.equals((Object)trSA.getApi())) {
                int pAmount = AbilityUtils.calculateAmount(trSA.getHostCard(), trSA.getParamOrDefault("Amount", "1"), trSA);
                String produced = trSA.getParam("Produced");
                if (produced.equals("Chosen")) {
                    produced = MagicColor.toShortString(trSA.getHostCard().getChosenColor());
                }
                manaProduced = manaProduced + " " + StringUtils.repeat(produced, " ", pAmount);
                continue;
            }
            if (!ApiType.ManaReflected.equals((Object)trSA.getApi())) continue;
            String colorOrType = trSA.getParamOrDefault("ColorOrType", "Color");
            String reflectProperty = trSA.getParam("ReflectProperty");
            if (!reflectProperty.equals("Produced") || originalProduced.isEmpty()) continue;
            if (toPay.equals((Object)ManaCostShard.COLORLESS) && colorOrType.equals("Type") && originalProduced.contains("C")) {
                manaProduced = manaProduced + " C";
                continue;
            }
            if (originalProduced.length() == 1) {
                if (!colorOrType.equals("Type") && originalProduced.equals("C")) continue;
                manaProduced = manaProduced + " " + originalProduced;
                continue;
            }
            boolean found = false;
            for (String s2 : originalProduced.split(" ")) {
                if (!colorOrType.equals("Type") && (s2.equals("C") || !toPay.canBePaidWithManaOfColor(MagicColor.fromName(s2)))) continue;
                found = true;
                manaProduced = manaProduced + " " + s2;
                break;
            }
            if (found) continue;
            for (String s2 : originalProduced.split(" ")) {
                if (!colorOrType.equals("Type") && s2.equals("C")) continue;
                manaProduced = manaProduced + " " + s2;
                continue block0;
            }
        }
        return manaProduced;
    }

    public static CardCollection getManaSourcesToPayCost(ManaCostBeingPaid cost, SpellAbility sa, Player ai) {
        ManaCostShard toPay;
        Collection<SpellAbility> saList;
        CardCollection manaSources = new CardCollection();
        ComputerUtilMana.adjustManaCostToAvoidNegEffects(cost, sa.getHostCard(), ai);
        ArrayList<Mana> manaSpentToPay = new ArrayList<Mana>();
        List<ManaCostShard> unpaidShards = cost.getUnpaidShards();
        Collections.sort(unpaidShards);
        for (ManaCostShard part : unpaidShards) {
            Mana mana;
            if (part == ManaCostShard.X || cost.isPaid() || (mana = CostPayment.getMana(ai, part, sa, (byte)-1, cost.getXManaCostPaidByColor())) == null || !ai.getManaPool().tryPayCostWithMana(sa, cost, mana, false)) continue;
            manaSpentToPay.add(mana);
        }
        if (cost.isPaid()) {
            ai.getManaPool().refundMana(manaSpentToPay);
            CostPayment.handleOfferings(sa, true, cost.isPaid());
            return manaSources;
        }
        ListMultimap<Integer, SpellAbility> manaAbilityMap = ComputerUtilMana.groupSourcesByManaColor(ai, true);
        if (manaAbilityMap.isEmpty()) {
            ai.getManaPool().refundMana(manaSpentToPay);
            CostPayment.handleOfferings(sa, true, cost.isPaid());
            return manaSources;
        }
        ListMultimap<ManaCostShard, SpellAbility> sourcesForShards = ComputerUtilMana.groupAndOrderToPayShards(ai, manaAbilityMap, cost);
        ComputerUtilMana.sortManaAbilities(sourcesForShards, sa);
        while (!cost.isPaid() && (saList = sourcesForShards.get(toPay = ComputerUtilMana.getNextShardToPay(cost, sourcesForShards))) != null) {
            SpellAbility saPayment = ComputerUtilMana.chooseManaAbility(cost, sa, ai, toPay, saList, true);
            if (saPayment == null) {
                boolean lifeInsteadOfBlack;
                boolean bl = lifeInsteadOfBlack = toPay.isBlack() && ai.hasKeyword("PayLifeInsteadOf:B");
                if (!toPay.isPhyrexian() && !lifeInsteadOfBlack || !ai.canPayLife(2, false, sa)) break;
                if (toPay.isPhyrexian()) {
                    cost.payPhyrexian();
                    continue;
                }
                if (!lifeInsteadOfBlack) continue;
                cost.decreaseShard(ManaCostShard.BLACK, 1);
                continue;
            }
            manaSources.add(saPayment.getHostCard());
            ComputerUtilMana.setExpressColorChoice(sa, ai, cost, toPay, saPayment);
            String manaProduced = ComputerUtilMana.predictManafromSpellAbility(saPayment, ai, toPay);
            ComputerUtilMana.payMultipleMana(cost, manaProduced, ai);
            Iterables.removeIf(sourcesForShards.values(), CardTraitPredicates.isHostCard(saPayment.getHostCard()));
        }
        CostPayment.handleOfferings(sa, true, cost.isPaid());
        ai.getManaPool().refundMana(manaSpentToPay);
        return manaSources;
    }

    private static boolean payManaCost(ManaCostBeingPaid cost, SpellAbility sa, Player ai, boolean test, boolean checkPlayable, boolean effect) {
        if (sa.isOffering() && sa.getSacrificedAsOffering() == null || sa.isEmerge() && sa.getSacrificedAsEmerge() == null) {
            return false;
        }
        AiCardMemory.clearMemorySet(ai, AiCardMemory.MemorySet.PAYS_TAP_COST);
        AiCardMemory.clearMemorySet(ai, AiCardMemory.MemorySet.PAYS_SAC_COST);
        ComputerUtilMana.adjustManaCostToAvoidNegEffects(cost, sa.getHostCard(), ai);
        ArrayList<Mana> manaSpentToPay = test ? new ArrayList() : sa.getPayingMana();
        ArrayList<SpellAbility> paymentList = Lists.newArrayList();
        ManaPool manapool = ai.getManaPool();
        manapool.restoreColorReplacements();
        CardPlayOption mayPlay = sa.getMayPlayOption();
        if (!effect) {
            if (sa.isSpell() && mayPlay != null) {
                mayPlay.applyManaConvert(manapool);
            } else if (sa.isActivatedAbility() && sa.getGrantorStatic() != null && sa.getGrantorStatic().hasParam("ManaConversion")) {
                AbilityUtils.applyManaColorConversion(manapool, sa.getGrantorStatic().getParam("ManaConversion"));
            }
        }
        if (sa.hasParam("ManaConversion")) {
            AbilityUtils.applyManaColorConversion(manapool, sa.getParam("ManaConversion"));
        }
        StaticAbilityManaConvert.manaConvert(manapool, ai, sa.getHostCard(), (SpellAbility)(effect && !sa.isCastFromPlayEffect() ? null : sa));
        if (manapool.payManaCostFromPool(cost, sa, test, manaSpentToPay)) {
            CostPayment.handleOfferings(sa, test, cost.isPaid());
            return true;
        }
        boolean purePhyrexian = cost.containsOnlyPhyrexianMana();
        boolean hasConverge = sa.getHostCard().hasConverge();
        ListMultimap<ManaCostShard, SpellAbility> sourcesForShards = ComputerUtilMana.getSourcesForShards(cost, sa, ai, test, checkPlayable, hasConverge);
        int testEnergyPool = ai.getCounters(CounterEnumType.ENERGY);
        ManaCostShard toPay = null;
        ArrayList<SpellAbility> saExcludeList = new ArrayList<SpellAbility>();
        while (!cost.isPaid()) {
            SpellAbility saPayment;
            while (!cost.isPaid() && !manapool.isEmpty()) {
                boolean found = false;
                for (byte color : ManaAtom.MANATYPES) {
                    if (!manapool.tryPayCostWithColor(color, sa, cost, manaSpentToPay)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                break;
            }
            if (cost.isPaid() || sourcesForShards == null && !purePhyrexian) break;
            toPay = ComputerUtilMana.getNextShardToPay(cost, sourcesForShards);
            boolean lifeInsteadOfBlack = toPay.isBlack() && ai.hasKeyword("PayLifeInsteadOf:B");
            Collection saList = null;
            if (hasConverge && (toPay == ManaCostShard.GENERIC || toPay == ManaCostShard.X)) {
                int unpaidColors = cost.getUnpaidColors() + cost.getColorsPaid() ^ 0x1F;
                for (byte b : ColorSet.fromMask(unpaidColors)) {
                    ManaCostShard shard = ManaCostShard.valueOf(b);
                    saList = sourcesForShards.get((Object)shard);
                    if (saList == null || saList.isEmpty()) continue;
                    toPay = shard;
                    break;
                }
                if (saList == null || saList.isEmpty()) {
                    saList = sourcesForShards.get((Object)toPay);
                    hasConverge = false;
                }
            } else {
                saList = sourcesForShards != null || !purePhyrexian ? sourcesForShards.get((Object)toPay) : Lists.newArrayList();
            }
            if (saList == null) break;
            saList.removeAll(saExcludeList);
            SpellAbility spellAbility = saList.isEmpty() ? null : (saPayment = ComputerUtilMana.chooseManaAbility(cost, sa, ai, toPay, saList, checkPlayable || !test));
            if (saPayment != null && ComputerUtilCost.isSacrificeSelfCost(saPayment.getPayCosts()) && sa.getTargets() != null && sa.getTargets().contains(saPayment.getHostCard())) {
                saExcludeList.add(saPayment);
                continue;
            }
            if (saPayment != null && saPayment.hasParam("AILogic")) {
                boolean consider = false;
                if (saPayment.getParam("AILogic").equals("BlackLotus") && !(consider = SpecialCardAi.BlackLotus.consider(ai, sa, cost))) {
                    saExcludeList.add(saPayment);
                    continue;
                }
            }
            if (saPayment == null) {
                if (!toPay.isPhyrexian() && !lifeInsteadOfBlack || !ai.canPayLife(2, false, sa) || ai.getLife() <= 2 && !ai.cantLoseForZeroOrLessLife()) break;
                if (sa.hasParam("AIPhyrexianPayment")) {
                    if ("Never".equals(sa.getParam("AIPhyrexianPayment"))) break;
                    if (sa.getParam("AIPhyrexianPayment").startsWith("OnFatalDamage.")) {
                        int dmg = Integer.parseInt(sa.getParam("AIPhyrexianPayment").substring(14));
                        if (!Iterables.any(ai.getOpponents(), PlayerPredicates.lifeLessOrEqualTo(dmg))) break;
                    }
                }
                if (toPay.isPhyrexian()) {
                    cost.payPhyrexian();
                    if (!test) {
                        sa.setSpendPhyrexianMana(true);
                    }
                } else if (lifeInsteadOfBlack) {
                    cost.decreaseShard(ManaCostShard.BLACK, 1);
                }
                if (test) continue;
                ai.payLife(2, sa, false);
                continue;
            }
            paymentList.add(saPayment);
            ComputerUtilMana.setExpressColorChoice(sa, ai, cost, toPay, saPayment);
            if (saPayment.getPayCosts().hasTapCost()) {
                AiCardMemory.rememberCard(ai, saPayment.getHostCard(), AiCardMemory.MemorySet.PAYS_TAP_COST);
            }
            if (test) {
                CostPayEnergy energyCost = saPayment.getPayCosts().getCostEnergy();
                if (energyCost != null && (testEnergyPool -= Integer.parseInt(energyCost.getAmount())) < 0) break;
                String manaProduced = ComputerUtilMana.predictManafromSpellAbility(saPayment, ai, toPay);
                ComputerUtilMana.payMultipleMana(cost, manaProduced, ai);
                Iterables.removeIf(sourcesForShards.values(), CardTraitPredicates.isHostCard(saPayment.getHostCard()));
                continue;
            }
            CostPayment pay = new CostPayment(saPayment.getPayCosts(), saPayment);
            if (!pay.payComputerCosts(new AiCostDecision(ai, saPayment, effect))) {
                saList.remove(saPayment);
                continue;
            }
            ai.getGame().getStack().addAndUnfreeze(saPayment);
            manapool.payManaFromAbility(sa, cost, saPayment);
            if (!hasConverge) continue;
            Iterables.removeIf(sourcesForShards.values(), CardTraitPredicates.isHostCard(saPayment.getHostCard()));
        }
        CostPayment.handleOfferings(sa, test, cost.isPaid());
        if (!cost.isPaid()) {
            manapool.refundMana(manaSpentToPay);
            if (test) {
                ComputerUtilMana.resetPayment(paymentList);
            } else {
                System.out.println("ComputerUtilMana: payManaCost() cost was not paid for " + sa.toString() + " (" + sa.getHostCard().getName() + "). Didn't find what to pay for " + (Object)((Object)toPay));
            }
            return false;
        }
        if (test) {
            manapool.refundMana(manaSpentToPay);
            ComputerUtilMana.resetPayment(paymentList);
        }
        return true;
    }

    private static void resetPayment(List<SpellAbility> payments) {
        for (SpellAbility sa : payments) {
            sa.getManaPart().clearExpressChoice();
        }
    }

    private static ListMultimap<ManaCostShard, SpellAbility> getSourcesForShards(ManaCostBeingPaid cost, SpellAbility sa, Player ai, boolean test, boolean checkPlayable, boolean hasConverge) {
        ListMultimap<Integer, SpellAbility> manaAbilityMap = ComputerUtilMana.groupSourcesByManaColor(ai, checkPlayable);
        if (manaAbilityMap.isEmpty()) {
            return null;
        }
        ListMultimap<ManaCostShard, SpellAbility> sourcesForShards = ComputerUtilMana.groupAndOrderToPayShards(ai, manaAbilityMap, cost);
        if (hasConverge) {
            int unpaidColors = cost.getUnpaidColors() + cost.getColorsPaid() ^ 0x1F;
            for (byte b : ColorSet.fromMask(unpaidColors)) {
                ManaCostShard shard = ManaCostShard.valueOf(b);
                if (sourcesForShards.containsKey((Object)shard) || !ai.getManaPool().canPayForShardWithColor(shard, b)) continue;
                for (SpellAbility saMana : manaAbilityMap.get(b)) {
                    sourcesForShards.get((Object)shard).add(saMana);
                }
            }
        }
        ComputerUtilMana.sortManaAbilities(sourcesForShards, sa);
        return sourcesForShards;
    }

    private static void setExpressColorChoice(SpellAbility sa, Player ai, ManaCostBeingPaid cost, ManaCostShard toPay, SpellAbility saPayment) {
        AbilityManaPart m4 = saPayment.getManaPart();
        if (m4.isComboMana()) {
            ColorSet shared = ColorSet.fromMask(toPay.getColorMask()).getSharedColors(ColorSet.fromNames(m4.getComboColors(saPayment).split(" ")));
            if (!shared.isColorless()) {
                m4.setExpressChoice(ColorSet.fromMask(shared.iterator().next().byteValue()));
            }
            ComputerUtilMana.getComboManaChoice(ai, saPayment, sa, cost);
        } else if (saPayment.getApi() == ApiType.ManaReflected) {
            Set<String> reflected = CardUtil.getReflectableManaColors(saPayment);
            for (byte c : MagicColor.WUBRGC) {
                if (!ai.getManaPool().canPayForShardWithColor(toPay, c) || !reflected.contains(MagicColor.toLongString(c))) continue;
                m4.setExpressChoice(MagicColor.toShortString(c));
                return;
            }
        } else if (m4.isAnyMana()) {
            byte colorChoice = 0;
            if (toPay.isOr2Generic()) {
                colorChoice = toPay.getColorMask();
            } else {
                for (byte c : MagicColor.WUBRG) {
                    if (!ai.getManaPool().canPayForShardWithColor(toPay, c)) continue;
                    colorChoice = c;
                    break;
                }
            }
            m4.setExpressChoice(MagicColor.toShortString(colorChoice));
        }
    }

    private static boolean canPayShardWithSpellAbility(ManaCostShard toPay, Player ai, SpellAbility ma, SpellAbility sa, boolean checkCosts, Map<String, Integer> xManaCostPaidByColor) {
        Card sourceCard = ma.getHostCard();
        if (ComputerUtilMana.isManaSourceReserved(ai, sourceCard, sa)) {
            return false;
        }
        if (toPay.isSnow() && !sourceCard.isSnow()) {
            return false;
        }
        AbilityManaPart m4 = ma.getManaPart();
        if (!m4.meetsManaRestrictions(sa)) {
            return false;
        }
        if (checkCosts) {
            ma.setActivatingPlayer(ai, true);
            if (!CostPayment.canPayAdditionalCosts(ma.getPayCosts(), ma, false)) {
                return false;
            }
            if (ma.getRestrictions() != null && ma.getRestrictions().isInstantSpeed()) {
                return false;
            }
        }
        if (m4.isComboMana()) {
            for (String s2 : m4.getComboColors(ma).split(" ")) {
                if (toPay == ManaCostShard.COLORED_X && !ManaCostBeingPaid.canColoredXShardBePaidByColor(s2, xManaCostPaidByColor) || !sa.allowsPayingWithShard(sourceCard, ManaAtom.fromName(s2)) || !"Any".equals(s2) && !ai.getManaPool().canPayForShardWithColor(toPay, ManaAtom.fromName(s2))) continue;
                return true;
            }
            return false;
        }
        if (ma.getApi() == ApiType.ManaReflected) {
            Set<String> reflected = CardUtil.getReflectableManaColors(ma);
            for (byte c : MagicColor.WUBRGC) {
                if (toPay == ManaCostShard.COLORED_X && !ManaCostBeingPaid.canColoredXShardBePaidByColor(MagicColor.toShortString(c), xManaCostPaidByColor) || !sa.allowsPayingWithShard(sourceCard, c) || !ai.getManaPool().canPayForShardWithColor(toPay, c) || !reflected.contains(MagicColor.toLongString(c))) continue;
                m4.setExpressChoice(MagicColor.toShortString(c));
                return true;
            }
            return false;
        }
        if (!sa.allowsPayingWithShard(sourceCard, MagicColor.fromName(m4.getOrigProduced()))) {
            return false;
        }
        if (toPay == ManaCostShard.COLORED_X) {
            for (String s3 : m4.mana(ma).split(" ")) {
                if (!ManaCostBeingPaid.canColoredXShardBePaidByColor(s3, xManaCostPaidByColor)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isManaSourceReserved(Player ai, Card sourceCard, SpellAbility sa) {
        if (sa == null) {
            return false;
        }
        if (!(ai.getController() instanceof PlayerControllerAi)) {
            return false;
        }
        if (AiCardMemory.isRememberedCard(ai, sourceCard, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_NEXT_SPELL)) {
            return true;
        }
        PhaseType curPhase = ai.getGame().getPhaseHandler().getPhase();
        AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
        int chanceToReserve = aic.getIntProperty(AiProps.RESERVE_MANA_FOR_MAIN2_CHANCE);
        if (curPhase == PhaseType.COMBAT_DECLARE_BLOCKERS || curPhase == PhaseType.CLEANUP) {
            if (!ai.getGame().getPhaseHandler().isPlayerTurn(ai)) {
                AiCardMemory.clearMemorySet(ai, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_ENEMY_DECLBLK);
                AiCardMemory.clearMemorySet(ai, AiCardMemory.MemorySet.CHOSEN_FOG_EFFECT);
            } else {
                AiCardMemory.clearMemorySet(ai, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_DECLBLK);
            }
        } else if (AiCardMemory.isRememberedCard(ai, sourceCard, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_DECLBLK) || AiCardMemory.isRememberedCard(ai, sourceCard, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_ENEMY_DECLBLK)) {
            return true;
        }
        if (sa.getSVar("LowPriorityAI").isEmpty() && (chanceToReserve == 0 || MyRandom.getRandom().nextInt(100) >= chanceToReserve)) {
            return false;
        }
        if (curPhase == PhaseType.MAIN2 || curPhase == PhaseType.CLEANUP) {
            AiCardMemory.clearMemorySet(ai, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2);
        } else if (AiCardMemory.isRememberedCard(ai, sourceCard, AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2)) {
            return true;
        }
        return false;
    }

    private static ManaCostShard getNextShardToPay(ManaCostBeingPaid cost, Multimap<ManaCostShard, SpellAbility> sourcesForShards) {
        ArrayList<ManaCostShard> shardsToPay = Lists.newArrayList(cost.getDistinctShards());
        shardsToPay.sort(Comparator.comparingInt(shard -> sourcesForShards.get((ManaCostShard)((Object)shard)).size()));
        return cost.getShardToPayByPriority(shardsToPay, ColorSet.ALL_COLORS.getColor());
    }

    private static void adjustManaCostToAvoidNegEffects(ManaCostBeingPaid cost, Card card, Player ai) {
        for (String manaPart : card.getSVar("ManaNeededToAvoidNegativeEffect").split(",")) {
            byte mask;
            if (manaPart.isEmpty() || cost.needsColor(mask = ManaAtom.fromName(manaPart), ai.getManaPool()) || cost.getGenericManaAmount() <= 0) continue;
            ManaCostShard shard = ManaCostShard.valueOf(mask);
            cost.increaseShard(shard, 1);
            cost.decreaseGenericMana(1);
        }
    }

    private static void getComboManaChoice(Player ai, SpellAbility manaAb, SpellAbility saRoot, ManaCostBeingPaid cost) {
        StringBuilder choiceString = new StringBuilder();
        Card source = manaAb.getHostCard();
        AbilityManaPart abMana = manaAb.getManaPart();
        if (abMana.isComboMana()) {
            int amount = manaAb.hasParam("Amount") ? AbilityUtils.calculateAmount(source, manaAb.getParam("Amount"), manaAb) : 1;
            ManaCostBeingPaid testCost = new ManaCostBeingPaid(cost);
            String[] comboColors = abMana.getComboColors(manaAb).split(" ");
            for (int nMana = 1; nMana <= amount; ++nMana) {
                String commonColor;
                String choice = "";
                if (!abMana.getExpressChoice().isEmpty()) {
                    choice = abMana.getExpressChoice();
                    abMana.clearExpressChoice();
                    byte colorMask = ManaAtom.fromName(choice);
                    if (manaAb.canProduce(choice) && ComputerUtilMana.satisfiesColorChoice(abMana, choiceString, choice) && testCost.isAnyPartPayableWith(colorMask, ai.getManaPool())) {
                        choiceString.append(choice);
                        ComputerUtilMana.payMultipleMana(testCost, choice, ai);
                        continue;
                    }
                }
                if (!testCost.isPaid()) {
                    for (String color : comboColors) {
                        if (!ComputerUtilMana.satisfiesColorChoice(abMana, choiceString, choice) || !testCost.needsColor(ManaAtom.fromName(color), ai.getManaPool())) continue;
                        ComputerUtilMana.payMultipleMana(testCost, color, ai);
                        if (nMana != 1) {
                            choiceString.append(" ");
                        }
                        choiceString.append(color);
                        choice = color;
                        break;
                    }
                    if (!choice.isEmpty()) continue;
                }
                if (!(commonColor = ComputerUtilCard.getMostProminentColor(ai.getCardsIn(ZoneType.Hand))).isEmpty() && ComputerUtilMana.satisfiesColorChoice(abMana, choiceString, MagicColor.toShortString(commonColor)) && abMana.getComboColors(manaAb).contains(MagicColor.toShortString(commonColor))) {
                    choice = MagicColor.toShortString(commonColor);
                } else {
                    for (String c : comboColors) {
                        if (!ComputerUtilMana.satisfiesColorChoice(abMana, choiceString, c)) continue;
                        choice = c;
                        break;
                    }
                }
                if (nMana != 1) {
                    choiceString.append(" ");
                }
                choiceString.append(choice);
            }
        }
        if (choiceString.toString().isEmpty()) {
            choiceString.append("0");
        }
        abMana.setExpressChoice(choiceString.toString());
    }

    private static boolean satisfiesColorChoice(AbilityManaPart abMana, StringBuilder choices, String choice) {
        return !abMana.getOrigProduced().contains("Different") || !choices.toString().contains(choice);
    }

    private static String payMultipleMana(ManaCostBeingPaid testCost, String mana, Player p) {
        ArrayList<String> unused = new ArrayList<String>(4);
        block0: for (String manaPart : TextUtil.split(mana, ' ')) {
            boolean wasNeeded;
            if (StringUtils.isNumeric(manaPart)) {
                for (int i = Integer.parseInt(manaPart); i > 0; --i) {
                    wasNeeded = testCost.ai_payMana("1", p.getManaPool());
                    if (wasNeeded) continue;
                    unused.add(Integer.toString(i));
                    continue block0;
                }
                continue;
            }
            String color = MagicColor.toShortString(manaPart);
            wasNeeded = testCost.ai_payMana(color, p.getManaPool());
            if (wasNeeded) continue;
            unused.add(color);
        }
        return unused.isEmpty() ? null : StringUtils.join(unused, ' ');
    }

    private static ListMultimap<ManaCostShard, SpellAbility> groupAndOrderToPayShards(Player ai, ListMultimap<Integer, SpellAbility> manaAbilityMap, ManaCostBeingPaid cost) {
        ArrayListMultimap<ManaCostShard, SpellAbility> res = ArrayListMultimap.create();
        if (cost.getGenericManaAmount() > 0 && manaAbilityMap.containsKey(64)) {
            res.putAll(ManaCostShard.GENERIC, (Iterable<SpellAbility>)manaAbilityMap.get((Object)64));
        }
        for (ManaCostShard shard : cost.getDistinctShards()) {
            if (shard == ManaCostShard.S) {
                res.putAll(shard, (Iterable<SpellAbility>)manaAbilityMap.get((Object)2048));
                continue;
            }
            if (shard.isOr2Generic()) {
                Integer colorKey = shard.getColorMask();
                if (manaAbilityMap.containsKey(colorKey)) {
                    res.putAll(shard, (Iterable<SpellAbility>)manaAbilityMap.get((Object)colorKey));
                }
                if (!manaAbilityMap.containsKey(64)) continue;
                res.putAll(shard, (Iterable<SpellAbility>)manaAbilityMap.get((Object)64));
                continue;
            }
            if (shard == ManaCostShard.GENERIC) continue;
            for (Integer colorint : manaAbilityMap.keySet()) {
                if (!ai.getManaPool().canPayForShardWithColor(shard, colorint.byteValue())) continue;
                for (SpellAbility sa : manaAbilityMap.get((Object)colorint)) {
                    if (res.get((Object)shard).contains(sa)) continue;
                    res.get((Object)shard).add(sa);
                }
            }
        }
        return res;
    }

    public static ManaCostBeingPaid calculateManaCost(SpellAbility sa, boolean test, int extraMana) {
        Cost payCosts;
        CostPartMana manapart;
        Card card = sa.getHostCard();
        Zone castFromBackup = null;
        if (test && sa.isSpell() && !card.isInZone(ZoneType.Stack)) {
            castFromBackup = card.getCastFrom();
            card.setCastFrom(card.getZone() != null ? card.getZone() : null);
        }
        CostPartMana costPartMana = manapart = (payCosts = CostAdjustment.adjust(sa.getPayCosts(), sa)) != null ? payCosts.getCostMana() : null;
        ManaCost mana = payCosts != null ? (manapart == null ? ManaCost.ZERO : manapart.getManaCostFor(sa)) : ManaCost.NO_COST;
        ManaCostBeingPaid cost = new ManaCostBeingPaid(mana);
        if (cost.getXcounter() > 0 || extraMana > 0) {
            String xColor;
            int manaToAdd = 0;
            int xCounter = cost.getXcounter();
            if (test && extraMana > 0) {
                int multiplicator = Math.max(xCounter, 1);
                manaToAdd = extraMana * multiplicator;
            } else {
                manaToAdd = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("XAlternative", "X"), sa) * xCounter;
            }
            if (manaToAdd < 1 && payCosts != null && payCosts.getCostMana().getXMin() > 0) {
                manaToAdd = 1;
            }
            if ((xColor = sa.getXColor()) == null) {
                xColor = "1";
            }
            if (card.hasKeyword("Spend only colored mana on X. No more than one mana of each color may be spent this way.")) {
                xColor = "WUBRGX";
            }
            if (xCounter > 0) {
                cost.setXManaCostPaid(manaToAdd / xCounter, xColor);
            } else {
                cost.increaseShard(ManaCostShard.parseNonGeneric(xColor), manaToAdd);
            }
            if (!test) {
                sa.setXManaCostPaid(manaToAdd / xCounter);
            }
        }
        CostAdjustment.adjust(cost, sa, null, test);
        if ("NumTimes".equals(sa.getParam("Announce"))) {
            ManaCost mkCost = sa.getPayCosts().getTotalMana();
            ManaCost mCost = ManaCost.ZERO;
            for (int i = 0; i < 10; ++i) {
                ManaCostBeingPaid mcbp = new ManaCostBeingPaid(mCost = ManaCost.combine(mCost, mkCost));
                if (ComputerUtilMana.canPayManaCost(mcbp, sa, sa.getActivatingPlayer(), true)) continue;
                sa.getHostCard().setSVar("NumTimes", "Number$" + i);
                break;
            }
        }
        if (test && sa.isSpell()) {
            sa.getHostCard().setCastFrom(castFromBackup);
        }
        return cost;
    }

    public static int getAvailableManaEstimate(Player p) {
        return ComputerUtilMana.getAvailableManaEstimate(p, true);
    }

    public static int getAvailableManaEstimate(Player p, boolean checkPlayable) {
        int availableMana = 0;
        CardCollection srcs = CardLists.filter((Iterable<Card>)p.getCardsIn(ZoneType.Battlefield), c -> !c.getManaAbilities().isEmpty());
        int maxProduced = 0;
        int producedWithCost = 0;
        boolean hasSourcesWithNoManaCost = false;
        for (Card src : srcs) {
            maxProduced = 0;
            for (SpellAbility ma : src.getManaAbilities()) {
                ma.setActivatingPlayer(p, true);
                if (checkPlayable && !ma.canPlay()) continue;
                int costsToActivate = ma.getPayCosts().getCostMana() != null ? ma.getPayCosts().getCostMana().convertAmount() : 0;
                int producedMana = ma.getParamOrDefault("Produced", "").split(" ").length;
                int producedAmount = AbilityUtils.calculateAmount(src, ma.getParamOrDefault("Amount", "1"), ma);
                int producedTotal = producedMana * producedAmount - costsToActivate;
                if (costsToActivate > 0) {
                    producedWithCost += producedTotal;
                } else if (!hasSourcesWithNoManaCost) {
                    hasSourcesWithNoManaCost = true;
                }
                if (producedTotal <= maxProduced) continue;
                maxProduced = producedTotal;
            }
            availableMana += maxProduced;
        }
        availableMana += p.getManaPool().totalMana();
        if (producedWithCost > 0 && !hasSourcesWithNoManaCost) {
            availableMana -= producedWithCost;
        }
        return availableMana;
    }

    public static CardCollection getAvailableManaSources(Player ai, boolean checkPlayable) {
        CardCollectionView list = CardCollection.combine(ai.getCardsIn(ZoneType.Battlefield), ai.getCardsIn(ZoneType.Hand));
        CardCollection manaSources = CardLists.filter((Iterable<Card>)list, c -> {
            for (SpellAbility am : ComputerUtilMana.getAIPlayableMana(c)) {
                am.setActivatingPlayer(ai, true);
                if (checkPlayable && (!am.canPlay() || !am.checkRestrictions(ai))) continue;
                return true;
            }
            return false;
        });
        CardCollection sortedManaSources = new CardCollection();
        CardCollection otherManaSources = new CardCollection();
        CardCollection useLastManaSources = new CardCollection();
        CardCollection colorlessManaSources = new CardCollection();
        CardCollection oneManaSources = new CardCollection();
        CardCollection twoManaSources = new CardCollection();
        CardCollection threeManaSources = new CardCollection();
        CardCollection fourManaSources = new CardCollection();
        CardCollection fiveManaSources = new CardCollection();
        CardCollection anyColorManaSources = new CardCollection();
        for (Card card : manaSources) {
            Combat combat;
            if (card.isCreature() && card.getGame().getPhaseHandler().is(PhaseType.COMBAT_DECLARE_ATTACKERS, ai) && (combat = card.getGame().getCombat()).getAttackers().indexOf(card) != -1 && !card.hasKeyword(Keyword.VIGILANCE)) continue;
            if (ai.canLoseLife() && !ai.cantLoseForZeroOrLessLife()) {
                boolean dealsLethalOnTap = false;
                for (Trigger t2 : card.getTriggers()) {
                    SpellAbility trigSa;
                    if (t2.getMode() != TriggerType.Taps && t2.getMode() != TriggerType.TapsForMana || (trigSa = t2.getOverridingAbility()).getApi() != ApiType.DealDamage || !trigSa.getParamOrDefault("Defined", "").equals("You")) continue;
                    int numDamage = AbilityUtils.calculateAmount(card, trigSa.getParam("NumDmg"), null);
                    numDamage = ai.staticReplaceDamage(numDamage, card, false);
                    if (ai.getLife() > numDamage) continue;
                    dealsLethalOnTap = true;
                    break;
                }
                if (dealsLethalOnTap) continue;
            }
            if (card.isCreature() || card.isEnchanted()) {
                otherManaSources.add(card);
                continue;
            }
            int usableManaAbilities = 0;
            boolean needsLimitedResources = false;
            boolean unpreferredCost = false;
            boolean producesAnyColor = false;
            List<SpellAbility> manaAbilities = ComputerUtilMana.getAIPlayableMana(card);
            for (SpellAbility m4 : manaAbilities) {
                AbilitySub sub;
                Cost cost;
                if (m4.getManaPart().isAnyMana()) {
                    producesAnyColor = true;
                }
                if ((cost = m4.getPayCosts()) != null) {
                    m4.setActivatingPlayer(ai, true);
                    if (!CostPayment.canPayAdditionalCosts(m4.getPayCosts(), m4, false)) continue;
                    if (!cost.isReusuableResource()) {
                        for (CostPart part : cost.getCostParts()) {
                            if (!(part instanceof CostSacrifice) || part.payCostFromSource()) continue;
                            unpreferredCost = true;
                        }
                        boolean bl = needsLimitedResources = !unpreferredCost;
                    }
                }
                if ((sub = m4.getSubAbility()) != null && !card.getName().equals("Pristine Talisman") && !card.getName().equals("Zhur-Taa Druid")) {
                    if (!SpellApiToAi.Converter.get(sub.getApi()).chkDrawbackWithSubs(ai, sub)) continue;
                    needsLimitedResources = true;
                }
                ++usableManaAbilities;
            }
            if (unpreferredCost) {
                useLastManaSources.add(card);
                continue;
            }
            if (needsLimitedResources) {
                otherManaSources.add(card);
                continue;
            }
            if (producesAnyColor) {
                anyColorManaSources.add(card);
                continue;
            }
            if (usableManaAbilities == 1) {
                if (manaAbilities.get(0).getManaPart().mana(manaAbilities.get(0)).equals("C")) {
                    colorlessManaSources.add(card);
                    continue;
                }
                oneManaSources.add(card);
                continue;
            }
            if (usableManaAbilities == 2) {
                twoManaSources.add(card);
                continue;
            }
            if (usableManaAbilities == 3) {
                threeManaSources.add(card);
                continue;
            }
            if (usableManaAbilities == 4) {
                fourManaSources.add(card);
                continue;
            }
            fiveManaSources.add(card);
        }
        sortedManaSources.addAll(sortedManaSources.size(), colorlessManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), oneManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), twoManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), threeManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), fourManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), fiveManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), anyColorManaSources);
        ComputerUtilCard.sortByEvaluateCreature(otherManaSources);
        Collections.reverse(otherManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), otherManaSources);
        ComputerUtilCard.sortByEvaluateCreature(useLastManaSources);
        Collections.reverse(useLastManaSources);
        sortedManaSources.addAll(sortedManaSources.size(), useLastManaSources);
        return sortedManaSources;
    }

    private static ListMultimap<Integer, SpellAbility> groupSourcesByManaColor(Player ai, boolean checkPlayable) {
        ArrayListMultimap<Integer, SpellAbility> manaMap = ArrayListMultimap.create();
        Game game = ai.getGame();
        for (Card sourceCard : ComputerUtilMana.getAvailableManaSources(ai, checkPlayable)) {
            for (SpellAbility m4 : ComputerUtilMana.getAIPlayableMana(sourceCard)) {
                AbilitySub sub;
                Cost abCost;
                m4.setActivatingPlayer(ai, true);
                if (checkPlayable && !m4.canPlay() || !ComputerUtilCost.checkLifeCost(ai, abCost = m4.getPayCosts(), sourceCard, 1, m4) || (sub = m4.getSubAbility()) != null && !SpellApiToAi.Converter.get(sub.getApi()).chkDrawbackWithSubs(ai, sub)) continue;
                manaMap.get((Object)64).add(m4);
                for (SpellAbility tail = m4; tail != null; tail = tail.getSubAbility()) {
                    AbilityManaPart mp = m4.getManaPart();
                    if (mp == null || !tail.metConditions()) continue;
                    String origin = mp.getOrigProduced();
                    Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(sourceCard);
                    repParams.put(AbilityKey.Mana, origin);
                    repParams.put(AbilityKey.Activator, ai);
                    repParams.put(AbilityKey.AbilityMana, m4);
                    List<ReplacementEffect> reList = game.getReplacementHandler().getReplacementList(ReplacementType.ProduceMana, repParams, ReplacementLayer.Other);
                    if (reList.isEmpty()) {
                        Set<String> reflectedColors = CardUtil.getReflectableManaColors(m4);
                        for (byte color : MagicColor.WUBRG) {
                            if (!tail.canThisProduce(MagicColor.toShortString(color)) && !reflectedColors.contains(MagicColor.toLongString(color))) continue;
                            manaMap.put(Integer.valueOf(color), m4);
                        }
                        if (!m4.canThisProduce("C") && !reflectedColors.contains("colorless")) continue;
                        manaMap.put(32, m4);
                        continue;
                    }
                    for (ReplacementEffect re : reList) {
                        String s2;
                        byte c;
                        int n;
                        int n2;
                        String color;
                        SpellAbility o = re.getOverridingAbility();
                        String replaced = origin;
                        if (o == null || o.getApi() != ApiType.ReplaceMana) continue;
                        if (o.hasParam("ReplaceMana")) {
                            replaced = o.getParam("ReplaceMana");
                        } else if (o.hasParam("ReplaceType")) {
                            color = o.getParam("ReplaceType");
                            byte[] byArray = MagicColor.WUBRGC;
                            n2 = byArray.length;
                            for (n = 0; n < n2; ++n) {
                                c = byArray[n];
                                s2 = MagicColor.toShortString(c);
                                replaced = replaced.replace(s2, color);
                            }
                        } else if (o.hasParam("ReplaceColor")) {
                            color = o.getParam("ReplaceColor");
                            if (o.hasParam("ReplaceOnly")) {
                                replaced = replaced.replace(o.getParam("ReplaceOnly"), color);
                            } else {
                                byte[] byArray = MagicColor.WUBRG;
                                n2 = byArray.length;
                                for (n = 0; n < n2; ++n) {
                                    c = byArray[n];
                                    s2 = MagicColor.toShortString(c);
                                    replaced = replaced.replace(s2, color);
                                }
                            }
                        }
                        for (byte color2 : MagicColor.WUBRG) {
                            if (!"Any".equals(replaced) && !replaced.contains(MagicColor.toShortString(color2))) continue;
                            manaMap.put(Integer.valueOf(color2), m4);
                        }
                        if (!replaced.contains("C")) continue;
                        manaMap.put(32, m4);
                    }
                }
                if (!m4.getHostCard().isSnow()) continue;
                manaMap.put(2048, m4);
            }
        }
        return manaMap;
    }

    public static int determineLeftoverMana(SpellAbility sa, Player player, boolean effect) {
        int max = 99;
        if (sa.hasParam("XMaxLimit")) {
            max = Math.min(max, AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("XMaxLimit"), sa));
        }
        for (int i = 1; i <= max; ++i) {
            if (ComputerUtilMana.canPayManaCost(sa.getRootAbility(), player, i, effect)) continue;
            return i - 1;
        }
        return max;
    }

    public static int determineLeftoverMana(SpellAbility sa, Player player, String shardColor, boolean effect) {
        ManaCost origCost = sa.getRootAbility().getPayCosts().getTotalMana();
        String shardSurplus = shardColor;
        for (int i = 1; i < 100; ++i) {
            ManaCost extra = new ManaCost(new ManaCostParser(shardSurplus));
            if (!ComputerUtilMana.canPayManaCost(new ManaCostBeingPaid(ManaCost.combine(origCost, extra)), sa, player, effect)) {
                return i - 1;
            }
            shardSurplus = shardSurplus + " " + shardColor;
        }
        return 99;
    }

    public static List<SpellAbility> getAIPlayableMana(Card c) {
        ArrayList<SpellAbility> res = new ArrayList<SpellAbility>();
        for (SpellAbility a : c.getManaAbilities()) {
            Cost cost = a.getPayCosts();
            if (cost.hasManaCost() || a.getApi() != ApiType.Mana && a.getApi() != ApiType.ManaReflected || a.getRestrictions() != null && a.getRestrictions().isInstantSpeed() || res.contains(a)) continue;
            if (cost.isReusuableResource()) {
                res.add(0, a);
                continue;
            }
            res.add(res.size(), a);
        }
        return res;
    }

    public static Map<Card, ManaCostShard> getConvokeOrImproviseFromList(ManaCost cost, List<Card> list, boolean improvise) {
        HashMap<Card, ManaCostShard> convoke = new HashMap<Card, ManaCostShard>();
        Card convoked = null;
        if (!improvise) {
            for (ManaCostShard toPay : cost) {
                if (toPay.isSnow() || toPay.isColorless()) continue;
                for (Card c : list) {
                    int mask = c.getColor().getColor() & toPay.getColorMask();
                    if (mask == 0) continue;
                    convoked = c;
                    convoke.put(c, toPay);
                    break;
                }
                if (convoked != null) {
                    list.remove(convoked);
                }
                convoked = null;
            }
        }
        for (int i = 0; i < list.size() && i < cost.getGenericCost(); ++i) {
            convoke.put(list.get(i), ManaCostShard.GENERIC);
        }
        return convoke;
    }
}

