/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import forge.ai.AiAttackController;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiCostDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilMana;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialAiLogic;
import forge.ai.SpellApiToAi;
import forge.ai.ability.AnimateAi;
import forge.ai.ability.TokenAi;
import forge.card.ColorSet;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardUtil;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostDamage;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostPart;
import forge.game.cost.CostPayLife;
import forge.game.cost.CostPayment;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveAnyCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostSacrifice;
import forge.game.cost.CostTapType;
import forge.game.cost.PaymentDecision;
import forge.game.keyword.Keyword;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.TargetChoices;
import forge.game.zone.ZoneType;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ComputerUtilCost {
    private static boolean suppressRecursiveSacCostCheck = false;

    public static void setSuppressRecursiveSacCostCheck(boolean shouldSuppress) {
        suppressRecursiveSacCostCheck = shouldSuppress;
    }

    public static boolean checkAddM1M1CounterCost(Cost cost, Card source) {
        if (cost == null) {
            return true;
        }
        for (CostPart part : cost.getCostParts()) {
            CostPutCounter addCounter;
            CounterType type;
            if (!(part instanceof CostPutCounter) || !(type = (addCounter = (CostPutCounter)part).getCounter()).is(CounterEnumType.M1M1)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkRemoveCounterCost(Cost cost, Card source, SpellAbility sa) {
        if (cost == null) {
            return true;
        }
        AiCostDecision decision = new AiCostDecision(sa.getActivatingPlayer(), sa, false);
        for (CostPart part : cost.getCostParts()) {
            CostPart remCounter;
            if (part instanceof CostRemoveCounter) {
                PaymentDecision pay;
                remCounter = (CostRemoveCounter)part;
                CounterType type = remCounter.counter;
                if (!part.payCostFromSource()) {
                    if (!type.is(CounterEnumType.P1P1)) continue;
                    return false;
                }
                if (part.payCostFromSource() && source.getCounters(type) <= 0) {
                    return false;
                }
                if (!(type.is(CounterEnumType.LOYALTY) || (pay = decision.visit((CostRemoveCounter)remCounter)) != null && pay.c > 0)) {
                    return false;
                }
                if (!type.is(CounterEnumType.P1P1) || source.getLethalDamage() > 1 || source.hasKeyword(Keyword.UNDYING)) continue;
                return false;
            }
            if (!(part instanceof CostRemoveAnyCounter)) continue;
            remCounter = (CostRemoveAnyCounter)part;
            PaymentDecision pay = decision.visit((CostRemoveAnyCounter)remCounter);
            return pay != null;
        }
        return true;
    }

    public static boolean checkDiscardCost(Player ai, Cost cost, Card source, SpellAbility sa) {
        if (cost == null) {
            return true;
        }
        CardCollection hand = new CardCollection(ai.getCardsIn(ZoneType.Hand));
        for (CostPart part : cost.getCostParts()) {
            CardCollection typeList;
            if (!(part instanceof CostDiscard)) continue;
            CostDiscard disc = (CostDiscard)part;
            String type = disc.getType();
            if (type.equals("CARDNAME")) {
                if (source.getAbilityText().contains("Bloodrush")) continue;
                if (ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN, ai) && !ai.isUnlimitedHandSize() && ai.getCardsIn(ZoneType.Hand).size() > ai.getMaxHandSize()) {
                    return true;
                }
            }
            if ((typeList = CardLists.getValidCards((Iterable<Card>)hand, type, source.getController(), source, (CardTraitBase)sa)).size() > ai.getMaxHandSize()) continue;
            int num = AbilityUtils.calculateAmount(source, disc.getAmount(), sa);
            for (int i = 0; i < num; ++i) {
                Card pref = ComputerUtil.getCardPreference(ai, source, "DiscardCost", typeList);
                if (pref == null) {
                    return false;
                }
                typeList.remove(pref);
                hand.remove(pref);
            }
        }
        return true;
    }

    public static boolean checkDamageCost(Player ai, Cost cost, Card source, int remainingLife, SpellAbility sa) {
        if (cost == null) {
            return true;
        }
        for (CostPart part : cost.getCostParts()) {
            if (!(part instanceof CostDamage)) continue;
            CostDamage pay = (CostDamage)part;
            int realDamage = ComputerUtilCombat.predictDamageTo(ai, pay.getAbilityAmount(sa), source, false);
            if (ai.getLife() - realDamage < remainingLife && realDamage > 0 && !ai.cantLoseForZeroOrLessLife() && ai.canLoseLife()) {
                return false;
            }
            if (!source.getName().equals("Skullscorch") || ai.getCardsIn(ZoneType.Hand).size() >= 2) continue;
            return false;
        }
        return true;
    }

    public static boolean checkLifeCost(Player ai, Cost cost, Card source, int remainingLife, SpellAbility sourceAbility) {
        if (cost == null) {
            return true;
        }
        for (CostPart part : cost.getCostParts()) {
            if (!(part instanceof CostPayLife)) continue;
            CostPayLife payLife = (CostPayLife)part;
            Integer amount = payLife.convertAmount();
            if (amount == null) {
                amount = AbilityUtils.calculateAmount(source, payLife.getAmount(), sourceAbility);
            }
            if (sourceAbility != null && sourceAbility.hasParam("AILifeThreshold")) {
                remainingLife = Integer.parseInt(sourceAbility.getParam("AILifeThreshold"));
            }
            if (ai.getLife() - amount >= remainingLife || ai.cantLoseForZeroOrLessLife()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkForManaSacrificeCost(Player ai, Cost cost, SpellAbility sourceAbility, boolean effect) {
        if (cost == null || !ai.isAI()) {
            return true;
        }
        for (CostPart part : cost.getCostParts()) {
            if (!(part instanceof CostSacrifice)) continue;
            CardCollection list = new CardCollection();
            CardCollection exclude = new CardCollection();
            if (AiCardMemory.getMemorySet(ai, AiCardMemory.MemorySet.PAYS_SAC_COST) != null) {
                exclude.addAll(AiCardMemory.getMemorySet(ai, AiCardMemory.MemorySet.PAYS_SAC_COST));
            }
            if (part.payCostFromSource()) {
                list.add(sourceAbility.getHostCard());
            } else if (part.getType().equals("OriginalHost")) {
                list.add(sourceAbility.getOriginalHost());
            } else {
                AiController aic;
                CardCollectionView choices;
                if (part.getAmount().equals("All")) {
                    return false;
                }
                Integer c = part.convertAmount();
                if (c == null) {
                    c = part.getAbilityAmount(sourceAbility);
                }
                if ((choices = (aic = ((PlayerControllerAi)ai.getController()).getAi()).chooseSacrificeType(part.getType(), sourceAbility, effect, c, exclude)) != null) {
                    list.addAll(choices);
                }
            }
            list.removeAll(exclude);
            if (list.isEmpty()) {
                return false;
            }
            for (Card choice : list) {
                AiCardMemory.rememberCard(ai, choice, AiCardMemory.MemorySet.PAYS_SAC_COST);
            }
            return true;
        }
        return true;
    }

    public static boolean checkCreatureSacrificeCost(Player ai, Cost cost, Card source, SpellAbility sourceAbility) {
        if (cost == null) {
            return true;
        }
        for (CostPart part : cost.getCostParts()) {
            if (!(part instanceof CostSacrifice)) continue;
            CostSacrifice sac = (CostSacrifice)part;
            int amount = AbilityUtils.calculateAmount(source, sac.getAmount(), sourceAbility);
            if (sac.payCostFromSource() && source.isCreature()) {
                return false;
            }
            String type = sac.getType();
            if (type.equals("CARDNAME")) continue;
            CardCollection sacList = new CardCollection();
            CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), type.split(";"), source.getController(), source, (CardTraitBase)sourceAbility);
            typeList = ComputerUtilCost.paymentChoicesWithoutTargets(typeList, sourceAbility, ai);
            for (int count = 0; count < amount; ++count) {
                Card prefCard = ComputerUtil.getCardPreference(ai, source, "SacCost", typeList);
                if (prefCard == null) {
                    return false;
                }
                sacList.add(prefCard);
                typeList.remove(prefCard);
            }
        }
        return true;
    }

    public static boolean checkSacrificeCost(Player ai, Cost cost, Card source, SpellAbility sourceAbility, boolean important) {
        if (cost == null) {
            return true;
        }
        for (CostPart part : cost.getCostParts()) {
            if (!(part instanceof CostSacrifice)) continue;
            if (suppressRecursiveSacCostCheck) {
                return false;
            }
            CostSacrifice sac = (CostSacrifice)part;
            int amount = AbilityUtils.calculateAmount(source, sac.getAmount(), sourceAbility);
            String type = sac.getType();
            if (type.equals("CARDNAME")) {
                boolean aiInDanger;
                if (!important) {
                    return false;
                }
                if (!CardLists.filterControlledBy((Iterable<Card>)source.getEnchantedBy(), source.getController()).isEmpty()) {
                    return false;
                }
                if (!source.isCreature()) continue;
                Combat combat = ai.getGame().getCombat();
                boolean beforeNextTurn = ai.getGame().getPhaseHandler().is(PhaseType.END_OF_TURN) && ai.getGame().getPhaseHandler().getNextTurn().equals(ai) && ComputerUtilCard.evaluateCreature(source) <= 150;
                boolean creatureInDanger = ComputerUtil.predictCreatureWillDieThisTurn(ai, source, sourceAbility, false) && !ComputerUtilCombat.willOpposingCreatureDieInCombat(ai, source, combat);
                int lifeThreshold = ai.getController().isAI() ? ((PlayerControllerAi)ai.getController()).getAi().getIntProperty(AiProps.AI_IN_DANGER_THRESHOLD) : 4;
                boolean bl = aiInDanger = ai.getLife() <= lifeThreshold && ai.canLoseLife() && !ai.cantLoseForZeroOrLessLife();
                if (creatureInDanger && !ComputerUtilCombat.isDangerousToSacInCombat(ai, source, combat)) {
                    return true;
                }
                if (!aiInDanger && beforeNextTurn) continue;
                return false;
            }
            boolean differentNames = false;
            if (type.contains("+WithDifferentNames")) {
                type = type.replace("+WithDifferentNames", "");
                differentNames = true;
            }
            CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), type.split(";"), source.getController(), source, (CardTraitBase)sourceAbility);
            if (differentNames) {
                HashSet<Card> uniqueNameCards = Sets.newHashSet();
                for (Card card : typeList) {
                    if (card.hasNoName()) continue;
                    uniqueNameCards.add(card);
                }
                typeList.clear();
                typeList.addAll(uniqueNameCards);
            }
            typeList = ComputerUtilCost.paymentChoicesWithoutTargets(typeList, sourceAbility, ai);
            for (int count = 0; count < amount; ++count) {
                Card prefCard = ComputerUtil.getCardPreference(ai, source, "SacCost", typeList, sourceAbility);
                if (prefCard == null) {
                    return false;
                }
                typeList.remove(prefCard);
            }
        }
        return true;
    }

    public static boolean checkSacrificeCost(Player ai, Cost cost, Card source, SpellAbility sourceAbility) {
        return ComputerUtilCost.checkSacrificeCost(ai, cost, source, sourceAbility, true);
    }

    public static boolean isSacrificeSelfCost(Cost cost) {
        if (cost == null) {
            return false;
        }
        for (CostPart part : cost.getCostParts()) {
            if (!(part instanceof CostSacrifice) || !part.payCostFromSource()) continue;
            return true;
        }
        return false;
    }

    public static boolean checkTapTypeCost(Player ai, Cost cost, Card source, SpellAbility sa, CardCollection alreadyTapped) {
        if (cost == null) {
            return true;
        }
        for (CostPart part : cost.getCostParts()) {
            CardCollection tapChoices;
            if (!(part instanceof CostTapType)) continue;
            String type = part.getType();
            if (sa.isCrew()) {
                Card vehicle = AnimateAi.becomeAnimated(source, sa);
                int vehicleValue = ComputerUtilCard.evaluateCreature(vehicle);
                String totalP = type.split("withTotalPowerGE")[1];
                type = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalPowerGE", totalP), "");
                CardCollection exclude = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), type.split(";"), source.getController(), source, (CardTraitBase)sa);
                exclude = CardLists.filter((Iterable<Card>)exclude, c -> ComputerUtilCard.evaluateCreature(c) >= vehicleValue);
                exclude.addAll(alreadyTapped);
                CardCollection tappedCrew = ComputerUtil.chooseTapTypeAccumulatePower(ai, type, sa, true, Integer.parseInt(totalP), exclude);
                if (tappedCrew != null) {
                    alreadyTapped.addAll(tappedCrew);
                    return true;
                }
                return false;
            }
            Integer c2 = part.convertAmount();
            if (c2 == null) {
                c2 = AbilityUtils.calculateAmount(source, part.getAmount(), sa);
            }
            CardCollection exclude = new CardCollection();
            if (AiCardMemory.getMemorySet(ai, AiCardMemory.MemorySet.PAYS_TAP_COST) != null) {
                exclude.addAll(AiCardMemory.getMemorySet(ai, AiCardMemory.MemorySet.PAYS_TAP_COST));
            }
            if (exclude.contains(source) && cost.hasTapCost()) {
                return false;
            }
            if (sa.getPayCosts().hasTapCost()) {
                exclude.add(sa.getHostCard());
            }
            if ((tapChoices = ComputerUtil.chooseTapType(ai, type, source, cost.hasTapCost(), c2, exclude, sa)) != null) {
                for (Card choice : tapChoices) {
                    AiCardMemory.rememberCard(ai, choice, AiCardMemory.MemorySet.PAYS_TAP_COST);
                }
                if (cost.hasTapCost()) {
                    AiCardMemory.rememberCard(ai, source, AiCardMemory.MemorySet.PAYS_TAP_COST);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean canPayCost(SpellAbility sa, Player player, boolean effect) {
        if (sa.getActivatingPlayer() == null) {
            sa.setActivatingPlayer(player, true);
        }
        boolean cannotBeCountered = false;
        int extraManaNeeded = 0;
        if (sa instanceof Spell) {
            Object snem;
            cannotBeCountered = !sa.isCounterableBy(null);
            for (Card c : player.getGame().getCardsIn(ZoneType.Battlefield)) {
                String[] parts;
                boolean meetsRestriction;
                snem = c.getSVar("AI_SpellsNeedExtraMana");
                if (StringUtils.isBlank((CharSequence)snem) || cannotBeCountered && c.getName().equals("Nether Void") || !(meetsRestriction = (parts = TextUtil.split((CharSequence)snem, ' ')).length == 1 || player.isValid(parts[1], c.getController(), c, (CardTraitBase)sa))) continue;
                if (StringUtils.isNumeric(parts[0])) {
                    extraManaNeeded += Integer.parseInt(parts[0]);
                    continue;
                }
                System.out.println("wrong SpellsNeedExtraMana SVar format on " + c);
            }
            for (Card c : player.getCardsIn(ZoneType.Command)) {
                if (cannotBeCountered || StringUtils.isBlank((CharSequence)(snem = c.getSVar("SpellsNeedExtraManaEffect")))) continue;
                if (StringUtils.isNumeric((CharSequence)snem)) {
                    extraManaNeeded += Integer.parseInt((String)snem);
                    continue;
                }
                System.out.println("wrong SpellsNeedExtraManaEffect SVar format on " + c);
            }
        }
        if (sa.isPwAbility()) {
            for (CostPart part : sa.getPayCosts().getCostParts()) {
                if (!(part instanceof CostRemoveCounter) || part.convertAmount() == null || part.convertAmount().intValue() != sa.getHostCard().getCurrentLoyalty() || !player.getOpponents().getCreaturesInPlay().isEmpty() && !(MyRandom.getRandom().nextFloat() < 0.5f)) continue;
                return false;
            }
        }
        if (!(sa.isTrigger() || sa.isSpell() && cannotBeCountered)) {
            for (TargetChoices tc : sa.getAllTargetChoices()) {
                for (Card tgt : tc.getTargetCards()) {
                    Cost wardCost;
                    if (!tgt.hasKeyword(Keyword.WARD) || !tgt.isInPlay() || !tgt.getController().isOpponentOf(sa.getHostCard().getController()) || !(wardCost = ComputerUtilCard.getTotalWardCost(tgt)).hasManaCost()) continue;
                    extraManaNeeded += wardCost.getTotalMana().getCMC();
                }
            }
        }
        if ("DontPayTapCostWithManaSources".equals(sa.getHostCard().getSVar("AIPaymentPreference"))) {
            for (CostPart part : sa.getPayCosts().getCostParts()) {
                if (!(part instanceof CostTapType)) continue;
                CardCollection nonManaSources = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), part.getType().split(";"), sa.getActivatingPlayer(), sa.getHostCard(), (CardTraitBase)sa);
                if ((nonManaSources = CardLists.filter((Iterable<Card>)nonManaSources, card -> {
                    boolean hasManaSa = false;
                    for (SpellAbility sa1 : card.getSpellAbilities()) {
                        if (!sa1.isManaAbility() || !sa1.getPayCosts().hasTapCost()) continue;
                        hasManaSa = true;
                        break;
                    }
                    return !hasManaSa;
                })).size() >= part.convertAmount()) continue;
                return false;
            }
        }
        if (sa.getHostCard().hasKeyword(Keyword.CASUALTY)) {
            for (CostPart part : sa.getPayCosts().getCostParts()) {
                if (!(part instanceof CostSacrifice)) continue;
                CardCollection valid = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), part.getType().split(";"), sa.getActivatingPlayer(), sa.getHostCard(), (CardTraitBase)sa);
                if (!(valid = CardLists.filter((Iterable<Card>)valid, Predicates.not(CardPredicates.hasSVar("AIDontSacToCasualty")))).isEmpty()) continue;
                return false;
            }
        }
        return ComputerUtilMana.canPayManaCost(sa, player, extraManaNeeded, effect) && CostPayment.canPayAdditionalCosts(sa.getPayCosts(), sa, effect);
    }

    public static boolean willPayUnlessCost(SpellAbility sa, Player payer, Cost cost, boolean alreadyPaid, FCollectionView<Player> payers) {
        Card source = sa.getHostCard();
        String aiLogic = sa.getParam("UnlessAI");
        boolean payForOwnOnly = "OnlyOwn".equals(aiLogic);
        boolean payOwner = sa.hasParam("UnlessAI") && aiLogic.startsWith("Defined");
        boolean payNever = "Never".equals(aiLogic);
        boolean isMine = sa.getActivatingPlayer().equals(payer);
        if (payNever) {
            return false;
        }
        if (payForOwnOnly && !isMine) {
            return false;
        }
        if (payOwner) {
            String defined = aiLogic.substring(7);
            Player player = (Player)AbilityUtils.getDefinedPlayers(source, defined, sa).get(false);
            if (!payer.equals(player)) {
                return false;
            }
        } else if ("OnlyDontControl".equals(aiLogic)) {
            if (source == null || payer.equals(source.getController())) {
                return false;
            }
        } else if ("Paralyze".equals(aiLogic)) {
            Card c = source.getEnchantingCard();
            if (c == null || c.isUntapped()) {
                return false;
            }
        } else if ("RiskFactor".equals(aiLogic)) {
            Player activator = sa.getActivatingPlayer();
            if (!activator.canDraw()) {
                return false;
            }
        } else if ("MorePowerful".equals(aiLogic)) {
            int sourceCreatures = sa.getActivatingPlayer().getCreaturesInPlay().size();
            int payerCreatures = payer.getCreaturesInPlay().size();
            if (payerCreatures > sourceCreatures + 1) {
                return false;
            }
        } else if (aiLogic != null && aiLogic.startsWith("LifeLE")) {
            if (!payer.canLoseLife()) {
                return false;
            }
            if (payer.getLife() <= AbilityUtils.calculateAmount(source, aiLogic.substring(6), sa)) {
                return true;
            }
        } else if ("WillAttack".equals(aiLogic)) {
            AiAttackController aiAtk = new AiAttackController(payer);
            Combat combat = new Combat(payer);
            aiAtk.declareAttackers(combat);
            if (combat.getAttackers().isEmpty()) {
                return false;
            }
        } else {
            if ("nonToken".equals(aiLogic) && !AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa).isEmpty() && ((Card)AbilityUtils.getDefinedCards(source, sa.getParam("Defined"), sa).get(false)).isToken()) {
                return false;
            }
            if ("LowPriority".equals(aiLogic) && MyRandom.getRandom().nextInt(100) < 67) {
                return false;
            }
            if (aiLogic != null && aiLogic.startsWith("Fabricate")) {
                CardCollection list;
                Card tokenCard;
                int n = Integer.parseInt(aiLogic.substring("Fabricate".length()));
                if (source.hasSVar("EndOfTurnLeavePlay") || ComputerUtilCard.isUselessCreature(payer, source)) {
                    return false;
                }
                Card copy = CardCopyService.getLKICopy(source);
                copy.setCounters(CounterEnumType.P1P1, (Integer)(copy.getCounters(CounterEnumType.P1P1) + n));
                copy.setZone(source.getZone());
                Combat combat = source.getGame().getCombat();
                if (combat != null && combat.isAttacking(source)) {
                    Player defender = combat.getDefenderPlayerByAttacker(source);
                    return defender.canLoseLife() && !ComputerUtilCard.canBeBlockedProfitably(defender, copy, true);
                }
                if (CombatUtil.canAttack(copy)) {
                    for (Player opp : payer.getOpponents()) {
                        if (!CombatUtil.canAttack(copy, opp) || !opp.canLoseLife() || ComputerUtilCard.canBeBlockedProfitably(opp, copy, true)) continue;
                        return true;
                    }
                }
                if (!(tokenCard = TokenAi.spawnToken(payer, sa)).isCreature() || tokenCard.getNetToughness() < 1) {
                    return true;
                }
                if ("Marionette Master".equals(source.getName())) {
                    list = CardLists.filter((Iterable<Card>)payer.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.ARTIFACTS);
                    return list.size() >= copy.getNetPower();
                }
                if ("Cultivator of Blades".equals(source.getName())) {
                    list = payer.getCreaturesInPlay();
                    return list.size() >= copy.getNetPower();
                }
                int evalCounter = ComputerUtilCard.evaluateCreature(copy);
                CardCollection tokenList = new CardCollection(source);
                for (int i = 0; i < n; ++i) {
                    tokenList.add(TokenAi.spawnToken(payer, sa));
                }
                int evalToken = ComputerUtilCard.evaluateCreatureList(tokenList);
                return evalToken < evalCounter;
            }
            if ("Riot".equals(aiLogic)) {
                return !SpecialAiLogic.preferHasteForRiot(sa, payer);
            }
        }
        if (sa.hasParam("ETB") && sa.getApi().equals((Object)ApiType.Tap)) {
            for (CostPart part : cost.getCostParts()) {
                if (!(part instanceof CostPayLife)) continue;
                CostPayLife lifeCost = (CostPayLife)part;
                Integer amount = lifeCost.convertAmount();
                if (payer.getLife() > amount + 1 && payer.canPayLife(amount, true, sa)) {
                    int landsize = payer.getLandsInPlay().size() + 1;
                    for (Card c : payer.getCardsIn(ZoneType.Hand)) {
                        if (landsize != c.getCMC()) continue;
                        boolean willPlay = ComputerUtil.hasReasonToPlayCardThisTurn(payer, c);
                        boolean canPay = c.getManaCost().canBePaidWithAvailable(ColorSet.fromNames(ComputerUtilCost.getAvailableManaColors(payer, source)).getColor());
                        if (!canPay || !willPlay) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        if (alreadyPaid || payers.size() > 1 && isMine && !payForOwnOnly) {
            return false;
        }
        if (ApiType.Counter.equals((Object)sa.getApi())) {
            FCollection<SpellAbility> spells = AbilityUtils.getDefinedSpellAbilities(source, sa.getParamOrDefault("Defined", "Targeted"), sa);
            for (SpellAbility toBeCountered : spells) {
                if (!toBeCountered.isCounterableBy(sa)) {
                    return false;
                }
                if (!toBeCountered.isOptionalTrigger() || SpellApiToAi.Converter.get(toBeCountered.getApi()).doTriggerNoCostWithSubs(payer, toBeCountered, false)) continue;
                return false;
            }
        }
        return !(!ComputerUtilCost.checkLifeCost(payer, cost, source, 4, sa) || !ComputerUtilCost.checkDamageCost(payer, cost, source, 4, sa) || !isMine && !ComputerUtilCost.checkSacrificeCost(payer, cost, source, sa) || !isMine && !ComputerUtilCost.checkDiscardCost(payer, cost, source, sa) || source.getName().equals("Tyrannize") && payer.getCardsIn(ZoneType.Hand).size() <= 2 || source.getName().equals("Perplex") && payer.getCardsIn(ZoneType.Hand).size() >= 2 || source.getName().equals("Breaking Point") && payer.getCreaturesInPlay().size() <= 1 || source.getName().equals("Chain of Vapor") && (payer.getWeakestOpponent().getCreaturesInPlay().size() <= 0 || payer.getLandsInPlay().size() <= 3));
    }

    public static Set<String> getAvailableManaColors(Player ai, Card additionalLand) {
        return ComputerUtilCost.getAvailableManaColors(ai, Lists.newArrayList(additionalLand));
    }

    public static Set<String> getAvailableManaColors(Player ai, List<Card> additionalLands) {
        CardCollection cardsToConsider = CardLists.filter((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.UNTAPPED);
        HashSet<String> colorsAvailable = Sets.newHashSet();
        if (additionalLands != null) {
            cardsToConsider.addAll(additionalLands);
        }
        for (Card c : cardsToConsider) {
            for (SpellAbility sa : c.getManaAbilities()) {
                if (sa.getManaPart() == null) continue;
                colorsAvailable.add(sa.getManaPart().getOrigProduced());
            }
        }
        return colorsAvailable;
    }

    public static boolean isFreeCastAllowedByPermanent(Player player, String altCost) {
        Game game = player.getGame();
        for (Card cardInPlay : game.getCardsIn(ZoneType.Battlefield)) {
            if (!cardInPlay.hasSVar("AllowFreeCast")) continue;
            return altCost == null ? "Always".equals(cardInPlay.getSVar("AllowFreeCast")) : altCost.equals(cardInPlay.getSVar("AllowFreeCast"));
        }
        return false;
    }

    public static int getMaxXValue(SpellAbility sa, Player ai, boolean effect) {
        Card source = sa.getHostCard();
        SpellAbility root = sa.getRootAbility();
        Cost abCost = root.getPayCosts();
        if (abCost == null || !abCost.hasXInAnyCostPart()) {
            return 0;
        }
        Integer val = null;
        if (root.costHasManaX()) {
            val = ComputerUtilMana.determineLeftoverMana(root, ai, effect);
        }
        if (sa.usesTargeting()) {
            if ("X".equals(sa.getTargetRestrictions().getMinTargets())) {
                val = (Integer)ObjectUtils.min((Comparable[])new Integer[]{val, CardUtil.getValidCardsToTarget(sa).size()});
            }
            if (sa.hasParam("AIMaxTgtsCount")) {
                val = (Integer)ObjectUtils.min((Comparable[])new Integer[]{val, AbilityUtils.calculateAmount(source, "Count$" + sa.getParam("AIMaxTgtsCount"), sa)});
            }
        }
        if ((val = (Integer)ObjectUtils.min((Comparable[])new Integer[]{val, abCost.getMaxForNonManaX(root, ai, effect)})) != null && val > 0) {
            for (CostPart part : abCost.getCostParts()) {
                Card prefCard;
                int count;
                if (!(part instanceof CostSacrifice) || part.payCostFromSource() || !part.getAmount().equals("X")) continue;
                CardCollection typeList = CardLists.getValidCards((Iterable<Card>)ai.getCardsIn(ZoneType.Battlefield), part.getType().split(";"), source.getController(), source, (CardTraitBase)sa);
                for (count = 0; count < val && (prefCard = ComputerUtil.getCardPreference(ai, source, "SacCost", typeList)) != null; ++count) {
                    typeList.remove(prefCard);
                }
                val = (Integer)ObjectUtils.min((Comparable[])new Integer[]{val, count});
            }
        }
        return ObjectUtils.defaultIfNull(val, 0);
    }

    public static CardCollection paymentChoicesWithoutTargets(Iterable<Card> choices, SpellAbility source, Player ai) {
        if (source.usesTargeting()) {
            CardCollection targets = new CardCollection(source.getTargets().getTargetCards());
            choices = Iterables.filter(choices, Predicates.not(Predicates.and(CardPredicates.isController(ai), Predicates.in(targets))));
        }
        return new CardCollection(choices);
    }
}

