/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.ai.AiAttackController;
import forge.ai.AiBlockController;
import forge.ai.AiCardMemory;
import forge.ai.AiController;
import forge.ai.AiPlayDecision;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCombat;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.CreatureEvaluator;
import forge.ai.PlayerControllerAi;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.ai.simulation.GameStateEvaluator;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostPayEnergy;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostUntap;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordCollection;
import forge.game.keyword.KeywordInterface;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbility;
import forge.game.trigger.Trigger;
import forge.game.zone.MagicStack;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.Expressions;
import forge.util.MyRandom;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ComputerUtilCard {
    public static final Comparator<Card> EvaluateCreatureComparator = (a, b) -> ComputerUtilCard.evaluateCreature(b) - ComputerUtilCard.evaluateCreature(a);
    public static final Comparator<SpellAbility> EvaluateCreatureSpellComparator = (a, b) -> ComputerUtilAbility.saEvaluator.compareEvaluator((SpellAbility)a, (SpellAbility)b, true);
    private static final CreatureEvaluator creatureEvaluator = new CreatureEvaluator();
    private static final LandEvaluator landEvaluator = new LandEvaluator();
    public static final Predicate<Deck> AI_KNOWS_HOW_TO_PLAY_ALL_CARDS = d -> {
        for (Map.Entry<DeckSection, CardPool> cp : d) {
            for (Map.Entry e : cp.getValue()) {
                if (!((PaperCard)e.getKey()).getRules().getAiHints().getRemAIDecks()) continue;
                return false;
            }
        }
        return true;
    };

    public static Card getMostExpensivePermanentAI(CardCollectionView list, SpellAbility spell, boolean targeted) {
        CardCollectionView all = list;
        if (targeted) {
            all = CardLists.filter((Iterable<Card>)all, c -> c.canBeTargetedBy(spell));
        }
        return ComputerUtilCard.getMostExpensivePermanentAI(all);
    }

    public static void sortByEvaluateCreature(CardCollection list) {
        list.sort(EvaluateCreatureComparator);
    }

    public static Card getBestArtifactAI(List<Card> list) {
        CardCollection all = CardLists.filter(list, CardPredicates.Presets.ARTIFACTS);
        if (all.size() == 0) {
            return null;
        }
        return Aggregates.itemWithMax(all, Card::getCMC);
    }

    public static Card getBestPlaneswalkerAI(List<Card> list) {
        CardCollection all = CardLists.filter(list, CardPredicates.Presets.PLANESWALKERS);
        if (all.isEmpty()) {
            return null;
        }
        return Aggregates.itemWithMax(all, Card::getCMC);
    }

    public static Card getWorstPlaneswalkerAI(List<Card> list) {
        CardCollection all = CardLists.filter(list, CardPredicates.Presets.PLANESWALKERS);
        if (all.isEmpty()) {
            return null;
        }
        return Aggregates.itemWithMin(all, Card::getCMC);
    }

    public static Card getBestPlaneswalkerToDamage(List<Card> pws) {
        Card bestTgt = null;
        int bestScore = 0;
        for (Card pw : pws) {
            int curLoyalty = pw.getCounters(CounterEnumType.LOYALTY);
            int pwScore = curLoyalty * 10;
            for (SpellAbility sa : pw.getSpellAbilities()) {
                if (!sa.hasParam("Ultimate")) continue;
                Integer loyaltyCost = 0;
                CostRemoveCounter remLoyalty = sa.getPayCosts().getCostPartByType(CostRemoveCounter.class);
                if (remLoyalty != null) {
                    loyaltyCost = remLoyalty.convertAmount();
                }
                if (loyaltyCost != null && loyaltyCost != 0 && loyaltyCost - curLoyalty <= 1) {
                    pwScore += 10000;
                }
                if (pwScore <= bestScore) continue;
                bestScore = pwScore;
                bestTgt = pw;
            }
        }
        return bestTgt;
    }

    public static Card getWorstPlaneswalkerToDamage(List<Card> pws) {
        Card bestTgt = null;
        int bestScore = Integer.MAX_VALUE;
        for (Card pw : pws) {
            int curLoyalty = pw.getCounters(CounterEnumType.LOYALTY);
            if (curLoyalty >= bestScore) continue;
            bestScore = curLoyalty;
            bestTgt = pw;
        }
        return bestTgt;
    }

    public static Card getBestEnchantmentAI(List<Card> list, SpellAbility spell, boolean targeted) {
        CardCollection all = CardLists.filter(list, CardPredicates.Presets.ENCHANTMENTS);
        if (targeted) {
            all = CardLists.filter((Iterable<Card>)all, c -> c.canBeTargetedBy(spell));
        }
        return Aggregates.itemWithMax(all, Card::getCMC);
    }

    public static Card getBestLandAI(Iterable<Card> list) {
        CardCollection land = CardLists.filter(list, CardPredicates.Presets.LANDS);
        if (land.isEmpty()) {
            return null;
        }
        CardCollection nbLand = CardLists.filter((Iterable<Card>)land, Predicates.not(CardPredicates.Presets.BASIC_LANDS));
        if (!nbLand.isEmpty()) {
            CardCollectionView aiAvailable = ((Card)nbLand.get(0)).getController().getCardsIn(Arrays.asList(ZoneType.Battlefield, ZoneType.Hand));
            if (Iterables.any(list, CardPredicates.nameEquals("Urza's Mine")) && CardLists.filter((Iterable<Card>)aiAvailable, CardPredicates.nameEquals("Urza's Mine")).isEmpty()) {
                return (Card)CardLists.filter((Iterable<Card>)nbLand, CardPredicates.nameEquals("Urza's Mine")).getFirst();
            }
            if (Iterables.any(list, CardPredicates.nameEquals("Urza's Tower")) && CardLists.filter((Iterable<Card>)aiAvailable, CardPredicates.nameEquals("Urza's Tower")).isEmpty()) {
                return (Card)CardLists.filter((Iterable<Card>)nbLand, CardPredicates.nameEquals("Urza's Tower")).getFirst();
            }
            if (Iterables.any(list, CardPredicates.nameEquals("Urza's Power Plant")) && CardLists.filter((Iterable<Card>)aiAvailable, CardPredicates.nameEquals("Urza's Power Plant")).isEmpty()) {
                return (Card)CardLists.filter((Iterable<Card>)nbLand, CardPredicates.nameEquals("Urza's Power Plant")).getFirst();
            }
            return Aggregates.random(nbLand);
        }
        String sminBL = "";
        int iminBL = Integer.MAX_VALUE;
        int n = 0;
        for (String name : MagicColor.Constant.BASIC_LANDS) {
            n = CardLists.getType(land, name).size();
            if (n >= iminBL || n <= 0) continue;
            iminBL = n;
            sminBL = name;
        }
        if (iminBL == Integer.MAX_VALUE) {
            return Iterables.find(land, CardPredicates.Presets.UNTAPPED, (Card)land.get(0));
        }
        CardCollection bLand = CardLists.getType(land, sminBL);
        Iterator<Card> iterator = Iterables.filter(bLand, CardPredicates.Presets.UNTAPPED).iterator();
        if (iterator.hasNext()) {
            Card ut = iterator.next();
            return ut;
        }
        return Aggregates.random(bLand);
    }

    public static Card getWorstLand(List<Card> lands) {
        Card worstLand = null;
        int maxScore = Integer.MIN_VALUE;
        for (Card tmp : lands) {
            int score = tmp.isTapped() ? 2 : 0;
            score += tmp.isBasicLand() ? 1 : 0;
            score -= tmp.isCreature() ? 4 : 0;
            for (Card aura : tmp.getEnchantedBy()) {
                if (aura.getController().isOpponentOf(tmp.getController())) {
                    score += 5;
                    continue;
                }
                score -= 5;
            }
            if (score == maxScore && CardLists.count(lands, CardPredicates.sharesNameWith(tmp)) > CardLists.count(lands, CardPredicates.sharesNameWith(worstLand))) {
                worstLand = tmp;
            }
            if (score <= maxScore) continue;
            worstLand = tmp;
            maxScore = score;
        }
        return worstLand;
    }

    public static Card getBestLandToAnimate(Iterable<Card> lands) {
        Card land = null;
        int maxScore = Integer.MIN_VALUE;
        for (Card tmp : lands) {
            int score = tmp.isTapped() ? 0 : 2;
            score += tmp.isBasicLand() ? 2 : 0;
            score -= tmp.isCreature() ? 4 : 0;
            if ((score -= 5 * tmp.getEnchantedBy().size()) == maxScore && CardLists.count(lands, CardPredicates.sharesNameWith(tmp)) > CardLists.count(lands, CardPredicates.sharesNameWith(land))) {
                land = tmp;
            }
            if (score <= maxScore) continue;
            land = tmp;
            maxScore = score;
        }
        return land;
    }

    public static Card getCheapestPermanentAI(Iterable<Card> all, SpellAbility spell, boolean targeted) {
        if (targeted) {
            all = CardLists.filter(all, c -> c.canBeTargetedBy(spell));
        }
        if (Iterables.isEmpty(all)) {
            return null;
        }
        Card cheapest = null;
        for (Card c2 : all) {
            if (cheapest != null && c2.getManaCost().getCMC() > cheapest.getManaCost().getCMC()) continue;
            cheapest = c2;
        }
        return cheapest;
    }

    public static Card getBestAI(Iterable<Card> list) {
        if (Iterables.all(list, CardPredicates.Presets.CREATURES)) {
            return ComputerUtilCard.getBestCreatureAI(list);
        }
        if (Iterables.all(list, CardPredicates.Presets.LANDS)) {
            return ComputerUtilCard.getBestLandAI(list);
        }
        return ComputerUtilCard.getMostExpensivePermanentAI(list);
    }

    public static Card getBestCreatureAI(Iterable<Card> list) {
        if (Iterables.size(list) == 1) {
            return Iterables.get(list, 0);
        }
        return Aggregates.itemWithMax(Iterables.filter(list, CardPredicates.Presets.CREATURES), creatureEvaluator);
    }

    public static Card getBestLandToPlayAI(Iterable<Card> list) {
        if (Iterables.size(list) == 1) {
            return Iterables.get(list, 0);
        }
        return Aggregates.itemWithMax(Iterables.filter(list, Card::hasPlayableLandFace), landEvaluator);
    }

    public static Card getWorstCreatureAI(Iterable<Card> list) {
        if (Iterables.size(list) == 1) {
            return Iterables.get(list, 0);
        }
        return Aggregates.itemWithMin(Iterables.filter(list, CardPredicates.Presets.CREATURES), creatureEvaluator);
    }

    public static Card getBestCreatureToBounceAI(Iterable<Card> list) {
        if (Iterables.size(list) == 1) {
            return Iterables.get(list, 0);
        }
        int tokenBonus = 60;
        Card biggest = null;
        int biggestvalue = -1;
        for (Card card : CardLists.filter(list, CardPredicates.Presets.CREATURES)) {
            int newvalue = ComputerUtilCard.evaluateCreature(card);
            if (biggestvalue >= (newvalue += card.isToken() ? 60 : 0)) continue;
            biggest = card;
            biggestvalue = newvalue;
        }
        return biggest;
    }

    public static Card getBestCreatureToAttackNextTurnAI(Player aiPlayer, Iterable<Card> list) {
        AiController aic = ((PlayerControllerAi)aiPlayer.getController()).getAi();
        for (Card card : list) {
            if (!aic.getPredictedCombatNextTurn().isAttacking(card)) continue;
            return card;
        }
        return null;
    }

    public static Card getWorstAI(Iterable<Card> list) {
        return ComputerUtilCard.getWorstPermanentAI(list, false, false, false, false);
    }

    public static Card getWorstPermanentAI(Iterable<Card> list, boolean biasEnch, boolean biasLand, boolean biasArt, boolean biasCreature) {
        if (Iterables.isEmpty(list)) {
            return null;
        }
        boolean hasEnchantmants = Iterables.any(list, CardPredicates.Presets.ENCHANTMENTS);
        if (biasEnch && hasEnchantmants) {
            return ComputerUtilCard.getCheapestPermanentAI(CardLists.filter(list, CardPredicates.Presets.ENCHANTMENTS), null, false);
        }
        boolean hasArtifacts = Iterables.any(list, CardPredicates.Presets.ARTIFACTS);
        if (biasArt && hasArtifacts) {
            return ComputerUtilCard.getCheapestPermanentAI(CardLists.filter(list, CardPredicates.Presets.ARTIFACTS), null, false);
        }
        if (biasLand && Iterables.any(list, CardPredicates.Presets.LANDS)) {
            return ComputerUtilCard.getWorstLand(CardLists.filter(list, CardPredicates.Presets.LANDS));
        }
        boolean hasCreatures = Iterables.any(list, CardPredicates.Presets.CREATURES);
        if (biasCreature && hasCreatures) {
            return ComputerUtilCard.getWorstCreatureAI(CardLists.filter(list, CardPredicates.Presets.CREATURES));
        }
        CardCollection lands = CardLists.filter(list, CardPredicates.Presets.LANDS);
        if (lands.size() > 6) {
            return ComputerUtilCard.getWorstLand(lands);
        }
        if (hasEnchantmants || hasArtifacts) {
            CardCollection ae = CardLists.filter(list, Predicates.and(Predicates.or(CardPredicates.Presets.ARTIFACTS, CardPredicates.Presets.ENCHANTMENTS), card -> !card.hasSVar("DoNotDiscardIfAble")));
            return ComputerUtilCard.getCheapestPermanentAI(ae, null, false);
        }
        if (hasCreatures) {
            return ComputerUtilCard.getWorstCreatureAI(CardLists.filter(list, CardPredicates.Presets.CREATURES));
        }
        return ComputerUtilCard.getCheapestPermanentAI(list, null, false);
    }

    public static final Card getCheapestSpellAI(Iterable<Card> list) {
        if (!Iterables.isEmpty(list)) {
            CardCollection cc = CardLists.filter(list, Predicates.or(CardPredicates.isType("Instant"), CardPredicates.isType("Sorcery")));
            if (cc.isEmpty()) {
                return null;
            }
            cc.sort(CardLists.CmcComparatorInv);
            Card cheapest = (Card)cc.getLast();
            if (cheapest.hasSVar("DoNotDiscardIfAble")) {
                for (int i = cc.size() - 1; i >= 0; --i) {
                    if (((Card)cc.get(i)).hasSVar("DoNotDiscardIfAble")) continue;
                    cheapest = (Card)cc.get(i);
                    break;
                }
            }
            return cheapest;
        }
        return null;
    }

    public static int evaluateCreature(Card c) {
        return creatureEvaluator.evaluateCreature(c);
    }

    public static int evaluateCreature(SpellAbility sa) {
        CardStateName currentState;
        Card host = sa.getHostCard();
        if (sa.getApi() != ApiType.PermanentCreature) {
            System.err.println("Warning: tried to evaluate a non-creature spell with evaluateCreature for card " + host + " via SA " + sa);
            return 0;
        }
        CardStateName cardStateName = currentState = sa.getCardState() != null && host.getCurrentStateName() != sa.getCardStateName() && !host.isInPlay() ? host.getCurrentStateName() : null;
        if (currentState != null) {
            host.setState(sa.getCardStateName(), false);
        }
        int eval = ComputerUtilCard.evaluateCreature(host);
        if (currentState != null) {
            host.setState(currentState, false);
        }
        return eval;
    }

    public static int evaluateCreature(Card c, boolean considerPT, boolean considerCMC) {
        return creatureEvaluator.evaluateCreature(c, considerPT, considerCMC);
    }

    public static int evaluatePermanentList(CardCollectionView list) {
        int value = 0;
        for (int i = 0; i < list.size(); ++i) {
            value += ((Card)list.get(i)).getCMC() + 1;
        }
        return value;
    }

    public static int evaluateCreatureList(CardCollectionView list) {
        return Aggregates.sum(list, creatureEvaluator);
    }

    public static Map<String, Integer> evaluateCreatureListByName(CardCollectionView list) {
        HashMap<String, Integer> values = Maps.newHashMap();
        for (Card c : list) {
            String name = c.getName();
            int val = ComputerUtilCard.evaluateCreature(c);
            if (values.containsKey(name)) {
                values.put(name, (Integer)values.get(name) + val);
                continue;
            }
            values.put(name, val);
        }
        return values;
    }

    public static boolean doesCreatureAttackAI(Player aiPlayer, Card card) {
        AiController aic = ((PlayerControllerAi)aiPlayer.getController()).getAi();
        return aic.getPredictedCombat().isAttacking(card);
    }

    public static boolean doesSpecifiedCreatureAttackAI(Player ai, Card card) {
        AiAttackController aiAtk = new AiAttackController(ai, card);
        Combat combat = new Combat(ai);
        aiAtk.declareAttackers(combat);
        return combat.isAttacking(card);
    }

    public static CardCollectionView getLikelyBlockers(Player ai, CardCollectionView blockers) {
        AiBlockController aiBlk = new AiBlockController(ai, false);
        Player opp = AiAttackController.choosePreferredDefenderPlayer(ai);
        Combat combat = new Combat(opp);
        Combat currentCombat = ai.getGame().getCombat();
        if (currentCombat != null && currentCombat.getAttackingPlayer() != ai) {
            for (Card c : currentCombat.getAttackers()) {
                combat.addAttacker(c, ai);
            }
        } else {
            for (Card c : opp.getCreaturesInPlay()) {
                if (!ComputerUtilCombat.canAttackNextTurn(c, ai)) continue;
                combat.addAttacker(c, ai);
            }
        }
        if (blockers == null || blockers.isEmpty()) {
            aiBlk.assignBlockersForCombat(combat);
        } else {
            aiBlk.assignAdditionalBlockers(combat, blockers);
        }
        return combat.getAllBlockers();
    }

    public static boolean doesSpecifiedCreatureBlock(Player ai, Card blocker) {
        return ComputerUtilCard.getLikelyBlockers(ai, new CardCollection(blocker)).contains(blocker);
    }

    public static boolean canBeBlockedProfitably(Player ai, Card attacker, boolean checkingOther) {
        AiBlockController aiBlk = new AiBlockController(ai, checkingOther);
        Combat combat = new Combat(ai);
        combat.addAttacker(attacker, ai);
        ArrayList<Card> attackers = Lists.newArrayList(attacker);
        aiBlk.assignBlockersGivenAttackers(combat, attackers);
        return ComputerUtilCombat.attackerWouldBeDestroyed(ai, attacker, combat);
    }

    public static boolean canBeKilledByRoyalAssassin(Player ai, Card card) {
        boolean wasTapped = card.isTapped();
        for (Player opp : ai.getOpponents()) {
            for (Card c : opp.getCardsIn(ZoneType.Battlefield)) {
                for (SpellAbility sa : c.getSpellAbilities()) {
                    if (sa.getApi() != ApiType.Destroy || !ComputerUtilCost.canPayCost(sa, opp, sa.isTrigger())) continue;
                    sa.setActivatingPlayer(opp, true);
                    if (sa.canTarget(card)) continue;
                    card.setTapped(true);
                    if (!sa.canTarget(card)) {
                        card.setTapped(wasTapped);
                        continue;
                    }
                    card.setTapped(wasTapped);
                    return true;
                }
            }
        }
        return false;
    }

    public static Card getMostExpensivePermanentAI(Iterable<Card> all) {
        Card biggest = null;
        int bigCMC = -1;
        for (Card card : all) {
            int curCMC = card.getCMC();
            if (card.isEnchanted()) {
                CardCollection auras = CardLists.filterControlledBy((Iterable<Card>)card.getEnchantedBy(), card.getController());
                curCMC += Aggregates.sum(auras, Card::getCMC) + auras.size();
            }
            if (curCMC < bigCMC) continue;
            bigCMC = curCMC;
            biggest = card;
        }
        return biggest;
    }

    public static String getMostProminentCardName(CardCollectionView list) {
        if (list.size() == 0) {
            return "";
        }
        HashMap<String, Integer> map = Maps.newHashMap();
        for (Card c : list) {
            String name;
            Integer currentCnt = (Integer)map.get(name = c.getName());
            map.put(name, currentCnt == null ? Integer.valueOf(1) : Integer.valueOf(1 + currentCnt));
        }
        int max = 0;
        String maxName = "";
        for (Map.Entry entry : map.entrySet()) {
            String type = (String)entry.getKey();
            if (max >= (Integer)entry.getValue()) continue;
            max = (Integer)entry.getValue();
            maxName = type;
        }
        return maxName;
    }

    public static String getMostProminentType(CardCollectionView list, Collection<String> valid) {
        return ComputerUtilCard.getMostProminentType(list, valid, true);
    }

    public static String getMostProminentType(CardCollectionView list, Collection<String> valid, boolean includeTokens) {
        if (list.size() == 0) {
            return "";
        }
        HashMap<String, Integer> typesInDeck = Maps.newHashMap();
        for (Card c : list) {
            if (!includeTokens && c.isToken() || c.getType().hasAllCreatureTypes()) continue;
            boolean isClone = false;
            for (ReplacementEffect re : c.getReplacementEffects()) {
                if (re.getLayer() != ReplacementLayer.Copy) continue;
                isClone = true;
                break;
            }
            if (isClone) continue;
            int weight = 1;
            if (c.isInZone(ZoneType.Hand) || c.isRealCommander()) {
                weight = 2;
            }
            Set<String> cardCreatureTypes = c.getType().getCreatureTypes();
            for (String type : cardCreatureTypes) {
                String[] count = typesInDeck.getOrDefault(type, 0);
                typesInDeck.put(type, count.intValue() + weight);
            }
            if (!includeTokens) continue;
            for (SpellAbility sa : c.getAllSpellAbilities()) {
                if (sa.getApi() != ApiType.Token || !sa.hasParam("TokenTypes")) continue;
                for (String var : sa.getParam("TokenTypes").split(",")) {
                    if (!CardType.isACreatureType(var)) continue;
                    Integer count = typesInDeck.getOrDefault(var, 0);
                    typesInDeck.put(var, count + weight);
                }
            }
            for (Trigger t2 : c.getTriggers()) {
                SpellAbility sa = t2.ensureAbility();
                if (sa == null || sa.getApi() != ApiType.Token || !sa.hasParam("TokenTypes")) continue;
                for (String var : sa.getParam("TokenTypes").split(",")) {
                    if (!CardType.isACreatureType(var)) continue;
                    Integer count = typesInDeck.getOrDefault(var, 0);
                    typesInDeck.put(var, count + weight);
                }
            }
            if (!c.hasKeyword(Keyword.FABRICATE)) continue;
            Integer count = typesInDeck.getOrDefault("Servo", 0);
            typesInDeck.put("Servo", count + weight);
        }
        int max = 0;
        String maxType = "";
        for (Map.Entry entry : typesInDeck.entrySet()) {
            String type = (String)entry.getKey();
            if (max >= (Integer)entry.getValue()) continue;
            max = (Integer)entry.getValue();
            maxType = type;
        }
        return maxType;
    }

    public static String getMostProminentCardType(CardCollectionView list, Collection<String> valid) {
        if (list.isEmpty() || valid.isEmpty()) {
            return "";
        }
        HashMap<String, Integer> typesInDeck = Maps.newHashMap();
        for (String type : valid) {
            typesInDeck.put(type, 0);
        }
        for (Card c : list) {
            Iterable<CardType.CoreType> cardTypes = c.getType().getCoreTypes();
            for (Object type : cardTypes) {
                Integer count = (Integer)typesInDeck.get(type.toString());
                if (count == null) continue;
                typesInDeck.put(type.toString(), count + 1);
            }
        }
        int max = 0;
        Object maxType = "";
        for (Map.Entry entry : typesInDeck.entrySet()) {
            Object type;
            type = (String)entry.getKey();
            if (max >= (Integer)entry.getValue()) continue;
            max = (Integer)entry.getValue();
            maxType = type;
        }
        return maxType;
    }

    public static String getMostProminentColor(Iterable<Card> list) {
        byte colors = CardFactoryUtil.getMostProminentColors(list);
        for (byte c : MagicColor.WUBRG) {
            if ((colors & c) == 0) continue;
            return MagicColor.toLongString(c);
        }
        return "white";
    }

    public static String getMostProminentColor(CardCollectionView list, List<String> restrictedToColors) {
        byte colors = CardFactoryUtil.getMostProminentColorsFromList(list, restrictedToColors);
        for (byte c : MagicColor.WUBRG) {
            if ((colors & c) == 0) continue;
            return MagicColor.toLongString(c);
        }
        return restrictedToColors.get(0);
    }

    public static List<String> getColorByProminence(List<Card> list) {
        int cntColors = MagicColor.WUBRG.length;
        ArrayList<Pair> map = new ArrayList<Pair>();
        for (int i = 0; i < cntColors; ++i) {
            map.add(MutablePair.of(MagicColor.WUBRG[i], 0));
        }
        for (Card crd : list) {
            ColorSet color = crd.getColor();
            if (color.hasWhite()) {
                ((Pair)map.get(0)).setValue((Integer)((Pair)map.get(0)).getValue() + 1);
            }
            if (color.hasBlue()) {
                ((Pair)map.get(1)).setValue((Integer)((Pair)map.get(1)).getValue() + 1);
            }
            if (color.hasBlack()) {
                ((Pair)map.get(2)).setValue((Integer)((Pair)map.get(2)).getValue() + 1);
            }
            if (color.hasRed()) {
                ((Pair)map.get(3)).setValue((Integer)((Pair)map.get(3)).getValue() + 1);
            }
            if (!color.hasGreen()) continue;
            ((Pair)map.get(4)).setValue((Integer)((Pair)map.get(4)).getValue() + 1);
        }
        map.sort(Comparator.comparingInt(Pair::getValue).reversed());
        ArrayList<String> result = new ArrayList<String>(cntColors);
        for (Pair idx : map) {
            result.add(MagicColor.toLongString((Byte)idx.getKey()));
        }
        return result;
    }

    public static List<String> chooseColor(SpellAbility sa, int min2, int max, List<String> colorChoices) {
        ArrayList<String> chosen = new ArrayList<String>();
        Player ai = sa.getActivatingPlayer();
        Game game = ai.getGame();
        Player opp = ai.getStrongestOpponent();
        if (sa.hasParam("AILogic")) {
            String logic = sa.getParam("AILogic");
            if (logic.equals("MostProminentInHumanDeck")) {
                chosen.add(ComputerUtilCard.getMostProminentColor(CardLists.filterControlledBy((Iterable<Card>)game.getCardsInGame(), opp), colorChoices));
            } else if (logic.equals("MostProminentInComputerDeck")) {
                chosen.add(ComputerUtilCard.getMostProminentColor(CardLists.filterControlledBy((Iterable<Card>)game.getCardsInGame(), ai), colorChoices));
            } else if (logic.equals("MostProminentDualInComputerDeck")) {
                List<String> prominence = ComputerUtilCard.getColorByProminence(CardLists.filterControlledBy((Iterable<Card>)game.getCardsInGame(), ai));
                chosen.add(prominence.get(0));
                chosen.add(prominence.get(1));
            } else if (logic.equals("MostProminentInGame")) {
                chosen.add(ComputerUtilCard.getMostProminentColor(game.getCardsInGame(), colorChoices));
            } else if (logic.equals("MostProminentHumanCreatures")) {
                CardCollection list = opp.getCreaturesInPlay();
                if (list.isEmpty()) {
                    list = CardLists.filter((Iterable<Card>)CardLists.filterControlledBy((Iterable<Card>)game.getCardsInGame(), opp), CardPredicates.Presets.CREATURES);
                }
                chosen.add(ComputerUtilCard.getMostProminentColor(list, colorChoices));
            } else if (logic.equals("MostProminentComputerControls")) {
                chosen.add(ComputerUtilCard.getMostProminentColor(ai.getCardsIn(ZoneType.Battlefield), colorChoices));
            } else if (logic.equals("MostProminentHumanControls")) {
                chosen.add(ComputerUtilCard.getMostProminentColor(opp.getCardsIn(ZoneType.Battlefield), colorChoices));
            } else if (logic.equals("MostProminentPermanent")) {
                chosen.add(ComputerUtilCard.getMostProminentColor(game.getCardsIn(ZoneType.Battlefield), colorChoices));
            } else if (logic.equals("MostProminentAttackers") && game.getPhaseHandler().inCombat()) {
                chosen.add(ComputerUtilCard.getMostProminentColor(game.getCombat().getAttackers(), colorChoices));
            } else if (logic.equals("MostProminentInActivePlayerHand")) {
                chosen.add(ComputerUtilCard.getMostProminentColor(game.getPhaseHandler().getPlayerTurn().getCardsIn(ZoneType.Hand), colorChoices));
            } else if (logic.equals("MostProminentInComputerDeckButGreen")) {
                List<String> prominence = ComputerUtilCard.getColorByProminence(CardLists.filterControlledBy((Iterable<Card>)game.getCardsInGame(), ai));
                if (prominence.get(0).equals("green")) {
                    chosen.add(prominence.get(1));
                } else {
                    chosen.add(prominence.get(0));
                }
            } else if (logic.equals("MostExcessOpponentControls")) {
                int maxExcess = 0;
                String bestColor = "green";
                for (byte color : MagicColor.WUBRG) {
                    CardCollectionView ailist = ai.getColoredCardsInPlay(color);
                    CardCollectionView opplist = opp.getColoredCardsInPlay(color);
                    int excess = ComputerUtilCard.evaluatePermanentList(opplist) - ComputerUtilCard.evaluatePermanentList(ailist);
                    if (excess <= maxExcess) continue;
                    maxExcess = excess;
                    bestColor = MagicColor.toLongString(color);
                }
                chosen.add(bestColor);
            } else if (logic.equals("MostProminentKeywordInComputerDeck")) {
                CardCollectionView list = ai.getAllCards();
                int m1 = 0;
                String chosenColor = "white";
                for (String c : MagicColor.Constant.ONLY_COLORS) {
                    int cmp = CardLists.filter((Iterable<Card>)list, CardPredicates.containsKeyword(c)).size();
                    if (cmp <= m1) continue;
                    m1 = cmp;
                    chosenColor = c;
                }
                chosen.add(chosenColor);
            } else if (logic.equals("HighestDevotionToColor")) {
                int curDevotion = 0;
                String chosenColor = "white";
                CardCollectionView hand = ai.getCardsIn(ZoneType.Hand);
                for (byte c : MagicColor.WUBRG) {
                    String devotionCode = "Count$Devotion." + MagicColor.toLongString(c);
                    int devotion = AbilityUtils.calculateAmount(sa.getHostCard(), devotionCode, sa);
                    if (devotion <= curDevotion || !Iterables.any(hand, CardPredicates.isColor(c))) continue;
                    curDevotion = devotion;
                    chosenColor = MagicColor.toLongString(c);
                }
                chosen.add(chosenColor);
            }
        }
        if (chosen.isEmpty()) {
            chosen.add(ComputerUtilCard.getMostProminentColor(ai.getAllCards(), colorChoices));
        }
        return chosen;
    }

    public static boolean useRemovalNow(SpellAbility sa, Card c, int dmg, ZoneType destination) {
        float valueNow;
        float threat;
        float valueTempo;
        int costTarget;
        Player opp;
        block40: {
            block42: {
                AiController aic;
                Player ai;
                block41: {
                    block39: {
                        SpellAbility topStack;
                        MagicStack stack;
                        Combat combat;
                        Combat currCombat;
                        ai = sa.getActivatingPlayer();
                        aic = ((PlayerControllerAi)ai.getController()).getAi();
                        Game game = ai.getGame();
                        PhaseHandler ph = game.getPhaseHandler();
                        PhaseType phaseType = ph.getPhase();
                        opp = ph.getPlayerTurn().isOpponentOf(ai) ? ph.getPlayerTurn() : ai.getStrongestOpponent();
                        int costRemoval = sa.getHostCard().getCMC();
                        costTarget = c.getCMC();
                        if (!sa.isSpell()) {
                            return true;
                        }
                        if (phaseType == PhaseType.MAIN1 && ComputerUtil.castSpellInMain1(ai, sa)) {
                            return true;
                        }
                        if (ph.is(PhaseType.MAIN1) && ph.isPlayerTurn(ai) && c.isCreature()) {
                            AiAttackController aiAtk = new AiAttackController(ai);
                            Iterator combat2 = new Combat(ai);
                            aiAtk.removeBlocker(c);
                            aiAtk.declareAttackers((Combat)((Object)combat2));
                            if (!((Combat)((Object)combat2)).getAttackers().isEmpty()) {
                                AiAttackController aiAtk2 = new AiAttackController(ai);
                                Combat combat22 = new Combat(ai);
                                aiAtk2.declareAttackers(combat22);
                                if (((Combat)((Object)combat2)).getAttackers().size() > combat22.getAttackers().size()) {
                                    return true;
                                }
                            }
                        }
                        if (ph.is(PhaseType.COMBAT_DECLARE_BLOCKERS) && !ph.isPlayerTurn(ai) && (currCombat = game.getCombat()) != null && !currCombat.getAllBlockers().isEmpty() && currCombat.getAllBlockers().contains(c)) {
                            for (Card attacker : currCombat.getAttackersBlockedBy(c)) {
                                if (attacker.getShieldCount() != 0 || !ComputerUtilCombat.attackerWouldBeDestroyed(ai, attacker, currCombat)) continue;
                                CardCollection blockers = currCombat.getBlockers(attacker);
                                ComputerUtilCard.sortByEvaluateCreature(blockers);
                                combat = new Combat(ai);
                                combat.addAttacker(attacker, opp);
                                for (Card blocker : blockers) {
                                    if (blocker == c) continue;
                                    combat.addBlocker(attacker, blocker);
                                }
                                if (ComputerUtilCombat.attackerWouldBeDestroyed(ai, attacker, combat)) continue;
                                return true;
                            }
                        }
                        if (c.isEnchanted()) {
                            boolean myEnchants = false;
                            for (Card enc : c.getEnchantedBy()) {
                                if (!enc.getOwner().equals(ai)) continue;
                                myEnchants = true;
                                break;
                            }
                            if (!myEnchants) {
                                return true;
                            }
                        }
                        if (!(stack = game.getStack()).isEmpty() && (topStack = stack.peekAbility()).getActivatingPlayer().equals(opp) && c.equals(topStack.getTargetCard()) && topStack.isSpell()) {
                            return true;
                        }
                        float valueBurn = 0.0f;
                        if (dmg > 0) {
                            if (sa.getDescription().contains("would die, exile it instead")) {
                                destination = ZoneType.Exile;
                            }
                            valueBurn = 1.0f * (float)c.getNetToughness() / (float)dmg;
                            valueBurn *= valueBurn;
                            if (sa.getTargetRestrictions().canTgtPlayer()) {
                                valueBurn /= 2.0f;
                            }
                            if ((double)valueBurn >= 0.8 && phaseType.isBefore(PhaseType.COMBAT_END)) {
                                return true;
                            }
                        }
                        valueTempo = Math.max(0.1f * (float)costTarget / (float)costRemoval, valueBurn);
                        if (c.isEquipped()) {
                            valueTempo *= 2.0f;
                        }
                        if (SpellAbilityAi.isSorcerySpeed(sa, ai)) {
                            valueTempo *= 2.0f;
                        }
                        if (!c.canBeDestroyed()) {
                            valueTempo *= 2.0f;
                        }
                        if (!destination.equals((Object)ZoneType.Graveyard) && c.hasKeyword(Keyword.PERSIST) || c.hasKeyword(Keyword.UNDYING) || c.hasKeyword(Keyword.MODULAR)) {
                            valueTempo *= 2.0f;
                        }
                        if (destination.equals((Object)ZoneType.Hand) && !c.isToken()) {
                            valueTempo /= 2.0f;
                        }
                        if (c.isLand()) {
                            valueTempo += 0.5f / (float)opp.getLandsInPlay().size();
                            if ("Land".equals(sa.getParam("ValidTgts")) && ph.getPhase().isAfter(PhaseType.COMBAT_END)) {
                                valueTempo = (float)((double)valueTempo + 0.5);
                            }
                        }
                        if (!ph.isPlayerTurn(ai) && ph.getPhase().equals((Object)PhaseType.END_OF_TURN)) {
                            valueTempo *= 2.0f;
                        }
                        if ((double)valueTempo >= 0.8 && ph.getPhase().isBefore(PhaseType.COMBAT_END)) {
                            return true;
                        }
                        threat = 0.0f;
                        if (!c.isCreature()) break block39;
                        threat += (-1.0f + 1.0f * (float)ComputerUtilCard.evaluateCreature(c) / 100.0f) / (float)costRemoval;
                        if (ai.getLife() > 0 && ComputerUtilCombat.canAttackNextTurn(c)) {
                            combat = game.getCombat();
                            threat += 1.0f * (float)ComputerUtilCombat.damageIfUnblocked(c, ai, combat, true) / (float)ai.getLife();
                        }
                        if (ph.isPlayerTurn(ai) && phaseType.isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                            threat *= 0.1f;
                        }
                        if (!ph.isPlayerTurn(ai) && (phaseType.isBefore(PhaseType.COMBAT_BEGIN) || phaseType.isAfter(PhaseType.COMBAT_DECLARE_BLOCKERS))) {
                            threat *= 0.1f;
                        }
                        break block40;
                    }
                    if (!c.isPlaneswalker()) break block41;
                    threat = 1.0f;
                    break block40;
                }
                if (!aic.getBooleanProperty(AiProps.ACTIVELY_DESTROY_ARTS_AND_NONAURA_ENCHS) || (!c.isArtifact() || c.isCreature()) && (!c.isEnchantment() || c.isAura())) break block42;
                boolean priority = false;
                if (!c.getOwner().isOpponentOf(ai) || !c.getController().isOpponentOf(ai)) break block40;
                for (StaticAbility stAb : c.getStaticAbilities()) {
                    Map<String, String> params = stAb.getMapParams();
                    if (!params.get("Mode").equals("Continuous") || !stAb.isIntrinsic()) continue;
                    priority = true;
                    break;
                }
                if (!priority) {
                    for (Trigger t2 : c.getTriggers()) {
                        if (!t2.isIntrinsic()) continue;
                        priority = true;
                        break;
                    }
                }
                if (!priority) {
                    for (String value : c.getSVars().values()) {
                        if (!value.contains("AILogic$ Curse")) continue;
                        priority = true;
                        break;
                    }
                }
                if (!priority) break block40;
                threat = 1.0f;
                break block40;
            }
            for (StaticAbility stAb : c.getStaticAbilities()) {
                String kws;
                Map<String, String> params = stAb.getMapParams();
                if (!params.get("Mode").equals("Continuous") || !"Creature.YouCtrl".equals(params.get("Affected"))) continue;
                int bonusPT = 0;
                if (params.containsKey("AddPower")) {
                    bonusPT += AbilityUtils.calculateAmount(c, params.get("AddPower"), stAb);
                }
                if (params.containsKey("AddToughness")) {
                    bonusPT += AbilityUtils.calculateAmount(c, params.get("AddPower"), stAb);
                }
                if ((kws = params.get("AddKeyword")) != null) {
                    bonusPT += 4 * (1 + StringUtils.countMatches((CharSequence)kws, "&"));
                }
                if (bonusPT <= 0) continue;
                threat = (float)(bonusPT * (1 + opp.getCreaturesInPlay().size())) / 10.0f;
            }
        }
        if (!c.getManaAbilities().isEmpty()) {
            threat += 0.5f * (float)costTarget / (float)opp.getLandsInPlay().size();
        }
        if ((double)(valueNow = Math.max(valueTempo, threat)) < 0.2) {
            return false;
        }
        float chance = MyRandom.getRandom().nextFloat();
        return chance < valueNow;
    }

    public static boolean shouldPumpCard(Player ai, SpellAbility sa, Card c, int toughness, int power, List<String> keywords) {
        return ComputerUtilCard.shouldPumpCard(ai, sa, c, toughness, power, keywords, false);
    }

    public static boolean shouldPumpCard(Player ai, SpellAbility sa, Card c, int toughness, int power, List<String> keywords, boolean immediately) {
        boolean isHeldCombatTrick;
        boolean wantToHoldTrick;
        AiController aic;
        Game game = ai.getGame();
        PhaseHandler phase = game.getPhaseHandler();
        Combat combat = phase.getCombat();
        boolean main1Preferred = "Main1IfAble".equals(sa.getParam("AILogic")) && phase.is(PhaseType.MAIN1, ai);
        boolean isBerserk = "Berserk".equals(sa.getParam("AILogic"));
        boolean loseCardAtEOT = "Sacrifice".equals(sa.getParam("AtEOT")) || "Exile".equals(sa.getParam("AtEOT")) || "Destroy".equals(sa.getParam("AtEOT")) || "ExileCombat".equals(sa.getParam("AtEOT"));
        boolean combatTrick = false;
        boolean holdCombatTricks = false;
        int chanceToHoldCombatTricks = -1;
        boolean simAI = false;
        if (ai.getController().isAI() && !(simAI = (aic = ((PlayerControllerAi)ai.getController()).getAi()).usesSimulation())) {
            holdCombatTricks = aic.getBooleanProperty(AiProps.TRY_TO_HOLD_COMBAT_TRICKS_UNTIL_BLOCK);
            chanceToHoldCombatTricks = aic.getIntProperty(AiProps.CHANCE_TO_HOLD_COMBAT_TRICKS_UNTIL_BLOCK);
        }
        if (!c.canBeTargetedBy(sa)) {
            return false;
        }
        if (c.getNetToughness() + toughness <= 0) {
            return false;
        }
        if (sa.getHostCard().equals(c) && ComputerUtilCost.isSacrificeSelfCost(sa.getPayCosts())) {
            return false;
        }
        if (phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && phase.isPlayerTurn(ai) && (SpellAbilityAi.isSorcerySpeed(sa, ai) || main1Preferred) && power > 0 && ComputerUtilCard.doesCreatureAttackAI(ai, c)) {
            return true;
        }
        if (immediately && phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_BLOCKERS) && !loseCardAtEOT && (phase.isPlayerTurn(ai) ? CombatUtil.canAttack(c) || phase.inCombat() && c.isAttacking() : CombatUtil.canBlock(c))) {
            return true;
        }
        if (keywords.contains("Banding") && !c.hasKeyword(Keyword.BANDING)) {
            if (phase.is(PhaseType.COMBAT_BEGIN) && phase.isPlayerTurn(ai) && !ComputerUtilCard.doesCreatureAttackAI(ai, c)) {
                Card bandingCard = ComputerUtilCard.getPumpedCreature(ai, sa, c, toughness, power, keywords);
                AiAttackController aiAtk = new AiAttackController(ai);
                Combat predicted = new Combat(ai);
                aiAtk.declareAttackers(predicted);
                aiAtk.reinforceWithBanding(predicted, bandingCard);
                if (predicted.isAttacking(bandingCard) && predicted.getBandOfAttacker(bandingCard).getAttackers().size() > 1) {
                    return true;
                }
            } else if (phase.is(PhaseType.COMBAT_DECLARE_BLOCKERS) && combat != null) {
                for (Card atk : combat.getAttackers()) {
                    if (!atk.getController().isOpponentOf(ai)) continue;
                    CardCollection blockers = combat.getBlockers(atk);
                    boolean hasBanding = false;
                    for (Object blocker : blockers) {
                        if (!((Card)blocker).hasKeyword(Keyword.BANDING)) continue;
                        hasBanding = true;
                        break;
                    }
                    if (hasBanding || (!blockers.contains(c) || blockers.size() <= 1) && !atk.hasKeyword(Keyword.TRAMPLE)) continue;
                    return true;
                }
            }
        }
        Player opp = ai.getWeakestOpponent();
        Card pumped = ComputerUtilCard.getPumpedCreature(ai, sa, c, toughness, power, keywords);
        CardCollection oppCreatures = opp.getCreaturesInPlay();
        float chance = 0.0f;
        if (phase.getPhase().isBefore(PhaseType.COMBAT_DECLARE_ATTACKERS) && phase.isPlayerTurn(ai) && opp.getLife() > 0) {
            if (!ComputerUtilCard.doesCreatureAttackAI(ai, c) && ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, pumped)) {
                float threat = 1.0f * (float)ComputerUtilCombat.damageIfUnblocked(pumped, opp, combat, true) / (float)opp.getLife();
                if (!Iterables.any(oppCreatures, CardPredicates.possibleBlockers(pumped))) {
                    threat *= 2.0f;
                }
                if (c.getNetPower() == 0 && c == sa.getHostCard() && power > 0) {
                    threat *= 4.0f;
                }
                chance += threat;
                if (holdCombatTricks && sa.getApi() == ApiType.Pump && sa.hasParam("NumAtt") && sa.getHostCard() != null && sa.getHostCard().isInZone(ZoneType.Hand) && c.getNetPower() > 0 && sa.getHostCard().isInstant() && ComputerUtilMana.hasEnoughManaSourcesToCast(sa, ai)) {
                    combatTrick = true;
                    for (String kw : keywords) {
                        if (kw.equals("Trample") || kw.equals("First Strike") || kw.equals("Double Strike")) continue;
                        combatTrick = false;
                        break;
                    }
                }
            }
            if (keywords.contains("Haste") && c.hasSickness() && !c.isTapped()) {
                double nonCombatChance = 0.0;
                double combatChance = 0.0;
                if (c.isAbilitySick()) {
                    for (SpellAbility ab : c.getSpellAbilities()) {
                        Cost abCost = ab.getPayCosts();
                        if (abCost == null || !abCost.hasTapCost() && !abCost.hasSpecificCostType(CostUntap.class) || abCost.hasManaCost() && !ComputerUtilMana.canPayManaCost(ab, ai, sa.getPayCosts().getTotalMana().getCMC(), false)) continue;
                        nonCombatChance += 0.5;
                        break;
                    }
                }
                if (ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, pumped)) {
                    combatChance += (double)(0.5f + 0.5f * (float)ComputerUtilCombat.damageIfUnblocked(pumped, opp, combat, true) / (float)opp.getLife());
                }
                chance = (float)((double)chance + (nonCombatChance + combatChance));
            }
            if (Iterables.any(oppCreatures, CardPredicates.possibleBlockers(c)) && !Iterables.any(oppCreatures, CardPredicates.possibleBlockers(pumped)) && ComputerUtilCard.doesSpecifiedCreatureAttackAI(ai, pumped)) {
                chance += 0.5f * (float)ComputerUtilCombat.damageIfUnblocked(pumped, opp, combat, true) / (float)opp.getLife();
            }
        }
        if (phase.is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
            Combat pumpedCombat = new Combat(phase.isPlayerTurn(ai) ? ai : opp);
            CardCollection opposing = null;
            boolean pumpedWillDie = false;
            boolean isAttacking = combat.isAttacking(c);
            if (isBerserk && isAttacking || loseCardAtEOT) {
                pumpedWillDie = true;
            }
            if (isAttacking) {
                pumpedCombat.addAttacker(pumped, opp);
                opposing = combat.getBlockers(c);
                for (Card b : opposing) {
                    pumpedCombat.addBlocker(pumped, b);
                }
                if (ComputerUtilCombat.attackerWouldBeDestroyed(ai, pumped, pumpedCombat)) {
                    pumpedWillDie = true;
                }
            } else {
                opposing = combat.getAttackersBlockedBy(c);
                for (Iterator a : opposing) {
                    pumpedCombat.addAttacker((Card)((Object)a), ai);
                    pumpedCombat.addBlocker((Card)((Object)a), pumped);
                }
                if (ComputerUtilCombat.blockerWouldBeDestroyed(ai, pumped, pumpedCombat)) {
                    pumpedWillDie = true;
                }
            }
            if (ComputerUtilCombat.combatantWouldBeDestroyed(ai, c, combat) && !pumpedWillDie && !c.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                return true;
            }
            boolean survivor = false;
            for (Card o : opposing) {
                if (ComputerUtilCombat.combatantWouldBeDestroyed(opp, o, combat)) continue;
                survivor = true;
                break;
            }
            if (survivor) {
                for (Card o : opposing) {
                    if (ComputerUtilCombat.combatantWouldBeDestroyed(opp, o, combat) || o.hasSVar("SacMe") && Integer.parseInt(o.getSVar("SacMe")) > 2 || !(isAttacking ? ComputerUtilCombat.blockerWouldBeDestroyed(opp, o, pumpedCombat) : ComputerUtilCombat.attackerWouldBeDestroyed(opp, o, pumpedCombat))) continue;
                    return true;
                }
            }
            if (combat.isAttacking(c) && opp.getLife() > 0) {
                int dmg = ComputerUtilCombat.damageIfUnblocked(c, opp, combat, true);
                int pumpedDmg = ComputerUtilCombat.damageIfUnblocked(pumped, opp, pumpedCombat, true);
                int poisonOrig = ComputerUtilCombat.poisonIfUnblocked(c, ai);
                int poisonPumped = ComputerUtilCombat.poisonIfUnblocked(pumped, ai);
                if (pumpedDmg == 0 && c.hasKeyword(Keyword.INFECT) && poisonPumped > poisonOrig) {
                    pumpedDmg = poisonPumped;
                }
                if (combat.isBlocked(c)) {
                    if (!c.hasKeyword(Keyword.TRAMPLE)) {
                        dmg = 0;
                    }
                    if (c.hasKeyword(Keyword.TRAMPLE) || keywords.contains("Trample")) {
                        for (Object b : combat.getBlockers(c)) {
                            pumpedDmg -= ComputerUtilCombat.getDamageToKill((Card)b, false);
                        }
                    } else {
                        pumpedDmg = 0;
                    }
                }
                if (pumpedDmg > dmg) {
                    if (!c.hasKeyword(Keyword.INFECT) && pumpedDmg >= opp.getLife() || c.hasKeyword(Keyword.INFECT) && opp.canReceiveCounters(CounterEnumType.POISON) && pumpedDmg >= opp.getPoisonCounters() || "PumpForTrample".equals(sa.getParam("AILogic"))) {
                        return true;
                    }
                    if (phase.is(PhaseType.COMBAT_DECLARE_BLOCKERS)) {
                        int totalPowerUnblocked = 0;
                        for (Card atk : combat.getAttackers()) {
                            if (combat.isBlocked(atk) && !atk.hasKeyword(Keyword.TRAMPLE)) continue;
                            if (atk == c) {
                                totalPowerUnblocked += pumpedDmg;
                                continue;
                            }
                            totalPowerUnblocked += ComputerUtilCombat.damageIfUnblocked(atk, opp, combat, true);
                            if (!combat.isBlocked(atk)) continue;
                            for (Card blk : combat.getBlockers(atk)) {
                                totalPowerUnblocked -= ComputerUtilCombat.getDamageToKill(blk, false);
                            }
                        }
                        if (totalPowerUnblocked >= opp.getLife()) {
                            return true;
                        }
                        if (totalPowerUnblocked > dmg && sa.getHostCard() != null && sa.getHostCard().isInPlay() && sa.getPayCosts().hasNoManaCost()) {
                            return true;
                        }
                    }
                }
                float value = 1.0f * (float)(pumpedDmg - dmg);
                if (c == sa.getHostCard() && power > 0) {
                    int divisor = sa.getPayCosts().getTotalMana().getCMC();
                    if (divisor <= 0) {
                        divisor = 1;
                    }
                    value *= (float)(power / divisor);
                } else {
                    value /= (float)opp.getLife();
                }
                chance += value;
            }
            if (ai.canGainLife() && ai.getLife() > 0 && !c.hasKeyword(Keyword.LIFELINK) && keywords.contains("Lifelink") && (combat.isAttacking(c) || combat.isBlocking(c))) {
                int dmg = pumped.getNetCombatDamage();
                chance += 1.0f * (float)dmg / (float)ai.getLife();
            }
            if (combat.isBlocking(c) && toughness > 0) {
                CardCollection blockedBy = combat.getAttackersBlockedBy(c);
                boolean attackerHasTrample = false;
                for (Card b : blockedBy) {
                    attackerHasTrample |= b.hasKeyword(Keyword.TRAMPLE);
                }
                if (attackerHasTrample && (sa.isAbility() || ComputerUtilCombat.lifeInDanger(ai, combat))) {
                    return true;
                }
            }
        }
        if ("UntapCombatTrick".equals(sa.getParam("AILogic")) && c.isTapped()) {
            if (phase.is(PhaseType.COMBAT_DECLARE_ATTACKERS) && phase.getPlayerTurn().isOpponentOf(ai)) {
                chance += 0.5f;
            } else if (phase.is(PhaseType.COMBAT_DECLARE_BLOCKERS, ai)) {
                chance += 1.0f;
            }
        }
        if (isBerserk && ai.getController() instanceof PlayerControllerAi) {
            boolean aggr;
            boolean bl = aggr = ((PlayerControllerAi)ai.getController()).getAi().getBooleanProperty(AiProps.USE_BERSERK_AGGRESSIVELY) || sa.hasParam("AtEOT");
            if (!aggr) {
                return false;
            }
        }
        boolean bl = wantToHoldTrick = holdCombatTricks && !ai.getCardsIn(ZoneType.Hand).isEmpty();
        wantToHoldTrick = chanceToHoldCombatTricks >= 0 ? (wantToHoldTrick &= MyRandom.percentTrue(chanceToHoldCombatTricks)) : (wantToHoldTrick &= MyRandom.getRandom().nextFloat() < chance);
        boolean bl2 = isHeldCombatTrick = combatTrick && wantToHoldTrick;
        if (isHeldCombatTrick) {
            if (AiCardMemory.isMemorySetEmpty(ai, AiCardMemory.MemorySet.TRICK_ATTACKERS)) {
                boolean reserved = false;
                if (ai.getController().isAI() && (reserved = ((PlayerControllerAi)ai.getController()).getAi().reserveManaSources(sa, PhaseType.COMBAT_DECLARE_BLOCKERS, false))) {
                    AiCardMemory.rememberCard(ai, c, AiCardMemory.MemorySet.MANDATORY_ATTACKERS);
                    AiCardMemory.rememberCard(ai, c, AiCardMemory.MemorySet.TRICK_ATTACKERS);
                    return false;
                }
            } else {
                return false;
            }
        }
        return simAI || MyRandom.getRandom().nextFloat() < chance;
    }

    public static Card getPumpedCreature(Player ai, SpellAbility sa, Card c, int toughness, int power, List<String> keywords) {
        Card pumped = new CardCopyService(c).copyCard(false);
        pumped.setSickness(c.hasSickness());
        long timestamp = c.getGame().getNextTimestamp();
        ArrayList<String> kws = Lists.newArrayList();
        ArrayList<String> hiddenKws = Lists.newArrayList();
        for (String kw : keywords) {
            if (kw.startsWith("HIDDEN")) {
                hiddenKws.add(kw.substring(7));
                continue;
            }
            kws.add(kw);
        }
        boolean isBerserk = "Berserk".equals(sa.getParam("AILogic"));
        int berserkPower = 0;
        if (isBerserk && sa.hasSVar("X")) {
            berserkPower = "Targeted$CardPower".equals(sa.getSVar("X")) ? c.getCurrentPower() : AbilityUtils.calculateAmount(sa.getHostCard(), "X", sa);
        }
        for (SpellAbility ab : c.getSpellAbilities()) {
            if (!"Pummeler".equals(ab.getParam("AILogic"))) continue;
            Pair<Integer, Integer> newPT = SpecialCardAi.ElectrostaticPummeler.getPumpedPT(ai, power, toughness);
            power = newPT.getLeft();
            toughness = newPT.getRight();
        }
        pumped.addNewPT(c.getCurrentPower(), c.getCurrentToughness(), timestamp, 0L);
        pumped.setPTBoost(c.getPTBoostTable());
        pumped.addPTBoost(power + berserkPower, toughness, timestamp, 0L);
        if (!kws.isEmpty()) {
            pumped.addChangedCardKeywords(kws, null, false, timestamp, null, false);
        }
        if (!hiddenKws.isEmpty()) {
            pumped.addHiddenExtrinsicKeywords(timestamp, 0L, hiddenKws);
        }
        pumped.setCounters(c.getCounters());
        if (c.isTapped()) {
            pumped.setTapped(true);
        }
        KeywordCollection copiedKeywords = new KeywordCollection();
        copiedKeywords.insertAll(pumped.getKeywords());
        ArrayList<KeywordInterface> toCopy = Lists.newArrayList();
        for (KeywordInterface k : c.getUnhiddenKeywords()) {
            KeywordInterface copiedKI = k.copy(c, true);
            if (copiedKeywords.contains(copiedKI.getOriginal())) continue;
            toCopy.add(copiedKI);
        }
        long timestamp2 = c.getGame().getNextTimestamp();
        pumped.addChangedCardKeywordsInternal(toCopy, null, false, timestamp2, null, false);
        pumped.updateKeywordsCache(pumped.getCurrentState());
        ComputerUtilCard.applyStaticContPT(ai.getGame(), pumped, new CardCollection(c));
        return pumped;
    }

    public static void applyStaticContPT(Game game, Card vCard, CardCollectionView exclude) {
        if (!vCard.isCreature()) {
            return;
        }
        CardCollection list = new CardCollection(game.getCardsIn(ZoneType.Battlefield));
        list.addAll(game.getCardsIn(ZoneType.Command));
        if (exclude != null) {
            list.removeAll(exclude);
        }
        list.add(vCard);
        for (Card c : list) {
            for (StaticAbility stAb : c.getStaticAbilities()) {
                vCard.removePTBoost(c.getLayerTimestamp(), stAb.getId());
                if (!stAb.checkMode("Continuous") || !stAb.hasParam("Affected") || !stAb.hasParam("AddPower") && !stAb.hasParam("AddToughness") || !stAb.matchesValidParam("Affected", vCard)) continue;
                int att = 0;
                if (stAb.hasParam("AddPower")) {
                    String addP = stAb.getParam("AddPower");
                    att = AbilityUtils.calculateAmount(addP.contains("Affected") ? vCard : c, addP, stAb, true);
                }
                int def = 0;
                if (stAb.hasParam("AddToughness")) {
                    String addT = stAb.getParam("AddToughness");
                    def = AbilityUtils.calculateAmount(addT.contains("Affected") ? vCard : c, addT, stAb, true);
                }
                vCard.addPTBoost(att, def, c.getLayerTimestamp(), stAb.getId());
            }
        }
    }

    public static boolean canPumpAgainstRemoval(Player ai, SpellAbility sa) {
        List<GameObject> objects = ComputerUtil.predictThreatenedObjects(sa.getActivatingPlayer(), sa, true);
        if (!sa.usesTargeting()) {
            CardCollection cards = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("Defined"), sa);
            for (Card card : cards) {
                if (!objects.contains(card)) continue;
                return true;
            }
            return false;
        }
        CardCollection threatenedTargets = CardLists.getTargetableCards(ai.getCardsIn(ZoneType.Battlefield), sa);
        threatenedTargets = ComputerUtil.getSafeTargets(ai, sa, threatenedTargets);
        threatenedTargets.retainAll(objects);
        if (!threatenedTargets.isEmpty()) {
            ComputerUtilCard.sortByEvaluateCreature(threatenedTargets);
            for (Card c : threatenedTargets) {
                if (!sa.canAddMoreTarget()) continue;
                sa.getTargets().add(c);
                if (sa.canAddMoreTarget()) continue;
                break;
            }
            if (!sa.isTargetNumberValid()) {
                sa.resetTargets();
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isUselessCreature(Player ai, Card c) {
        if (c == null) {
            return true;
        }
        if (!c.isCreature()) {
            return false;
        }
        return c.hasKeyword("CARDNAME can't attack or block.") || c.hasKeyword("CARDNAME doesn't untap during your untap step.") && c.isTapped() || c.getOwner() == ai && ai.getOpponents().contains(c.getController());
    }

    public static boolean hasActiveUndyingOrPersist(Card c) {
        if (c.isToken()) {
            return false;
        }
        if (c.hasKeyword(Keyword.UNDYING) && c.getCounters(CounterEnumType.P1P1) == 0) {
            return true;
        }
        return c.hasKeyword(Keyword.PERSIST) && c.getCounters(CounterEnumType.M1M1) == 0;
    }

    public static int getMaxSAEnergyCostOnBattlefield(Player ai) {
        int maxEnergyCost = 0;
        for (Card c : ai.getCardsIn(ZoneType.Battlefield)) {
            for (SpellAbility sa : c.getSpellAbilities()) {
                int amount;
                CostPayEnergy energyCost = sa.getPayCosts().getCostEnergy();
                if (energyCost == null || (amount = energyCost.convertAmount().intValue()) <= maxEnergyCost) continue;
                maxEnergyCost = amount;
            }
        }
        return maxEnergyCost;
    }

    public static CardCollection prioritizeCreaturesWorthRemovingNow(Player ai, CardCollection oppCards, boolean temporary) {
        if (!CardLists.getNotType(oppCards, "Creature").isEmpty()) {
            return oppCards;
        }
        boolean enablePriorityRemoval = false;
        boolean priorityRemovalOnlyInDanger = false;
        int priorityRemovalThreshold = 0;
        int lifeInDanger = 5;
        if (ai.getController().isAI()) {
            AiController aic = ((PlayerControllerAi)ai.getController()).getAi();
            enablePriorityRemoval = aic.getBooleanProperty(AiProps.ACTIVELY_DESTROY_IMMEDIATELY_UNBLOCKABLE);
            priorityRemovalThreshold = aic.getIntProperty(AiProps.DESTROY_IMMEDIATELY_UNBLOCKABLE_THRESHOLD);
            priorityRemovalOnlyInDanger = aic.getBooleanProperty(AiProps.DESTROY_IMMEDIATELY_UNBLOCKABLE_ONLY_IN_DNGR);
            lifeInDanger = aic.getIntProperty(AiProps.DESTROY_IMMEDIATELY_UNBLOCKABLE_LIFE_IN_DNGR);
        }
        if (!enablePriorityRemoval) {
            return oppCards;
        }
        CardCollection aiCreats = ai.getCreaturesInPlay();
        if (temporary) {
            oppCards = CardLists.filter((Iterable<Card>)oppCards, CardPredicates.Presets.UNTAPPED);
        }
        CardCollection priorityCards = new CardCollection();
        for (Card atk : oppCards) {
            boolean threat;
            boolean canBeBlocked = false;
            if (ComputerUtilCard.isUselessCreature(atk.getController(), atk)) continue;
            for (Card blk : aiCreats) {
                if (!CombatUtil.canBlock(atk, blk, true)) continue;
                canBeBlocked = true;
                break;
            }
            if (canBeBlocked) continue;
            boolean bl = threat = ComputerUtilCombat.getAttack(atk) >= ai.getLife() - lifeInDanger;
            if (priorityRemovalOnlyInDanger && !threat) continue;
            priorityCards.add(atk);
        }
        if (!priorityCards.isEmpty() && priorityCards.size() <= priorityRemovalThreshold) {
            return priorityCards;
        }
        return oppCards;
    }

    public static AiPlayDecision checkNeedsToPlayReqs(Card card, SpellAbility sa) {
        String needsToPlay;
        String needsToPlayVarName;
        Game game = card.getGame();
        boolean isRightSplit = sa != null && sa.getCardState().getStateName() == CardStateName.RightSplit;
        String needsToPlayName = isRightSplit ? "SplitNeedsToPlay" : "NeedsToPlay";
        String string = needsToPlayVarName = isRightSplit ? "SplitNeedsToPlayVar" : "NeedsToPlayVar";
        if (sa != null) {
            if (sa.isEvoke()) {
                if (card.hasSVar("NeedsToPlayEvoked")) {
                    needsToPlayName = "NeedsToPlayEvoked";
                }
                if (card.hasSVar("NeedsToPlayEvokedVar")) {
                    needsToPlayVarName = "NeedsToPlayEvokedVar";
                }
            } else if (sa.isKicked()) {
                needsToPlayName = card.hasSVar("NeedsToPlayKicked") ? "NeedsToPlayKicked" : "UNUSED";
                needsToPlayVarName = card.hasSVar("NeedsToPlayKickedVar") ? "NeedsToPlayKickedVar" : "UNUSED";
            }
        }
        if (card.hasSVar(needsToPlayName)) {
            needsToPlay = card.getSVar(needsToPlayName);
            if (needsToPlay.equalsIgnoreCase("WillAttack")) {
                if (sa != null && game.getPhaseHandler().isPlayerTurn(sa.getActivatingPlayer())) {
                    return ComputerUtilCard.doesSpecifiedCreatureAttackAI(sa.getActivatingPlayer(), card) ? AiPlayDecision.WillPlay : AiPlayDecision.BadEtbEffects;
                }
                return AiPlayDecision.WillPlay;
            }
            CardCollectionView list = game.getCardsIn(ZoneType.Battlefield);
            if ((list = CardLists.getValidCards((Iterable<Card>)list, needsToPlay, card.getController(), card, (CardTraitBase)sa)).isEmpty()) {
                return AiPlayDecision.MissingNeededCards;
            }
        }
        if (card.getSVar(needsToPlayVarName).length() > 0) {
            int y;
            needsToPlay = card.getSVar(needsToPlayVarName);
            String sVar = needsToPlay.split(" ")[0];
            String comparator = needsToPlay.split(" ")[1];
            String compareTo = comparator.substring(2);
            int x = AbilityUtils.calculateAmount(card, sVar, sa);
            if (!Expressions.compare(x, comparator, y = AbilityUtils.calculateAmount(card, compareTo, sa))) {
                return AiPlayDecision.NeedsToPlayCriteriaNotMet;
            }
        }
        return AiPlayDecision.WillPlay;
    }

    public static Cost getTotalWardCost(Card c) {
        Cost totalCost = new Cost(ManaCost.NO_COST, false);
        for (KeywordInterface inst : c.getKeywords(Keyword.WARD)) {
            String keyword = inst.getOriginal();
            String[] k = keyword.split(":");
            Cost wardCost = new Cost(k[1], false);
            totalCost = totalCost.add(wardCost);
        }
        return totalCost;
    }

    public static boolean willUntap(Player ai, Card tapped) {
        for (Card card : ai.getGame().getCardsIn(ZoneType.Battlefield)) {
            boolean untapsEachTurn = card.hasSVar("UntapsEachTurn");
            boolean untapsEachOtherTurn = card.hasSVar("UntapsEachOtherPlayerTurn");
            if (!untapsEachTurn && !untapsEachOtherTurn) continue;
            String affected = untapsEachTurn ? card.getSVar("UntapsEachTurn") : card.getSVar("UntapsEachOtherPlayerTurn");
            for (String aff : TextUtil.split(affected, ',')) {
                if (!tapped.isValid(aff, ai, tapped, null) || !untapsEachTurn && (!untapsEachOtherTurn || !ai.equals(card.getController()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNonDisabledCardInPlay(Player ai, String cardName) {
        for (Card card : ai.getCardsIn(ZoneType.Battlefield, cardName)) {
            boolean disabledByEnemy = false;
            for (Card card2 : card.getEnchantedBy()) {
                if (card2.getOwner() == ai) continue;
                disabledByEnemy = true;
                break;
            }
            if (disabledByEnemy) continue;
            return true;
        }
        return false;
    }

    public static CardCollection dedupeCards(CardCollection cc) {
        if (cc.size() <= 1) {
            return cc;
        }
        CardCollection deduped = new CardCollection();
        for (Card c : cc) {
            boolean unique = true;
            if (c.isInZone(ZoneType.Hand)) {
                for (Card d : deduped) {
                    if (!d.isInZone(ZoneType.Hand) || !d.getOwner().equals(c.getOwner()) || !d.getName().equals(c.getName())) continue;
                    unique = false;
                    break;
                }
            }
            if (!unique) continue;
            deduped.add(c);
        }
        return deduped;
    }

    public static boolean isCardRemAIDeck(Card card) {
        return card.getRules() != null && card.getRules().getAiHints().getRemAIDecks();
    }

    public static boolean isCardRemRandomDeck(Card card) {
        return card.getRules() != null && card.getRules().getAiHints().getRemRandomDecks();
    }

    public static boolean isCardRemNonCommanderDeck(Card card) {
        return card.getRules() != null && card.getRules().getAiHints().getRemNonCommanderDecks();
    }

    static class LandEvaluator
    implements Function<Card, Integer> {
        LandEvaluator() {
        }

        @Override
        public Integer apply(Card card) {
            return GameStateEvaluator.evaluateLand(card);
        }
    }
}

