/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import forge.ai.AiController;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilCard;
import forge.ai.PlayerControllerAi;
import forge.card.CardType;
import forge.card.MagicColor;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.card.CounterType;
import forge.game.cost.CostAddMana;
import forge.game.cost.CostChooseColor;
import forge.game.cost.CostChooseCreatureType;
import forge.game.cost.CostCollectEvidence;
import forge.game.cost.CostDamage;
import forge.game.cost.CostDecisionMakerBase;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostDraw;
import forge.game.cost.CostEnlist;
import forge.game.cost.CostExert;
import forge.game.cost.CostExile;
import forge.game.cost.CostExileFromStack;
import forge.game.cost.CostExiledMoveToGrave;
import forge.game.cost.CostFlipCoin;
import forge.game.cost.CostForage;
import forge.game.cost.CostGainControl;
import forge.game.cost.CostGainLife;
import forge.game.cost.CostMill;
import forge.game.cost.CostPartMana;
import forge.game.cost.CostPayEnergy;
import forge.game.cost.CostPayLife;
import forge.game.cost.CostPayShards;
import forge.game.cost.CostPromiseGift;
import forge.game.cost.CostPutCardToLib;
import forge.game.cost.CostPutCounter;
import forge.game.cost.CostRemoveAnyCounter;
import forge.game.cost.CostRemoveCounter;
import forge.game.cost.CostReturn;
import forge.game.cost.CostReveal;
import forge.game.cost.CostRevealChosen;
import forge.game.cost.CostRollDice;
import forge.game.cost.CostSacrifice;
import forge.game.cost.CostTap;
import forge.game.cost.CostTapType;
import forge.game.cost.CostUnattach;
import forge.game.cost.CostUntap;
import forge.game.cost.CostUntapType;
import forge.game.cost.PaymentDecision;
import forge.game.keyword.Keyword;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class AiCostDecision
extends CostDecisionMakerBase {
    private final CardCollection discarded = new CardCollection();
    private final CardCollection tapped = new CardCollection();

    public AiCostDecision(Player ai0, SpellAbility sa, boolean effect) {
        super(ai0, effect, sa, sa.getHostCard());
    }

    @Override
    public PaymentDecision visit(CostAddMana cost) {
        int c = cost.getAbilityAmount(this.ability);
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostChooseColor cost) {
        int c = cost.getAbilityAmount(this.ability);
        List<String> choices = this.player.getController().chooseColors("Color", this.ability, c, c, new ArrayList<String>(MagicColor.Constant.ONLY_COLORS));
        return PaymentDecision.colors(choices);
    }

    @Override
    public PaymentDecision visit(CostChooseCreatureType cost) {
        String choice = this.player.getController().chooseSomeType("Creature", this.ability, CardType.getAllCreatureTypes(), Lists.newArrayList());
        return PaymentDecision.type(choice);
    }

    @Override
    public PaymentDecision visit(CostCollectEvidence cost) {
        int c = cost.getAbilityAmount(this.ability);
        CardCollection chosen = ComputerUtil.chooseCollectEvidence(this.player, cost, this.source, c, this.ability, this.isEffect());
        return null == chosen ? null : PaymentDecision.card(chosen);
    }

    @Override
    public PaymentDecision visit(CostDiscard cost) {
        int c;
        String type = cost.getType();
        CardCollectionView hand = this.player.getCardsIn(ZoneType.Hand);
        if (type.equals("LastDrawn")) {
            if (!hand.contains(this.player.getLastDrawnCard())) {
                return null;
            }
            return PaymentDecision.card(this.player.getLastDrawnCard());
        }
        if (cost.payCostFromSource()) {
            if (!hand.contains(this.source)) {
                return null;
            }
            return PaymentDecision.card(this.source);
        }
        if (type.equals("Hand")) {
            if (hand.size() > 1 && this.ability.getActivatingPlayer() != null) {
                hand = this.ability.getActivatingPlayer().getController().orderMoveToZoneList(hand, ZoneType.Graveyard, this.ability);
            }
            return PaymentDecision.card(hand);
        }
        if (type.contains("WithSameName")) {
            return null;
        }
        if (type.equals("Random")) {
            CardCollectionView randomSubset = CardLists.getRandomSubList(new CardCollection(hand), c);
            if (randomSubset.size() > 1 && this.ability.getActivatingPlayer() != null) {
                randomSubset = this.ability.getActivatingPlayer().getController().orderMoveToZoneList(randomSubset, ZoneType.Graveyard, this.ability);
            }
            return PaymentDecision.card(randomSubset);
        }
        if (type.equals("DifferentNames")) {
            CardCollection differentNames = new CardCollection();
            CardCollection discardMe = CardLists.filter((Iterable<Card>)hand, CardPredicates.hasSVar("DiscardMe"));
            for (c = cost.getAbilityAmount(this.ability); c > 0; --c) {
                Card chosen;
                if (!discardMe.isEmpty()) {
                    chosen = Aggregates.random(discardMe);
                    discardMe = CardLists.filter((Iterable<Card>)discardMe, Predicates.not(CardPredicates.sharesNameWith(chosen)));
                } else {
                    Card worst = ComputerUtilCard.getWorstAI(hand);
                    chosen = worst != null ? worst : Aggregates.random(hand);
                }
                differentNames.add(chosen);
                hand = CardLists.filter((Iterable<Card>)hand, Predicates.not(CardPredicates.sharesNameWith(chosen)));
            }
            return PaymentDecision.card(differentNames);
        }
        AiController aic = ((PlayerControllerAi)this.player.getController()).getAi();
        CardCollection result = aic.getCardsToDiscard(c, type.split(";"), this.ability, this.discarded);
        if (result != null) {
            this.discarded.addAll(result);
        }
        return PaymentDecision.card(result);
    }

    @Override
    public PaymentDecision visit(CostDamage cost) {
        int c = cost.getAbilityAmount(this.ability);
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostDraw cost) {
        if (!cost.canPay(this.ability, this.player, this.isEffect())) {
            return null;
        }
        int c = cost.getAbilityAmount(this.ability);
        PlayerCollection res = cost.getPotentialPlayers(this.player, this.ability);
        PaymentDecision decision = PaymentDecision.players(res);
        decision.c = c;
        return decision;
    }

    @Override
    public PaymentDecision visit(CostPromiseGift cost) {
        if (!cost.canPay(this.ability, this.player, this.isEffect())) {
            return null;
        }
        PlayerCollection res = cost.getPotentialPlayers(this.player, this.ability);
        Collections.shuffle(res);
        return PaymentDecision.players(res.subList(0, 1));
    }

    @Override
    public PaymentDecision visit(CostExile cost) {
        String type = cost.getType();
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        if (type.equals("All")) {
            return PaymentDecision.card(this.player.getCardsIn(cost.getFrom()));
        }
        if (type.contains("FromTopGrave")) {
            return null;
        }
        if (type.contains("+withTotalCMCGE")) {
            String strAmount = type.split("withTotalCMCGE")[1];
            int amount = AbilityUtils.calculateAmount(this.source, strAmount, this.ability);
            String typeCleaned = TextUtil.fastReplace(type, TextUtil.concatNoSpace("+withTotalCMCGE", strAmount), "");
            CardCollection valid = CardLists.getValidCards((Iterable<Card>)this.player.getGame().getCardsIn(cost.getFrom().get(0)), typeCleaned, this.player, this.source, (CardTraitBase)this.ability);
            CardCollection chosen = new CardCollection();
            CardLists.sortByCmcDesc(valid);
            Collections.reverse(valid);
            int totalCMC = 0;
            for (Card card : valid) {
                chosen.add(card);
                if ((totalCMC += card.getCMC()) < amount) continue;
                return PaymentDecision.card(chosen);
            }
            return null;
        }
        int c = cost.getAbilityAmount(this.ability);
        if (cost.from.size() == 1 && cost.getFrom().get(0).equals((Object)ZoneType.Library)) {
            return PaymentDecision.card(this.player.getCardsIn(ZoneType.Library, c));
        }
        if (cost.zoneRestriction == 0) {
            return null;
        }
        CardCollection chosen = ComputerUtil.chooseExileFrom(this.player, cost, this.source, c, this.ability, this.isEffect());
        return null == chosen ? null : PaymentDecision.card(chosen);
    }

    @Override
    public PaymentDecision visit(CostExileFromStack cost) {
        ArrayList<SpellAbility> chosen = Lists.newArrayList();
        for (SpellAbilityStackInstance si : this.source.getGame().getStack()) {
            SpellAbility sp = si.getSpellAbility().getRootAbility();
            if (!si.getSourceCard().isValid(cost.getType().split(";"), this.source.getController(), this.source, (CardTraitBase)sp)) continue;
            chosen.add(sp);
        }
        return chosen.isEmpty() ? null : PaymentDecision.spellabilities(chosen);
    }

    @Override
    public PaymentDecision visit(CostExiledMoveToGrave cost) {
        CardCollection chosen = new CardCollection();
        int c = cost.getAbilityAmount(this.ability);
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.player.getGame().getCardsIn(ZoneType.Exile), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if (typeList.size() < c) {
            return null;
        }
        CardLists.sortByPowerDesc(typeList);
        for (int i = 0; i < c; ++i) {
            chosen.add((Card)typeList.get(i));
        }
        return chosen.isEmpty() ? null : PaymentDecision.card(chosen);
    }

    @Override
    public PaymentDecision visit(CostExert cost) {
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        int c = cost.getAbilityAmount(this.ability);
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.player.getGame().getCardsIn(ZoneType.Battlefield), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if (typeList.size() < c) {
            return null;
        }
        CardLists.sortByPowerAsc(typeList);
        CardCollection res = new CardCollection();
        for (int i = 0; i < c; ++i) {
            res.add((Card)typeList.get(i));
        }
        return res.isEmpty() ? null : PaymentDecision.card(res);
    }

    @Override
    public PaymentDecision visit(CostEnlist cost) {
        CardCollection choices = CostEnlist.getCardsForEnlisting(this.player);
        CardLists.sortByPowerDesc(choices);
        return choices.isEmpty() ? null : PaymentDecision.card((Card)choices.getFirst());
    }

    @Override
    public PaymentDecision visit(CostFlipCoin cost) {
        int c = cost.getAbilityAmount(this.ability);
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostForage cost) {
        CardCollection food = CardLists.filter(this.player.getCardsIn(ZoneType.Battlefield), CardPredicates.isType("Food"), CardPredicates.canBeSacrificedBy(this.ability, this.isEffect()));
        CardCollection exile = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Graveyard), CardPredicates.canExiledBy(this.ability, this.isEffect()));
        if (!food.isEmpty()) {
            AiController aic = ((PlayerControllerAi)this.player.getController()).getAi();
            CardCollectionView list = aic.chooseSacrificeType("Food", this.ability, this.isEffect(), 1, null);
            return list == null ? null : PaymentDecision.card(list);
        }
        CardCollection chosen = ComputerUtil.chooseExileFromList(this.player, exile, this.source, 3, this.ability, this.isEffect());
        return null == chosen ? null : PaymentDecision.card(chosen);
    }

    @Override
    public PaymentDecision visit(CostRollDice cost) {
        int c = cost.getAbilityAmount(this.ability);
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostGainControl cost) {
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        int c = cost.getAbilityAmount(this.ability);
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.player.getGame().getCardsIn(ZoneType.Battlefield), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if ((typeList = CardLists.filter((Iterable<Card>)typeList, crd -> crd.canBeControlledBy(this.player))).size() < c) {
            return null;
        }
        CardLists.sortByPowerAsc(typeList);
        CardCollection res = new CardCollection();
        for (int i = 0; i < c; ++i) {
            res.add((Card)typeList.get(i));
        }
        return res.isEmpty() ? null : PaymentDecision.card(res);
    }

    @Override
    public PaymentDecision visit(CostGainLife cost) {
        ArrayList<Player> oppsThatCanGainLife = Lists.newArrayList();
        for (Player opp : cost.getPotentialTargets(this.player, this.ability)) {
            if (!opp.canGainLife()) continue;
            oppsThatCanGainLife.add(opp);
        }
        if (oppsThatCanGainLife.isEmpty()) {
            return null;
        }
        return PaymentDecision.players(oppsThatCanGainLife);
    }

    @Override
    public PaymentDecision visit(CostMill cost) {
        int c = cost.getAbilityAmount(this.ability);
        CardCollectionView topLib = this.player.getCardsIn(ZoneType.Library, c);
        return topLib.size() < c ? null : PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostPartMana cost) {
        return PaymentDecision.number(0);
    }

    @Override
    public PaymentDecision visit(CostPayLife cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (!this.player.canPayLife(c, this.isEffect(), this.ability)) {
            return null;
        }
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostPayEnergy cost) {
        int c = cost.getAbilityAmount(this.ability);
        if (!this.player.canPayEnergy(c)) {
            return null;
        }
        return PaymentDecision.number(c);
    }

    @Override
    public PaymentDecision visit(CostPutCardToLib cost) {
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        Game game = this.player.getGame();
        CardCollection chosen = new CardCollection();
        CardCollectionView list = cost.isSameZone() ? game.getCardsIn(cost.getFrom()) : this.player.getCardsIn(cost.getFrom());
        int c = cost.getAbilityAmount(this.ability);
        list = CardLists.getValidCards((Iterable<Card>)list, cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if (cost.isSameZone()) {
            PlayerCollection players = game.getPlayers();
            for (Player p : players) {
                CardCollection enoughType = CardLists.filter((Iterable<Card>)list, CardPredicates.isOwner(p));
                if (enoughType.size() < c) continue;
                chosen.addAll(enoughType);
                break;
            }
            chosen = chosen.subList(0, c);
        } else {
            chosen = ComputerUtil.choosePutToLibraryFrom(this.player, cost.getFrom(), cost.getType(), this.source, this.ability.getTargetCard(), c, this.ability);
        }
        return chosen.isEmpty() ? null : PaymentDecision.card(chosen);
    }

    @Override
    public PaymentDecision visit(CostPutCounter cost) {
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.player.getGame().getCardsIn(ZoneType.Battlefield), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        Card card = cost.getType().equals("Creature.YouCtrl") ? ComputerUtilCard.getWorstCreatureAI(typeList) : ComputerUtilCard.getWorstPermanentAI(typeList, false, false, false, false);
        return PaymentDecision.card(card);
    }

    @Override
    public PaymentDecision visit(CostTap cost) {
        return PaymentDecision.number(0);
    }

    @Override
    public PaymentDecision visit(CostTapType cost) {
        CardCollection totap;
        String type = cost.getType();
        boolean isVehicle = type.contains("+withTotalPowerGE");
        CardCollection exclude = new CardCollection();
        exclude.addAll(this.tapped);
        if (type.contains("sharesCreatureTypeWith")) {
            return null;
        }
        if ("DontPayTapCostWithManaSources".equals(this.source.getSVar("AIPaymentPreference"))) {
            CardCollection toExclude = CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(ZoneType.Battlefield), type.split(";"), this.ability.getActivatingPlayer(), this.ability.getHostCard(), (CardTraitBase)this.ability);
            toExclude = CardLists.filter((Iterable<Card>)toExclude, card -> {
                for (SpellAbility sa : card.getSpellAbilities()) {
                    if (!sa.isManaAbility() || !sa.getPayCosts().hasTapCost()) continue;
                    return true;
                }
                return false;
            });
            exclude.addAll(toExclude);
        }
        String totalP = "";
        if (isVehicle) {
            totalP = type.split("withTotalPowerGE")[1];
            type = TextUtil.fastReplace(type, "+withTotalPowerGE", "");
            totap = ComputerUtil.chooseTapTypeAccumulatePower(this.player, type, this.ability, !cost.canTapSource, Integer.parseInt(totalP), exclude);
        } else {
            int c = cost.getAbilityAmount(this.ability);
            totap = ComputerUtil.chooseTapType(this.player, type, this.source, !cost.canTapSource, c, exclude, this.ability);
        }
        if (totap == null) {
            return null;
        }
        this.tapped.addAll(totap);
        return PaymentDecision.card(totap);
    }

    @Override
    public PaymentDecision visit(CostSacrifice cost) {
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        if (cost.getType().equals("OriginalHost")) {
            return PaymentDecision.card(this.ability.getOriginalHost());
        }
        if (cost.getAmount().equals("All")) {
            return null;
        }
        int c = cost.getAbilityAmount(this.ability);
        AiController aic = ((PlayerControllerAi)this.player.getController()).getAi();
        CardCollectionView list = aic.chooseSacrificeType(cost.getType(), this.ability, this.isEffect(), c, null);
        return list == null ? null : PaymentDecision.card(list);
    }

    @Override
    public PaymentDecision visit(CostReturn cost) {
        if (cost.payCostFromSource()) {
            return PaymentDecision.card(this.source);
        }
        int c = cost.getAbilityAmount(this.ability);
        CardCollection res = ComputerUtil.chooseReturnType(this.player, cost.getType(), this.source, this.ability.getTargetCard(), c, this.ability);
        return res.isEmpty() ? null : PaymentDecision.card(res);
    }

    @Override
    public PaymentDecision visit(CostReveal cost) {
        String type = cost.getType();
        CardCollectionView hand = this.player.getCardsIn(cost.getRevealFrom());
        if (cost.payCostFromSource()) {
            if (!hand.contains(this.source)) {
                return null;
            }
            return PaymentDecision.card(this.source);
        }
        if (cost.getType().equals("Hand")) {
            return PaymentDecision.card(hand);
        }
        if (cost.getRevealFrom().size() == 2 && cost.getRevealFrom().containsAll(Arrays.asList(ZoneType.Hand, ZoneType.Battlefield))) {
            String aiLogic = this.ability.getParamOrDefault("AILogic", "");
            hand = CardLists.getValidCards((Iterable<Card>)hand, type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
            if (aiLogic.startsWith("PowerAtLeast.")) {
                int minPower = Integer.parseInt(aiLogic.substring(aiLogic.indexOf(".") + 1));
                hand = CardLists.filterPower(hand, minPower);
            }
            return hand.isEmpty() ? null : PaymentDecision.card(ComputerUtilCard.getBestCreatureAI(hand));
        }
        if (cost.getType().equals("SameColor")) {
            return null;
        }
        if (cost.getRevealFrom().get(0).equals((Object)ZoneType.Exile)) {
            hand = CardLists.getValidCards((Iterable<Card>)hand, type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
            return PaymentDecision.card(ComputerUtilCard.getBestCreatureAI(hand));
        }
        int c = cost.getAbilityAmount(this.ability);
        AiController aic = ((PlayerControllerAi)this.player.getController()).getAi();
        return PaymentDecision.card(aic.getCardsToDiscard(c, type.split(";"), this.ability));
    }

    @Override
    public PaymentDecision visit(CostRevealChosen cost) {
        return PaymentDecision.number(1);
    }

    protected int removeCounter(GameEntityCounterTable table, List<Card> prefs, CounterEnumType cType, int stillToRemove) {
        int removed = 0;
        if (!prefs.isEmpty() && stillToRemove > 0) {
            prefs.sort(CardPredicates.compareByCounterType(cType));
            for (Card prefCard : prefs) {
                if (stillToRemove <= removed) break;
                int thisRemove = Math.min(prefCard.getCounters(cType), stillToRemove);
                if (thisRemove <= 0) continue;
                removed += thisRemove;
                table.put(null, prefCard, CounterType.get(cType), thisRemove);
            }
        }
        return removed;
    }

    @Override
    public PaymentDecision visit(CostRemoveAnyCounter cost) {
        CardCollection useless;
        CardCollection negatives;
        CardCollection prefs;
        int c = cost.getAbilityAmount(this.ability);
        Card originalHost = ObjectUtils.defaultIfNull(this.ability.getOriginalHost(), this.source);
        if (c <= 0) {
            return null;
        }
        CardCollection typeList = CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(ZoneType.Battlefield), cost.getType().split(";"), this.player, this.source, (CardTraitBase)this.ability);
        if ((typeList = CardLists.filter((Iterable<Card>)typeList, CardPredicates.hasCounters())).isEmpty()) {
            return null;
        }
        int toRemove = 0;
        GameEntityCounterTable table = new GameEntityCounterTable();
        if (c > toRemove && (cost.counter == null || cost.counter.is(CounterEnumType.M1M1))) {
            prefs = CardLists.filter(typeList, CardPredicates.hasCounter(CounterEnumType.M1M1), CardPredicates.hasKeyword(Keyword.PERSIST));
            toRemove += this.removeCounter(table, prefs, CounterEnumType.M1M1, c - toRemove);
        }
        if (c > toRemove && (cost.counter == null || cost.counter.is(CounterEnumType.P1P1))) {
            prefs = CardLists.filter(typeList, CardPredicates.hasCounter(CounterEnumType.P1P1), CardPredicates.hasKeyword(Keyword.UNDYING));
            toRemove += this.removeCounter(table, prefs, CounterEnumType.P1P1, c - toRemove);
        }
        if (c > toRemove && cost.counter == null && originalHost.hasSVar("AIRemoveCounterCostPriority") && !"ANY".equalsIgnoreCase(originalHost.getSVar("AIRemoveCounterCostPriority"))) {
            String[] counters = TextUtil.split(originalHost.getSVar("AIRemoveCounterCostPriority"), ',');
            for (String ctr : counters) {
                CounterType ctype = CounterType.getType(ctr);
                for (Card card : CardLists.filter((Iterable<Card>)typeList, CardPredicates.hasCounter(ctype))) {
                    int thisRemove = Math.min(card.getCounters(ctype), c - toRemove);
                    if (thisRemove <= 0) continue;
                    toRemove += thisRemove;
                    table.put(null, card, ctype, thisRemove);
                }
            }
        }
        if (c > toRemove && cost.counter == null && !(negatives = CardLists.filter((Iterable<Card>)typeList, crd -> {
            for (CounterType cType : table.filterToRemove((GameEntity)crd).keySet()) {
                if (!ComputerUtil.isNegativeCounter(cType, crd)) continue;
                return true;
            }
            return false;
        })).isEmpty()) {
            for (Card crd2 : negatives) {
                for (Map.Entry<CounterType, Integer> e : table.filterToRemove(crd2).entrySet()) {
                    int over;
                    if (!ComputerUtil.isNegativeCounter(e.getKey(), crd2) || !crd2.canRemoveCounters(e.getKey()) || (over = Math.min(e.getValue(), c - toRemove)) <= 0) continue;
                    toRemove += over;
                    table.put(null, crd2, e.getKey(), over);
                }
            }
        }
        if (c > toRemove && cost.counter == null && !(useless = CardLists.filter((Iterable<Card>)typeList, crd -> {
            for (CounterType ctype : table.filterToRemove((GameEntity)crd).keySet()) {
                if (!ComputerUtil.isUselessCounter(ctype, crd)) continue;
                return true;
            }
            return false;
        })).isEmpty()) {
            for (Card crd3 : useless) {
                for (Map.Entry<CounterType, Integer> e : table.filterToRemove(crd3).entrySet()) {
                    int over;
                    if (!ComputerUtil.isUselessCounter(e.getKey(), crd3) || (over = Math.min(e.getValue(), c - toRemove)) <= 0) continue;
                    toRemove += over;
                    table.put(null, crd3, e.getKey(), over);
                }
            }
        }
        if (c > toRemove && (cost.counter == null || cost.counter.is(CounterEnumType.TIME))) {
            prefs = CardLists.filter(typeList, CardPredicates.hasCounter(CounterEnumType.TIME), CardPredicates.nameEquals("Chronozoa"));
            toRemove += this.removeCounter(table, prefs, CounterEnumType.TIME, c - toRemove);
        }
        if (c > toRemove && (cost.counter == null || cost.counter.is(CounterEnumType.QUEST))) {
            prefs = CardLists.filter((Iterable<Card>)typeList, crd -> {
                int e = 0;
                if (crd.hasSVar("MaxQuestEffect")) {
                    e = Integer.parseInt(crd.getSVar("MaxQuestEffect"));
                }
                return crd.getCounters(CounterEnumType.QUEST) > e;
            });
            prefs.sort(Collections.reverseOrder(CardPredicates.compareByCounterType(CounterEnumType.QUEST)));
            for (Card crd4 : prefs) {
                int over;
                int e = 0;
                if (crd4.hasSVar("MaxQuestEffect")) {
                    e = Integer.parseInt(crd4.getSVar("MaxQuestEffect"));
                }
                if ((over = Math.min(crd4.getCounters(CounterEnumType.QUEST) - e, c - toRemove)) <= 0) continue;
                toRemove += over;
                table.put(null, crd4, CounterType.get(CounterEnumType.QUEST), over);
            }
        }
        if (c > toRemove && (cost.counter == null || cost.counter.is(CounterEnumType.LORE))) {
            prefs = CardLists.filter(typeList, CardPredicates.hasCounter(CounterEnumType.LORE), CardPredicates.isType("Saga"));
            toRemove += this.removeCounter(table, prefs, CounterEnumType.LORE, c - toRemove);
        }
        if (c > toRemove && cost.counter != null) {
            CardCollection withCtr = CardLists.filter((Iterable<Card>)typeList, CardPredicates.hasCounter(cost.counter));
            for (Card card : withCtr) {
                int thisRemove = Math.min(card.getCounters(cost.counter), c - toRemove);
                if (thisRemove <= 0) continue;
                toRemove += thisRemove;
                table.put(null, card, cost.counter, thisRemove);
            }
        }
        if (c > toRemove && cost.counter == null && originalHost.hasSVar("AIRemoveCounterCostPriority") && "ANY".equalsIgnoreCase(originalHost.getSVar("AIRemoveCounterCostPriority"))) {
            for (Card card : typeList) {
                for (Map.Entry<CounterType, Integer> e : table.filterToRemove(card).entrySet()) {
                    int thisRemove = Math.min(e.getValue(), c - toRemove);
                    if (thisRemove <= 0) continue;
                    toRemove += thisRemove;
                    table.put(null, card, e.getKey(), thisRemove);
                }
            }
        }
        return table.isEmpty() ? null : PaymentDecision.counters(table);
    }

    @Override
    public PaymentDecision visit(CostRemoveCounter cost) {
        int c;
        String amount = cost.getAmount();
        String type = cost.getType();
        String sVar = this.ability.getSVar(amount);
        if (amount.equals("All")) {
            c = this.source.getCounters(cost.counter);
        } else if (sVar.equals("Targeted$CardManaCost")) {
            c = 0;
            if (this.ability.getTargets().size() > 0) {
                for (Card tgt : this.ability.getTargets().getTargetCards()) {
                    if (tgt.getManaCost() == null) continue;
                    c += tgt.getManaCost().getCMC();
                }
            }
        } else {
            c = cost.getAbilityAmount(this.ability);
        }
        if (!cost.payCostFromSource()) {
            CardCollection typeList = type.equals("OriginalHost") ? new CardCollection(this.ability.getOriginalHost()) : CardLists.getValidCards((Iterable<Card>)this.player.getCardsIn(cost.zone), type.split(";"), this.player, this.source, (CardTraitBase)this.ability);
            for (Card card : typeList) {
                if (card.getCounters(cost.counter) < c) continue;
                return PaymentDecision.card(card, c);
            }
            return null;
        }
        if (c > this.source.getCounters(cost.counter)) {
            System.out.println("Not enough " + cost.counter + " on " + this.source.getName());
            return null;
        }
        return PaymentDecision.card(this.source, c);
    }

    @Override
    public PaymentDecision visit(CostUntapType cost) {
        int c = cost.getAbilityAmount(this.ability);
        CardCollection list = ComputerUtil.chooseUntapType(this.player, cost.getType(), this.source, cost.canUntapSource, c, this.ability);
        if (list == null) {
            System.out.println("Couldn't find a valid card to untap for: " + this.source.getName());
            return null;
        }
        return PaymentDecision.card(list);
    }

    @Override
    public PaymentDecision visit(CostUntap cost) {
        return PaymentDecision.number(0);
    }

    @Override
    public PaymentDecision visit(CostPayShards cost) {
        return PaymentDecision.number(0);
    }

    @Override
    public PaymentDecision visit(CostUnattach cost) {
        Card cardToUnattach = cost.findCardToUnattach(this.source, this.player, this.ability);
        if (cardToUnattach == null) {
            return null;
        }
        return PaymentDecision.card(cardToUnattach);
    }

    @Override
    public boolean paysRightAfterDecision() {
        return false;
    }
}

