/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import com.esotericsoftware.minlog.Log;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.ai.AiAttackController;
import forge.ai.AiBlockController;
import forge.ai.AiCardMemory;
import forge.ai.AiPlayDecision;
import forge.ai.AiProfileUtil;
import forge.ai.AiProps;
import forge.ai.ComputerUtil;
import forge.ai.ComputerUtilAbility;
import forge.ai.ComputerUtilCard;
import forge.ai.ComputerUtilCost;
import forge.ai.ComputerUtilMana;
import forge.ai.SpecialCardAi;
import forge.ai.SpellAbilityAi;
import forge.ai.SpellApiToAi;
import forge.ai.ability.ChangeZoneAi;
import forge.ai.ability.LearnAi;
import forge.ai.simulation.SpellAbilityPicker;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.MagicColor;
import forge.card.mana.ManaCost;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.CardTraitBase;
import forge.game.CardTraitPredicates;
import forge.game.Direction;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.SpellApiBased;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CounterEnumType;
import forge.game.combat.Combat;
import forge.game.combat.CombatUtil;
import forge.game.cost.Cost;
import forge.game.cost.CostAdjustment;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostPart;
import forge.game.cost.CostPayLife;
import forge.game.cost.CostSacrifice;
import forge.game.keyword.Keyword;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.player.PlayerCollection;
import forge.game.replacement.ReplaceMoved;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementLayer;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.OptionalCostValue;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityCondition;
import forge.game.spellability.SpellAbilityPredicates;
import forge.game.spellability.SpellPermanent;
import forge.game.spellability.TargetChoices;
import forge.game.staticability.StaticAbility;
import forge.game.staticability.StaticAbilityDisableTriggers;
import forge.game.staticability.StaticAbilityMustTarget;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.trigger.WrappedAbility;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.Aggregates;
import forge.util.ComparatorUtil;
import forge.util.Expressions;
import forge.util.MyRandom;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AiController {
    private final Player player;
    private final Game game;
    private final AiCardMemory memory;
    private Combat predictedCombat;
    private Combat predictedCombatNextTurn;
    private boolean cheatShuffle;
    private boolean useSimulation;
    private SpellAbilityPicker simPicker;
    private int lastAttackAggression;
    private boolean useLivingEnd;

    public AiController(Player computerPlayer, Game game0) {
        this.player = computerPlayer;
        this.game = game0;
        this.memory = new AiCardMemory();
        this.simPicker = new SpellAbilityPicker(this.game, this.player);
    }

    public boolean canCheatShuffle() {
        return this.cheatShuffle;
    }

    public void allowCheatShuffle(boolean canCheatShuffle) {
        this.cheatShuffle = canCheatShuffle;
    }

    public boolean usesSimulation() {
        return this.useSimulation;
    }

    public void setUseSimulation(boolean value) {
        this.useSimulation = value;
    }

    public int getAttackAggression() {
        return this.lastAttackAggression;
    }

    public SpellAbilityPicker getSimulationPicker() {
        return this.simPicker;
    }

    public Game getGame() {
        return this.game;
    }

    public Player getPlayer() {
        return this.player;
    }

    public AiCardMemory getCardMemory() {
        return this.memory;
    }

    public Combat getPredictedCombat() {
        if (this.predictedCombat == null) {
            AiAttackController aiAtk = new AiAttackController(this.player);
            this.predictedCombat = new Combat(this.player);
            aiAtk.declareAttackers(this.predictedCombat);
        }
        return this.predictedCombat;
    }

    public Combat getPredictedCombatNextTurn() {
        if (this.predictedCombatNextTurn == null) {
            AiAttackController aiAtk = new AiAttackController(this.player, true);
            this.predictedCombatNextTurn = new Combat(this.player);
            aiAtk.declareAttackers(this.predictedCombatNextTurn);
        }
        return this.predictedCombatNextTurn;
    }

    private List<SpellAbility> getPossibleETBCounters() {
        CardCollection all = new CardCollection(this.player.getCardsIn(ZoneType.Hand));
        CardCollectionView ccvPlayerLibrary = this.player.getCardsIn(ZoneType.Library);
        all.addAll(this.player.getCardsIn(ZoneType.Exile));
        all.addAll(this.player.getCardsIn(ZoneType.Graveyard));
        if (!ccvPlayerLibrary.isEmpty()) {
            all.add((Card)ccvPlayerLibrary.get(false));
        }
        all.addAll(this.player.getOpponents().getCardsIn(ZoneType.Exile));
        ArrayList<SpellAbility> spellAbilities = Lists.newArrayList();
        for (Card c : all) {
            for (SpellAbility sa : c.getNonManaAbilities()) {
                if (!(sa instanceof SpellPermanent)) continue;
                sa.setActivatingPlayer(this.player, true);
                if (!this.checkETBEffects(c, sa, ApiType.Counter)) continue;
                spellAbilities.add(sa);
            }
        }
        return spellAbilities;
    }

    private boolean checkCurseEffects(SpellAbility sa) {
        CardCollection ccvGameBattlefield = CardLists.filter((Iterable<Card>)this.game.getCardsIn(ZoneType.Battlefield), CardPredicates.hasSVar("AICurseEffect"));
        for (Card c : ccvGameBattlefield) {
            String curse = c.getSVar("AICurseEffect");
            if ("NonActive".equals(curse) && !this.player.equals(this.game.getPhaseHandler().getPlayerTurn())) {
                return true;
            }
            Card host = sa.getHostCard();
            if ("DestroyCreature".equals(curse) && sa.isSpell() && host.isCreature() && !host.hasKeyword(Keyword.INDESTRUCTIBLE)) {
                return true;
            }
            if ("CounterEnchantment".equals(curse) && sa.isSpell() && host.isEnchantment() && sa.isCounterableBy(null)) {
                return true;
            }
            if ("ChaliceOfTheVoid".equals(curse) && sa.isSpell() && sa.isCounterableBy(null) && host.getCMC() == c.getCounters(CounterEnumType.CHARGE)) {
                return true;
            }
            if (!"BazaarOfWonders".equals(curse) || !sa.isSpell() || !sa.isCounterableBy(null)) continue;
            String hostName = host.getName();
            for (Card card : ccvGameBattlefield) {
                if (card.isToken() || !card.sharesNameWith(host)) continue;
                return true;
            }
            if (!Iterables.any(this.game.getCardsIn(ZoneType.Graveyard), CardPredicates.nameEquals(hostName))) continue;
            return true;
        }
        return false;
    }

    public boolean checkETBEffects(Card card, SpellAbility sa, ApiType api) {
        boolean reset = false;
        if (card.getCastSA() == null) {
            card.setCastSA(sa);
            reset = true;
        }
        boolean result = this.checkETBEffectsPreparedCard(card, sa, api);
        if (reset) {
            card.setCastSA(null);
        }
        return result;
    }

    private boolean checkETBEffectsPreparedCard(Card card, SpellAbility sa, ApiType api) {
        Player activator = sa.getActivatingPlayer();
        for (ReplacementEffect re : card.getReplacementEffects()) {
            SpellAbility exSA;
            if (!(re instanceof ReplaceMoved) || !ZoneType.Battlefield.toString().equals(re.getParam("Destination"))) continue;
            if (re.hasParam("ValidCard")) {
                String s2;
                String validCard = re.getParam("ValidCard");
                if (!validCard.contains("Self")) continue;
                if (validCard.contains("!kicked")) {
                    if (sa.isKicked()) {
                        continue;
                    }
                } else if (validCard.contains("kicked") && (!validCard.contains("kicked ") ? !sa.isKicked() : "1".equals(s2 = validCard.split("kicked ")[1]) && !sa.isOptionalCostPaid(OptionalCost.Kicker1) || "2".equals(s2) && !sa.isOptionalCostPaid(OptionalCost.Kicker2))) continue;
            }
            if (!re.requirementsCheck(this.game) || (exSA = re.getOverridingAbility()) == null || !((exSA = exSA.copy(activator)) instanceof AbilitySub) || this.doTrigger(exSA, false)) continue;
            return false;
        }
        boolean rightapi = false;
        for (Trigger tr : card.getTriggers()) {
            String pres;
            if (tr.getMode() != TriggerType.ChangesZone || tr.getKeyword() != null && tr.getKeyword().getOriginal().startsWith("Partner") || !ZoneType.Battlefield.toString().equals(tr.getParam("Destination"))) continue;
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(tr.getHostCard());
            runParams.put(AbilityKey.Destination, ZoneType.Battlefield.name());
            if (StaticAbilityDisableTriggers.disabled(this.game, tr, runParams)) {
                return api == null;
            }
            if (tr.hasParam("ValidCard")) {
                String s3;
                String validCard = tr.getParam("ValidCard");
                if (!validCard.contains("Self")) continue;
                if (validCard.contains("!kicked")) {
                    if (sa.isKicked()) {
                        continue;
                    }
                } else if (validCard.contains("kicked") && (!validCard.contains("kicked ") ? !sa.isKicked() : "1".equals(s3 = validCard.split("kicked ")[1]) && !sa.isOptionalCostPaid(OptionalCost.Kicker1) || "2".equals(s3) && !sa.isOptionalCostPaid(OptionalCost.Kicker2))) continue;
            }
            if (!tr.requirementsCheck(this.game) || tr.hasParam("OptionalDecider") && api == null) continue;
            SpellAbility exSA = tr.ensureAbility().copy(activator);
            if (api != null) {
                if (exSA.getApi() != api) continue;
                rightapi = true;
                if (!(exSA instanceof AbilitySub) && !ComputerUtilCost.canPayCost(exSA, this.player, true)) {
                    return false;
                }
            }
            exSA.setTrigger(tr);
            exSA.setTriggeringObject(AbilityKey.Card, card);
            SpellAbilityCondition cons = exSA.getConditions();
            if (cons != null && (pres = cons.getIsPresent()) != null && pres.matches("Card\\.(Strictly)?Self")) {
                cons.setIsPresent(null);
            }
            if (!(exSA instanceof AbilitySub) || this.doTrigger(exSA, false) || api == null && card.isCreature() && !ComputerUtilAbility.isFullyTargetable(exSA) && (ComputerUtil.aiLifeInDanger(activator, true, 0) || "BadETB".equals(tr.getParam("AILogic")))) continue;
            return false;
        }
        if (card.isSaga()) {
            for (Trigger tr : card.getTriggers()) {
                if (tr.getMode() != TriggerType.CounterAdded || !tr.isChapter()) continue;
                SpellAbility exSA = tr.ensureAbility().copy(activator);
                if (api != null && exSA.getApi() == api) {
                    rightapi = true;
                }
                if (!(exSA instanceof AbilitySub) || this.doTrigger(exSA, false)) break;
                return false;
            }
        }
        return api == null || rightapi;
    }

    private static List<SpellAbility> getPlayableCounters(CardCollection l) {
        ArrayList<SpellAbility> spellAbility = Lists.newArrayList();
        for (Card c : l) {
            for (SpellAbility sa : c.getNonManaAbilities()) {
                if (sa.getApi() != ApiType.Counter) continue;
                spellAbility.add(sa);
            }
        }
        return spellAbility;
    }

    private CardCollection filterLandsToPlay(CardCollection landList) {
        CardCollectionView hand = this.player.getCardsIn(ZoneType.Hand);
        CardCollection nonLandList = CardLists.filter((Iterable<Card>)hand, Predicates.not(CardPredicates.Presets.LANDS));
        if (landList.size() == 1 && nonLandList.size() < 3) {
            CardCollectionView cardsInPlay = this.player.getCardsIn(ZoneType.Battlefield);
            CardCollection landsInPlay = CardLists.filter((Iterable<Card>)cardsInPlay, CardPredicates.Presets.LANDS);
            CardCollection allCards = new CardCollection(this.player.getCardsIn(ZoneType.Graveyard));
            allCards.addAll(this.player.getCardsIn(ZoneType.Command));
            allCards.addAll(cardsInPlay);
            int maxCmcInHand = Aggregates.max(hand, Card::getCMC);
            int max = Math.max(maxCmcInHand, 6);
            if (landsInPlay.size() + landList.size() > max) {
                for (Card c2 : allCards) {
                    for (SpellAbility sa : c2.getSpellAbilities()) {
                        Cost payCosts = sa.getPayCosts();
                        if (payCosts == null) continue;
                        for (CostPart part : payCosts.getCostParts()) {
                            if (!(part instanceof CostDiscard)) continue;
                            return null;
                        }
                    }
                }
            }
        }
        landList = CardLists.filter((Iterable<Card>)landList, c -> {
            if (this.canPlaySpellBasic((Card)c, null) != AiPlayDecision.WillPlay) {
                return false;
            }
            String name = c.getName();
            CardCollectionView battlefield = this.player.getCardsIn(ZoneType.Battlefield);
            if (c.getType().isLegendary() && !name.equals("Flagstones of Trokair") && Iterables.any(battlefield, CardPredicates.nameEquals(name))) {
                return false;
            }
            CardCollectionView hand1 = this.player.getCardsIn(ZoneType.Hand);
            CardCollection lands = new CardCollection(battlefield);
            lands.addAll(hand1);
            lands = CardLists.filter((Iterable<Card>)lands, CardPredicates.Presets.LANDS);
            int maxCmcInHand = Aggregates.max(hand1, Card::getCMC);
            if (lands.size() >= Math.max(maxCmcInHand, 6)) {
                if (!c.isLand() || c.isModal() && !c.getState(CardStateName.Modal).getType().isLand()) {
                    return false;
                }
                if (c.hasKeyword(Keyword.CYCLING)) {
                    return false;
                }
            }
            return Iterables.any(c.getAllPossibleAbilities(this.player, true), SpellAbility::isLandAbility);
        });
        return landList;
    }

    private Card chooseBestLandToPlay(CardCollection landList) {
        if (landList.isEmpty()) {
            return null;
        }
        CardCollection nonLandsInHand = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Hand), Predicates.not(CardPredicates.Presets.LANDS));
        boolean hasMomir = this.player.isCardInCommand("Momir Vig, Simic Visionary Avatar");
        if (hasMomir && nonLandsInHand.isEmpty()) {
            String landStrategy = this.getProperty(AiProps.MOMIR_BASIC_LAND_STRATEGY);
            if (landStrategy.equalsIgnoreCase("random")) {
                return Aggregates.random(landList);
            }
            if (landStrategy.toLowerCase().startsWith("preforder:")) {
                String order = landStrategy.substring(10);
                for (char c : order.toCharArray()) {
                    byte color = MagicColor.fromName(c);
                    for (Card land : landList) {
                        for (SpellAbility m4 : ComputerUtilMana.getAIPlayableMana(land)) {
                            if (!m4.canProduce(MagicColor.toShortString(color))) continue;
                            return land;
                        }
                    }
                }
                return Aggregates.random(landList);
            }
        }
        CardCollection unreflectedLands = new CardCollection(landList);
        for (Object l : landList) {
            if (!((Card)l).isReflectedLand()) continue;
            unreflectedLands.remove(l);
        }
        if (!unreflectedLands.isEmpty()) {
            landList = unreflectedLands;
        }
        if (!nonLandsInHand.isEmpty()) {
            CardCollection nonTappedLands = new CardCollection();
            for (Card land : landList) {
                Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(land);
                repParams.put(AbilityKey.Origin, (Object)land.getZone().getZoneType());
                repParams.put(AbilityKey.Destination, (Object)ZoneType.Battlefield);
                repParams.put(AbilityKey.Source, land);
                GameEntityCounterTable table = new GameEntityCounterTable();
                repParams.put(AbilityKey.EffectOnly, true);
                repParams.put(AbilityKey.CounterTable, table);
                repParams.put(AbilityKey.CounterMap, table.column(land));
                boolean foundTapped = false;
                for (ReplacementEffect re : this.player.getGame().getReplacementHandler().getReplacementList(ReplacementType.Moved, repParams, ReplacementLayer.Other)) {
                    SpellAbility reSA = re.ensureAbility();
                    if (reSA == null || !ApiType.Tap.equals((Object)reSA.getApi())) continue;
                    reSA.setActivatingPlayer(reSA.getHostCard().getController(), true);
                    if (!reSA.metConditions()) continue;
                    foundTapped = true;
                    break;
                }
                if (foundTapped) continue;
                nonTappedLands.add(land);
            }
            if (!nonTappedLands.isEmpty()) {
                landList = nonTappedLands;
            }
        }
        if (this.player.getLandsInPlay().isEmpty()) {
            CardCollection oneDrops = CardLists.filter((Iterable<Card>)nonLandsInHand, CardPredicates.hasCMC(1));
            for (int i = 0; i < MagicColor.WUBRG.length; ++i) {
                byte color = MagicColor.WUBRG[i];
                if (!Iterables.any(oneDrops, CardPredicates.isColor(color))) continue;
                for (Card land : landList) {
                    if (land.getType().hasSubtype((String)MagicColor.Constant.BASIC_LANDS.get(i))) {
                        return land;
                    }
                    for (SpellAbility m5 : ComputerUtilMana.getAIPlayableMana(land)) {
                        if (!m5.canProduce(MagicColor.toShortString(color))) continue;
                        return land;
                    }
                }
            }
        }
        CardCollectionView landsInBattlefield = this.player.getCardsIn(ZoneType.Battlefield);
        ArrayList<String> basics = Lists.newArrayList();
        for (String name : MagicColor.Constant.BASIC_LANDS) {
            if (CardLists.getType(landList, name).isEmpty()) continue;
            basics.add(name);
        }
        if (!basics.isEmpty()) {
            int minSize = Integer.MAX_VALUE;
            String minType = null;
            for (String b : basics) {
                int num = CardLists.getType(landsInBattlefield, b).size();
                if (num >= minSize) continue;
                minType = b;
                minSize = num;
            }
            if (minType != null) {
                landList = CardLists.getType(landList, minType);
            }
            if (Iterables.any(landList, Predicates.not(CardPredicates.Presets.BASIC_LANDS))) {
                landList = CardLists.filter((Iterable<Card>)landList, Predicates.not(CardPredicates.Presets.BASIC_LANDS));
            }
        }
        return ComputerUtilCard.getBestLandToPlayAI(landList);
    }

    private SpellAbility chooseCounterSpell(List<SpellAbility> possibleCounters) {
        if (possibleCounters == null || possibleCounters.isEmpty()) {
            return null;
        }
        SpellAbility bestSA = null;
        int bestRestriction = Integer.MIN_VALUE;
        Iterator<SpellAbility> iterator = ComputerUtilAbility.getOriginalAndAltCostAbilities(possibleCounters, this.player).iterator();
        while (iterator.hasNext()) {
            SpellAbility sa;
            SpellAbility currentSA = sa = iterator.next();
            sa.setActivatingPlayer(this.player, true);
            AiPlayDecision opinion = this.canPlayAndPayFor(currentSA);
            if (opinion != AiPlayDecision.WillPlay) continue;
            if (bestSA == null) {
                bestSA = currentSA;
                bestRestriction = ComputerUtil.counterSpellRestriction(this.player, currentSA);
                continue;
            }
            int restrictionLevel = ComputerUtil.counterSpellRestriction(this.player, currentSA);
            if (restrictionLevel <= bestRestriction) continue;
            bestRestriction = restrictionLevel;
            bestSA = currentSA;
        }
        return bestSA;
    }

    public SpellAbility predictSpellToCastInMain2(ApiType exceptSA) {
        return this.predictSpellToCastInMain2(exceptSA, true);
    }

    private SpellAbility predictSpellToCastInMain2(ApiType exceptSA, boolean handOnly) {
        if (!this.getBooleanProperty(AiProps.PREDICT_SPELLS_FOR_MAIN2)) {
            return null;
        }
        CardCollectionView cards = handOnly ? this.player.getCardsIn(ZoneType.Hand) : ComputerUtilAbility.getAvailableCards(this.game, this.player);
        List<SpellAbility> all = ComputerUtilAbility.getSpellAbilities(cards, this.player);
        try {
            all.sort(ComputerUtilAbility.saEvaluator);
            ComputerUtilAbility.sortCreatureSpells(all);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            String assertex = ComparatorUtil.verifyTransitivity(ComputerUtilAbility.saEvaluator, all);
            Sentry.captureMessage(ex.getMessage() + "\nAssertionError [verifyTransitivity]: " + assertex);
        }
        for (SpellAbility sa : ComputerUtilAbility.getOriginalAndAltCostAbilities(all, this.player)) {
            ApiType saApi = sa.getApi();
            if (saApi == ApiType.Counter || saApi == exceptSA) continue;
            sa.setActivatingPlayer(this.player, true);
            Card host = sa.getHostCard();
            if (!(sa instanceof SpellPermanent) || host == null || host.isLand() || ComputerUtil.castPermanentInMain1(this.player, sa) || !ComputerUtilCost.canPayCost(sa, this.player, false)) continue;
            return sa;
        }
        return null;
    }

    public boolean reserveManaSourcesForNextSpell(SpellAbility sa, SpellAbility exceptForSa) {
        return this.reserveManaSources(sa, null, false, true, exceptForSa);
    }

    public boolean reserveManaSources(SpellAbility sa) {
        return this.reserveManaSources(sa, PhaseType.MAIN2, false, false, null);
    }

    public boolean reserveManaSources(SpellAbility sa, PhaseType phaseType, boolean enemy) {
        return this.reserveManaSources(sa, phaseType, enemy, true, null);
    }

    public boolean reserveManaSources(SpellAbility sa, PhaseType phaseType, boolean enemy, boolean forNextSpell, SpellAbility exceptForThisSa) {
        ManaCostBeingPaid cost = ComputerUtilMana.calculateManaCost(sa, true, 0);
        CardCollection manaSources = ComputerUtilMana.getManaSourcesToPayCost(cost, sa, this.player);
        if (exceptForThisSa != null) {
            manaSources.removeAll(ComputerUtilMana.getManaSourcesToPayCost(ComputerUtilMana.calculateManaCost(exceptForThisSa, true, 0), exceptForThisSa, this.player));
        }
        if (manaSources.isEmpty()) {
            return false;
        }
        AiCardMemory.MemorySet memSet = null;
        if (phaseType == null && forNextSpell) {
            memSet = AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_NEXT_SPELL;
        } else if (phaseType != null) {
            switch (phaseType) {
                case MAIN2: {
                    memSet = AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2;
                    break;
                }
                case COMBAT_DECLARE_BLOCKERS: {
                    memSet = enemy ? AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_ENEMY_DECLBLK : AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_DECLBLK;
                    break;
                }
                default: {
                    System.out.println("Warning: unsupported mana reservation phase specified for reserveManaSources: " + phaseType.name() + ", reserving until Main 2 instead. Consider adding support for the phase if needed.");
                    memSet = AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_MAIN2;
                }
            }
        }
        if (manaSources.size() >= cost.getConvertedManaCost()) {
            for (Card c : manaSources) {
                this.memory.rememberCard(c, memSet);
            }
            return true;
        }
        return false;
    }

    private AiPlayDecision canPlayAndPayFor(SpellAbility sa) {
        CardStateName currentState;
        if (!sa.canPlay()) {
            return AiPlayDecision.CantPlaySa;
        }
        Card host = sa.getHostCard();
        CardStateName cardStateName = currentState = sa.getCardState() != null && host.getCurrentStateName() != sa.getCardStateName() && !host.isInPlay() ? host.getCurrentStateName() : null;
        if (currentState != null) {
            host.setState(sa.getCardStateName(), false);
        }
        AiPlayDecision decision = this.canPlayAndPayForFace(sa);
        if (currentState != null) {
            host.setState(currentState, false);
        }
        return decision;
    }

    private AiPlayDecision canPlayAndPayForFace(SpellAbility sa) {
        int finalCMC;
        AiPlayDecision canPlay;
        boolean xCost;
        Card host = sa.getHostCard();
        if (sa.hasParam("AICheckSVar")) {
            int left;
            String svarToCheck = sa.getParam("AICheckSVar");
            String comparator = "GE";
            int compareTo = 1;
            if (sa.hasParam("AISVarCompare")) {
                String fullCmp = sa.getParam("AISVarCompare");
                comparator = fullCmp.substring(0, 2);
                String strCmpTo = fullCmp.substring(2);
                try {
                    compareTo = Integer.parseInt(strCmpTo);
                }
                catch (Exception ignored) {
                    compareTo = AbilityUtils.calculateAmount(host, host.getSVar(strCmpTo), sa);
                }
            }
            if (!Expressions.compare(left = AbilityUtils.calculateAmount(host, svarToCheck, sa), comparator, compareTo)) {
                return AiPlayDecision.AnotherTime;
            }
        }
        int oldCMC = -1;
        boolean bl = xCost = sa.costHasX() || host.hasKeyword(Keyword.STRIVE) || sa.getApi() == ApiType.Charm;
        if (!xCost) {
            if (!ComputerUtilCost.canPayCost(sa, this.player, sa.isTrigger())) {
                return AiPlayDecision.CantAfford;
            }
            if (!sa.getAllTargetChoices().isEmpty()) {
                oldCMC = CostAdjustment.adjust(sa.getPayCosts(), sa).getTotalMana().getCMC();
            }
        }
        if ((canPlay = this.canPlaySa(sa)) != AiPlayDecision.WillPlay) {
            return canPlay;
        }
        if (!sa.isSpell() || sa.isCounterableBy(null)) {
            for (TargetChoices tc : sa.getAllTargetChoices()) {
                for (Card tgt : tc.getTargetCards()) {
                    SpellAbilityAi topAI;
                    if (!tgt.hasKeyword(Keyword.WARD) || !tgt.isInPlay() || !tgt.getController().isOpponentOf(host.getController())) continue;
                    Cost wardCost = ComputerUtilCard.getTotalWardCost(tgt);
                    if (wardCost.hasManaCost()) {
                        xCost |= wardCost.getTotalMana().getCMC() > 0;
                    }
                    if ((topAI = new SpellAbilityAi(){}).willPayCosts(this.player, sa, wardCost, host)) continue;
                    return AiPlayDecision.CostNotAcceptable;
                }
            }
        }
        if (!xCost && oldCMC > -1 && (finalCMC = CostAdjustment.adjust(sa.getPayCosts(), sa).getTotalMana().getCMC()) > oldCMC) {
            xCost = true;
        }
        if (xCost && !ComputerUtilCost.canPayCost(sa, this.player, sa.isTrigger())) {
            return AiPlayDecision.CantAfford;
        }
        return AiPlayDecision.WillPlay;
    }

    public AiPlayDecision canPlaySa(SpellAbility sa) {
        if (!this.checkAiSpecificRestrictions(sa)) {
            return AiPlayDecision.CantPlayAi;
        }
        if (sa instanceof WrappedAbility) {
            return this.canPlaySa(((WrappedAbility)sa).getWrappedAbility());
        }
        if (!sa.canCastTiming(this.player)) {
            return AiPlayDecision.AnotherTime;
        }
        Card card = sa.getHostCard();
        if (this.getBooleanProperty(AiProps.TRY_TO_PRESERVE_BUYBACK_SPELLS) && card.hasKeyword(Keyword.BUYBACK) && !sa.isBuyback() && !this.canPlaySpellWithoutBuyback(card, sa)) {
            return AiPlayDecision.NeedsToPlayCriteriaNotMet;
        }
        this.memory.clearMemorySet(AiCardMemory.MemorySet.MARKED_TO_AVOID_REENTRY);
        if (sa.getApi() != null) {
            String msg = "AiController:canPlaySa: AI checks for if can PlaySa";
            Breadcrumb bread = new Breadcrumb(msg);
            bread.setData("Api", sa.getApi().toString());
            bread.setData("Card", card.getName());
            bread.setData("SA", sa.toString());
            Sentry.addBreadcrumb(bread);
            Sentry.setExtra("Card", card.getName());
            Sentry.setExtra("SA", sa.toString());
            boolean canPlay = SpellApiToAi.Converter.get(sa.getApi()).canPlayAIWithSubs(this.player, sa);
            Sentry.removeExtra("Card");
            Sentry.removeExtra("SA");
            if (!canPlay) {
                return AiPlayDecision.CantPlayAi;
            }
        } else {
            ManaCost mana;
            Cost payCosts = sa.getPayCosts();
            if (payCosts != null && (mana = payCosts.getTotalMana()) != null) {
                ManaCost cardCost;
                if (mana.countX() > 0) {
                    int xPay = ComputerUtilCost.getMaxXValue(sa, this.player, sa.isTrigger());
                    if (xPay <= 0) {
                        return AiPlayDecision.CantAffordX;
                    }
                    sa.setXManaCostPaid(xPay);
                } else if (mana.isZero() && (cardCost = card.getManaCost()) != null && cardCost.countX() > 0) {
                    return AiPlayDecision.CantPlayAi;
                }
            }
        }
        if (this.checkCurseEffects(sa)) {
            return AiPlayDecision.CurseEffects;
        }
        if (!sa.isLegalAfterStack()) {
            return AiPlayDecision.AnotherTime;
        }
        Card spellHost = card;
        if (sa.isSpell()) {
            spellHost = CardCopyService.getLKICopy(spellHost);
            spellHost.setLKICMC(-1);
            spellHost.setLastKnownZone(this.game.getStackZone());
            spellHost.setCastFrom(card.getZone());
        }
        if (!sa.checkRestrictions(spellHost, this.player)) {
            return AiPlayDecision.AnotherTime;
        }
        if (sa.usesTargeting()) {
            if (!sa.isTargetNumberValid() && sa.getTargetRestrictions().getNumCandidates(sa, true) == 0) {
                return AiPlayDecision.TargetingFailed;
            }
            if (!StaticAbilityMustTarget.meetsMustTargetRestriction(sa)) {
                return AiPlayDecision.TargetingFailed;
            }
        }
        if (sa instanceof Spell) {
            if (sa.getApi() == ApiType.PermanentCreature || sa.getApi() == ApiType.PermanentNoncreature) {
                return this.canPlayFromEffectAI((Spell)sa, false, true);
            }
            if (!this.player.cantLoseForZeroOrLessLife() && this.player.canLoseLife() && ComputerUtil.getDamageForPlaying(this.player, sa) >= this.player.getLife()) {
                return AiPlayDecision.CurseEffects;
            }
            return this.canPlaySpellBasic(card, sa);
        }
        return AiPlayDecision.WillPlay;
    }

    private AiPlayDecision canPlaySpellBasic(Card card, SpellAbility sa) {
        if ("True".equals(card.getSVar("NonStackingEffect")) && ComputerUtilCard.isNonDisabledCardInPlay(this.player, card.getName())) {
            return AiPlayDecision.NeedsToPlayCriteriaNotMet;
        }
        return ComputerUtilCard.checkNeedsToPlayReqs(card, sa);
    }

    private boolean canPlaySpellWithoutBuyback(Card card, SpellAbility sa) {
        int n;
        int copies = CardLists.count(this.player.getCardsIn(ZoneType.Hand), CardPredicates.nameEquals(card.getName()));
        if (copies >= 2) {
            return true;
        }
        if (ComputerUtil.aiLifeInDanger(this.player, true, 0)) {
            return true;
        }
        Cost costWithBuyback = sa.getPayCosts().copy();
        for (OptionalCostValue optionalCostValue : GameActionUtil.getOptionalCostValues(sa)) {
            if (optionalCostValue.getType() != OptionalCost.Buyback) continue;
            costWithBuyback.add(optionalCostValue.getCost());
        }
        if ((costWithBuyback = CostAdjustment.adjust(costWithBuyback, sa)).hasSpecificCostType(CostPayLife.class) || costWithBuyback.hasSpecificCostType(CostDiscard.class) || costWithBuyback.hasSpecificCostType(CostSacrifice.class)) {
            return true;
        }
        int neededMana = 0;
        if (costWithBuyback.getCostMana() != null) {
            neededMana = costWithBuyback.getCostMana().getMana().getCMC();
        }
        for (Card c : this.game.getCardsIn(ZoneType.Battlefield)) {
            for (StaticAbility s2 : c.getStaticAbilities()) {
                if (!"ReduceCost".equals(s2.getParam("Mode")) || !"Spell.Buyback".equals(s2.getParam("ValidSpell"))) continue;
                neededMana -= AbilityUtils.calculateAmount(c, s2.getParam("Amount"), s2);
            }
        }
        if (neededMana < 0) {
            neededMana = 0;
        }
        return (n = ComputerUtilMana.getAvailableManaEstimate(this.player, false)) < neededMana - 1;
    }

    public CardCollection getCardsToDiscard(int numDiscard, String[] uTypes, SpellAbility sa) {
        return this.getCardsToDiscard(numDiscard, uTypes, sa, CardCollection.EMPTY);
    }

    public CardCollection getCardsToDiscard(int numDiscard, String[] uTypes, SpellAbility sa, CardCollectionView exclude) {
        boolean noFiltering = sa != null && "DiscardCMCX".equals(sa.getParam("AILogic"));
        CardCollection hand = new CardCollection(this.player.getCardsIn(ZoneType.Hand));
        hand.removeAll(exclude);
        if (uTypes != null && sa != null && !noFiltering) {
            hand = CardLists.getValidCards((Iterable<Card>)hand, uTypes, sa.getActivatingPlayer(), sa.getHostCard(), (CardTraitBase)sa);
        }
        return this.getCardsToDiscard(numDiscard, numDiscard, hand, sa);
    }

    public CardCollection getCardsToDiscard(int min2, int max, CardCollection validCards, SpellAbility sa) {
        if (validCards.size() <= min2) {
            return validCards;
        }
        Card sourceCard = null;
        CardCollection discardList = new CardCollection();
        int count = 0;
        if (sa != null) {
            String logic = sa.getParamOrDefault("AILogic", "");
            sourceCard = sa.getHostCard();
            if ("Always".equals(logic) && !validCards.isEmpty()) {
                min2 = 1;
            } else if (logic.startsWith("UnlessAtLife.")) {
                int threshold = AbilityUtils.calculateAmount(sourceCard, logic.substring(logic.indexOf(".") + 1), sa);
                if (this.player.getLife() <= threshold) {
                    min2 = 1;
                }
            } else {
                if ("VolrathsShapeshifter".equals(logic)) {
                    return SpecialCardAi.VolrathsShapeshifter.targetBestCreature(this.player, sa);
                }
                if ("DiscardCMCX".equals(logic)) {
                    int cmc = sa.getXManaCostPaid();
                    CardCollection discards = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Hand), CardPredicates.hasCMC(cmc));
                    if (discards.isEmpty()) {
                        return null;
                    }
                    return new CardCollection(ComputerUtilCard.getWorstAI(discards));
                }
            }
            if (sa.hasParam("AnyNumber") && "DiscardUncastableAndExcess".equals(sa.getParam("AILogic"))) {
                CardCollection discards = new CardCollection();
                CardCollectionView inHand = this.player.getCardsIn(ZoneType.Hand);
                int numLandsOTB = CardLists.count(inHand, CardPredicates.Presets.LANDS);
                int numOppInHand = 0;
                for (Player p : this.player.getGame().getPlayers()) {
                    if (p.getCardsIn(ZoneType.Hand).size() <= numOppInHand) continue;
                    numOppInHand = p.getCardsIn(ZoneType.Hand).size();
                }
                for (Card c : inHand) {
                    if (c.hasSVar("DoNotDiscardIfAble") || c.hasSVar("IsReanimatorCard")) continue;
                    if (c.isCreature() && !ComputerUtilMana.hasEnoughManaSourcesToCast(c.getSpellPermanent(), this.player)) {
                        discards.add(c);
                    }
                    if ((!c.isLand() || numLandsOTB < 5) && (c.getFirstSpellAbility() == null || ComputerUtilMana.hasEnoughManaSourcesToCast(c.getFirstSpellAbility(), this.player)) || discards.size() + 1 > numOppInHand) continue;
                    discards.add(c);
                }
                return discards;
            }
        }
        while (count < min2) {
            Card prefCard = null;
            if (sa != null && sa.getActivatingPlayer() != null && sa.getActivatingPlayer().isOpponentOf(this.player)) {
                for (Card c : validCards) {
                    if (!c.hasSVar("DiscardMeByOpp")) continue;
                    prefCard = c;
                    break;
                }
            }
            if (prefCard == null && (prefCard = ComputerUtil.getCardPreference(this.player, sourceCard, "DiscardCost", validCards)) != null && prefCard.hasSVar("DoNotDiscardIfAble")) {
                prefCard = null;
            }
            if (prefCard == null) break;
            discardList.add(prefCard);
            validCards.remove(prefCard);
            ++count;
        }
        int discardsLeft = min2 - count;
        for (int i = 0; i < discardsLeft; ++i) {
            boolean canDiscardLands;
            if (validCards.isEmpty()) continue;
            int numLandsInPlay = CardLists.count(this.player.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.LANDS_PRODUCING_MANA);
            CardCollection landsInHand = CardLists.filter((Iterable<Card>)validCards, CardPredicates.Presets.LANDS);
            int numLandsInHand = landsInHand.size();
            boolean bl = canDiscardLands = numLandsInHand > 3 || numLandsInHand > 2 && numLandsInPlay > 0 || numLandsInHand > 1 && numLandsInPlay > 2 || numLandsInHand > 0 && numLandsInPlay > 5;
            if (canDiscardLands) {
                discardList.add((Card)landsInHand.get(false));
                validCards.remove(landsInHand.get(false));
                continue;
            }
            CardLists.sortByCmcDesc(validCards);
            int numLandsAvailable = numLandsInPlay;
            if (numLandsInHand > 0) {
                ++numLandsAvailable;
            }
            boolean discardedUnplayable = false;
            boolean freeCastAllowed = ComputerUtilCost.isFreeCastAllowedByPermanent(this.player, null);
            for (int j = 0; j < validCards.size(); ++j) {
                if ((((Card)validCards.get(j)).getCMC() > numLandsAvailable || freeCastAllowed) && !((Card)validCards.get(j)).hasSVar("DoNotDiscardIfAble")) {
                    discardList.add((Card)validCards.get(j));
                    validCards.remove((Object)validCards.get(j));
                    discardedUnplayable = true;
                    break;
                }
                if (((Card)validCards.get(j)).getCMC() <= numLandsAvailable) break;
            }
            if (discardedUnplayable) continue;
            Card worst = ComputerUtilCard.getWorstAI(validCards);
            if (worst == null) {
                worst = ComputerUtilCard.getCheapestSpellAI(validCards);
            }
            if (worst == null && !validCards.isEmpty()) {
                for (Card c : validCards) {
                    if (c.hasSVar("DoNotDiscardIfAble")) continue;
                    worst = c;
                    break;
                }
                if (worst == null) {
                    for (Card c : validCards) {
                        if (CardLists.count(this.player.getCardsIn(ZoneType.Hand), CardPredicates.nameEquals(c.getName())) <= 1) continue;
                        worst = c;
                        break;
                    }
                    if (worst == null) {
                        worst = Aggregates.random(validCards);
                    }
                }
            }
            discardList.add(worst);
            validCards.remove(worst);
        }
        return discardList;
    }

    public boolean confirmAction(SpellAbility sa, PlayerActionConfirmMode mode, String message, Map<String, Object> params) {
        ApiType api;
        if (mode == PlayerActionConfirmMode.ChangeZoneToAltDestination) {
            System.err.printf("Overriding AI confirmAction decision for %s, defaulting to true.\n", new Object[]{mode});
            return true;
        }
        ApiType apiType = api = sa == null ? null : sa.getApi();
        if (sa == null || api == null) {
            String exMsg = String.format("AI confirmAction does not know what to decide about %s mode (%s is null).", new Object[]{mode, sa == null ? "SA" : "API"});
            throw new IllegalArgumentException(exMsg);
        }
        return SpellApiToAi.Converter.get(api).confirmAction(this.player, sa, mode, message, params);
    }

    public boolean confirmBidAction(SpellAbility sa, PlayerActionConfirmMode mode, String message, int bid, Player winner) {
        if (mode != null) {
            switch (mode) {
                case BidLife: {
                    if (sa.hasParam("AIBidMax")) {
                        return !this.player.equals(winner) && bid < Integer.parseInt(sa.getParam("AIBidMax")) && this.player.getLife() > bid + 5;
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    public boolean confirmStaticApplication(Card hostCard, String logic) {
        return true;
    }

    public String getProperty(AiProps propName) {
        return AiProfileUtil.getAIProp(this.getPlayer().getLobbyPlayer(), propName);
    }

    public int getIntProperty(AiProps propName) {
        String prop = AiProfileUtil.getAIProp(this.getPlayer().getLobbyPlayer(), propName);
        if (prop == null || prop.isEmpty()) {
            return Integer.parseInt(propName.getDefault());
        }
        return Integer.parseInt(prop);
    }

    public boolean getBooleanProperty(AiProps propName) {
        String prop = AiProfileUtil.getAIProp(this.getPlayer().getLobbyPlayer(), propName);
        if (prop == null || prop.isEmpty()) {
            return Boolean.parseBoolean(propName.getDefault());
        }
        return Boolean.parseBoolean(prop);
    }

    public AiPlayDecision canPlayFromEffectAI(Spell spell, boolean mandatory, boolean withoutPayingManaCost) {
        int damage = ComputerUtil.getDamageForPlaying(this.player, spell);
        if (!mandatory && damage >= this.player.getLife() && !this.player.cantLoseForZeroOrLessLife() && this.player.canLoseLife()) {
            return AiPlayDecision.CurseEffects;
        }
        Card card = spell.getHostCard();
        if (spell instanceof SpellApiBased) {
            boolean chance = false;
            chance = withoutPayingManaCost ? SpellApiToAi.Converter.get(spell.getApi()).doTriggerNoCostWithSubs(this.player, spell, mandatory) : SpellApiToAi.Converter.get(spell.getApi()).doTriggerAI(this.player, spell, mandatory);
            if (!chance) {
                return AiPlayDecision.TargetingFailed;
            }
            if (mandatory) {
                return AiPlayDecision.WillPlay;
            }
            if (card.isPermanent()) {
                if (!this.checkETBEffects(card, spell, null)) {
                    return AiPlayDecision.BadEtbEffects;
                }
                if (!this.player.cantLoseForZeroOrLessLife() && this.player.canLoseLife() && damage + ComputerUtil.getDamageFromETB(this.player, card) >= this.player.getLife()) {
                    return AiPlayDecision.BadEtbEffects;
                }
            }
        }
        return this.canPlaySpellBasic(card, spell);
    }

    public void declareBlockersFor(Player defender, Combat combat) {
        AiBlockController block = new AiBlockController(defender, defender != this.player);
        block.assignBlockersForCombat(combat);
    }

    public void declareAttackers(Player attacker, Combat combat) {
        AiAttackController aiAtk = new AiAttackController(attacker);
        this.lastAttackAggression = aiAtk.declareAttackers(combat);
        aiAtk.reinforceWithBanding(combat);
        if (!CombatUtil.validateAttackers(combat)) {
            combat.clearAttackers();
            Map<Card, GameEntity> legal = combat.getAttackConstraints().getLegalAttackers().getLeft();
            System.err.println("AI Attack declaration invalid, defaulting to: " + legal);
            for (Map.Entry<Card, GameEntity> mandatoryAttacker : legal.entrySet()) {
                combat.addAttacker(mandatoryAttacker.getKey(), mandatoryAttacker.getValue());
            }
            if (!CombatUtil.validateAttackers(combat)) {
                aiAtk.declareAttackers(combat);
            }
        }
        for (Card element : combat.getAttackers()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Computer just assigned ").append(element.getName()).append(" as an attacker.");
            Log.debug(sb.toString());
        }
    }

    private List<SpellAbility> singleSpellAbilityList(SpellAbility sa) {
        if (sa == null) {
            return null;
        }
        return Lists.newArrayList(sa);
    }

    public List<SpellAbility> chooseSpellAbilityToPlay() {
        SpellAbility wantToPlayBeforeLand;
        this.predictedCombat = null;
        this.predictedCombatNextTurn = null;
        this.memory.clearMemorySet(AiCardMemory.MemorySet.HELD_MANA_SOURCES_FOR_NEXT_SPELL);
        if (this.useSimulation) {
            return this.singleSpellAbilityList(this.simPicker.chooseSpellAbilityToPlay(null));
        }
        CardCollection playBeforeLand = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Hand), CardPredicates.hasSVar("PlayBeforeLandDrop"));
        if (!playBeforeLand.isEmpty() && (wantToPlayBeforeLand = this.chooseSpellAbilityToPlayFromList(ComputerUtilAbility.getSpellAbilities(playBeforeLand, this.player), false)) != null) {
            return this.singleSpellAbilityList(wantToPlayBeforeLand);
        }
        CardCollection landsWannaPlay = ComputerUtilAbility.getAvailableLandsToPlay(this.game, this.player);
        if (landsWannaPlay != null) {
            landsWannaPlay = this.filterLandsToPlay(landsWannaPlay);
            Log.debug("Computer " + this.game.getPhaseHandler().getPhase().nameForUi);
            if (landsWannaPlay != null && !landsWannaPlay.isEmpty()) {
                Card land = this.chooseBestLandToPlay(landsWannaPlay);
                if (!(this.player.canLoseLife() && !this.player.cantLoseForZeroOrLessLife() && ComputerUtil.getDamageFromETB(this.player, land) >= this.player.getLife() || this.game.getPhaseHandler().is(PhaseType.MAIN1) && this.isSafeToHoldLandDropForMain2(land))) {
                    List<SpellAbility> abilities = land.getAllPossibleAbilities(this.player, true);
                    abilities.removeIf(sa -> !sa.isLandAbility());
                    if (!abilities.isEmpty()) {
                        return abilities;
                    }
                }
            }
        }
        return this.singleSpellAbilityList(this.getSpellAbilityToPlay());
    }

    private boolean isSafeToHoldLandDropForMain2(Card landToPlay) {
        int predictedMana;
        boolean hasMomir = this.player.isCardInCommand("Momir Vig, Simic Visionary Avatar");
        if (hasMomir) {
            return false;
        }
        if (!MyRandom.percentTrue(this.getIntProperty(AiProps.HOLD_LAND_DROP_FOR_MAIN2_IF_UNUSED))) {
            return false;
        }
        if (this.game.getPhaseHandler().getTurn() <= 2) {
            return false;
        }
        CardCollection inHand = CardLists.filter((Iterable<Card>)this.player.getCardsIn(ZoneType.Hand), Predicates.not(CardPredicates.Presets.LANDS));
        CardCollectionView otb = this.player.getCardsIn(ZoneType.Battlefield);
        if (this.getBooleanProperty(AiProps.HOLD_LAND_DROP_ONLY_IF_HAVE_OTHER_PERMS) && !Iterables.any(otb, Predicates.not(CardPredicates.Presets.LANDS))) {
            return false;
        }
        boolean isTapLand = false;
        for (ReplacementEffect repl : landToPlay.getReplacementEffects()) {
            if (!repl.getParamOrDefault("Description", "").equals("CARDNAME enters tapped.")) continue;
            isTapLand = true;
        }
        int totalCMCInHand = Aggregates.sum(inHand, Card::getCMC);
        int minCMCInHand = Aggregates.min(inHand, Card::getCMC);
        if (minCMCInHand == Integer.MAX_VALUE) {
            minCMCInHand = 0;
        }
        boolean canCastWithLandDrop = (predictedMana = ComputerUtilMana.getAvailableManaEstimate(this.player, true)) + 1 >= minCMCInHand && minCMCInHand > 0 && !isTapLand;
        boolean cantCastAnythingNow = predictedMana < minCMCInHand;
        boolean hasRelevantAbsOTB = Iterables.any(otb, card -> {
            boolean isTapLand1 = false;
            for (ReplacementEffect repl : card.getReplacementEffects()) {
                if (!repl.getParamOrDefault("Description", "").equals("CARDNAME enters tapped.")) continue;
                isTapLand1 = true;
            }
            for (SpellAbility sa : card.getSpellAbilities()) {
                if (!sa.isAbility() || sa.getPayCosts().getCostMana() == null || sa.getPayCosts().getCostMana().getMana().getCMC() <= 0 || sa.getPayCosts().hasTapCost() && isTapLand1 || sa.hasParam("ActivationZone") && !sa.getParam("ActivationZone").contains("Battlefield")) continue;
                return true;
            }
            return false;
        });
        boolean hasLandBasedEffect = Iterables.any(otb, card -> {
            for (Trigger t2 : card.getTriggers()) {
                Map<String, String> params = t2.getMapParams();
                if (!"ChangesZone".equals(params.get("Mode")) || !params.containsKey("ValidCard") || params.containsKey("AILogic") && params.get("AILogic").equals("SafeToHold") || params.get("ValidCard").contains("nonLand") || !params.get("ValidCard").contains("Land") && !params.get("ValidCard").contains("Permanent") || !"Battlefield".equals(params.get("Destination"))) continue;
                return true;
            }
            for (String sv : card.getSVars().keySet()) {
                String varValue = card.getSVar(sv);
                if (varValue.equals("Count$Domain")) {
                    for (String type : landToPlay.getType().getLandTypes()) {
                        if (!CardType.isABasicLandType(type) || !CardLists.getType(otb, type).isEmpty()) continue;
                        return true;
                    }
                }
                if (!varValue.startsWith("Count$Valid") && !sv.equals("BuffedBy") || !varValue.contains("Land") && !varValue.contains("Plains") && !varValue.contains("Forest") && !varValue.contains("Mountain") && !varValue.contains("Island") && !varValue.contains("Swamp") && !varValue.contains("Wastes")) continue;
                return true;
            }
            return false;
        });
        if (!(canCastWithLandDrop || !cantCastAnythingNow || hasLandBasedEffect || hasRelevantAbsOTB && !isTapLand)) {
            return true;
        }
        return !(predictedMana <= totalCMCInHand && canCastWithLandDrop || hasRelevantAbsOTB && !isTapLand) && !hasLandBasedEffect;
    }

    private SpellAbility getSpellAbilityToPlay() {
        CardCollection cards = ComputerUtilAbility.getAvailableCards(this.game, this.player);
        cards = ComputerUtilCard.dedupeCards(cards);
        ArrayList<SpellAbility> saList = Lists.newArrayList();
        SpellAbility top = null;
        if (!this.game.getStack().isEmpty()) {
            top = this.game.getStack().peekAbility();
        }
        boolean topOwnedByAI = top != null && top.getActivatingPlayer().equals(this.player);
        boolean mustRespond = false;
        if (top != null) {
            mustRespond = top.hasParam("AIRespondsToOwnAbility");
            mustRespond |= top.isTrigger() && top.getTrigger().isKeyword(Keyword.EVOKE);
        }
        if (topOwnedByAI && !mustRespond && ComputerUtilAbility.getFirstCopySASpell(saList = ComputerUtilAbility.getSpellAbilities(cards, this.player)) == null) {
            return null;
        }
        if (!this.game.getStack().isEmpty()) {
            SpellAbility counter = this.chooseCounterSpell(AiController.getPlayableCounters(cards));
            if (counter != null) {
                return counter;
            }
            SpellAbility counterETB = this.chooseSpellAbilityToPlayFromList(this.getPossibleETBCounters(), false);
            if (counterETB != null) {
                return counterETB;
            }
        }
        if (saList.isEmpty()) {
            saList = ComputerUtilAbility.getSpellAbilities(cards, this.player);
        }
        Iterables.removeIf(saList, spellAbility -> spellAbility.isLandAbility() || spellAbility.getHostCard() != null && ComputerUtilCard.isCardRemAIDeck(spellAbility.getHostCard()));
        this.useLivingEnd = Iterables.any(this.player.getZone(ZoneType.Library), CardPredicates.nameEquals("Living End"));
        SpellAbility chosenSa = this.chooseSpellAbilityToPlayFromList(saList, true);
        if (topOwnedByAI && !mustRespond && chosenSa != ComputerUtilAbility.getFirstCopySASpell(saList)) {
            return null;
        }
        return chosenSa;
    }

    private SpellAbility chooseSpellAbilityToPlayFromList(List<SpellAbility> all, boolean skipCounter) {
        if (all == null || all.isEmpty()) {
            return null;
        }
        try {
            all.sort(ComputerUtilAbility.saEvaluator);
            ComputerUtilAbility.sortCreatureSpells(all);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            String assertex = ComparatorUtil.verifyTransitivity(ComputerUtilAbility.saEvaluator, all);
            Sentry.captureMessage(ex.getMessage() + "\nAssertionError [verifyTransitivity]: " + assertex);
        }
        boolean isLifeInDanger = this.useLivingEnd && ComputerUtil.aiLifeInDanger(this.player, true, 0);
        for (SpellAbility sa : ComputerUtilAbility.getOriginalAndAltCostAbilities(all, this.player)) {
            if (skipCounter && sa.getApi() == ApiType.Counter || sa.getHostCard().hasKeyword(Keyword.STORM) && sa.getApi() != ApiType.Counter && this.player.getZone(ZoneType.Hand).contains(Predicates.not(Predicates.or(CardPredicates.Presets.LANDS, CardPredicates.hasKeyword("Storm")))) && this.game.getView().getStormCount() < this.getIntProperty(AiProps.MIN_COUNT_FOR_STORM_SPELLS)) continue;
            AiPlayDecision aiPlayDecision = AiPlayDecision.CantPlaySa;
            if (this.useLivingEnd) {
                if (sa.isCycling() && sa.canCastTiming(this.player) && this.player.getCardsIn(ZoneType.Library).size() >= 10) {
                    if (ComputerUtilCost.canPayCost(sa, this.player, sa.isTrigger())) {
                        aiPlayDecision = sa.getPayCosts() != null && sa.getPayCosts().hasSpecificCostType(CostPayLife.class) && !this.player.cantLoseForZeroOrLessLife() && this.player.getLife() <= sa.getPayCosts().getCostPartByType(CostPayLife.class).getAbilityAmount(sa) * 2 ? AiPlayDecision.CantAfford : AiPlayDecision.WillPlay;
                    }
                } else if (sa.getHostCard().hasKeyword(Keyword.CASCADE)) {
                    if (isLifeInDanger) {
                        aiPlayDecision = this.player.getCreaturesInPlay().size() >= 4 ? AiPlayDecision.CantPlaySa : AiPlayDecision.WillPlay;
                    } else {
                        if (CardLists.filter((Iterable<Card>)this.player.getZone(ZoneType.Graveyard).getCards(), CardPredicates.Presets.CREATURES).size() <= 4 || this.player.getCreaturesInPlay().size() >= 4) continue;
                        if (!sa.getHostCard().isPermanent() && sa.canCastTiming(this.player) && ComputerUtilCost.canPayCost(sa, this.player, sa.isTrigger())) {
                            aiPlayDecision = AiPlayDecision.WillPlay;
                        }
                    }
                }
            }
            sa.setActivatingPlayer(this.player, true);
            SpellAbility root = sa.getRootAbility();
            if (root.isSpell() || root.isTrigger() || root.isReplacementAbility()) {
                sa.setLastStateBattlefield(this.game.getLastStateBattlefield());
                sa.setLastStateGraveyard(this.game.getLastStateGraveyard());
            }
            AiPlayDecision opinion = this.useLivingEnd && AiPlayDecision.WillPlay.equals((Object)aiPlayDecision) ? aiPlayDecision : this.canPlayAndPayFor(sa);
            sa.clearLastState();
            if (opinion != AiPlayDecision.WillPlay) continue;
            return sa;
        }
        return null;
    }

    public CardCollection chooseCardsToDelve(int genericCost, CardCollection grave) {
        CardCollection toExile = new CardCollection();
        int numToExile = Math.min(grave.size(), genericCost);
        for (int i = 0; i < numToExile; ++i) {
            Card chosen = null;
            for (Card c : grave) {
                if (c.isCreature()) continue;
                chosen = c;
                break;
            }
            if (chosen == null) {
                chosen = ComputerUtilCard.getWorstCreatureAI(grave);
            }
            if (chosen == null) {
                chosen = (Card)grave.get(false);
            }
            toExile.add(chosen);
            grave.remove(chosen);
        }
        return toExile;
    }

    public boolean doTrigger(SpellAbility spell, boolean mandatory) {
        if (spell instanceof WrappedAbility) {
            return this.doTrigger(((WrappedAbility)spell).getWrappedAbility(), mandatory);
        }
        if (spell.getApi() != null) {
            return SpellApiToAi.Converter.get(spell.getApi()).doTriggerAI(this.player, spell, mandatory);
        }
        return spell.getPayCosts() == Cost.Zero && !spell.usesTargeting();
    }

    public final boolean aiShouldRun(ReplacementEffect effect, SpellAbility sa, GameEntity affected) {
        Card hostCard = effect.getHostCard();
        if (hostCard.hasAlternateState()) {
            hostCard = this.game.getCardState(hostCard);
        }
        if (effect.hasParam("AILogic") && effect.getParam("AILogic").equalsIgnoreCase("ProtectFriendly")) {
            Player controller = hostCard.getController();
            if (affected instanceof Player) {
                return !((Player)affected).isOpponentOf(controller);
            }
            if (affected instanceof Card) {
                return !((Card)affected).getController().isOpponentOf(controller);
            }
        }
        if (effect.hasParam("AICheckSVar")) {
            System.out.println("aiShouldRun?" + sa);
            String svarToCheck = effect.getParam("AICheckSVar");
            String comparator = "GE";
            int compareTo = 1;
            if (effect.hasParam("AISVarCompare")) {
                String fullCmp = effect.getParam("AISVarCompare");
                comparator = fullCmp.substring(0, 2);
                String strCmpTo = fullCmp.substring(2);
                try {
                    compareTo = Integer.parseInt(strCmpTo);
                }
                catch (Exception ignored) {
                    compareTo = sa == null ? AbilityUtils.calculateAmount(hostCard, hostCard.getSVar(strCmpTo), effect) : AbilityUtils.calculateAmount(hostCard, hostCard.getSVar(strCmpTo), sa);
                }
            }
            int left = 0;
            left = sa == null ? AbilityUtils.calculateAmount(hostCard, svarToCheck, effect) : AbilityUtils.calculateAmount(hostCard, svarToCheck, sa);
            System.out.println("aiShouldRun?" + left + comparator + compareTo);
            return Expressions.compare(left, comparator, compareTo);
        }
        if (effect.hasParam("AICheckDredge")) {
            return this.player.getCardsIn(ZoneType.Library).size() > 8 || this.player.isCardInPlay("Laboratory Maniac");
        }
        return sa != null && this.doTrigger(sa, false);
    }

    public List<SpellAbility> chooseSaToActivateFromOpeningHand(List<SpellAbility> usableFromOpeningHand) {
        ArrayList<SpellAbility> result = Lists.newArrayList();
        for (SpellAbility sa : usableFromOpeningHand) {
            if (!this.doTrigger(sa, false)) continue;
            result.add(sa);
        }
        boolean hasLeyline1 = false;
        SpellAbility saGemstones = null;
        ArrayList<SpellAbility> toRemove = Lists.newArrayList();
        for (SpellAbility sa : result) {
            String srcName = sa.getHostCard().getName();
            if ("Gemstone Caverns".equals(srcName)) {
                if (saGemstones == null) {
                    saGemstones = sa;
                    continue;
                }
                toRemove.add(sa);
                continue;
            }
            if (!"Leyline of Singularity".equals(srcName)) continue;
            if (!hasLeyline1) {
                hasLeyline1 = true;
                continue;
            }
            toRemove.add(sa);
        }
        result.removeAll(toRemove);
        if (saGemstones != null) {
            result.remove(saGemstones);
            result.add(saGemstones);
        }
        return result;
    }

    public int chooseNumber(SpellAbility sa, String title, int min2, int max) {
        Card source = sa.getHostCard();
        String logic = sa.getParamOrDefault("AILogic", "Max");
        if ("GainLife".equals(logic)) {
            if (this.player.getLife() < 5 || this.player.getCardsIn(ZoneType.Hand).size() >= this.player.getMaxHandSize()) {
                return min2;
            }
        } else if ("LoseLife".equals(logic)) {
            if (this.player.getLife() > 5) {
                return min2;
            }
        } else {
            if ("Min".equals(logic)) {
                return min2;
            }
            if ("DigACard".equals(logic)) {
                int random = MyRandom.getRandom().nextInt(Math.min(4, max)) + 1;
                if (this.player.getLife() < random + 5) {
                    return min2;
                }
                return random;
            }
            if ("Damnation".equals(logic)) {
                int chosenMax = this.player.getLife() - 1;
                int cardsInPlay = this.player.getCardsIn(ZoneType.Battlefield).size();
                return Math.min(chosenMax, cardsInPlay);
            }
            if ("OptionalDraw".equals(logic)) {
                int cardsInLib = this.player.getCardsIn(ZoneType.Library).size();
                if (cardsInLib >= max && this.player.isCardInPlay("Laboratory Maniac")) {
                    return max;
                }
                int cardsInHand = this.player.getCardsIn(ZoneType.Hand).size();
                int maxDraw = Math.min(this.player.getMaxHandSize() + 2 - cardsInHand, max);
                int maxCheckLib = Math.min(maxDraw, cardsInLib);
                return Math.max(min2, maxCheckLib);
            }
            if ("RepeatDraw".equals(logic)) {
                int remaining = this.player.getMaxHandSize() - this.player.getCardsIn(ZoneType.Hand).size() + MyRandom.getRandom().nextInt(3);
                return Math.max(remaining, min2) / 2;
            }
            if ("LowestLoseLife".equals(logic)) {
                return MyRandom.getRandom().nextInt(Math.min(this.player.getLife() / 3, this.player.getWeakestOpponent().getLife())) + 1;
            }
            if ("HighestLoseLife".equals(logic)) {
                return Math.min(this.player.getLife() - 1, MyRandom.getRandom().nextInt(Math.max(this.player.getLife() / 3, this.player.getWeakestOpponent().getLife())) + 1);
            }
            if ("HighestGetCounter".equals(logic)) {
                return MyRandom.getRandom().nextInt(3);
            }
            if (sa.hasSVar("EnergyToPay")) {
                return AbilityUtils.calculateAmount(source, sa.getSVar("EnergyToPay"), sa);
            }
            if ("Vermin".equals(logic)) {
                if (this.player.getLife() < 5) {
                    return min2;
                }
                return MyRandom.getRandom().nextInt(Math.max(this.player.getLife() - 5, 1));
            }
            if ("SweepCreatures".equals(logic)) {
                int minAllowedChoice = AbilityUtils.calculateAmount(source, sa.getParam("Min"), sa);
                int choiceLimit = AbilityUtils.calculateAmount(source, sa.getParam("Max"), sa);
                int maxCreatures = 0;
                for (Player opp : this.player.getOpponents()) {
                    maxCreatures = Math.max(maxCreatures, opp.getCreaturesInPlay().size());
                }
                return Math.min(choiceLimit, Math.max(minAllowedChoice, maxCreatures));
            }
            if ("Random".equals(logic)) {
                return MyRandom.getRandom().nextInt(max - min2 + 1) + min2;
            }
        }
        return max;
    }

    public int chooseNumber(SpellAbility sa, String title, List<Integer> options, Player relatedPlayer) {
        switch (sa.getApi()) {
            case SetLife: {
                if (relatedPlayer.equals(sa.getHostCard().getController())) {
                    return Collections.max(options);
                }
                if (relatedPlayer.isOpponentOf(sa.getHostCard().getController())) {
                    return Collections.min(options);
                }
                return options.get(0);
            }
            case ChooseNumber: {
                if (sa.getHostCard().getName().equals("Emissary's Ploy")) {
                    ArrayList<Integer> counter = Lists.newArrayList(0, 0, 0);
                    int max = 0;
                    int slot = 0;
                    for (Card c : relatedPlayer.getZone(ZoneType.Library).getCards()) {
                        if (!c.isCreature() || c.getCMC() <= 0 || c.getCMC() >= 4) continue;
                        counter.set(c.getCMC() - 1, (Integer)counter.get(c.getCMC() - 1) + 1);
                    }
                    for (int i = 0; i < counter.size(); ++i) {
                        if ((Integer)counter.get(i) < max) continue;
                        max = (Integer)counter.get(i);
                        slot = i;
                    }
                    return slot;
                }
                return Aggregates.random(options);
            }
        }
        return options.get(0);
    }

    public boolean confirmPayment(CostPart costPart) {
        throw new UnsupportedOperationException("AI is not supposed to reach this code at the moment");
    }

    public int attemptToAssist(SpellAbility sa, int max, int request) {
        Player activator = sa.getActivatingPlayer();
        if (this.game.getPlayers().size() == 2) {
            return 0;
        }
        PlayerCollection allies = this.player.getAllies();
        if (allies.isEmpty()) {
            return 0;
        }
        if (!allies.contains(activator)) {
            return 0;
        }
        int mana = ComputerUtilMana.getAvailableManaEstimate(this.player, true);
        if (MyRandom.percentTrue(80)) {
            return 0;
        }
        boolean willingToPay = false;
        if (mana >= request) {
            return request;
        }
        return mana;
    }

    public CardCollection chooseCardsForEffect(CardCollectionView pool, SpellAbility sa, int min2, int max, boolean isOptional, Map<String, Object> params) {
        if (sa == null || sa.getApi() == null) {
            throw new UnsupportedOperationException();
        }
        CardCollection result = new CardCollection();
        if (sa.hasParam("AIMaxAmount")) {
            max = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("AIMaxAmount"), sa);
        }
        block0 : switch (sa.getApi()) {
            case TwoPiles: {
                Card biggest = null;
                Card smallest = null;
                biggest = (Card)pool.get(false);
                smallest = (Card)pool.get(false);
                for (Card c : pool) {
                    if (c.getCMC() >= biggest.getCMC()) {
                        biggest = c;
                        continue;
                    }
                    if (c.getCMC() > smallest.getCMC()) continue;
                    smallest = c;
                }
                result.add(biggest);
                if (max <= 3 || result.contains(smallest)) break;
                result.add(smallest);
                break;
            }
            case MultiplePiles: {
                result.addAll(pool);
                break;
            }
            case FlipOntoBattlefield: {
                if ("DamageCreatures".equals(sa.getParam("AILogic"))) {
                    int maxToughness = Integer.parseInt(sa.getSubAbility().getParam("NumDmg"));
                    CardCollection rightToughness = CardLists.filter((Iterable<Card>)pool, card -> card.getController().isOpponentOf(sa.getActivatingPlayer()) && card.getNetToughness() <= maxToughness && card.canBeDestroyed());
                    Card bestCreature = ComputerUtilCard.getBestCreatureAI(rightToughness.isEmpty() ? pool : rightToughness);
                    if (bestCreature != null) {
                        result.add(bestCreature);
                        break;
                    }
                } else {
                    CardCollection viableOptions = CardLists.filter(pool, CardPredicates.isControlledByAnyOf(sa.getActivatingPlayer().getOpponents()), CardPredicates.Presets.CAN_BE_DESTROYED);
                    Card best = ComputerUtilCard.getBestAI(viableOptions);
                    if (best != null) {
                        result.add(best);
                        break;
                    }
                }
                result.add(Aggregates.random(pool));
                break;
            }
            default: {
                Card c;
                CardCollection editablePool = new CardCollection(pool);
                for (int i = 0; i < max && (c = this.player.getController().chooseSingleEntityForEffect(editablePool, sa, null, isOptional, params)) != null; ++i) {
                    result.add(c);
                    editablePool.remove(c);
                    if (!"BowToMyCommand".equals(sa.getParam("AILogic"))) continue;
                    if (!sa.getHostCard().isInZone(ZoneType.Command)) {
                        result.clear();
                        break block0;
                    }
                    int totPower = 0;
                    for (Card p : result) {
                        totPower += p.getNetPower();
                    }
                    if (totPower >= 8) break block0;
                }
            }
        }
        if ("Phyrexian Dreadnought".equals(ComputerUtilAbility.getAbilitySourceName(sa))) {
            result = SpecialCardAi.PhyrexianDreadnought.reviseCreatureSacList(this.player, sa, result);
        }
        return result;
    }

    public Map<DeckSection, List<? extends PaperCard>> complainCardsCantPlayWell(Deck myDeck) {
        Map<DeckSection, List<? extends PaperCard>> complaints = new HashMap<DeckSection, List<? extends PaperCard>>();
        if (!this.useSimulation) {
            complaints = myDeck.getUnplayableAICards().unplayable;
        }
        return complaints;
    }

    public CardCollectionView cheatShuffle(CardCollectionView in) {
        if (in.size() < 20 || !this.canCheatShuffle()) {
            return in;
        }
        CardCollection library = new CardCollection(in);
        CardLists.shuffle(library);
        CardCollection land = CardLists.filter((Iterable<Card>)library, CardPredicates.Presets.LANDS);
        for (Card c : land) {
            if (!c.isLand()) continue;
            library.remove(c);
        }
        try {
            library.add(5, (Card)land.get(false));
            library.add(6, (Card)land.get(true));
            library.add(8, (Card)land.get(2));
            library.add(9, (Card)land.get(3));
            library.add(10, (Card)land.get(4));
            library.add(12, (Card)land.get(5));
            library.add(15, (Card)land.get(6));
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Error: cannot smooth mana curve, not enough land");
            return in;
        }
        for (Card card : land) {
            if (library.contains(card)) continue;
            library.add(card);
        }
        return library;
    }

    public boolean chooseDirection(SpellAbility sa) {
        CardCollection right;
        CardCollection left;
        if (sa == null || sa.getApi() == null) {
            throw new UnsupportedOperationException();
        }
        if ("GainControl".equals(sa.getParam("AILogic")) && this.game.getPlayers().size() > 2) {
            CardCollection creats = CardLists.getType(this.game.getCardsIn(ZoneType.Battlefield), "Creature");
            left = CardLists.filterControlledBy((Iterable<Card>)creats, this.game.getNextPlayerAfter(this.player, Direction.Left));
            right = CardLists.filterControlledBy((Iterable<Card>)creats, this.game.getNextPlayerAfter(this.player, Direction.Right));
            if (!left.isEmpty() || !right.isEmpty()) {
                CardCollection all = new CardCollection(left);
                all.addAll(right);
                return left.contains(ComputerUtilCard.getBestCreatureAI(all));
            }
        }
        if ("Aminatou".equals(sa.getParam("AILogic")) && this.game.getPlayers().size() > 2) {
            CardCollection all = CardLists.filter((Iterable<Card>)this.game.getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.NONLAND_PERMANENTS);
            left = CardLists.filterControlledBy((Iterable<Card>)all, this.game.getNextPlayerAfter(this.player, Direction.Left));
            right = CardLists.filterControlledBy((Iterable<Card>)all, this.game.getNextPlayerAfter(this.player, Direction.Right));
            return Aggregates.sum(left, Card::getCMC) > Aggregates.sum(right, Card::getCMC);
        }
        return MyRandom.getRandom().nextBoolean();
    }

    public boolean chooseEvenOdd(SpellAbility sa) {
        String aiLogic = sa.getParamOrDefault("AILogic", "");
        if (aiLogic.equals("AlwaysEven")) {
            return false;
        }
        if (aiLogic.equals("AlwaysOdd")) {
            return true;
        }
        if (aiLogic.equals("Random")) {
            return MyRandom.getRandom().nextBoolean();
        }
        if (aiLogic.equals("CMCInHand")) {
            CardCollectionView hand = sa.getActivatingPlayer().getCardsIn(ZoneType.Hand);
            int numEven = CardLists.filter((Iterable<Card>)hand, CardPredicates.evenCMC()).size();
            int numOdd = CardLists.filter((Iterable<Card>)hand, CardPredicates.oddCMC()).size();
            return numOdd > numEven;
        }
        if (aiLogic.equals("CMCOppControls")) {
            CardCollection hand = sa.getActivatingPlayer().getOpponents().getCardsIn(ZoneType.Battlefield);
            int numEven = CardLists.filter((Iterable<Card>)hand, CardPredicates.evenCMC()).size();
            int numOdd = CardLists.filter((Iterable<Card>)hand, CardPredicates.oddCMC()).size();
            return numOdd > numEven;
        }
        if (aiLogic.equals("CMCOppControlsByPower")) {
            CardCollection hand = sa.getActivatingPlayer().getOpponents().getCardsIn(ZoneType.Battlefield);
            int powerEven = Aggregates.sum(CardLists.filter((Iterable<Card>)hand, CardPredicates.evenCMC()), Card::getNetPower);
            int powerOdd = Aggregates.sum(CardLists.filter((Iterable<Card>)hand, CardPredicates.oddCMC()), Card::getNetPower);
            return powerOdd > powerEven;
        }
        return MyRandom.getRandom().nextBoolean();
    }

    public Card chooseCardToHiddenOriginChangeZone(ZoneType destination, List<ZoneType> origin, SpellAbility sa, CardCollection fetchList, Player player2, Player decider) {
        if (this.useSimulation) {
            return this.simPicker.chooseCardToHiddenOriginChangeZone(destination, origin, sa, fetchList, player2, decider);
        }
        if (sa.getApi() == ApiType.Learn) {
            return LearnAi.chooseCardToLearn(fetchList, decider, sa);
        }
        return ChangeZoneAi.chooseCardToHiddenOriginChangeZone(destination, origin, sa, fetchList, player2, decider);
    }

    public List<SpellAbility> orderPlaySa(List<SpellAbility> activePlayerSAs) {
        if (activePlayerSAs.size() < 2) {
            return activePlayerSAs;
        }
        ArrayList<SpellAbility> result = Lists.newArrayList();
        List<SpellAbility> discard = AiController.filterListByApi(activePlayerSAs, ApiType.Discard);
        List<SpellAbility> mandatoryDiscard = AiController.filterList(discard, SpellAbilityPredicates.isMandatory());
        List<SpellAbility> draw = AiController.filterListByApi(activePlayerSAs, ApiType.Draw);
        List<SpellAbility> putCounter = AiController.filterListByApi(activePlayerSAs, ApiType.PutCounter);
        List<SpellAbility> putCounterAll = AiController.filterListByApi(activePlayerSAs, ApiType.PutCounterAll);
        List<CardTraitBase> evolve = AiController.filterList(putCounter, CardTraitPredicates.isKeyword(Keyword.EVOLVE));
        List<SpellAbility> token = AiController.filterListByApi(activePlayerSAs, ApiType.Token);
        List<SpellAbility> pump = AiController.filterListByApi(activePlayerSAs, ApiType.Pump);
        List<SpellAbility> pumpAll = AiController.filterListByApi(activePlayerSAs, ApiType.PumpAll);
        boolean discardEarly = false;
        CardCollectionView playerHand = this.player.getCardsIn(ZoneType.Hand);
        if (playerHand.isEmpty() || Iterables.any(playerHand, CardPredicates.hasSVar("DiscardMe"))) {
            discardEarly = true;
            result.addAll(mandatoryDiscard);
        }
        result.addAll(token);
        result.addAll(pump);
        result.addAll(pumpAll);
        result.addAll(evolve);
        result.addAll(putCounter);
        result.addAll(putCounterAll);
        result.addAll(draw);
        result.addAll(discard);
        if (!discardEarly) {
            result.addAll(mandatoryDiscard);
        }
        result.addAll(activePlayerSAs);
        Collections.reverse(result);
        return result;
    }

    private static <T> List<T> filterList(List<T> input, Predicate<? super T> pred) {
        ArrayList<? super T> filtered = Lists.newArrayList(Iterables.filter(input, pred));
        input.removeAll(filtered);
        return filtered;
    }

    public static List<SpellAbility> filterListByApi(List<SpellAbility> input, ApiType type) {
        return AiController.filterList(input, SpellAbilityPredicates.isApi(type));
    }

    private <T extends CardTraitBase> List<T> filterListByAiLogic(List<T> list, String logic) {
        return AiController.filterList(list, CardTraitPredicates.hasParam("AILogic", logic));
    }

    public List<AbilitySub> chooseModeForAbility(SpellAbility sa, List<AbilitySub> possible, int min2, int num, boolean allowRepeat) {
        if (this.simPicker != null) {
            return this.simPicker.chooseModeForAbility(sa, possible, min2, num, allowRepeat);
        }
        return null;
    }

    public CardCollectionView chooseSacrificeType(String type, SpellAbility ability, boolean effect, int amount, CardCollectionView exclude) {
        if (this.simPicker != null) {
            return this.simPicker.chooseSacrificeType(type, ability, effect, amount, exclude);
        }
        return ComputerUtil.chooseSacrificeType(this.player, type, ability, ability.getTargetCard(), effect, amount, exclude);
    }

    private boolean checkAiSpecificRestrictions(SpellAbility sa) {
        if (sa.hasParam("AILifeThreshold")) {
            return this.player.getLife() > Integer.parseInt(sa.getParam("AILifeThreshold"));
        }
        return true;
    }

    public ReplacementEffect chooseSingleReplacementEffect(List<ReplacementEffect> list) {
        if (list.size() <= 1) {
            return Iterables.getFirst(list, null);
        }
        ReplacementType mode = ((ReplacementEffect)Iterables.getFirst(list, null)).getMode();
        if (mode.equals((Object)ReplacementType.GainLife)) {
            List<ReplacementEffect> noGain = this.filterListByAiLogic(list, "NoLife");
            List<ReplacementEffect> loseLife = this.filterListByAiLogic(list, "LoseLife");
            List<ReplacementEffect> doubleLife = this.filterListByAiLogic(list, "DoubleLife");
            List<ReplacementEffect> lichDraw = this.filterListByAiLogic(list, "LichDraw");
            if (!noGain.isEmpty()) {
                return Iterables.getFirst(noGain, null);
            }
            if (!loseLife.isEmpty()) {
                return Iterables.getFirst(loseLife, null);
            }
            if (!lichDraw.isEmpty()) {
                return Iterables.getFirst(lichDraw, null);
            }
            if (!doubleLife.isEmpty()) {
                return Iterables.getFirst(doubleLife, null);
            }
        } else if (mode.equals((Object)ReplacementType.DamageDone)) {
            List<CardTraitBase> prevention = AiController.filterList(list, CardTraitPredicates.hasParam("Prevent"));
            if (!prevention.isEmpty()) {
                return Iterables.getFirst(prevention, null);
            }
        } else if (mode.equals((Object)ReplacementType.Destroy)) {
            List<CardTraitBase> shield = AiController.filterList(list, CardTraitPredicates.hasParam("ShieldCounter"));
            List<CardTraitBase> regeneration = AiController.filterList(list, CardTraitPredicates.hasParam("Regeneration"));
            List<CardTraitBase> umbraArmor = AiController.filterList(list, CardTraitPredicates.isKeyword(Keyword.UMBRA_ARMOR));
            List<CardTraitBase> umbraArmorIndestructible = AiController.filterList(umbraArmor, Predicates.compose(CardPredicates.hasKeyword(Keyword.INDESTRUCTIBLE), CardTraitBase::getHostCard));
            if (!umbraArmorIndestructible.isEmpty()) {
                return Iterables.getFirst(umbraArmorIndestructible, null);
            }
            if (!shield.isEmpty()) {
                return Iterables.getFirst(shield, null);
            }
            if (!regeneration.isEmpty()) {
                return Iterables.getFirst(regeneration, null);
            }
            if (!umbraArmor.isEmpty()) {
                umbraArmor.sort(Comparator.comparing(CardTraitBase::getHostCard, Comparator.comparing(Card::getCMC)));
                return Iterables.getFirst(umbraArmor, null);
            }
        }
        return Iterables.getFirst(list, null);
    }
}

