/*
 * Decompiled with CFR 0.152.
 */
package forge.ai;

import forge.card.CardRules;
import forge.card.CardType;
import forge.deck.CardPool;
import forge.deck.Deck;
import forge.deck.DeckSection;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.item.IPaperCard;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AIDeckStatistics {
    public float averageCMC = 0.0f;
    public float stddevCMC = 0.0f;
    public int maxCost = 0;
    public int maxColoredCost = 0;
    public int[] maxPips = null;
    public int numLands = 0;

    public AIDeckStatistics(float averageCMC, float stddevCMC, int maxCost, int maxColoredCost, int[] maxPips, int numLands) {
        this.averageCMC = averageCMC;
        this.stddevCMC = stddevCMC;
        this.maxCost = maxCost;
        this.maxColoredCost = maxColoredCost;
        this.maxPips = maxPips;
        this.numLands = numLands;
    }

    public static AIDeckStatistics fromCards(List<Card> cards) {
        int totalCMC = 0;
        int totalCount = 0;
        int numLands = 0;
        int maxCost = 0;
        int[] maxPips = new int[6];
        int maxColoredCost = 0;
        for (Card c : cards) {
            CardRules rules = c.getRules();
            if (rules == null) {
                System.err.println(c + " CardRules is null" + (c.isToken() ? "/token" : "."));
                continue;
            }
            CardType type = rules.getType();
            if (type.isLand()) {
                ++numLands;
                continue;
            }
            int cost = rules.getManaCost().getCMC();
            maxCost = Math.max(maxCost, cost);
            totalCMC += cost;
            ++totalCount;
            int[] pips = rules.getManaCost().getColorShardCounts();
            int colored_pips = 0;
            for (int i = 0; i < pips.length; ++i) {
                maxPips[i] = Math.max(maxPips[i], pips[i]);
                if (i >= 5) continue;
                colored_pips += pips[i];
            }
            maxColoredCost = Math.max(maxColoredCost, colored_pips);
        }
        return new AIDeckStatistics(totalCount == 0 ? 0.0f : (float)totalCMC / (float)totalCount, 0.0f, maxCost, maxColoredCost, maxPips, numLands);
    }

    public static AIDeckStatistics fromDeck(Deck deck, Player player) {
        ArrayList<Card> cardlist = new ArrayList<Card>();
        block3: for (Map.Entry<DeckSection, CardPool> deckEntry : deck) {
            switch (deckEntry.getKey()) {
                case Main: 
                case Commander: {
                    for (Map.Entry poolEntry : deckEntry.getValue()) {
                        Card card = Card.fromPaperCard((IPaperCard)poolEntry.getKey(), player);
                        cardlist.add(card);
                    }
                    continue block3;
                }
            }
        }
        return AIDeckStatistics.fromCards(cardlist);
    }

    public static AIDeckStatistics fromPlayer(Player player) {
        Deck deck = player.getRegisteredPlayer().getDeck();
        if (deck.isEmpty()) {
            ArrayList<Card> cardlist = new ArrayList<Card>();
            for (Card c : player.getAllCards()) {
                if (c.getPaperCard() == null) continue;
                cardlist.add(c);
            }
            return AIDeckStatistics.fromCards(cardlist);
        }
        return AIDeckStatistics.fromDeck(deck, player);
    }
}

