/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.google.common.base.Predicate;
import forge.CardStorageReader;
import forge.ImageKeys;
import forge.MulliganDefs;
import forge.card.CardDb;
import forge.card.CardEdition;
import forge.card.CardRules;
import forge.card.PrintSheet;
import forge.item.BoosterBox;
import forge.item.FatPack;
import forge.item.PaperCard;
import forge.item.PaperToken;
import forge.item.SealedTemplate;
import forge.token.TokenDb;
import forge.util.FileUtil;
import forge.util.ImageUtil;
import forge.util.TextUtil;
import forge.util.storage.IStorage;
import forge.util.storage.StorageBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;

public class StaticData {
    private final CardStorageReader cardReader;
    private final CardStorageReader tokenReader;
    private final CardStorageReader customCardReader;
    private final String blockDataFolder;
    private final CardDb commonCards;
    private final CardDb variantCards;
    private final TokenDb allTokens;
    private final CardEdition.Collection editions;
    private Predicate<PaperCard> standardPredicate;
    private Predicate<PaperCard> brawlPredicate;
    private Predicate<PaperCard> pioneerPredicate;
    private Predicate<PaperCard> modernPredicate;
    private Predicate<PaperCard> commanderPredicate;
    private Predicate<PaperCard> oathbreakerPredicate;
    private boolean filteredHandsEnabled = false;
    private MulliganDefs.MulliganRule mulliganRule = MulliganDefs.getDefaultRule();
    private boolean allowCustomCardsInDecksConformance;
    private boolean enableSmartCardArtSelection;
    private boolean loadNonLegalCards;
    private boolean sourceImageForClone;
    private IStorage<SealedTemplate> boosters;
    private IStorage<SealedTemplate> specialBoosters;
    private IStorage<SealedTemplate> tournaments;
    private IStorage<FatPack.Template> fatPacks;
    private IStorage<BoosterBox.Template> boosterBoxes;
    private IStorage<PrintSheet> printSheets;
    private final Map<String, List<String>> setLookup = new HashMap<String, List<String>>();
    private List<String> blocksLandCodes = new ArrayList<String>();
    private static StaticData lastInstance = null;
    private List<CardEdition> sortedEditions;
    private TreeMap<CardEdition.Type, List<CardEdition>> editionsTypeMap;

    public StaticData(CardStorageReader cardReader, CardStorageReader customCardReader, String editionFolder, String customEditionsFolder, String blockDataFolder, String cardArtPreference, boolean enableUnknownCards, boolean loadNonLegalCards) {
        this(cardReader, null, customCardReader, null, editionFolder, customEditionsFolder, blockDataFolder, "", cardArtPreference, enableUnknownCards, loadNonLegalCards, false, false);
    }

    public StaticData(CardStorageReader cardReader, CardStorageReader tokenReader, CardStorageReader customCardReader, CardStorageReader customTokenReader, String editionFolder, String customEditionsFolder, String blockDataFolder, String setLookupFolder, String cardArtPreference, boolean enableUnknownCards, boolean loadNonLegalCards, boolean allowCustomCardsInDecksConformance) {
        this(cardReader, tokenReader, customCardReader, customTokenReader, editionFolder, customEditionsFolder, blockDataFolder, setLookupFolder, cardArtPreference, enableUnknownCards, loadNonLegalCards, allowCustomCardsInDecksConformance, false);
    }

    public StaticData(CardStorageReader cardReader, CardStorageReader tokenReader, CardStorageReader customCardReader, CardStorageReader customTokenReader, String editionFolder, String customEditionsFolder, String blockDataFolder, String setLookupFolder, String cardArtPreference, boolean enableUnknownCards, boolean loadNonLegalCards, boolean allowCustomCardsInDecksConformance, boolean enableSmartCardArtSelection) {
        String cardName;
        this.cardReader = cardReader;
        this.tokenReader = tokenReader;
        this.editions = new CardEdition.Collection(new CardEdition.Reader(new File(editionFolder)));
        this.blockDataFolder = blockDataFolder;
        this.customCardReader = customCardReader;
        this.allowCustomCardsInDecksConformance = allowCustomCardsInDecksConformance;
        this.enableSmartCardArtSelection = enableSmartCardArtSelection;
        this.loadNonLegalCards = loadNonLegalCards;
        lastInstance = this;
        ArrayList<String> funnyCards = new ArrayList<String>();
        ArrayList<String> filtered = new ArrayList<String>();
        this.editions.append(new CardEdition.Collection(new CardEdition.Reader(new File(customEditionsFolder), true)));
        TreeMap<String, CardRules> regularCards = new TreeMap<String, CardRules>(String.CASE_INSENSITIVE_ORDER);
        TreeMap<String, CardRules> variantsCards = new TreeMap<String, CardRules>(String.CASE_INSENSITIVE_ORDER);
        if (!loadNonLegalCards) {
            for (CardEdition e : this.editions) {
                if (e.getType() != CardEdition.Type.FUNNY && e.getBorderColor() != CardEdition.BorderColor.SILVER) continue;
                List<CardEdition.CardInSet> eternalCards = e.getFunnyEternalCards();
                for (CardEdition.CardInSet cis : e.getAllCardsInSet()) {
                    if (eternalCards.contains(cis)) continue;
                    funnyCards.add(cis.name);
                }
            }
        }
        for (CardRules card : cardReader.loadCards()) {
            if (null == card) continue;
            cardName = card.getName();
            if (!loadNonLegalCards && !card.getType().isLand() && funnyCards.contains(cardName)) {
                filtered.add(cardName);
            }
            if (card.isVariant()) {
                variantsCards.put(cardName, card);
                continue;
            }
            regularCards.put(cardName, card);
        }
        if (customCardReader != null) {
            for (CardRules card : customCardReader.loadCards()) {
                if (null == card) continue;
                cardName = card.getName();
                card.setCustom();
                if (card.isVariant()) {
                    variantsCards.put(cardName, card);
                    continue;
                }
                regularCards.put(cardName, card);
            }
        }
        if (!filtered.isEmpty()) {
            Collections.sort(filtered);
        }
        this.commonCards = new CardDb(regularCards, this.editions, filtered, cardArtPreference);
        this.variantCards = new CardDb(variantsCards, this.editions, filtered, cardArtPreference);
        this.commonCards.initialize(false, false, enableUnknownCards);
        this.variantCards.initialize(false, false, enableUnknownCards);
        if (this.tokenReader != null) {
            TreeMap<String, CardRules> tokens = new TreeMap<String, CardRules>(String.CASE_INSENSITIVE_ORDER);
            for (CardRules card : this.tokenReader.loadCards()) {
                if (null == card) continue;
                tokens.put(card.getNormalizedName(), card);
            }
            if (customTokenReader != null) {
                for (CardRules card : customTokenReader.loadCards()) {
                    if (null == card) continue;
                    card.setCustom();
                    tokens.put(card.getNormalizedName(), card);
                }
            }
            this.allTokens = new TokenDb(tokens, this.editions);
        } else {
            this.allTokens = null;
        }
        if (FileUtil.isDirectoryWithFiles(setLookupFolder)) {
            for (File f : Objects.requireNonNull(new File(setLookupFolder).listFiles())) {
                if (!f.isFile()) continue;
                this.setLookup.put(f.getName().replace(".txt", ""), FileUtil.readFile(f));
            }
        }
    }

    public static StaticData instance() {
        return lastInstance;
    }

    public Map<String, List<String>> getSetLookup() {
        return this.setLookup;
    }

    public final CardEdition.Collection getEditions() {
        return this.editions;
    }

    public final List<CardEdition> getSortedEditions() {
        if (this.sortedEditions == null) {
            this.sortedEditions = new ArrayList<CardEdition>();
            for (CardEdition set : this.editions) {
                this.sortedEditions.add(set);
            }
            Collections.sort(this.sortedEditions);
            Collections.reverse(this.sortedEditions);
        }
        return this.sortedEditions;
    }

    public final Map<CardEdition.Type, List<CardEdition>> getEditionsTypeMap() {
        if (this.editionsTypeMap == null) {
            this.editionsTypeMap = new TreeMap();
            for (CardEdition.Type editionType : CardEdition.Type.values()) {
                this.editionsTypeMap.put(editionType, new ArrayList());
            }
            for (CardEdition edition : this.getSortedEditions()) {
                CardEdition.Type key = edition.getType();
                List<CardEdition> editionsOfType = this.editionsTypeMap.get((Object)key);
                editionsOfType.add(edition);
            }
        }
        return this.editionsTypeMap;
    }

    public CardEdition getCardEdition(String setCode) {
        CardEdition edition = this.editions.get(setCode);
        return edition;
    }

    public PaperCard getOrLoadCommonCard(String cardName, String setCode, int artIndex, boolean foil) {
        PaperCard card = this.commonCards.getCard(cardName, setCode, artIndex);
        if (card == null) {
            this.attemptToLoadCard(cardName, setCode);
            card = this.commonCards.getCard(cardName, setCode, artIndex);
        }
        if (card == null) {
            card = this.commonCards.getCard(cardName, setCode);
        }
        if (card == null) {
            return null;
        }
        return foil ? card.getFoiled() : card;
    }

    public void attemptToLoadCard(String cardName) {
        this.attemptToLoadCard(cardName, null);
    }

    public void attemptToLoadCard(String cardName, String setCode) {
        CardRules rules = this.cardReader.attemptToLoadCard(cardName);
        if (rules != null) {
            if (rules.isVariant()) {
                this.variantCards.loadCard(cardName, setCode, rules);
            } else {
                this.commonCards.loadCard(cardName, setCode, rules);
            }
        }
    }

    public PaperCard fetchCard(String cardName, String setCode, String collectorNumber) {
        CardDb db;
        PaperCard card = null;
        Iterator<CardDb> iterator = this.getAvailableDatabases().values().iterator();
        while (iterator.hasNext() && (card = (db = iterator.next()).getCard(cardName, setCode, collectorNumber)) == null) {
        }
        return card;
    }

    public PaperCard getCardFromSet(String cardName, CardEdition edition, String collectorNumber, int artIndex, boolean isFoil) {
        CardDb.CardRequest cr = CardDb.CardRequest.fromString(cardName);
        cr.isFoil = cr.isFoil || isFoil;
        CardDb targetDb = this.matchTargetCardDb(cr.cardName);
        if (targetDb == null) {
            return null;
        }
        PaperCard result = targetDb.getCardFromSet(cardName, edition, collectorNumber, cr.isFoil);
        if (result == null && !collectorNumber.equals("N.A.")) {
            int maxArtForCard;
            if (artIndex != -1 && artIndex <= (maxArtForCard = targetDb.getMaxArtIndex(cardName))) {
                result = targetDb.getCardFromSet(cardName, edition, artIndex, cr.isFoil);
            }
            if (result == null) {
                result = targetDb.getCardFromSet(cardName, edition, cr.isFoil);
            }
        }
        return result;
    }

    public PaperCard getCardFromSupportedEditions(String cardName, boolean isFoil, CardDb.CardArtPreference artPreference, List<String> allowedSetCodes, Date releasedBefore) {
        PaperCard result;
        CardDb.CardRequest cr = CardDb.CardRequest.fromString(cardName);
        isFoil = cr.isFoil || isFoil;
        CardDb targetDb = this.matchTargetCardDb(cr.cardName);
        if (targetDb == null) {
            return null;
        }
        Predicate<PaperCard> filter = null;
        if (allowedSetCodes != null) {
            filter = targetDb.isLegal(allowedSetCodes);
        }
        String cardRequest = CardDb.CardRequest.compose(cardName, isFoil);
        if (releasedBefore != null) {
            result = targetDb.getCardFromEditionsReleasedBefore(cardRequest, artPreference, releasedBefore, filter);
            if (result == null) {
                result = targetDb.getCardFromEditions(cardRequest, artPreference, filter);
            }
        } else {
            result = targetDb.getCardFromEditions(cardRequest, artPreference, filter);
        }
        return result;
    }

    private CardDb matchTargetCardDb(String cardName) {
        for (CardDb targetDb : this.getAvailableDatabases().values()) {
            if (!targetDb.contains(cardName)) continue;
            return targetDb;
        }
        return null;
    }

    public boolean isMTGCard(String cardName) {
        if (cardName == null || cardName.trim().length() == 0) {
            return false;
        }
        CardDb.CardRequest cr = CardDb.CardRequest.fromString(cardName);
        return this.commonCards.contains(cr.cardName) || this.variantCards.contains(cr.cardName);
    }

    public final IStorage<SealedTemplate> getTournamentPacks() {
        if (this.tournaments == null) {
            this.tournaments = new StorageBase<SealedTemplate>("Starter sets", new SealedTemplate.Reader(new File(this.blockDataFolder, "starters.txt")));
        }
        return this.tournaments;
    }

    public final IStorage<SealedTemplate> getBoosters() {
        if (this.boosters == null) {
            this.boosters = new StorageBase<SealedTemplate>("Boosters", this.editions.getBoosterGenerator());
        }
        return this.boosters;
    }

    public final IStorage<SealedTemplate> getSpecialBoosters() {
        if (this.specialBoosters == null) {
            this.specialBoosters = new StorageBase<SealedTemplate>("Special boosters", new SealedTemplate.Reader(new File(this.blockDataFolder, "boosters-special.txt")));
        }
        return this.specialBoosters;
    }

    public IStorage<PrintSheet> getPrintSheets() {
        if (this.printSheets == null) {
            this.printSheets = PrintSheet.initializePrintSheets(new File(this.blockDataFolder, "printsheets.txt"), this.getEditions());
        }
        return this.printSheets;
    }

    public CardDb getCommonCards() {
        return this.commonCards;
    }

    public CardDb getVariantCards() {
        return this.variantCards;
    }

    public Map<String, CardDb> getAvailableDatabases() {
        LinkedHashMap<String, CardDb> databases = new LinkedHashMap<String, CardDb>();
        databases.put("Common", this.commonCards);
        databases.put("Variant", this.variantCards);
        return databases;
    }

    public List<String> getBlockLands() {
        return this.blocksLandCodes;
    }

    public TokenDb getAllTokens() {
        return this.allTokens;
    }

    public boolean allowCustomCardsInDecksConformance() {
        return this.allowCustomCardsInDecksConformance;
    }

    public void setStandardPredicate(Predicate<PaperCard> standardPredicate) {
        this.standardPredicate = standardPredicate;
    }

    public void setPioneerPredicate(Predicate<PaperCard> pioneerPredicate) {
        this.pioneerPredicate = pioneerPredicate;
    }

    public void setModernPredicate(Predicate<PaperCard> modernPredicate) {
        this.modernPredicate = modernPredicate;
    }

    public void setCommanderPredicate(Predicate<PaperCard> commanderPredicate) {
        this.commanderPredicate = commanderPredicate;
    }

    public void setOathbreakerPredicate(Predicate<PaperCard> oathbreakerPredicate) {
        this.oathbreakerPredicate = oathbreakerPredicate;
    }

    public void setBrawlPredicate(Predicate<PaperCard> brawlPredicate) {
        this.brawlPredicate = brawlPredicate;
    }

    public Predicate<PaperCard> getStandardPredicate() {
        return this.standardPredicate;
    }

    public Predicate<PaperCard> getPioneerPredicate() {
        return this.pioneerPredicate;
    }

    public Predicate<PaperCard> getModernPredicate() {
        return this.modernPredicate;
    }

    public Predicate<PaperCard> getCommanderPredicate() {
        return this.commanderPredicate;
    }

    public Predicate<PaperCard> getOathbreakerPredicate() {
        return this.oathbreakerPredicate;
    }

    public Predicate<PaperCard> getBrawlPredicate() {
        return this.brawlPredicate;
    }

    public PaperCard getAlternativeCardPrint(PaperCard card, Date setReleaseDate) {
        boolean isCardArtPreferenceLatestArt = this.cardArtPreferenceIsLatest();
        boolean cardArtPreferenceHasFilter = this.isCoreExpansionOnlyFilterSet();
        return this.getAlternativeCardPrint(card, setReleaseDate, isCardArtPreferenceLatestArt, cardArtPreferenceHasFilter, null);
    }

    public PaperCard getAlternativeCardPrint(PaperCard card, Date setReleaseDate, boolean isCardArtPreferenceLatestArt, boolean cardArtPreferenceHasFilter, List<String> allowedSetCodes) {
        Date searchReferenceDate = this.getReferenceDate(setReleaseDate, isCardArtPreferenceLatestArt);
        CardDb.CardArtPreference searchCardArtStrategy = this.getSearchStrategyForAlternativeCardArt(isCardArtPreferenceLatestArt, cardArtPreferenceHasFilter);
        return this.searchAlternativeCardCandidate(card, isCardArtPreferenceLatestArt, searchReferenceDate, searchCardArtStrategy, allowedSetCodes);
    }

    public PaperCard getAlternativeCardPrint(PaperCard card, Date setReleaseDate, boolean isCardArtPreferenceLatestArt, boolean cardArtPreferenceHasFilter, boolean preferCandidatesFromExpansionSets, boolean preferModernFrame) {
        return this.getAlternativeCardPrint(card, setReleaseDate, isCardArtPreferenceLatestArt, cardArtPreferenceHasFilter, preferCandidatesFromExpansionSets, preferModernFrame, null);
    }

    public PaperCard getAlternativeCardPrint(PaperCard card, Date setReleaseDate, boolean isCardArtPreferenceLatestArt, boolean cardArtPreferenceHasFilter, boolean preferCandidatesFromExpansionSets, boolean preferModernFrame, List<String> allowedSetCodes) {
        PaperCard altCard = this.getAlternativeCardPrint(card, setReleaseDate, isCardArtPreferenceLatestArt, cardArtPreferenceHasFilter, allowedSetCodes);
        if (altCard == null) {
            return altCard;
        }
        PaperCard refinedAltCandidate = this.tryToGetCardPrintWithMatchingFrame(altCard, isCardArtPreferenceLatestArt, cardArtPreferenceHasFilter, preferModernFrame, allowedSetCodes);
        if (refinedAltCandidate != null) {
            altCard = refinedAltCandidate;
        }
        if (cardArtPreferenceHasFilter && preferCandidatesFromExpansionSets && (refinedAltCandidate = this.tryToGetCardPrintFromExpansionSet(altCard, isCardArtPreferenceLatestArt, preferModernFrame, allowedSetCodes)) != null) {
            altCard = refinedAltCandidate;
        }
        return altCard;
    }

    private PaperCard searchAlternativeCardCandidate(PaperCard card, boolean isCardArtPreferenceLatestArt, Date searchReferenceDate, CardDb.CardArtPreference searchCardArtStrategy, List<String> allowedSetCodes) {
        CardDb cardDb = this.commonCards;
        String cardName = card.getName();
        int artIndex = card.getArtIndex();
        PaperCard altCard = null;
        Predicate<PaperCard> filter = null;
        if (allowedSetCodes != null && !allowedSetCodes.isEmpty()) {
            filter = cardDb.isLegal(allowedSetCodes);
        }
        if (isCardArtPreferenceLatestArt) {
            altCard = cardDb.getCardFromEditionsReleasedAfter(cardName, searchCardArtStrategy, artIndex, searchReferenceDate, filter);
            if (altCard == null) {
                altCard = cardDb.getCardFromEditionsReleasedAfter(cardName, searchCardArtStrategy, searchReferenceDate, filter);
            }
        } else {
            altCard = cardDb.getCardFromEditionsReleasedBefore(cardName, searchCardArtStrategy, artIndex, searchReferenceDate, filter);
            if (altCard == null) {
                altCard = cardDb.getCardFromEditionsReleasedBefore(cardName, searchCardArtStrategy, searchReferenceDate, filter);
            }
        }
        if (altCard == null) {
            return null;
        }
        return card.isFoil() ? altCard.getFoiled() : altCard;
    }

    private Date getReferenceDate(Date setReleaseDate, boolean isCardArtPreferenceLatestArt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(setReleaseDate);
        if (isCardArtPreferenceLatestArt) {
            cal.add(5, -2);
        } else {
            cal.add(5, 2);
        }
        return cal.getTime();
    }

    private CardDb.CardArtPreference getSearchStrategyForAlternativeCardArt(boolean isCardArtPreferenceLatestArt, boolean cardArtPreferenceHasFilter) {
        CardDb.CardArtPreference lookupStrategy = isCardArtPreferenceLatestArt ? (cardArtPreferenceHasFilter ? CardDb.CardArtPreference.ORIGINAL_ART_CORE_EXPANSIONS_REPRINT_ONLY : CardDb.CardArtPreference.ORIGINAL_ART_ALL_EDITIONS) : (cardArtPreferenceHasFilter ? CardDb.CardArtPreference.LATEST_ART_CORE_EXPANSIONS_REPRINT_ONLY : CardDb.CardArtPreference.LATEST_ART_ALL_EDITIONS);
        return lookupStrategy;
    }

    private PaperCard tryToGetCardPrintFromExpansionSet(PaperCard altCard, boolean isCardArtPreferenceLatestArt, boolean preferModernFrame, List<String> allowedSetCodes) {
        CardEdition altCandidateEdition;
        Date referenceDate;
        CardEdition altCardEdition = this.editions.get(altCard.getEdition());
        if (altCardEdition.getType() == CardEdition.Type.EXPANSION) {
            return null;
        }
        boolean searchStrategyFlag = isCardArtPreferenceLatestArt == preferModernFrame == isCardArtPreferenceLatestArt;
        CardDb.CardArtPreference searchStrategy = this.getSearchStrategyForAlternativeCardArt(searchStrategyFlag, true);
        PaperCard altCandidate = altCard;
        while (altCandidate != null && ((altCandidate = this.searchAlternativeCardCandidate(altCandidate, preferModernFrame, referenceDate = this.editions.get(altCandidate.getEdition()).getDate(), searchStrategy, allowedSetCodes)) == null || (altCandidateEdition = this.editions.get(altCandidate.getEdition())).getType() != CardEdition.Type.EXPANSION)) {
        }
        return altCandidate;
    }

    private PaperCard tryToGetCardPrintWithMatchingFrame(PaperCard altCard, boolean isCardArtPreferenceLatestArt, boolean cardArtHasFilter, boolean preferModernFrame, List<String> allowedSetCodes) {
        CardEdition altCandidateEdition;
        Date referenceDate;
        boolean frameIsCompliantAlready;
        CardEdition altCardEdition = this.editions.get(altCard.getEdition());
        boolean bl = frameIsCompliantAlready = altCardEdition.isModern() == preferModernFrame;
        if (frameIsCompliantAlready) {
            return null;
        }
        boolean searchStrategyFlag = isCardArtPreferenceLatestArt == preferModernFrame == isCardArtPreferenceLatestArt;
        CardDb.CardArtPreference searchStrategy = this.getSearchStrategyForAlternativeCardArt(searchStrategyFlag, cardArtHasFilter);
        PaperCard altCandidate = altCard;
        while (altCandidate != null && ((altCandidate = this.searchAlternativeCardCandidate(altCandidate, preferModernFrame, referenceDate = this.editions.get(altCandidate.getEdition()).getDate(), searchStrategy, allowedSetCodes)) == null || (altCandidateEdition = this.editions.get(altCandidate.getEdition())).isModern() != preferModernFrame)) {
        }
        return altCandidate;
    }

    public int getCardArtCount(PaperCard card) {
        Collection<CardDb> databases = this.getAvailableDatabases().values();
        for (CardDb db : databases) {
            int artCount = db.getArtCount(card.getName(), card.getEdition());
            if (artCount <= 0) continue;
            return artCount;
        }
        return 0;
    }

    public boolean getFilteredHandsEnabled() {
        return this.filteredHandsEnabled;
    }

    public void setFilteredHandsEnabled(boolean filteredHandsEnabled) {
        this.filteredHandsEnabled = filteredHandsEnabled;
    }

    public void setMulliganRule(MulliganDefs.MulliganRule rule) {
        this.mulliganRule = rule;
    }

    public MulliganDefs.MulliganRule getMulliganRule() {
        return this.mulliganRule;
    }

    public void setCardArtPreference(boolean latestArt, boolean coreExpansionOnly) {
        this.commonCards.setCardArtPreference(latestArt, coreExpansionOnly);
        this.variantCards.setCardArtPreference(latestArt, coreExpansionOnly);
    }

    public String getCardArtPreferenceName() {
        return this.commonCards.getCardArtPreference().toString();
    }

    public CardDb.CardArtPreference getCardArtPreference() {
        return this.commonCards.getCardArtPreference();
    }

    public CardDb.CardArtPreference getCardArtPreference(boolean latestArt, boolean coreExpansionOnly) {
        if (latestArt) {
            return coreExpansionOnly ? CardDb.CardArtPreference.LATEST_ART_CORE_EXPANSIONS_REPRINT_ONLY : CardDb.CardArtPreference.LATEST_ART_ALL_EDITIONS;
        }
        return coreExpansionOnly ? CardDb.CardArtPreference.ORIGINAL_ART_CORE_EXPANSIONS_REPRINT_ONLY : CardDb.CardArtPreference.ORIGINAL_ART_ALL_EDITIONS;
    }

    public boolean isCoreExpansionOnlyFilterSet() {
        return this.commonCards.getCardArtPreference().filterSets;
    }

    public boolean cardArtPreferenceIsLatest() {
        return this.commonCards.getCardArtPreference().latestFirst;
    }

    public String[] getCardArtAvailablePreferences() {
        CardDb.CardArtPreference[] preferences = CardDb.CardArtPreference.values();
        String[] preferences_avails = new String[preferences.length];
        for (int i = 0; i < preferences.length; ++i) {
            preferences_avails[i] = this.prettifyCardArtPreferenceName(preferences[i]);
        }
        return preferences_avails;
    }

    public Pair<Integer, Integer> audit(StringBuffer noImageFound, StringBuffer cardNotImplemented) {
        int missingCount = 0;
        int notImplementedCount = 0;
        for (CardEdition e : this.editions) {
            if (CardEdition.Type.FUNNY.equals((Object)e.getType())) continue;
            boolean nifHeader = false;
            boolean cniHeader = false;
            boolean tokenHeader = false;
            int artIndex = 1;
            HashMap<String, Pair<Boolean, Integer>> cardCount = new HashMap<String, Pair<Boolean, Integer>>();
            for (CardEdition.CardInSet cardInSet : e.getAllCardsInSet()) {
                if (cardCount.containsKey(cardInSet.name)) {
                    cardCount.put(cardInSet.name, Pair.of(cardInSet.collectorNumber.startsWith("F"), (Integer)((Pair)cardCount.get(cardInSet.name)).getRight() + 1));
                    continue;
                }
                cardCount.put(cardInSet.name, Pair.of(cardInSet.collectorNumber.startsWith("F"), 1));
            }
            for (Map.Entry entry : cardCount.entrySet()) {
                File file;
                String c = (String)entry.getKey();
                artIndex = (Integer)((Pair)entry.getValue()).getRight();
                PaperCard cp = this.getCommonCards().getCard(c, e.getCode(), artIndex);
                if (cp == null) {
                    cp = this.getVariantCards().getCard(c, e.getCode(), artIndex);
                }
                if (cp == null) {
                    if (((Boolean)((Pair)entry.getValue()).getLeft()).booleanValue() || !this.loadNonLegalCards && CardEdition.Type.FUNNY.equals((Object)e.getType())) continue;
                    if (!cniHeader) {
                        cardNotImplemented.append("\nEdition: ").append(e.getName()).append(" ").append("(").append(e.getCode()).append("/").append(e.getCode2()).append(")\n");
                        cniHeader = true;
                    }
                    cardNotImplemented.append(" ").append(c).append("\n");
                    ++notImplementedCount;
                    continue;
                }
                String imagePath = ImageUtil.getImageRelativePath(cp, "", true, false);
                if (imagePath != null) {
                    file = ImageKeys.getImageFile(imagePath);
                    if (file == null && ImageKeys.hasSetLookup(imagePath)) {
                        file = ImageKeys.setLookUpFile(imagePath, imagePath + "border");
                    }
                    if (file == null) {
                        if (!nifHeader) {
                            noImageFound.append("Edition: ").append(e.getName()).append(" ").append("(").append(e.getCode()).append("/").append(e.getCode2()).append(")\n");
                            nifHeader = true;
                        }
                        noImageFound.append(" ").append(imagePath).append("\n");
                        ++missingCount;
                    }
                }
                if (!cp.hasBackFace() || (imagePath = ImageUtil.getImageRelativePath(cp, "back", true, false)) == null) continue;
                file = ImageKeys.getImageFile(imagePath);
                if (file == null && ImageKeys.hasSetLookup(imagePath)) {
                    file = ImageKeys.setLookUpFile(imagePath, imagePath + "border");
                }
                if (file != null) continue;
                if (!nifHeader) {
                    noImageFound.append("Edition: ").append(e.getName()).append(" ").append("(").append(e.getCode()).append("/").append(e.getCode2()).append(")\n");
                    nifHeader = true;
                }
                noImageFound.append(" ").append(imagePath).append("\n");
                ++missingCount;
            }
            for (Map.Entry entry : e.getTokens().entrySet()) {
                String name = (String)entry.getKey();
                artIndex = (Integer)entry.getValue();
                try {
                    PaperToken token = this.getAllTokens().getToken(name, e.getCode());
                    if (token == null) continue;
                    for (int i = 0; i < artIndex; ++i) {
                        String imgKey = token.getImageKey(i);
                        File file = ImageKeys.getImageFile(imgKey);
                        if (file != null) continue;
                        if (!nifHeader) {
                            noImageFound.append("Edition: ").append(e.getName()).append(" ").append("(").append(e.getCode()).append("/").append(e.getCode2()).append(")\n");
                            nifHeader = true;
                        }
                        if (!tokenHeader) {
                            noImageFound.append("\nTOKENS\n");
                            tokenHeader = true;
                        }
                        noImageFound.append(" ").append(token.getImageFilename(i + 1)).append("\n");
                        ++missingCount;
                    }
                }
                catch (Exception ex) {
                    System.out.println("No Token found: " + name + " in " + e.getName());
                }
            }
            if (!nifHeader) continue;
            noImageFound.append("\n");
        }
        String totalStats = "Missing images: " + missingCount + "\nUnimplemented cards: " + notImplementedCount + "\n";
        cardNotImplemented.append("\n-----------\n");
        cardNotImplemented.append(totalStats);
        cardNotImplemented.append("-----------\n\n");
        noImageFound.append(cardNotImplemented);
        return Pair.of(missingCount, notImplementedCount);
    }

    private String prettifyCardArtPreferenceName(CardDb.CardArtPreference preference) {
        String[] fullNames;
        StringBuilder label = new StringBuilder();
        for (String name : fullNames = preference.toString().split("_")) {
            label.append(TextUtil.capitalize(name.toLowerCase())).append(" ");
        }
        return label.toString().trim();
    }

    public void setCardArtPreference(String artPreference) {
        this.commonCards.setCardArtPreference(artPreference);
        this.variantCards.setCardArtPreference(artPreference);
    }

    public boolean isEnabledCardArtSmartSelection() {
        return this.enableSmartCardArtSelection;
    }

    public void setEnableSmartCardArtSelection(boolean isEnabled) {
        this.enableSmartCardArtSelection = isEnabled;
    }

    public boolean useSourceImageForClone() {
        return this.sourceImageForClone;
    }

    public void setSourceImageForClone(boolean b) {
        this.sourceImageForClone = b;
    }

    public boolean isRebalanced(String name) {
        if (!name.startsWith("A-")) {
            return false;
        }
        for (PaperCard pc : this.getCommonCards().getAllCards(name)) {
            CardEdition e = this.editions.get(pc.getEdition());
            if (e == null || !e.isRebalanced(name)) continue;
            return true;
        }
        return false;
    }
}

