/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.google.common.collect.Lists;
import java.util.ArrayList;

public class MulliganDefs {
    private static MulliganRule defaultRule = MulliganRule.London;

    public static MulliganRule getDefaultRule() {
        return defaultRule;
    }

    public static String[] getMulliganRuleNames() {
        ArrayList<String> names = Lists.newArrayList();
        for (MulliganRule mr : MulliganRule.values()) {
            names.add(mr.name());
        }
        return names.toArray(new String[0]);
    }

    public static MulliganRule GetRuleByName(String rule) {
        MulliganRule r;
        try {
            r = MulliganRule.valueOf(rule);
        }
        catch (IllegalArgumentException ex) {
            System.err.println("Warning: illegal Mulligan rule specified: " + rule + ", defaulting to " + MulliganDefs.getDefaultRule().name());
            r = MulliganDefs.getDefaultRule();
        }
        return r;
    }

    public static enum MulliganRule {
        Original,
        Paris,
        Vancouver,
        London;

    }
}

