/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.StaticData;
import forge.card.CardEdition;
import forge.item.PaperCard;
import forge.util.FileUtil;
import forge.util.TextUtil;
import forge.util.ThreadUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class ImageKeys {
    public static final String CARD_PREFIX = "c:";
    public static final String TOKEN_PREFIX = "t:";
    public static final String ICON_PREFIX = "i:";
    public static final String BOOSTER_PREFIX = "b:";
    public static final String FATPACK_PREFIX = "f:";
    public static final String BOOSTERBOX_PREFIX = "x:";
    public static final String PRECON_PREFIX = "p:";
    public static final String TOURNAMENTPACK_PREFIX = "o:";
    public static final String ADVENTURECARD_PREFIX = "a:";
    public static final String HIDDEN_CARD = "hidden";
    public static final String MORPH_IMAGE = "morph";
    public static final String DISGUISED_IMAGE = "disguised";
    public static final String MANIFEST_IMAGE = "manifest";
    public static final String CLOAKED_IMAGE = "cloaked";
    public static final String FORETELL_IMAGE = "foretell";
    public static final String BACKFACE_POSTFIX = "$alt";
    public static final String SPECFACE_W = "$wspec";
    public static final String SPECFACE_U = "$uspec";
    public static final String SPECFACE_B = "$bspec";
    public static final String SPECFACE_R = "$rspec";
    public static final String SPECFACE_G = "$gspec";
    private static String CACHE_CARD_PICS_DIR;
    private static String CACHE_TOKEN_PICS_DIR;
    private static String CACHE_ICON_PICS_DIR;
    private static String CACHE_BOOSTER_PICS_DIR;
    private static String CACHE_FATPACK_PICS_DIR;
    private static String CACHE_BOOSTERBOX_PICS_DIR;
    private static String CACHE_PRECON_PICS_DIR;
    private static String CACHE_TOURNAMENTPACK_PICS_DIR;
    public static String ADVENTURE_CARD_PICS_DIR;
    private static Map<String, String> CACHE_CARD_PICS_SUBDIR;
    private static Map<String, Boolean> editionImageLookup;
    private static Map<String, Set<String>> editionAlias;
    private static Set<String> toFind;
    private static boolean isLibGDXPort;
    private static final String[] FILE_EXTENSIONS;
    private static final Map<String, File> cachedCards;
    private static HashSet<String> missingCards;
    static HashMap<String, HashSet<String>> cachedContent;

    private ImageKeys() {
    }

    public static void setIsLibGDXPort(boolean value) {
        isLibGDXPort = value;
    }

    public static void initializeDirs(String cards, Map<String, String> cardsSub, String tokens, String icons, String boosters, String fatPacks, String boosterBoxes, String precons, String tournamentPacks) {
        CACHE_CARD_PICS_DIR = cards;
        CACHE_CARD_PICS_SUBDIR = cardsSub;
        CACHE_TOKEN_PICS_DIR = tokens;
        CACHE_ICON_PICS_DIR = icons;
        CACHE_BOOSTER_PICS_DIR = boosters;
        CACHE_FATPACK_PICS_DIR = fatPacks;
        CACHE_BOOSTERBOX_PICS_DIR = boosterBoxes;
        CACHE_PRECON_PICS_DIR = precons;
        CACHE_TOURNAMENTPACK_PICS_DIR = tournamentPacks;
    }

    public static String getTokenKey(String tokenName) {
        return TOKEN_PREFIX + tokenName;
    }

    public static String getTokenImageName(String tokenKey) {
        if (!tokenKey.startsWith(TOKEN_PREFIX)) {
            return null;
        }
        return tokenKey.substring(TOKEN_PREFIX.length());
    }

    public static void clearMissingCards() {
        missingCards.clear();
    }

    public static File getCachedCardsFile(String key) {
        return cachedCards.get(key);
    }

    public static File getImageFile(String key) {
        String dir;
        String filename;
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        if (key.startsWith(TOKEN_PREFIX)) {
            filename = key.substring(TOKEN_PREFIX.length());
            dir = CACHE_TOKEN_PICS_DIR;
        } else if (key.startsWith(ICON_PREFIX)) {
            filename = key.substring(ICON_PREFIX.length());
            dir = CACHE_ICON_PICS_DIR;
        } else if (key.startsWith(BOOSTER_PREFIX)) {
            filename = key.substring(BOOSTER_PREFIX.length());
            dir = CACHE_BOOSTER_PICS_DIR;
        } else if (key.startsWith(FATPACK_PREFIX)) {
            filename = key.substring(FATPACK_PREFIX.length());
            dir = CACHE_FATPACK_PICS_DIR;
        } else if (key.startsWith(BOOSTERBOX_PREFIX)) {
            filename = key.substring(BOOSTERBOX_PREFIX.length());
            dir = CACHE_BOOSTERBOX_PICS_DIR;
        } else if (key.startsWith(PRECON_PREFIX)) {
            filename = key.substring(PRECON_PREFIX.length());
            dir = CACHE_PRECON_PICS_DIR;
        } else if (key.startsWith(TOURNAMENTPACK_PREFIX)) {
            filename = key.substring(TOURNAMENTPACK_PREFIX.length());
            dir = CACHE_TOURNAMENTPACK_PICS_DIR;
        } else if (key.startsWith(ADVENTURECARD_PREFIX)) {
            filename = key.substring(ADVENTURECARD_PREFIX.length());
            dir = ADVENTURE_CARD_PICS_DIR;
        } else {
            filename = key;
            dir = CACHE_CARD_PICS_DIR;
        }
        if (toFind.contains(filename)) {
            return null;
        }
        if (missingCards.contains(filename)) {
            return null;
        }
        File cachedFile = cachedCards.get(filename);
        if (cachedFile != null) {
            return cachedFile;
        }
        File file = ImageKeys.findFile(dir, filename);
        if (file != null) {
            cachedCards.put(filename, file);
            return file;
        }
        if (filename.contains("Ae")) {
            file = ImageKeys.findFile(dir, TextUtil.fastReplace(filename, "Ae", "AE"));
            if (file != null) {
                cachedCards.put(filename, file);
                return file;
            }
        } else if (filename.contains("AE") && (file = ImageKeys.findFile(dir, TextUtil.fastReplace(filename, "AE", "Ae"))) != null) {
            cachedCards.put(filename, file);
            return file;
        }
        if (filename.contains(".full")) {
            String setCode;
            String fullborderFile = TextUtil.fastReplace(filename, ".full", ".fullborder");
            file = ImageKeys.findFile(dir, fullborderFile);
            if (file != null) {
                cachedCards.put(filename, file);
                return file;
            }
            file = ImageKeys.findFile(dir, TextUtil.fastReplace(fullborderFile, "1.fullborder", ".fullborder"));
            if (file != null) {
                cachedCards.put(filename, file);
                return file;
            }
            file = ImageKeys.findFile(dir, filename.replaceAll("[0-9].full", ".full"));
            if (file != null) {
                cachedCards.put(filename, file);
                return file;
            }
            if (ImageKeys.hasSetLookup(filename)) {
                toFind.add(filename);
                try {
                    ThreadUtil.getServicePool().submit(() -> {
                        File f = ImageKeys.setLookUpFile(filename, fullborderFile);
                        if (f != null) {
                            cachedCards.put(filename, f);
                        } else {
                            missingCards.add(filename);
                        }
                        toFind.remove(filename);
                    });
                }
                catch (Exception e) {
                    toFind.remove(filename);
                }
            }
            String string = setCode = filename.contains("/") ? filename.substring(0, filename.indexOf("/")) : "";
            if (!setCode.isEmpty() && editionAlias.containsKey(setCode)) {
                for (String alias : editionAlias.get(setCode)) {
                    file = ImageKeys.findFile(dir, TextUtil.fastReplace(filename, setCode + "/", alias + "/"));
                    if (file != null) {
                        cachedCards.put(filename, file);
                        return file;
                    }
                    file = ImageKeys.findFile(dir, TextUtil.fastReplace(fullborderFile, setCode + "/", alias + "/"));
                    if (file == null) continue;
                    cachedCards.put(filename, file);
                    return file;
                }
            }
        }
        if (!filename.contains(".full")) {
            file = ImageKeys.findFile(dir, TextUtil.addSuffix(filename, ".full"));
            if (file != null) {
                cachedCards.put(filename, file);
                return file;
            }
            file = ImageKeys.findFile(dir, TextUtil.addSuffix(filename, ".fullborder"));
            if (file != null) {
                cachedCards.put(filename, file);
                return file;
            }
        }
        if (dir.equals(CACHE_TOKEN_PICS_DIR)) {
            int index = filename.lastIndexOf(95);
            if (index != -1) {
                String setlessFilename = filename.substring(0, index);
                String setCode = filename.substring(index + 1);
                file = ImageKeys.findFile(dir, setlessFilename + "_" + setCode.toUpperCase());
                if (file != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
                file = ImageKeys.findFile(dir, setlessFilename + "_" + setCode.toLowerCase());
                if (file != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
                file = ImageKeys.findFile(dir, setlessFilename);
                if (file != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
                if (setlessFilename.matches(".*[0-9]*$") && (file = ImageKeys.findFile(dir, setlessFilename.replaceAll("[0-9]*$", ""))) != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
            }
        } else if (filename.contains("/")) {
            String setlessFilename = filename.substring(filename.indexOf(47) + 1);
            file = ImageKeys.findFile(dir, setlessFilename);
            if (file != null) {
                cachedCards.put(filename, file);
                return file;
            }
            if (setlessFilename.contains(".full")) {
                String fullborderFile = TextUtil.fastReplace(setlessFilename, ".full", ".fullborder");
                file = ImageKeys.findFile(dir, fullborderFile);
                if (file != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
                file = ImageKeys.findFile(dir, setlessFilename.replaceAll("[0-9]*[.]full", "1.full"));
                if (file != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
            }
            if (!filename.contains(".full")) {
                String newFilename = TextUtil.addSuffix(filename, ".full");
                file = ImageKeys.findFile(dir, newFilename);
                if (file != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
                String newFilename2 = TextUtil.addSuffix(filename, ".fullborder");
                file = ImageKeys.findFile(dir, newFilename2);
                if (file != null) {
                    cachedCards.put(filename, file);
                    return file;
                }
                String setCode = filename.substring(0, filename.indexOf("/"));
                if (!setCode.isEmpty() && editionAlias.containsKey(setCode)) {
                    for (String alias : editionAlias.get(setCode)) {
                        file = ImageKeys.findFile(dir, TextUtil.fastReplace(newFilename, setCode + "/", alias + "/"));
                        if (file != null) {
                            cachedCards.put(filename, file);
                            return file;
                        }
                        file = ImageKeys.findFile(dir, TextUtil.fastReplace(newFilename2, setCode + "/", alias + "/"));
                        if (file == null) continue;
                        cachedCards.put(filename, file);
                        return file;
                    }
                }
            }
        }
        if (isLibGDXPort && !ImageKeys.hasSetLookup(filename)) {
            missingCards.add(filename);
        }
        return null;
    }

    public static String getSetFolder(String edition) {
        return !CACHE_CARD_PICS_SUBDIR.containsKey(edition) ? StaticData.instance().getEditions().getCode2ByCode(edition) : CACHE_CARD_PICS_SUBDIR.get(edition);
    }

    public static boolean hasSetLookup(String filename) {
        if (!StaticData.instance().getSetLookup().isEmpty()) {
            return StaticData.instance().getSetLookup().keySet().stream().anyMatch(filename::startsWith);
        }
        return false;
    }

    public static File setLookUpFile(String filename, String fullborderFile) {
        if (!StaticData.instance().getSetLookup().isEmpty()) {
            for (String setKey : StaticData.instance().getSetLookup().keySet()) {
                if (!filename.startsWith(setKey)) continue;
                for (String setLookup : StaticData.instance().getSetLookup().get(setKey)) {
                    String lookupDirectory = CACHE_CARD_PICS_DIR + setLookup;
                    File f = new File(lookupDirectory);
                    if (!f.exists() || !f.isDirectory()) continue;
                    for (String ext : FILE_EXTENSIONS) {
                        if (ext.isEmpty()) continue;
                        String fb1 = fullborderFile.replace(setKey + "/", "") + ext;
                        File placeholder = new File(lookupDirectory + "/" + fb1);
                        if (placeholder.exists()) {
                            return placeholder;
                        }
                        String fb2 = fullborderFile.replace(setKey + "/", "").replaceAll("[0-9]*.fullborder", "1.fullborder") + ext;
                        placeholder = new File(lookupDirectory + "/" + fb2);
                        if (placeholder.exists()) {
                            return placeholder;
                        }
                        String f1 = filename.replace(setKey + "/", "") + ext;
                        placeholder = new File(lookupDirectory + "/" + f1);
                        if (placeholder.exists()) {
                            return placeholder;
                        }
                        String f2 = filename.replace(setKey + "/", "").replaceAll("[0-9]*.full", "1.full") + ext;
                        placeholder = new File(lookupDirectory + "/" + f2);
                        if (!placeholder.exists()) continue;
                        return placeholder;
                    }
                }
            }
        }
        return null;
    }

    private static File findFile(String dir, String filename) {
        if (dir.equals(CACHE_CARD_PICS_DIR)) {
            for (String ext : FILE_EXTENSIONS) {
                File f;
                if (ext.isEmpty() || !(f = new File(dir, filename + ext)).exists()) continue;
                return f;
            }
        } else {
            for (String ext : FILE_EXTENSIONS) {
                File file = new File(dir, filename + ext);
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    file.delete();
                    continue;
                }
                return file;
            }
        }
        return null;
    }

    public static boolean hasImage(PaperCard pc) {
        return ImageKeys.hasImage(pc, false);
    }

    public static boolean hasImage(PaperCard pc, boolean update) {
        String[] keyParts;
        Boolean editionHasImage = editionImageLookup.get(pc.getEdition());
        if (editionHasImage == null) {
            String setFolder = ImageKeys.getSetFolder(pc.getEdition());
            CardEdition ed = StaticData.instance().getEditions().get(setFolder);
            if (ed != null && !editionAlias.containsKey(setFolder)) {
                String code;
                String alias = ed.getAlias();
                HashSet<String> aliasSet = new HashSet<String>();
                if (alias != null && !alias.equalsIgnoreCase(setFolder)) {
                    aliasSet.add(alias);
                }
                if ((code = ed.getCode()) != null && !code.equalsIgnoreCase(setFolder)) {
                    aliasSet.add(code);
                }
                if (!aliasSet.isEmpty()) {
                    editionAlias.put(setFolder, aliasSet);
                }
            }
            editionHasImage = FileUtil.isDirectoryWithFiles(CACHE_CARD_PICS_DIR + setFolder);
            editionImageLookup.put(pc.getEdition(), editionHasImage);
            if (editionHasImage.booleanValue()) {
                File f = new File(CACHE_CARD_PICS_DIR + setFolder);
                HashSet<String> setFolderContent = new HashSet<String>();
                for (String filename : Arrays.asList(f.list())) {
                    if (!filename.endsWith(".jpg") && !filename.endsWith(".png")) continue;
                    setFolderContent.add(filename.split("\\.")[0]);
                    String key = setFolder + "/" + filename.replace(".fullborder", ".full").replace(".jpg", "").replace(".png", "");
                    File value = new File(CACHE_CARD_PICS_DIR + setFolder + "/" + filename);
                    cachedCards.put(key, value);
                }
                cachedContent.put(setFolder, setFolderContent);
            }
        }
        if ((keyParts = StringUtils.split(pc.getCardImageKey(), "//")).length != 2) {
            return false;
        }
        if (update && editionHasImage.booleanValue()) {
            try {
                cachedContent.get(ImageKeys.getSetFolder(pc.getEdition())).add(pc.getName());
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        HashSet content = cachedContent.getOrDefault(keyParts[0], null);
        return editionHasImage != false && ImageKeys.hitCache(content, keyParts[1]);
    }

    private static boolean hitCache(HashSet<String> cache, String filename) {
        if (cache == null || cache.isEmpty()) {
            return false;
        }
        String keyPrefix = filename.split("\\.")[0];
        return cache.contains(keyPrefix);
    }

    static {
        editionImageLookup = new HashMap<String, Boolean>();
        editionAlias = new HashMap<String, Set<String>>();
        toFind = new HashSet<String>();
        isLibGDXPort = false;
        FILE_EXTENSIONS = new String[]{".jpg", ".png", ""};
        cachedCards = new HashMap<String, File>(50000);
        missingCards = new HashSet();
        cachedContent = new HashMap(50000);
    }
}

