/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mortennobel.imagescaling.ResampleOp;
import forge.ImageKeys;
import forge.ImageLoader;
import forge.StaticData;
import forge.card.CardSplitType;
import forge.game.card.Card;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.localinstance.skin.FSkinProp;
import forge.model.FModel;
import forge.toolbox.FSkin;
import forge.toolbox.imaging.FCardImageRenderer;
import forge.util.ImageUtil;
import forge.util.TextUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ImageCache {
    private static final Set<String> _missingIconKeys = new HashSet<String>();
    private static final LoadingCache<String, BufferedImage> _CACHE = CacheBuilder.newBuilder().maximumSize(FModel.getPreferences().getPrefInt(ForgePreferences.FPref.UI_IMAGE_CACHE_MAXIMUM)).expireAfterAccess(15L, TimeUnit.MINUTES).build(new ImageLoader());
    private static final BufferedImage _defaultImage;

    public static void clear() {
        _CACHE.invalidateAll();
        _missingIconKeys.clear();
        ImageKeys.clearMissingCards();
    }

    public static BufferedImage getImage(CardView card, Iterable<PlayerView> viewers, int width, int height) {
        String key = card.getCurrentState().getImageKey(viewers);
        return ImageCache.scaleImage(key, width, height, true, card);
    }

    public static BufferedImage getImageNoDefault(CardView card, Iterable<PlayerView> viewers, int width, int height) {
        String key = card.getCurrentState().getImageKey(viewers);
        return ImageCache.scaleImage(key, width, height, false, card);
    }

    public static BufferedImage getImage(InventoryItem ii, int width, int height) {
        return ImageCache.getImage(ii, width, height, false);
    }

    public static BufferedImage getImage(InventoryItem ii, int width, int height, boolean altState) {
        return ImageCache.scaleImage(ii.getImageKey(altState), width, height, true, null);
    }

    public static FSkin.SkinIcon getIcon(String imageKey) {
        BufferedImage i;
        if (_missingIconKeys.contains(imageKey) || null == (i = ImageCache.scaleImage(imageKey, -1, -1, false, null))) {
            _missingIconKeys.add(imageKey);
            return FSkin.getIcon(FSkinProp.ICO_UNKNOWN);
        }
        return new FSkin.UnskinnedIcon(i);
    }

    public static BufferedImage getOriginalImage(String imageKey, boolean useDefaultIfNotFound, CardView cardView) {
        return ImageCache.getOriginalImageInternal(imageKey, useDefaultIfNotFound, cardView).getLeft();
    }

    public static Pair<BufferedImage, Boolean> getCardOriginalImageInfo(String imageKey, boolean useDefaultIfNotFound) {
        return ImageCache.getOriginalImageInternal(imageKey, useDefaultIfNotFound, null);
    }

    private static Pair<BufferedImage, Boolean> getOriginalImageInternal(String imageKey, boolean useDefaultIfNotFound, CardView cardView) {
        BufferedImage cached;
        BufferedImage original;
        if (null == imageKey) {
            return Pair.of(null, false);
        }
        PaperCard ipc = null;
        boolean altState = imageKey.endsWith("$alt");
        String specColor = "";
        if (imageKey.endsWith("$wspec")) {
            specColor = "white";
        } else if (imageKey.endsWith("$uspec")) {
            specColor = "blue";
        } else if (imageKey.endsWith("$bspec")) {
            specColor = "black";
        } else if (imageKey.endsWith("$rspec")) {
            specColor = "red";
        } else if (imageKey.endsWith("$gspec")) {
            specColor = "green";
        }
        if (altState) {
            imageKey = imageKey.substring(0, imageKey.length() - "$alt".length());
        }
        if (!specColor.isEmpty()) {
            imageKey = imageKey.substring(0, imageKey.length() - "$wspec".length());
        }
        if (imageKey.startsWith("c:") && (ipc = ImageUtil.getPaperCardFromImageKey(imageKey)) != null) {
            if (altState) {
                imageKey = ipc.getCardAltImageKey();
            } else if (!specColor.isEmpty()) {
                switch (specColor) {
                    case "white": {
                        imageKey = ipc.getCardWSpecImageKey();
                        break;
                    }
                    case "blue": {
                        imageKey = ipc.getCardUSpecImageKey();
                        break;
                    }
                    case "black": {
                        imageKey = ipc.getCardBSpecImageKey();
                        break;
                    }
                    case "red": {
                        imageKey = ipc.getCardRSpecImageKey();
                        break;
                    }
                    case "green": {
                        imageKey = ipc.getCardGSpecImageKey();
                    }
                }
            } else {
                imageKey = ipc.getCardImageKey();
            }
            if (StringUtils.isBlank(imageKey)) {
                return Pair.of(_defaultImage, true);
            }
        }
        boolean useArtCrop = "Crop".equals(FModel.getPreferences().getPref(ForgePreferences.FPref.UI_CARD_ART_FORMAT)) && ipc != null && !ipc.getArtist().isEmpty();
        String originalKey = imageKey;
        if (useArtCrop) {
            if (ipc != null && ipc.getRules().getSplitType() == CardSplitType.Flip) {
                imageKey = ipc.getCardImageKey();
            }
            imageKey = TextUtil.fastReplace(imageKey, ".full", ".artcrop");
        }
        if ((original = ImageCache.getImage(imageKey)) == null && !useDefaultIfNotFound) {
            return Pair.of(null, false);
        }
        if (useArtCrop && original != null && (cached = (BufferedImage)_CACHE.getIfPresent(originalKey)) != null) {
            return Pair.of(cached, false);
        }
        boolean noBorder = !useArtCrop && !ImageCache.isPreferenceEnabled(ForgePreferences.FPref.UI_RENDER_BLACK_BORDERS);
        boolean fetcherEnabled = ImageCache.isPreferenceEnabled(ForgePreferences.FPref.UI_ENABLE_ONLINE_IMAGE_FETCHER);
        boolean isPlaceholder = original == null && fetcherEnabled;
        String setCode = imageKey.split("/")[0].trim().toUpperCase();
        if (original != null && noBorder) {
            float width = original.getWidth();
            int radius = setCode.equals("A") ? (int)(-107.0 * (double)(width * width) / 5.2648506E7 + 743043.0 * (double)width / 5849834.0 + 6.498474239705871) : (setCode.equals("ME2") || setCode.equals("ME3") || setCode.equals("ME4") || setCode.equals("TD0") || setCode.equals("TD1") ? (int)(23.0 * (double)(width * width) / 1.7549502E7 + 559597.0 * (double)width / 5849834.0 + 5.0056567986943445) : (int)(-145.0 * (double)(width * width) / 8774751.0 + 287215.0 * (double)width / 2924917.0 + 1.0156316686365232));
            original = ImageCache.makeRoundedCorner(original, radius);
        }
        if (original != null && ImageCache.isWhite(FSkin.getColorFromPixel(original.getRGB(0, 0))) && !ImageCache.isWhiteBorderSet(setCode)) {
            int xSpacing = original.getWidth() / 40;
            int ySpacing = original.getHeight() / 57;
            original = original.getSubimage(xSpacing, ySpacing, original.getWidth() - 2 * xSpacing, original.getHeight() - 2 * ySpacing);
        }
        if (original == null || useArtCrop) {
            if (!(ipc == null && cardView == null || originalKey.equals(ImageKeys.getTokenKey("hidden")))) {
                float screenScale = GuiBase.getInterface().getScreenScale();
                int width = Math.round(488.0f * screenScale);
                int height = Math.round(680.0f * screenScale);
                BufferedImage art = original;
                CardView card = ipc != null ? Card.getCardForUi(ipc).getView() : cardView;
                String legalString = null;
                original = new BufferedImage(width, height, 2);
                if (art != null) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(StaticData.instance().getCardEdition(ipc.getEdition()).getDate());
                    int year = cal.get(1);
                    legalString = "Illus. " + ipc.getArtist() + "   \u00a9" + year + " WOTC";
                }
                FCardImageRenderer.drawCardImage(original.createGraphics(), card, altState, width, height, art, legalString);
            } else {
                original = _defaultImage;
            }
        }
        return Pair.of(original, isPlaceholder);
    }

    private static boolean isWhite(Color color) {
        return color.getRed() > 200 && color.getBlue() > 200 && color.getGreen() > 200;
    }

    private static boolean isWhiteBorderSet(String setCode) {
        return setCode.equals("U") || setCode.equals("R") || setCode.equals("4E") || setCode.equals("5E") || setCode.equals("6E") || setCode.equals("7E") || setCode.equals("8E") || setCode.equals("9E");
    }

    public static boolean isSupportedImageSize(int width, int height) {
        return !(3 > width && -1 != width || 3 > height && -1 != height);
    }

    public static BufferedImage scaleImage(String key, int width, int height, boolean useDefaultImage, CardView cardView) {
        BufferedImage result;
        double scaleY;
        BufferedImage cachedDefault;
        if (StringUtils.isEmpty(key) || !ImageCache.isSupportedImageSize(width, height)) {
            return null;
        }
        String resizedKey = String.format("%s#%dx%d", key, width, height);
        BufferedImage cached = (BufferedImage)_CACHE.getIfPresent(resizedKey);
        if (null != cached) {
            return cached;
        }
        Pair<BufferedImage, Boolean> orgImgs = ImageCache.getOriginalImageInternal(key, useDefaultImage, cardView);
        BufferedImage original = orgImgs.getLeft();
        boolean isPlaceholder = orgImgs.getRight();
        if (original == null) {
            return null;
        }
        if (original == _defaultImage && null != (cachedDefault = (BufferedImage)_CACHE.getIfPresent(resizedKey = String.format("__DEFAULT__#%dx%d", width, height)))) {
            return cachedDefault;
        }
        double scaleX = -1 == width ? 1.0 : (double)width / (double)original.getWidth();
        double bestFitScale = Math.min(scaleX, scaleY = -1 == height ? 1.0 : (double)height / (double)original.getHeight());
        if (bestFitScale > 1.0 && !FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_SCALE_LARGER)) {
            bestFitScale = 1.0;
        }
        if (1.0 == bestFitScale) {
            result = original;
        } else {
            int destWidth = (int)((double)original.getWidth() * bestFitScale);
            int destHeight = (int)((double)original.getHeight() * bestFitScale);
            ResampleOp resampler = new ResampleOp(destWidth, destHeight);
            result = resampler.filter(original, null);
        }
        if (!isPlaceholder) {
            _CACHE.put(resizedKey, result);
        }
        return result;
    }

    public static BufferedImage getCroppedArt(BufferedImage bufferedImage, float x, float y, float w, float h2) {
        x = w * 0.1f;
        y = h2 * 0.11f;
        float ratioRatio = (w -= 2.0f * x) / (h2 *= 0.43f) / 1.302f;
        if (ratioRatio > 1.0f) {
            float dw = w * (ratioRatio - 1.0f);
            w -= dw;
            x += dw / 2.0f;
        } else {
            float dh = h2 * (1.0f - ratioRatio);
            h2 -= dh;
            y += dh / 2.0f;
        }
        return bufferedImage.getSubimage(Math.round(x), Math.round(y), Math.round(w), Math.round(h2));
    }

    private static BufferedImage getImage(String key) {
        FThreads.assertExecutedByEdt(true);
        try {
            return _CACHE.get(key);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof NullPointerException) {
                return null;
            }
            ex.printStackTrace();
            return null;
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            return null;
        }
    }

    private static boolean isPreferenceEnabled(ForgePreferences.FPref preferenceName) {
        return FModel.getPreferences().getPrefBoolean(preferenceName);
    }

    public static BufferedImage makeRoundedCorner(BufferedImage image, int cornerRadius) {
        int w = image.getWidth();
        int h2 = image.getHeight();
        BufferedImage output = new BufferedImage(w, h2, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h2, cornerRadius, cornerRadius));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)image, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static boolean isDefaultImage(BufferedImage image) {
        return _defaultImage.equals(image);
    }

    public static BufferedImage getDefaultImage() {
        return _defaultImage;
    }

    static {
        BufferedImage defImage = null;
        try {
            defImage = ImageIO.read(new File(ForgeConstants.NO_CARD_FILE));
            _defaultImage = null == defImage ? new BufferedImage(10, 10, 2) : defImage;
        }
        catch (Exception ex) {
            try {
                System.err.println("could not load default card image");
                _defaultImage = null == defImage ? new BufferedImage(10, 10, 2) : defImage;
            }
            catch (Throwable throwable) {
                _defaultImage = null == defImage ? new BufferedImage(10, 10, 2) : defImage;
                throw throwable;
            }
        }
    }
}

