/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.google.common.base.Function;
import forge.ImageCache;
import forge.ImageKeys;
import forge.Singletons;
import forge.download.GuiDownloader;
import forge.error.BugReportDialog;
import forge.gamemodes.match.HostedMatch;
import forge.gui.BoxedProductCardListViewer;
import forge.gui.CardListChooser;
import forge.gui.CardListViewer;
import forge.gui.FThreads;
import forge.gui.GuiChoose;
import forge.gui.download.GuiDownloadService;
import forge.gui.framework.FScreen;
import forge.gui.interfaces.IGuiBase;
import forge.gui.interfaces.IGuiGame;
import forge.item.PaperCard;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.ISkinImage;
import forge.model.FModel;
import forge.screens.deckeditor.CDeckEditorUI;
import forge.screens.deckeditor.controllers.CEditorQuestCardShop;
import forge.screens.match.CMatchUI;
import forge.sound.AltSoundSystem;
import forge.sound.AudioClip;
import forge.sound.AudioMusic;
import forge.sound.IAudioClip;
import forge.sound.IAudioMusic;
import forge.toolbox.FOptionPane;
import forge.toolbox.FSkin;
import forge.util.BuildInfo;
import forge.util.Callback;
import forge.util.FileUtil;
import forge.util.ImageFetcher;
import forge.util.OperatingSystem;
import forge.util.SwingImageFetcher;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class GuiDesktop
implements IGuiBase {
    private ImageFetcher imageFetcher = new SwingImageFetcher();
    static float screenScale = GuiDesktop.initializeScreenScale();

    @Override
    public boolean isRunningOnDesktop() {
        return true;
    }

    @Override
    public boolean isLibgdxPort() {
        return false;
    }

    @Override
    public String getCurrentVersion() {
        return BuildInfo.getVersionString();
    }

    @Override
    public String getAssetsDir() {
        return StringUtils.containsIgnoreCase(BuildInfo.getVersionString(), "git") ? "../forge-gui/" : "";
    }

    @Override
    public ImageFetcher getImageFetcher() {
        return this.imageFetcher;
    }

    @Override
    public void invokeInEdtNow(Runnable proc) {
        proc.run();
    }

    @Override
    public void invokeInEdtLater(Runnable proc) {
        SwingUtilities.invokeLater(proc);
    }

    @Override
    public void invokeInEdtAndWait(Runnable proc) {
        if (SwingUtilities.isEventDispatchThread()) {
            proc.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(proc);
            }
            catch (InterruptedException | InvocationTargetException exn) {
                throw new RuntimeException(exn);
            }
        }
    }

    @Override
    public boolean isGuiThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @Override
    public ISkinImage getSkinIcon(FSkinProp skinProp) {
        if (skinProp == null) {
            return null;
        }
        return FSkin.getIcon(skinProp);
    }

    @Override
    public ISkinImage getUnskinnedIcon(String path) {
        return new FSkin.UnskinnedIcon(path);
    }

    @Override
    public ISkinImage getCardArt(PaperCard card) {
        return null;
    }

    @Override
    public ISkinImage getCardArt(PaperCard card, boolean backFace) {
        return null;
    }

    @Override
    public ISkinImage createLayeredImage(PaperCard paperCard, FSkinProp background, String overlayFilename, float opacity) {
        BufferedImage cardImage;
        BufferedImage image = new BufferedImage(background.getWidth(), background.getHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        FSkin.SkinImage backgroundImage = FSkin.getImage(background);
        FSkin.drawImage(g2, backgroundImage, 0, 0, background.getWidth(), background.getHeight());
        int cardImageWidth = 90;
        int cardImageHeight = 128;
        if (FileUtil.doesFileExist(overlayFilename)) {
            ImageIcon overlay = new ImageIcon(overlayFilename);
            g2.drawImage(overlay.getImage(), (background.getWidth() - overlay.getIconWidth()) / 2, (background.getHeight() - overlay.getIconHeight()) / 2, overlay.getIconWidth(), overlay.getIconHeight(), null);
        } else if (paperCard != null && (cardImage = ImageCache.scaleImage(paperCard.getCardImageKey(), 90, 128, false, null)) != null) {
            g2.drawImage(cardImage, (background.getWidth() - 90) / 2, (background.getHeight() - 128) / 4, 90, 128, null);
        }
        return new FSkin.UnskinnedIcon(image, opacity);
    }

    @Override
    public void showImageDialog(ISkinImage image, String message, String title) {
        FOptionPane.showMessageDialog(message, title, (FSkin.SkinImage)image);
    }

    @Override
    public int showOptionDialog(String message, String title, FSkinProp icon, List<String> options, int defaultOption) {
        return FOptionPane.showOptionDialog(message, title, icon == null ? null : FSkin.getImage(icon), options, defaultOption);
    }

    @Override
    public String showInputDialog(String message, String title, FSkinProp icon, String initialInput, List<String> inputOptions, boolean isNumeric) {
        return FOptionPane.showInputDialog(message, title, icon == null ? null : FSkin.getImage(icon), initialInput, inputOptions);
    }

    @Override
    public <T> List<T> getChoices(String message, int min2, int max, Collection<T> choices, T selected, Function<T, String> display) {
        return GuiChoose.getChoices(message, min2, max, choices, selected, display);
    }

    @Override
    public <T> List<T> order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices) {
        return GuiChoose.order(title, top, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices);
    }

    @Override
    public void showCardList(String title, String message, List<PaperCard> list) {
        CardListViewer cardView = new CardListViewer(title, message, list);
        cardView.setVisible(true);
        cardView.dispose();
    }

    @Override
    public boolean showBoxedProduct(String title, String message, List<PaperCard> list) {
        BoxedProductCardListViewer viewer = new BoxedProductCardListViewer(title, message, list);
        viewer.setVisible(true);
        viewer.dispose();
        return viewer.skipTheRest();
    }

    @Override
    public PaperCard chooseCard(String title, String message, List<PaperCard> list) {
        CardListChooser cardListChooser = new CardListChooser(title, message, list);
        cardListChooser.setVisible(true);
        cardListChooser.dispose();
        return cardListChooser.getSelectedCard();
    }

    @Override
    public int getAvatarCount() {
        if (FSkin.isLoaded()) {
            return FSkin.getAvatars().size();
        }
        return 0;
    }

    @Override
    public int getSleevesCount() {
        if (FSkin.isLoaded()) {
            return FSkin.getSleeves().size();
        }
        return 0;
    }

    @Override
    public String showFileDialog(String title, String defaultDir) {
        JFileChooser fc = new JFileChooser(defaultDir);
        int rc = fc.showDialog(null, title);
        if (rc != 0) {
            return null;
        }
        return fc.getSelectedFile().getAbsolutePath();
    }

    @Override
    public void showBugReportDialog(String title, String text, boolean showExitAppBtn) {
        BugReportDialog.show(title, text, showExitAppBtn);
    }

    @Override
    public File getSaveFile(File defaultFile) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(defaultFile);
        int result = fc.showSaveDialog(null);
        return result == 0 ? fc.getSelectedFile() : null;
    }

    @Override
    public void download(GuiDownloadService service, Callback<Boolean> callback) {
        new GuiDownloader(service, callback).show();
    }

    @Override
    public void refreshSkin() {
    }

    @Override
    public void copyToClipboard(String text) {
        StringSelection ss = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    @Override
    public void browseToUrl(String url) throws IOException, URISyntaxException {
        Desktop.getDesktop().browse(new URI(url));
    }

    @Override
    public IAudioClip createAudioClip(String filename) {
        return AudioClip.fileExists(filename) ? new AudioClip(filename) : null;
    }

    @Override
    public IAudioMusic createAudioMusic(String filename) {
        return new AudioMusic(filename);
    }

    @Override
    public void startAltSoundSystem(String filename, boolean isSynchronized) {
        new AltSoundSystem(filename, isSynchronized).start();
    }

    @Override
    public void clearImageCache() {
        ImageCache.clear();
        ImageKeys.clearMissingCards();
    }

    @Override
    public void showSpellShop() {
        Singletons.getControl().setCurrentScreen(FScreen.QUEST_CARD_SHOP);
        CDeckEditorUI.SINGLETON_INSTANCE.setEditorController(new CEditorQuestCardShop(FModel.getQuest(), CDeckEditorUI.SINGLETON_INSTANCE.getCDetailPicture()));
    }

    @Override
    public void showBazaar() {
        Singletons.getControl().setCurrentScreen(FScreen.QUEST_BAZAAR);
        FScreen.QUEST_BAZAAR.getController().update();
        Singletons.getView().getFrame().validate();
    }

    @Override
    public IGuiGame getNewGuiGame() {
        return new CMatchUI();
    }

    @Override
    public HostedMatch hostMatch() {
        HostedMatch match = new HostedMatch();
        Singletons.getControl().addMatch(match);
        return match;
    }

    @Override
    public void runBackgroundTask(String message, Runnable task) {
        FThreads.invokeInBackgroundThread(task);
    }

    @Override
    public String encodeSymbols(String str, boolean formatReminderText) {
        return FSkin.encodeSymbols(str, formatReminderText);
    }

    @Override
    public void preventSystemSleep(boolean preventSleep) {
        OperatingSystem.preventSystemSleep(preventSleep);
    }

    private static float initializeScreenScale() {
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        AffineTransform at = gc.getDefaultTransform();
        double scaleX = at.getScaleX();
        double scaleY = at.getScaleY();
        return (float)Math.min(scaleX, scaleY);
    }

    @Override
    public float getScreenScale() {
        return screenScale;
    }
}

