/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.ImageCache;
import forge.game.card.CardView;
import forge.game.player.PlayerView;
import forge.util.ImageFetcher;
import forge.util.SwingImageFetcher;
import java.awt.image.BufferedImage;

public abstract class CachedCardImage
implements ImageFetcher.Callback {
    final CardView card;
    final Iterable<PlayerView> viewers;
    final int width;
    final int height;
    static final SwingImageFetcher fetcher = new SwingImageFetcher();

    public CachedCardImage(CardView card, Iterable<PlayerView> viewers, int width, int height) {
        BufferedImage image;
        this.card = card;
        this.viewers = viewers;
        this.width = width;
        this.height = height;
        if (ImageCache.isSupportedImageSize(width, height) && (image = ImageCache.getImageNoDefault(card, viewers, width, height)) == null) {
            String key = card.getCurrentState().getImageKey(viewers);
            System.err.println("Fetch due to missing key: " + key + " for " + card);
            fetcher.fetchImage(key, this);
        }
    }

    public BufferedImage getImage() {
        return ImageCache.getImage(this.card, this.viewers, this.width, this.height);
    }

    @Override
    public abstract void onImageFetched();
}

