/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.util.Arrays;
import regexodus.Block;
import regexodus.Category;
import regexodus.CharacterClass;
import regexodus.Term;
import regexodus.UnicodeConstants;
import regexodus.ds.IntBitSet;

class BlockSet
implements UnicodeConstants {
    private boolean positive = true;
    private boolean isLarge = false;
    private IntBitSet block0 = new IntBitSet();
    private static final IntBitSet emptyBlock0 = new IntBitSet();
    private Block[] blocks;
    private int weight;

    BlockSet() {
    }

    final void reset() {
        this.positive = true;
        this.block0 = null;
        this.blocks = null;
        this.isLarge = false;
        this.weight = 0;
    }

    static void unify(BlockSet bs, Term term) {
        if (bs.isLarge) {
            term.type = 2;
            term.bitset2 = Block.toBitset2(bs.blocks);
        } else {
            term.type = 1;
            term.bitset = bs.block0 == null ? emptyBlock0 : bs.block0;
        }
        term.inverse = !bs.positive;
        term.weight = bs.positive ? bs.weight : 65536 - bs.weight;
    }

    final void setPositive(boolean b) {
        this.positive = b;
    }

    final boolean isPositive() {
        return this.positive;
    }

    final boolean isLarge() {
        return this.isLarge;
    }

    private void enableLargeMode() {
        if (this.isLarge) {
            return;
        }
        Block[] blocks = new Block[256];
        this.blocks = blocks;
        if (this.block0 != null) {
            blocks[0] = new Block(this.block0);
        }
        this.isLarge = true;
    }

    private int getWeight() {
        return this.positive ? this.weight : 65536 - this.weight;
    }

    final void setWordChar(boolean unicode) {
        if (unicode) {
            if (!this.isLarge) {
                this.enableLargeMode();
            }
            this.weight += Block.add(this.blocks, Category.Word.blocks, 0, 255, false);
        } else {
            this.setRange('a', 'z');
            this.setRange('A', 'Z');
            this.setRange('0', '9');
            this.setChar('_');
        }
    }

    final void setDigit(boolean unicode) {
        if (unicode) {
            this.setCategory("Nd");
        } else {
            this.setRange('0', '9');
        }
    }

    final void setSpace(boolean unicode) {
        if (unicode) {
            this.setCategory("G");
        } else {
            this.setChar(' ');
            this.setChar('\r');
            this.setChar('\n');
            this.setChar('\t');
            this.setChar('\f');
        }
    }

    final void setHorizontalSpace(boolean unicode) {
        if (unicode) {
            this.setCategory("Gh");
        } else {
            this.setChar(' ');
            this.setChar('\t');
        }
    }

    final void setVerticalSpace(boolean unicode) {
        if (unicode) {
            this.setCategory("Gv");
        } else {
            this.setChar('\n');
            this.setChar('\r');
            this.setChar('\f');
            this.setChar('\u000b');
        }
    }

    final void setCategory(String c) {
        if (!this.isLarge) {
            this.enableLargeMode();
        }
        Block[] catBits = Category.categories.get((Object)c).blocks;
        this.weight += Block.add(this.blocks, catBits, 0, 255, false);
    }

    final void setChars(String chars) {
        for (int i = chars.length() - 1; i >= 0; --i) {
            this.setChar(chars.charAt(i));
        }
    }

    final void setChar(char c) {
        this.setRange(c, c);
    }

    final void setRange(char c1, char c2) {
        if (c2 >= '\u0100' || this.isLarge) {
            int s2 = 0;
            if (!this.isLarge) {
                this.enableLargeMode();
            }
            Block[] blocks = this.blocks;
            for (int c = c1; c <= c2; ++c) {
                int i2 = c >> 8 & 0xFF;
                int i = c & 0xFF;
                Block block = blocks[i2];
                if (block == null) {
                    blocks[i2] = block = new Block();
                }
                if (!block.set(i)) continue;
                ++s2;
            }
            this.weight += s2;
        } else {
            IntBitSet block0 = this.block0;
            if (block0 == null) {
                this.block0 = block0 = new IntBitSet();
            }
            this.weight += BlockSet.set(block0, c1, c2);
        }
    }

    final void add(BlockSet bs) {
        this.add(bs, false);
    }

    final void add(BlockSet bs, boolean inverse) {
        this.weight += BlockSet.addImpl(this, bs, !bs.positive ^ inverse);
    }

    private static int addImpl(BlockSet bs1, BlockSet bs2, boolean inv) {
        int s2 = 0;
        if (!(bs1.isLarge || bs2.isLarge || inv)) {
            if (bs2.block0 != null) {
                IntBitSet bits = bs1.block0;
                if (bits == null) {
                    bs1.block0 = bits = new IntBitSet();
                }
                s2 += BlockSet.add(bits, bs2.block0, 0, 255, false);
            }
        } else {
            if (!bs1.isLarge) {
                bs1.enableLargeMode();
            }
            if (!bs2.isLarge) {
                bs2.enableLargeMode();
            }
            s2 += Block.add(bs1.blocks, bs2.blocks, 0, 255, inv);
        }
        return s2;
    }

    final void subtract(BlockSet bs) {
        this.subtract(bs, false);
    }

    private void subtract(BlockSet bs, boolean inverse) {
        this.weight += BlockSet.subtractImpl(this, bs, !bs.positive ^ inverse);
    }

    private static int subtractImpl(BlockSet bs1, BlockSet bs2, boolean inv) {
        int s2 = 0;
        if (!(bs1.isLarge || bs2.isLarge || inv)) {
            IntBitSet bits2 = bs2.block0;
            if (bits2 != null) {
                IntBitSet bits1 = bs1.block0;
                if (bits1 == null) {
                    return 0;
                }
                s2 += BlockSet.subtract(bits1, bits2, false);
            }
        } else {
            if (!bs1.isLarge) {
                bs1.enableLargeMode();
            }
            if (!bs2.isLarge) {
                bs2.enableLargeMode();
            }
            s2 += Block.subtract(bs1.blocks, bs2.blocks, 0, 255, inv);
        }
        return s2;
    }

    final void intersect(BlockSet bs) {
        this.intersect(bs, false);
    }

    private void intersect(BlockSet bs, boolean inverse) {
        this.subtract(bs, !inverse);
    }

    static int add(IntBitSet bs1, IntBitSet bs2, int from, int to, boolean inv) {
        int s2 = bs1.cardinality();
        if (inv) {
            bs1.or(bs2.copy().negate());
        } else {
            bs1.or(bs2);
        }
        return bs1.cardinality() - s2;
    }

    static int subtract(IntBitSet bs1, IntBitSet bs2, boolean inv) {
        int s2 = -bs1.cardinality();
        if (inv) {
            bs1.andNot(bs2.copy().negate());
        } else {
            bs1.andNot(bs2);
        }
        return s2 + bs1.cardinality();
    }

    private static int set(IntBitSet arr, int from, int to) {
        int s2 = arr.cardinality();
        arr.set(from, to);
        return arr.cardinality() - s2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.positive) {
            sb.append('^');
        }
        if (this.isLarge) {
            sb.append(CharacterClass.stringValue2(Block.toBitset2(this.blocks)));
        } else if (this.block0 != null) {
            sb.append(CharacterClass.stringValue0(this.block0));
        }
        sb.append('(');
        sb.append(this.getWeight());
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockSet blockSet = (BlockSet)o;
        if (this.positive != blockSet.positive) {
            return false;
        }
        if (this.isLarge != blockSet.isLarge) {
            return false;
        }
        if (this.weight != blockSet.weight) {
            return false;
        }
        if (this.block0 != null ? !this.block0.equals(blockSet.block0) : blockSet.block0 != null) {
            return false;
        }
        return Arrays.equals(this.blocks, blockSet.blocks);
    }

    public int hashCode() {
        int result = this.positive ? 1 : 0;
        result = 31 * result + (this.isLarge ? 1 : 0);
        result = 31 * result + (this.block0 != null ? this.block0.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.blocks);
        result = 31 * result + this.weight;
        return result;
    }
}

