/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.shared;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.fourthline.cling.support.shared.ShutdownHandler;

public class NewPlatformApple {
    public static void setup(ShutdownHandler shutdownHandler, String appName) throws Exception {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", appName);
        System.setProperty("apple.awt.showGrowBox", "true");
        Class<?> appClass = Class.forName("com.apple.eawt.Application");
        Object application = appClass.newInstance();
        Class<?> listenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        Method addAppListmethod = appClass.getDeclaredMethod("addApplicationListener", listenerClass);
        Class<?> adapterClass = Class.forName("com.apple.eawt.ApplicationAdapter");
        Object listener = AppListenerProxy.newInstance(adapterClass.newInstance(), shutdownHandler);
        addAppListmethod.invoke(application, listener);
    }

    static class AppListenerProxy
    implements InvocationHandler {
        private ShutdownHandler shutdownHandler;
        private Object object;

        public static Object newInstance(Object obj, ShutdownHandler shutdownHandler) {
            return Proxy.newProxyInstance(obj.getClass().getClassLoader(), obj.getClass().getInterfaces(), (InvocationHandler)new AppListenerProxy(obj, shutdownHandler));
        }

        private AppListenerProxy(Object obj, ShutdownHandler shutdownHandler) {
            this.object = obj;
            this.shutdownHandler = shutdownHandler;
        }

        @Override
        public Object invoke(Object proxy, Method m4, Object[] args) throws Throwable {
            Object result = null;
            try {
                if ("handleQuit".equals(m4.getName())) {
                    if (this.shutdownHandler != null) {
                        this.shutdownHandler.shutdown();
                    }
                } else {
                    result = m4.invoke(this.object, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
    }
}

