/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna.types;

import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.support.model.dlna.types.NormalPlayTime;

public class NormalPlayTimeRange {
    public static final String PREFIX = "npt=";
    private NormalPlayTime timeStart;
    private NormalPlayTime timeEnd;
    private NormalPlayTime timeDuration;

    public NormalPlayTimeRange(long timeStart, long timeEnd) {
        this.timeStart = new NormalPlayTime(timeStart);
        this.timeEnd = new NormalPlayTime(timeEnd);
    }

    public NormalPlayTimeRange(NormalPlayTime timeStart, NormalPlayTime timeEnd) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
    }

    public NormalPlayTimeRange(NormalPlayTime timeStart, NormalPlayTime timeEnd, NormalPlayTime timeDuration) {
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeDuration = timeDuration;
    }

    public NormalPlayTime getTimeStart() {
        return this.timeStart;
    }

    public NormalPlayTime getTimeEnd() {
        return this.timeEnd;
    }

    public NormalPlayTime getTimeDuration() {
        return this.timeDuration;
    }

    public String getString() {
        return this.getString(true);
    }

    public String getString(boolean includeDuration) {
        String s2 = PREFIX;
        s2 = s2 + this.timeStart.getString() + "-";
        if (this.timeEnd != null) {
            s2 = s2 + this.timeEnd.getString();
        }
        if (includeDuration) {
            s2 = s2 + "/" + (this.timeDuration != null ? this.timeDuration.getString() : "*");
        }
        return s2;
    }

    public static NormalPlayTimeRange valueOf(String s2) throws InvalidValueException {
        return NormalPlayTimeRange.valueOf(s2, false);
    }

    public static NormalPlayTimeRange valueOf(String s2, boolean mandatoryTimeEnd) throws InvalidValueException {
        if (s2.startsWith(PREFIX)) {
            NormalPlayTime timeEnd = null;
            NormalPlayTime timeDuration = null;
            String[] params = s2.substring(PREFIX.length()).split("[-/]");
            switch (params.length) {
                case 3: {
                    if (params[2].length() != 0 && !params[2].equals("*")) {
                        timeDuration = NormalPlayTime.valueOf(params[2]);
                    }
                }
                case 2: {
                    if (params[1].length() != 0) {
                        timeEnd = NormalPlayTime.valueOf(params[1]);
                    }
                }
                case 1: {
                    if (params[0].length() == 0 || mandatoryTimeEnd && (!mandatoryTimeEnd || params.length <= 1)) break;
                    NormalPlayTime timeStart = NormalPlayTime.valueOf(params[0]);
                    return new NormalPlayTimeRange(timeStart, timeEnd, timeDuration);
                }
            }
        }
        throw new InvalidValueException("Can't parse NormalPlayTimeRange: " + s2);
    }
}

