/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.types.BytesRange;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.support.model.dlna.message.header.DLNAHeader;
import org.fourthline.cling.support.model.dlna.types.AvailableSeekRangeType;
import org.fourthline.cling.support.model.dlna.types.NormalPlayTimeRange;

public class AvailableSeekRangeHeader
extends DLNAHeader<AvailableSeekRangeType> {
    public AvailableSeekRangeHeader() {
    }

    public AvailableSeekRangeHeader(AvailableSeekRangeType timeSeekRange) {
        this.setValue(timeSeekRange);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        String[] params;
        if (s2.length() != 0 && (params = s2.split(" ")).length > 1) {
            try {
                AvailableSeekRangeType.Mode mode = null;
                NormalPlayTimeRange timeRange = null;
                BytesRange byteRange = null;
                try {
                    mode = AvailableSeekRangeType.Mode.valueOf("MODE_" + params[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidValueException("Invalid AvailableSeekRange Mode");
                }
                boolean useTime = true;
                try {
                    timeRange = NormalPlayTimeRange.valueOf(params[1], true);
                }
                catch (InvalidValueException timeInvalidValueException) {
                    try {
                        byteRange = BytesRange.valueOf(params[1]);
                        useTime = false;
                    }
                    catch (InvalidValueException bytesInvalidValueException) {
                        throw new InvalidValueException("Invalid AvailableSeekRange Range");
                    }
                }
                if (useTime) {
                    if (params.length > 2) {
                        byteRange = BytesRange.valueOf(params[2]);
                        this.setValue(new AvailableSeekRangeType(mode, timeRange, byteRange));
                    } else {
                        this.setValue(new AvailableSeekRangeType(mode, timeRange));
                    }
                } else {
                    this.setValue(new AvailableSeekRangeType(mode, byteRange));
                }
                return;
            }
            catch (InvalidValueException invalidValueException) {
                throw new InvalidHeaderException("Invalid AvailableSeekRange header value: " + s2 + "; " + invalidValueException.getMessage());
            }
        }
        throw new InvalidHeaderException("Invalid AvailableSeekRange header value: " + s2);
    }

    @Override
    public String getString() {
        AvailableSeekRangeType t2 = (AvailableSeekRangeType)this.getValue();
        String s2 = Integer.toString(t2.getModeFlag().ordinal());
        if (t2.getNormalPlayTimeRange() != null) {
            s2 = s2 + " " + t2.getNormalPlayTimeRange().getString(false);
        }
        if (t2.getBytesRange() != null) {
            s2 = s2 + " " + t2.getBytesRange().getString(false);
        }
        return s2;
    }
}

