/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna;

import java.util.EnumSet;
import java.util.Locale;
import org.fourthline.cling.support.model.dlna.DLNAAttribute;
import org.fourthline.cling.support.model.dlna.DLNAOperations;
import org.fourthline.cling.support.model.dlna.InvalidDLNAProtocolAttributeException;

public class DLNAOperationsAttribute
extends DLNAAttribute<EnumSet<DLNAOperations>> {
    public DLNAOperationsAttribute() {
        this.setValue(EnumSet.of(DLNAOperations.NONE));
    }

    public DLNAOperationsAttribute(DLNAOperations ... op) {
        if (op != null && op.length > 0) {
            DLNAOperations first = op[0];
            if (op.length > 1) {
                System.arraycopy(op, 1, op, 0, op.length - 1);
                this.setValue(EnumSet.of(first, op));
            } else {
                this.setValue(EnumSet.of(first));
            }
        }
    }

    @Override
    public void setString(String s2, String cf) throws InvalidDLNAProtocolAttributeException {
        EnumSet<DLNAOperations> value = EnumSet.noneOf(DLNAOperations.class);
        try {
            int parseInt = Integer.parseInt(s2, 16);
            for (DLNAOperations op : DLNAOperations.values()) {
                int code = op.getCode() & parseInt;
                if (op == DLNAOperations.NONE || op.getCode() != code) continue;
                value.add(op);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (value.isEmpty()) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA operations integer from: " + s2);
        }
        this.setValue(value);
    }

    @Override
    public String getString() {
        int code = DLNAOperations.NONE.getCode();
        for (DLNAOperations op : (EnumSet)this.getValue()) {
            code |= op.getCode();
        }
        return String.format(Locale.ROOT, "%02x", code);
    }
}

