/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.support.model.dlna.DLNAConversionIndicatorAttribute;
import org.fourthline.cling.support.model.dlna.DLNAFlagsAttribute;
import org.fourthline.cling.support.model.dlna.DLNAOperationsAttribute;
import org.fourthline.cling.support.model.dlna.DLNAPlaySpeedAttribute;
import org.fourthline.cling.support.model.dlna.DLNAProfileAttribute;
import org.fourthline.cling.support.model.dlna.InvalidDLNAProtocolAttributeException;
import org.seamless.util.Exceptions;

public abstract class DLNAAttribute<T> {
    private static final Logger log = Logger.getLogger(DLNAAttribute.class.getName());
    private T value;

    public void setValue(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public abstract void setString(String var1, String var2) throws InvalidDLNAProtocolAttributeException;

    public abstract String getString();

    public static DLNAAttribute newInstance(Type type, String attributeValue, String contentFormat) {
        DLNAAttribute attr = null;
        for (int i = 0; i < type.getAttributeTypes().length && attr == null; ++i) {
            Class<? extends DLNAAttribute> attributeClass = type.getAttributeTypes()[i];
            try {
                log.finest("Trying to parse DLNA '" + (Object)((Object)type) + "' with class: " + attributeClass.getSimpleName());
                attr = attributeClass.newInstance();
                if (attributeValue == null) continue;
                attr.setString(attributeValue, contentFormat);
                continue;
            }
            catch (InvalidDLNAProtocolAttributeException ex) {
                log.finest("Invalid DLNA attribute value for tested type: " + attributeClass.getSimpleName() + " - " + ex.getMessage());
                attr = null;
                continue;
            }
            catch (Exception ex) {
                log.severe("Error instantiating DLNA attribute of type '" + (Object)((Object)type) + "' with value: " + attributeValue);
                log.log(Level.SEVERE, "Exception root cause: ", Exceptions.unwrap(ex));
            }
        }
        return attr;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") '" + this.getValue() + "'";
    }

    public static enum Type {
        DLNA_ORG_PN("DLNA.ORG_PN", DLNAProfileAttribute.class),
        DLNA_ORG_OP("DLNA.ORG_OP", DLNAOperationsAttribute.class),
        DLNA_ORG_PS("DLNA.ORG_PS", DLNAPlaySpeedAttribute.class),
        DLNA_ORG_CI("DLNA.ORG_CI", DLNAConversionIndicatorAttribute.class),
        DLNA_ORG_FLAGS("DLNA.ORG_FLAGS", DLNAFlagsAttribute.class);

        private static Map<String, Type> byName;
        private String attributeName;
        private Class<? extends DLNAAttribute>[] attributeTypes;

        @SafeVarargs
        private Type(String attributeName, Class<? extends DLNAAttribute> ... attributeClass) {
            this.attributeName = attributeName;
            this.attributeTypes = attributeClass;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public Class<? extends DLNAAttribute>[] getAttributeTypes() {
            return this.attributeTypes;
        }

        public static Type valueOfAttributeName(String attributeName) {
            if (attributeName == null) {
                return null;
            }
            return byName.get(attributeName.toUpperCase(Locale.ROOT));
        }

        static {
            byName = new HashMap<String, Type>(){
                {
                    for (Type t2 : Type.values()) {
                        this.put(t2.getAttributeName().toUpperCase(Locale.ROOT), t2);
                    }
                }
            };
        }
    }
}

