/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model;

import java.util.HashMap;
import java.util.Map;
import org.fourthline.cling.model.ModelUtil;

public enum StorageMedium {
    UNKNOWN,
    DV,
    MINI_DV("MINI-DV"),
    VHS,
    W_VHS("W-VHS"),
    S_VHS("S-VHS"),
    D_VHS("D-VHS"),
    VHSC,
    VIDEO8,
    HI8,
    CD_ROM("CD-ROM"),
    CD_DA("CD-DA"),
    CD_R("CD-R"),
    CD_RW("CD-RW"),
    VIDEO_CD("VIDEO-CD"),
    SACD,
    MD_AUDIO("M-AUDIO"),
    MD_PICTURE("MD-PICTURE"),
    DVD_ROM("DVD-ROM"),
    DVD_VIDEO("DVD-VIDEO"),
    DVD_R("DVD-R"),
    DVD_PLUS_RW("DVD+RW"),
    DVD_MINUS_RW("DVD-RW"),
    DVD_RAM("DVD-RAM"),
    DVD_AUDIO("DVD-AUDIO"),
    DAT,
    LD,
    HDD,
    MICRO_MV("MICRO_MV"),
    NETWORK,
    NONE,
    NOT_IMPLEMENTED,
    VENDOR_SPECIFIC;

    private static Map<String, StorageMedium> byProtocolString;
    private String protocolString;

    private StorageMedium() {
        this(null);
    }

    private StorageMedium(String protocolString) {
        this.protocolString = protocolString == null ? this.name() : protocolString;
    }

    public String toString() {
        return this.protocolString;
    }

    public static StorageMedium valueOrExceptionOf(String s2) {
        StorageMedium sm = byProtocolString.get(s2);
        if (sm != null) {
            return sm;
        }
        throw new IllegalArgumentException("Invalid storage medium string: " + s2);
    }

    public static StorageMedium valueOrVendorSpecificOf(String s2) {
        StorageMedium sm = byProtocolString.get(s2);
        return sm != null ? sm : VENDOR_SPECIFIC;
    }

    public static StorageMedium[] valueOfCommaSeparatedList(String s2) {
        String[] strings = ModelUtil.fromCommaSeparatedList(s2);
        if (strings == null) {
            return new StorageMedium[0];
        }
        StorageMedium[] result = new StorageMedium[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = StorageMedium.valueOrVendorSpecificOf(strings[i]);
        }
        return result;
    }

    static {
        byProtocolString = new HashMap<String, StorageMedium>(){
            {
                for (StorageMedium e : StorageMedium.values()) {
                    this.put(e.protocolString, e);
                }
            }
        };
    }
}

