/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.sync;

import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.gena.CancelReason;
import org.fourthline.cling.model.gena.LocalGENASubscription;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.gena.IncomingSubscribeRequestMessage;
import org.fourthline.cling.model.message.gena.OutgoingSubscribeResponseMessage;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.resource.ServiceEventSubscriptionResource;
import org.fourthline.cling.protocol.ReceivingSync;
import org.fourthline.cling.transport.RouterException;
import org.seamless.util.Exceptions;

public class ReceivingSubscribe
extends ReceivingSync<StreamRequestMessage, OutgoingSubscribeResponseMessage> {
    private static final Logger log = Logger.getLogger(ReceivingSubscribe.class.getName());
    protected LocalGENASubscription subscription;

    public ReceivingSubscribe(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected OutgoingSubscribeResponseMessage executeSync() throws RouterException {
        ServiceEventSubscriptionResource resource = this.getUpnpService().getRegistry().getResource(ServiceEventSubscriptionResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri());
        if (resource == null) {
            log.fine("No local resource found: " + this.getInputMessage());
            return null;
        }
        log.fine("Found local event subscription matching relative request URI: " + ((StreamRequestMessage)this.getInputMessage()).getUri());
        IncomingSubscribeRequestMessage requestMessage = new IncomingSubscribeRequestMessage((StreamRequestMessage)this.getInputMessage(), (LocalService)resource.getModel());
        if (requestMessage.getSubscriptionId() != null && (requestMessage.hasNotificationHeader() || requestMessage.getCallbackURLs() != null)) {
            log.fine("Subscription ID and NT or Callback in subscribe request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.BAD_REQUEST);
        }
        if (requestMessage.getSubscriptionId() != null) {
            return this.processRenewal((LocalService)resource.getModel(), requestMessage);
        }
        if (requestMessage.hasNotificationHeader() && requestMessage.getCallbackURLs() != null) {
            return this.processNewSubscription((LocalService)resource.getModel(), requestMessage);
        }
        log.fine("No subscription ID, no NT or Callback, neither subscription or renewal: " + this.getInputMessage());
        return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
    }

    protected OutgoingSubscribeResponseMessage processRenewal(LocalService service, IncomingSubscribeRequestMessage requestMessage) {
        this.subscription = this.getUpnpService().getRegistry().getLocalSubscription(requestMessage.getSubscriptionId());
        if (this.subscription == null) {
            log.fine("Invalid subscription ID for renewal request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        log.fine("Renewing subscription: " + this.subscription);
        this.subscription.setSubscriptionDuration(requestMessage.getRequestedTimeoutSeconds());
        if (this.getUpnpService().getRegistry().updateLocalSubscription(this.subscription)) {
            return new OutgoingSubscribeResponseMessage(this.subscription);
        }
        log.fine("Subscription went away before it could be renewed: " + this.getInputMessage());
        return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
    }

    protected OutgoingSubscribeResponseMessage processNewSubscription(LocalService service, IncomingSubscribeRequestMessage requestMessage) {
        List<URL> callbackURLs = requestMessage.getCallbackURLs();
        if (callbackURLs == null || callbackURLs.size() == 0) {
            log.fine("Missing or invalid Callback URLs in subscribe request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        if (!requestMessage.hasNotificationHeader()) {
            log.fine("Missing or invalid NT header in subscribe request: " + this.getInputMessage());
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.PRECONDITION_FAILED);
        }
        Integer timeoutSeconds = this.getUpnpService().getConfiguration().isReceivedSubscriptionTimeoutIgnored() ? null : requestMessage.getRequestedTimeoutSeconds();
        try {
            this.subscription = new LocalGENASubscription(service, timeoutSeconds, callbackURLs){

                @Override
                public void established() {
                }

                @Override
                public void ended(CancelReason reason) {
                }

                @Override
                public void eventReceived() {
                    ReceivingSubscribe.this.getUpnpService().getConfiguration().getSyncProtocolExecutorService().execute(ReceivingSubscribe.this.getUpnpService().getProtocolFactory().createSendingEvent(this));
                }
            };
        }
        catch (Exception ex) {
            log.warning("Couldn't create local subscription to service: " + Exceptions.unwrap(ex));
            return new OutgoingSubscribeResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
        }
        log.fine("Adding subscription to registry: " + this.subscription);
        this.getUpnpService().getRegistry().addLocalSubscription(this.subscription);
        log.fine("Returning subscription response, waiting to send initial event");
        return new OutgoingSubscribeResponseMessage(this.subscription);
    }

    @Override
    public void responseSent(StreamResponseMessage responseMessage) {
        if (this.subscription == null) {
            return;
        }
        if (responseMessage != null && !((UpnpResponse)responseMessage.getOperation()).isFailed() && this.subscription.getCurrentSequence().getValue() == 0L) {
            log.fine("Establishing subscription");
            this.subscription.registerOnService();
            this.subscription.establish();
            log.fine("Response to subscription sent successfully, now sending initial event asynchronously");
            this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(this.getUpnpService().getProtocolFactory().createSendingEvent(this.subscription));
        } else if (this.subscription.getCurrentSequence().getValue() == 0L) {
            log.fine("Subscription request's response aborted, not sending initial event");
            if (responseMessage == null) {
                log.fine("Reason: No response at all from subscriber");
            } else {
                log.fine("Reason: " + responseMessage.getOperation());
            }
            log.fine("Removing subscription from registry: " + this.subscription);
            this.getUpnpService().getRegistry().removeLocalSubscription(this.subscription);
        }
    }

    @Override
    public void responseException(Throwable t2) {
        if (this.subscription == null) {
            return;
        }
        log.fine("Response could not be send to subscriber, removing local GENA subscription: " + this.subscription);
        this.getUpnpService().getRegistry().removeLocalSubscription(this.subscription);
    }
}

