/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.types.csv;

import java.util.ArrayList;
import java.util.List;
import org.fourthline.cling.model.ModelUtil;
import org.fourthline.cling.model.types.Datatype;
import org.fourthline.cling.model.types.InvalidValueException;
import org.seamless.util.Reflections;

public abstract class CSV<T>
extends ArrayList<T> {
    protected final Datatype.Builtin datatype = this.getBuiltinDatatype();

    public CSV() {
    }

    public CSV(String s2) throws InvalidValueException {
        this.addAll(this.parseString(s2));
    }

    protected List parseString(String s2) throws InvalidValueException {
        String[] strings = ModelUtil.fromCommaSeparatedList(s2);
        ArrayList values = new ArrayList();
        for (String string : strings) {
            values.add(this.datatype.getDatatype().valueOf(string));
        }
        return values;
    }

    protected Datatype.Builtin getBuiltinDatatype() throws InvalidValueException {
        Class<?> csvType = Reflections.getTypeArguments(ArrayList.class, this.getClass()).get(0);
        Datatype.Default defaultType = Datatype.Default.getByJavaType(csvType);
        if (defaultType == null) {
            throw new InvalidValueException("No built-in UPnP datatype for Java type of CSV: " + csvType);
        }
        return defaultType.getBuiltinType();
    }

    @Override
    public String toString() {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Object t2 : this) {
            stringValues.add(this.datatype.getDatatype().getString(t2));
        }
        return ModelUtil.toCommaSeparatedList(stringValues.toArray(new Object[stringValues.size()]));
    }
}

