/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.types;

import org.fourthline.cling.model.types.InvalidValueException;

public class PragmaType {
    private String token;
    private boolean quote;
    private String value;

    public PragmaType(String token, String value, boolean quote) {
        this.token = token;
        this.value = value;
        this.quote = quote;
    }

    public PragmaType(String token, String value) {
        this.token = token;
        this.value = value;
    }

    public PragmaType(String value) {
        this.token = null;
        this.value = value;
    }

    public String getToken() {
        return this.token;
    }

    public String getValue() {
        return this.value;
    }

    public String getString() {
        String s2 = "";
        if (this.token != null) {
            s2 = s2 + this.token + "=";
        }
        s2 = s2 + (this.quote ? "\"" + this.value + "\"" : this.value);
        return s2;
    }

    public static PragmaType valueOf(String s2) throws InvalidValueException {
        if (s2.length() != 0) {
            String token = null;
            String value = null;
            boolean quote = false;
            String[] params = s2.split("=");
            if (params.length > 1) {
                token = params[0];
                value = params[1];
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    quote = true;
                    value = value.substring(1, value.length() - 1);
                }
            } else {
                value = s2;
            }
            return new PragmaType(token, value, quote);
        }
        throw new InvalidValueException("Can't parse Bytes Range: " + s2);
    }
}

