/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.meta;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.fourthline.cling.model.Namespace;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.meta.Action;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.DeviceDetails;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.Icon;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.meta.StateVariable;
import org.fourthline.cling.model.meta.UDAVersion;
import org.fourthline.cling.model.resource.Resource;
import org.fourthline.cling.model.resource.ServiceEventCallbackResource;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceId;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;
import org.seamless.util.URIUtil;

public class RemoteDevice
extends Device<RemoteDeviceIdentity, RemoteDevice, RemoteService> {
    public RemoteDevice(RemoteDeviceIdentity identity) throws ValidationException {
        super(identity);
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, RemoteService service) throws ValidationException {
        super((DeviceIdentity)identity, type, details, null, (Service[])new RemoteService[]{service});
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, RemoteService service, RemoteDevice embeddedDevice) throws ValidationException {
        super((DeviceIdentity)identity, type, details, null, (Service[])new RemoteService[]{service}, (Device[])new RemoteDevice[]{embeddedDevice});
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, RemoteService[] services) throws ValidationException {
        super((DeviceIdentity)identity, type, details, null, (Service[])services);
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, RemoteService[] services, RemoteDevice[] embeddedDevices) throws ValidationException {
        super((DeviceIdentity)identity, type, details, null, (Service[])services, (Device[])embeddedDevices);
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, RemoteService service) throws ValidationException {
        super((DeviceIdentity)identity, type, details, new Icon[]{icon}, (Service[])new RemoteService[]{service});
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, RemoteService service, RemoteDevice embeddedDevice) throws ValidationException {
        super((DeviceIdentity)identity, type, details, new Icon[]{icon}, (Service[])new RemoteService[]{service}, (Device[])new RemoteDevice[]{embeddedDevice});
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, RemoteService[] services) throws ValidationException {
        super((DeviceIdentity)identity, type, details, new Icon[]{icon}, (Service[])services);
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon icon, RemoteService[] services, RemoteDevice[] embeddedDevices) throws ValidationException {
        super((DeviceIdentity)identity, type, details, new Icon[]{icon}, (Service[])services, (Device[])embeddedDevices);
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, RemoteService service) throws ValidationException {
        super((DeviceIdentity)identity, type, details, icons, (Service[])new RemoteService[]{service});
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, RemoteService service, RemoteDevice embeddedDevice) throws ValidationException {
        super((DeviceIdentity)identity, type, details, icons, (Service[])new RemoteService[]{service}, (Device[])new RemoteDevice[]{embeddedDevice});
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, RemoteService[] services) throws ValidationException {
        super((DeviceIdentity)identity, type, details, icons, (Service[])services);
    }

    public RemoteDevice(RemoteDeviceIdentity identity, DeviceType type, DeviceDetails details, Icon[] icons, RemoteService[] services, RemoteDevice[] embeddedDevices) throws ValidationException {
        super((DeviceIdentity)identity, type, details, icons, (Service[])services, (Device[])embeddedDevices);
    }

    public RemoteDevice(RemoteDeviceIdentity identity, UDAVersion version, DeviceType type, DeviceDetails details, Icon[] icons, RemoteService[] services, RemoteDevice[] embeddedDevices) throws ValidationException {
        super((DeviceIdentity)identity, version, type, details, icons, (Service[])services, (Device[])embeddedDevices);
    }

    public RemoteService[] getServices() {
        return this.services != null ? (RemoteService[])this.services : new RemoteService[]{};
    }

    public RemoteDevice[] getEmbeddedDevices() {
        return this.embeddedDevices != null ? (RemoteDevice[])this.embeddedDevices : new RemoteDevice[]{};
    }

    public URL normalizeURI(URI relativeOrAbsoluteURI) {
        if (this.getDetails() != null && this.getDetails().getBaseURL() != null) {
            return URIUtil.createAbsoluteURL(this.getDetails().getBaseURL(), relativeOrAbsoluteURI);
        }
        return URIUtil.createAbsoluteURL(((RemoteDeviceIdentity)this.getIdentity()).getDescriptorURL(), relativeOrAbsoluteURI);
    }

    public RemoteDevice newInstance(UDN udn, UDAVersion version, DeviceType type, DeviceDetails details, Icon[] icons, RemoteService[] services, List<RemoteDevice> embeddedDevices) throws ValidationException {
        return new RemoteDevice(new RemoteDeviceIdentity(udn, (RemoteDeviceIdentity)this.getIdentity()), version, type, details, icons, services, embeddedDevices.size() > 0 ? embeddedDevices.toArray(new RemoteDevice[embeddedDevices.size()]) : null);
    }

    @Override
    public RemoteService newInstance(ServiceType serviceType, ServiceId serviceId, URI descriptorURI, URI controlURI, URI eventSubscriptionURI, Action<RemoteService>[] actions, StateVariable<RemoteService>[] stateVariables) throws ValidationException {
        return new RemoteService(serviceType, serviceId, descriptorURI, controlURI, eventSubscriptionURI, actions, stateVariables);
    }

    public RemoteDevice[] toDeviceArray(Collection<RemoteDevice> col) {
        return col.toArray(new RemoteDevice[col.size()]);
    }

    public RemoteService[] newServiceArray(int size) {
        return new RemoteService[size];
    }

    public RemoteService[] toServiceArray(Collection<RemoteService> col) {
        return col.toArray(new RemoteService[col.size()]);
    }

    @Override
    public Resource[] discoverResources(Namespace namespace) {
        ArrayList<Resource> discovered = new ArrayList<Resource>();
        for (RemoteService service : this.getServices()) {
            if (service == null) continue;
            discovered.add(new ServiceEventCallbackResource(namespace.getEventCallbackPath(service), service));
        }
        if (this.hasEmbeddedDevices()) {
            for (RemoteDevice embeddedDevice : this.getEmbeddedDevices()) {
                if (embeddedDevice == null) continue;
                discovered.addAll(Arrays.asList(((Device)embeddedDevice).discoverResources(namespace)));
            }
        }
        return discovered.toArray(new Resource[discovered.size()]);
    }

    @Override
    public RemoteDevice getRoot() {
        if (this.isRoot()) {
            return this;
        }
        RemoteDevice current = this;
        while (current.getParentDevice() != null) {
            current = (RemoteDevice)current.getParentDevice();
        }
        return current;
    }

    @Override
    public RemoteDevice findDevice(UDN udn) {
        return this.find(udn, this);
    }
}

