/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.types.UDN;

public class UDNHeader
extends UpnpHeader<UDN> {
    public UDNHeader() {
    }

    public UDNHeader(UDN udn) {
        this.setValue(udn);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        if (!s2.startsWith("uuid:")) {
            throw new InvalidHeaderException("Invalid UDA header value, must start with 'uuid:': " + s2);
        }
        if (s2.contains("::urn")) {
            throw new InvalidHeaderException("Invalid UDA header value, must not contain '::urn': " + s2);
        }
        UDN udn = new UDN(s2.substring("uuid:".length()));
        this.setValue(udn);
    }

    @Override
    public String getString() {
        return ((UDN)this.getValue()).toString();
    }
}

