/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;

public class MANHeader
extends UpnpHeader<String> {
    public static final Pattern PATTERN = Pattern.compile("\"(.+?)\"(;.+?)??");
    public static final Pattern NAMESPACE_PATTERN = Pattern.compile(";\\s?ns\\s?=\\s?([0-9]{2})");
    public String namespace;

    public MANHeader() {
    }

    public MANHeader(String value) {
        this.setValue(value);
    }

    public MANHeader(String value, String namespace) {
        this(value);
        this.namespace = namespace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setString(String s2) throws InvalidHeaderException {
        Matcher matcher = PATTERN.matcher(s2);
        if (!matcher.matches()) throw new InvalidHeaderException("Invalid MAN header value: " + s2);
        this.setValue(matcher.group(1));
        if (matcher.group(2) == null) return;
        Matcher nsMatcher = NAMESPACE_PATTERN.matcher(matcher.group(2));
        if (!nsMatcher.matches()) throw new InvalidHeaderException("Invalid namespace in MAN header value: " + s2);
        this.setNamespace(nsMatcher.group(1));
    }

    @Override
    public String getString() {
        if (this.getValue() == null) {
            return null;
        }
        StringBuilder s2 = new StringBuilder();
        s2.append("\"").append((String)this.getValue()).append("\"");
        if (this.getNamespace() != null) {
            s2.append("; ns=").append(this.getNamespace());
        }
        return s2.toString();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

