/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.types.BytesRange;
import org.fourthline.cling.model.types.InvalidValueException;

public class ContentRangeHeader
extends UpnpHeader<BytesRange> {
    public static final String PREFIX = "bytes ";

    public ContentRangeHeader() {
    }

    public ContentRangeHeader(BytesRange value) {
        this.setValue(value);
    }

    public ContentRangeHeader(String s2) {
        this.setString(s2);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        try {
            this.setValue(BytesRange.valueOf(s2, PREFIX));
        }
        catch (InvalidValueException invalidValueException) {
            throw new InvalidHeaderException("Invalid Range Header: " + invalidValueException.getMessage());
        }
    }

    @Override
    public String getString() {
        return ((BytesRange)this.getValue()).getString(true, PREFIX);
    }
}

