/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;

public class CallbackHeader
extends UpnpHeader<List<URL>> {
    private static final Logger log = Logger.getLogger(CallbackHeader.class.getName());

    public CallbackHeader() {
        this.setValue(new ArrayList());
    }

    public CallbackHeader(List<URL> urls) {
        this();
        ((List)this.getValue()).addAll(urls);
    }

    public CallbackHeader(URL url) {
        this();
        ((List)this.getValue()).add(url);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        if (s2.length() == 0) {
            return;
        }
        if (!s2.contains("<") || !s2.contains(">")) {
            throw new InvalidHeaderException("URLs not in brackets: " + s2);
        }
        s2 = s2.replaceAll("<", "");
        String[] split = s2.split(">");
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String sp : split) {
                if (!(sp = sp.trim()).startsWith("http://")) {
                    log.warning("Discarding non-http callback URL: " + sp);
                    continue;
                }
                URL url = new URL(sp);
                try {
                    url.toURI();
                }
                catch (URISyntaxException ex) {
                    log.log(Level.WARNING, "Discarding callback URL, not a valid URI on this platform: " + url, ex);
                    continue;
                }
                urls.add(url);
            }
            this.setValue(urls);
        }
        catch (MalformedURLException ex) {
            throw new InvalidHeaderException("Can't parse callback URLs from '" + s2 + "': " + ex);
        }
    }

    @Override
    public String getString() {
        StringBuilder s2 = new StringBuilder();
        for (URL url : (List)this.getValue()) {
            s2.append("<").append(url.toString()).append(">");
        }
        return s2.toString();
    }
}

