/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.discovery;

import org.fourthline.cling.model.Location;
import org.fourthline.cling.model.message.discovery.OutgoingNotificationRequest;
import org.fourthline.cling.model.message.header.InterfaceMacHeader;
import org.fourthline.cling.model.message.header.RootDeviceHeader;
import org.fourthline.cling.model.message.header.USNRootDeviceHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.types.NotificationSubtype;

public class OutgoingNotificationRequestRootDevice
extends OutgoingNotificationRequest {
    public OutgoingNotificationRequestRootDevice(Location location, LocalDevice device, NotificationSubtype type) {
        super(location, device, type);
        this.getHeaders().add(UpnpHeader.Type.NT, new RootDeviceHeader());
        this.getHeaders().add(UpnpHeader.Type.USN, new USNRootDeviceHeader(((DeviceIdentity)device.getIdentity()).getUdn()));
        if ("true".equals(System.getProperty("org.fourthline.cling.network.announceMACAddress")) && location.getNetworkAddress().getHardwareAddress() != null) {
            this.getHeaders().add(UpnpHeader.Type.EXT_IFACE_MAC, new InterfaceMacHeader(location.getNetworkAddress().getHardwareAddress()));
        }
    }
}

