/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Dsn;
import io.sentry.HubAdapter;
import io.sentry.ILogger;
import io.sentry.IScope;
import io.sentry.ITransaction;
import io.sentry.PropagationContext;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanContext;
import io.sentry.TraceContext;
import io.sentry.TracesSamplingDecision;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.protocol.User;
import io.sentry.util.SampleRateUtils;
import io.sentry.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class Baggage {
    @NotNull
    static final String CHARSET = "UTF-8";
    @NotNull
    static final Integer MAX_BAGGAGE_STRING_LENGTH = 8192;
    @NotNull
    static final Integer MAX_BAGGAGE_LIST_MEMBER_COUNT = 64;
    @NotNull
    static final String SENTRY_BAGGAGE_PREFIX = "sentry-";
    @NotNull
    final Map<String, String> keyValues;
    @Nullable
    final String thirdPartyHeader;
    private boolean mutable;
    @NotNull
    final ILogger logger;

    @NotNull
    public static Baggage fromHeader(@Nullable String headerValue) {
        return Baggage.fromHeader(headerValue, false, HubAdapter.getInstance().getOptions().getLogger());
    }

    @NotNull
    public static Baggage fromHeader(@Nullable List<String> headerValues) {
        return Baggage.fromHeader(headerValues, false, HubAdapter.getInstance().getOptions().getLogger());
    }

    @ApiStatus.Internal
    @NotNull
    public static Baggage fromHeader(String headerValue, @NotNull ILogger logger) {
        return Baggage.fromHeader(headerValue, false, logger);
    }

    @ApiStatus.Internal
    @NotNull
    public static Baggage fromHeader(@Nullable List<String> headerValues, @NotNull ILogger logger) {
        return Baggage.fromHeader(headerValues, false, logger);
    }

    @ApiStatus.Internal
    @NotNull
    public static Baggage fromHeader(@Nullable List<String> headerValues, boolean includeThirdPartyValues, @NotNull ILogger logger) {
        if (headerValues != null) {
            return Baggage.fromHeader(StringUtils.join(",", headerValues), includeThirdPartyValues, logger);
        }
        return Baggage.fromHeader((String)null, includeThirdPartyValues, logger);
    }

    @ApiStatus.Internal
    @NotNull
    public static Baggage fromHeader(@Nullable String headerValue, boolean includeThirdPartyValues, @NotNull ILogger logger) {
        @NotNull HashMap<String, String> keyValues = new HashMap<String, String>();
        @NotNull ArrayList<String> thirdPartyKeyValueStrings = new ArrayList<String>();
        boolean mutable = true;
        if (headerValue != null) {
            try {
                String[] keyValueStrings;
                for (String keyValueString : keyValueStrings = headerValue.split(",", -1)) {
                    if (keyValueString.trim().startsWith(SENTRY_BAGGAGE_PREFIX)) {
                        try {
                            int separatorIndex = keyValueString.indexOf("=");
                            String key = keyValueString.substring(0, separatorIndex).trim();
                            String keyDecoded = Baggage.decode(key);
                            String value = keyValueString.substring(separatorIndex + 1).trim();
                            String valueDecoded = Baggage.decode(value);
                            keyValues.put(keyDecoded, valueDecoded);
                            mutable = false;
                        }
                        catch (Throwable e) {
                            logger.log(SentryLevel.ERROR, e, "Unable to decode baggage key value pair %s", keyValueString);
                        }
                        continue;
                    }
                    if (!includeThirdPartyValues) continue;
                    thirdPartyKeyValueStrings.add(keyValueString.trim());
                }
            }
            catch (Throwable e) {
                logger.log(SentryLevel.ERROR, e, "Unable to decode baggage header %s", headerValue);
            }
        }
        String thirdPartyHeader = thirdPartyKeyValueStrings.isEmpty() ? null : StringUtils.join(",", thirdPartyKeyValueStrings);
        return new Baggage(keyValues, thirdPartyHeader, mutable, logger);
    }

    @ApiStatus.Internal
    @NotNull
    public static Baggage fromEvent(@NotNull SentryEvent event, @NotNull SentryOptions options) {
        Baggage baggage = new Baggage(options.getLogger());
        SpanContext trace = event.getContexts().getTrace();
        baggage.setTraceId(trace != null ? trace.getTraceId().toString() : null);
        baggage.setPublicKey(new Dsn(options.getDsn()).getPublicKey());
        baggage.setRelease(event.getRelease());
        baggage.setEnvironment(event.getEnvironment());
        User user = event.getUser();
        baggage.setUserSegment(user != null ? Baggage.getSegment(user) : null);
        baggage.setTransaction(event.getTransaction());
        baggage.setSampleRate(null);
        baggage.setSampled(null);
        @Nullable V replayId = event.getContexts().get("replay_id");
        if (replayId != null && !replayId.toString().equals(SentryId.EMPTY_ID.toString())) {
            baggage.setReplayId(replayId.toString());
            event.getContexts().remove("replay_id");
        }
        baggage.freeze();
        return baggage;
    }

    @ApiStatus.Internal
    public Baggage(@NotNull ILogger logger) {
        this(new HashMap<String, String>(), null, true, logger);
    }

    @ApiStatus.Internal
    public Baggage(@NotNull Baggage baggage) {
        this(baggage.keyValues, baggage.thirdPartyHeader, baggage.mutable, baggage.logger);
    }

    @ApiStatus.Internal
    public Baggage(@NotNull Map<String, String> keyValues, @Nullable String thirdPartyHeader, boolean isMutable, @NotNull ILogger logger) {
        this.keyValues = keyValues;
        this.logger = logger;
        this.mutable = isMutable;
        this.thirdPartyHeader = thirdPartyHeader;
    }

    @ApiStatus.Internal
    public void freeze() {
        this.mutable = false;
    }

    @ApiStatus.Internal
    public boolean isMutable() {
        return this.mutable;
    }

    @Nullable
    public String getThirdPartyHeader() {
        return this.thirdPartyHeader;
    }

    @NotNull
    public String toHeaderString(@Nullable String thirdPartyBaggageHeaderString) {
        StringBuilder sb = new StringBuilder();
        String separator = "";
        int listMemberCount = 0;
        if (thirdPartyBaggageHeaderString != null && !thirdPartyBaggageHeaderString.isEmpty()) {
            sb.append(thirdPartyBaggageHeaderString);
            listMemberCount = StringUtils.countOf(thirdPartyBaggageHeaderString, ',') + 1;
            separator = ",";
        }
        TreeSet<String> keys = new TreeSet<String>(this.keyValues.keySet());
        for (String key : keys) {
            @Nullable String value = this.keyValues.get(key);
            if (value == null) continue;
            if (listMemberCount >= MAX_BAGGAGE_LIST_MEMBER_COUNT) {
                this.logger.log(SentryLevel.ERROR, "Not adding baggage value %s as the total number of list members would exceed the maximum of %s.", key, MAX_BAGGAGE_LIST_MEMBER_COUNT);
                continue;
            }
            try {
                String encodedKey = this.encode(key);
                String encodedValue = this.encode(value);
                String encodedKeyValue = separator + encodedKey + "=" + encodedValue;
                int valueLength = encodedKeyValue.length();
                int totalLengthIfValueAdded = sb.length() + valueLength;
                if (totalLengthIfValueAdded > MAX_BAGGAGE_STRING_LENGTH) {
                    this.logger.log(SentryLevel.ERROR, "Not adding baggage value %s as the total header value length would exceed the maximum of %s.", key, MAX_BAGGAGE_STRING_LENGTH);
                    continue;
                }
                ++listMemberCount;
                sb.append(encodedKeyValue);
                separator = ",";
            }
            catch (Throwable e) {
                this.logger.log(SentryLevel.ERROR, e, "Unable to encode baggage key value pair (key=%s,value=%s).", key, value);
            }
        }
        return sb.toString();
    }

    private String encode(@NotNull String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, CHARSET).replaceAll("\\+", "%20");
    }

    private static String decode(@NotNull String value) throws UnsupportedEncodingException {
        return URLDecoder.decode(value, CHARSET);
    }

    @ApiStatus.Internal
    @Nullable
    public String get(@Nullable String key) {
        if (key == null) {
            return null;
        }
        return this.keyValues.get(key);
    }

    @ApiStatus.Internal
    @Nullable
    public String getTraceId() {
        return this.get("sentry-trace_id");
    }

    @ApiStatus.Internal
    public void setTraceId(@Nullable String traceId) {
        this.set("sentry-trace_id", traceId);
    }

    @ApiStatus.Internal
    @Nullable
    public String getPublicKey() {
        return this.get("sentry-public_key");
    }

    @ApiStatus.Internal
    public void setPublicKey(@Nullable String publicKey) {
        this.set("sentry-public_key", publicKey);
    }

    @ApiStatus.Internal
    @Nullable
    public String getEnvironment() {
        return this.get("sentry-environment");
    }

    @ApiStatus.Internal
    public void setEnvironment(@Nullable String environment) {
        this.set("sentry-environment", environment);
    }

    @ApiStatus.Internal
    @Nullable
    public String getRelease() {
        return this.get("sentry-release");
    }

    @ApiStatus.Internal
    public void setRelease(@Nullable String release) {
        this.set("sentry-release", release);
    }

    @ApiStatus.Internal
    @Nullable
    public String getUserId() {
        return this.get("sentry-user_id");
    }

    @ApiStatus.Internal
    public void setUserId(@Nullable String userId) {
        this.set("sentry-user_id", userId);
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public String getUserSegment() {
        return this.get("sentry-user_segment");
    }

    @Deprecated
    @ApiStatus.Internal
    public void setUserSegment(@Nullable String userSegment) {
        this.set("sentry-user_segment", userSegment);
    }

    @ApiStatus.Internal
    @Nullable
    public String getTransaction() {
        return this.get("sentry-transaction");
    }

    @ApiStatus.Internal
    public void setTransaction(@Nullable String transaction) {
        this.set("sentry-transaction", transaction);
    }

    @ApiStatus.Internal
    @Nullable
    public String getSampleRate() {
        return this.get("sentry-sample_rate");
    }

    @ApiStatus.Internal
    @Nullable
    public String getSampled() {
        return this.get("sentry-sampled");
    }

    @ApiStatus.Internal
    public void setSampleRate(@Nullable String sampleRate) {
        this.set("sentry-sample_rate", sampleRate);
    }

    @ApiStatus.Internal
    public void setSampled(@Nullable String sampled) {
        this.set("sentry-sampled", sampled);
    }

    @ApiStatus.Internal
    @Nullable
    public String getReplayId() {
        return this.get("sentry-replay_id");
    }

    @ApiStatus.Internal
    public void setReplayId(@Nullable String replayId) {
        this.set("sentry-replay_id", replayId);
    }

    @ApiStatus.Internal
    public void set(@NotNull String key, @Nullable String value) {
        if (this.mutable) {
            this.keyValues.put(key, value);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, Object> getUnknown() {
        @NotNull ConcurrentHashMap<String, Object> unknown = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, String> keyValue : this.keyValues.entrySet()) {
            @NotNull String key = keyValue.getKey();
            @Nullable String value = keyValue.getValue();
            if (DSCKeys.ALL.contains(key) || value == null) continue;
            @NotNull String unknownKey = key.replaceFirst(SENTRY_BAGGAGE_PREFIX, "");
            unknown.put(unknownKey, value);
        }
        return unknown;
    }

    @ApiStatus.Internal
    public void setValuesFromTransaction(@NotNull ITransaction transaction, @Nullable User user, @Nullable SentryId replayId, @NotNull SentryOptions sentryOptions, @Nullable TracesSamplingDecision samplingDecision) {
        this.setTraceId(transaction.getSpanContext().getTraceId().toString());
        this.setPublicKey(new Dsn(sentryOptions.getDsn()).getPublicKey());
        this.setRelease(sentryOptions.getRelease());
        this.setEnvironment(sentryOptions.getEnvironment());
        this.setUserSegment(user != null ? Baggage.getSegment(user) : null);
        this.setTransaction(Baggage.isHighQualityTransactionName(transaction.getTransactionNameSource()) ? transaction.getName() : null);
        if (replayId != null && !SentryId.EMPTY_ID.equals(replayId)) {
            this.setReplayId(replayId.toString());
        }
        this.setSampleRate(Baggage.sampleRateToString(Baggage.sampleRate(samplingDecision)));
        this.setSampled(StringUtils.toString(Baggage.sampled(samplingDecision)));
    }

    @ApiStatus.Internal
    public void setValuesFromScope(@NotNull IScope scope, @NotNull SentryOptions options) {
        @NotNull PropagationContext propagationContext = scope.getPropagationContext();
        @Nullable User user = scope.getUser();
        @NotNull SentryId replayId = scope.getReplayId();
        this.setTraceId(propagationContext.getTraceId().toString());
        this.setPublicKey(new Dsn(options.getDsn()).getPublicKey());
        this.setRelease(options.getRelease());
        this.setEnvironment(options.getEnvironment());
        if (!SentryId.EMPTY_ID.equals(replayId)) {
            this.setReplayId(replayId.toString());
        }
        this.setUserSegment(user != null ? Baggage.getSegment(user) : null);
        this.setTransaction(null);
        this.setSampleRate(null);
        this.setSampled(null);
    }

    @Deprecated
    @Nullable
    private static String getSegment(@NotNull User user) {
        if (user.getSegment() != null) {
            return user.getSegment();
        }
        Map<String, String> userData = user.getData();
        if (userData != null) {
            return userData.get("segment");
        }
        return null;
    }

    @Nullable
    private static Double sampleRate(@Nullable TracesSamplingDecision samplingDecision) {
        if (samplingDecision == null) {
            return null;
        }
        return samplingDecision.getSampleRate();
    }

    @Nullable
    private static String sampleRateToString(@Nullable Double sampleRateAsDouble) {
        if (!SampleRateUtils.isValidTracesSampleRate(sampleRateAsDouble, false)) {
            return null;
        }
        DecimalFormat df = new DecimalFormat("#.################", DecimalFormatSymbols.getInstance(Locale.ROOT));
        return df.format(sampleRateAsDouble);
    }

    @Nullable
    private static Boolean sampled(@Nullable TracesSamplingDecision samplingDecision) {
        if (samplingDecision == null) {
            return null;
        }
        return samplingDecision.getSampled();
    }

    private static boolean isHighQualityTransactionName(@Nullable TransactionNameSource transactionNameSource) {
        return transactionNameSource != null && !TransactionNameSource.URL.equals((Object)transactionNameSource);
    }

    @ApiStatus.Internal
    @Nullable
    public Double getSampleRateDouble() {
        String sampleRateString = this.getSampleRate();
        if (sampleRateString != null) {
            try {
                double sampleRate = Double.parseDouble(sampleRateString);
                if (SampleRateUtils.isValidTracesSampleRate(sampleRate, false)) {
                    return sampleRate;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public TraceContext toTraceContext() {
        String traceIdString = this.getTraceId();
        String replayIdString = this.getReplayId();
        String publicKey = this.getPublicKey();
        if (traceIdString != null && publicKey != null) {
            @NotNull TraceContext traceContext = new TraceContext(new SentryId(traceIdString), publicKey, this.getRelease(), this.getEnvironment(), this.getUserId(), this.getUserSegment(), this.getTransaction(), this.getSampleRate(), this.getSampled(), replayIdString == null ? null : new SentryId(replayIdString));
            traceContext.setUnknown(this.getUnknown());
            return traceContext;
        }
        return null;
    }

    @ApiStatus.Internal
    public static final class DSCKeys {
        public static final String TRACE_ID = "sentry-trace_id";
        public static final String PUBLIC_KEY = "sentry-public_key";
        public static final String RELEASE = "sentry-release";
        public static final String USER_ID = "sentry-user_id";
        public static final String ENVIRONMENT = "sentry-environment";
        public static final String USER_SEGMENT = "sentry-user_segment";
        public static final String TRANSACTION = "sentry-transaction";
        public static final String SAMPLE_RATE = "sentry-sample_rate";
        public static final String SAMPLED = "sentry-sampled";
        public static final String REPLAY_ID = "sentry-replay_id";
        public static final List<String> ALL = Arrays.asList("sentry-trace_id", "sentry-public_key", "sentry-release", "sentry-user_id", "sentry-environment", "sentry-user_segment", "sentry-transaction", "sentry-sample_rate", "sentry-sampled", "sentry-replay_id");
    }
}

