/*
 * Decompiled with CFR 0.152.
 */
package forge.util.storage;

import com.google.common.base.Function;
import forge.util.FileUtil;
import forge.util.storage.StorageReaderBase;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class StorageReaderFile<T>
extends StorageReaderBase<T> {
    protected final File file;

    public StorageReaderFile(String pathname, Function<? super T, String> keySelector0) {
        this(new File(pathname), keySelector0);
    }

    public StorageReaderFile(File file0, Function<? super T, String> keySelector0) {
        super(keySelector0);
        this.file = file0;
    }

    @Override
    public String getFullPath() {
        return this.file.getPath();
    }

    @Override
    public Map<String, T> readAll() {
        Map result = this.createMap();
        int idx = 0;
        for (String line : FileUtil.readFile(this.file)) {
            T item;
            if ((line = line.trim()).isEmpty() || !this.lineContainsObject(line) || (item = this.read(line, idx)) == null) continue;
            ++idx;
            String newKey = (String)this.keySelector.apply(item);
            if (result.containsKey(newKey)) {
                System.err.println("StorageReaderFile: Overwriting an object with key " + newKey);
            }
            result.put(newKey, item);
        }
        return result;
    }

    protected abstract T read(String var1, int var2);

    protected boolean lineContainsObject(String line) {
        return !StringUtils.isBlank(line) && !line.trim().startsWith("#");
    }

    @Override
    public String getItemKey(T item) {
        return (String)this.keySelector.apply(item);
    }

    protected void alertInvalidLine(String line, String message) {
        System.err.println(message);
        System.err.println(line);
        System.err.println(this.file.getPath());
        System.err.println();
    }
}

