/*
 * Decompiled with CFR 0.152.
 */
package forge.util.storage;

import com.google.common.base.Function;
import forge.util.IItemSerializer;
import forge.util.TextUtil;
import forge.util.storage.IStorage;
import forge.util.storage.StorageBase;
import forge.util.storage.StorageNestedFolders;
import java.io.File;

public class StorageImmediatelySerialized<T>
extends StorageBase<T> {
    private final IItemSerializer<T> serializer;
    private final IStorage<IStorage<T>> subfolders;
    private final Function<File, IStorage<T>> nestedFactory = new Function<File, IStorage<T>>(){

        @Override
        public IStorage<T> apply(File file) {
            return new StorageImmediatelySerialized(file.getName(), (IItemSerializer)StorageImmediatelySerialized.this.serializer.getReaderForFolder(file), true);
        }
    };

    public StorageImmediatelySerialized(String name, IItemSerializer<T> io) {
        this(name, io, false);
    }

    public StorageImmediatelySerialized(String name, IItemSerializer<T> io, boolean withSubFolders) {
        super(name, io);
        this.serializer = io;
        this.subfolders = withSubFolders ? new StorageNestedFolders<T>(io.getDirectory(), io.getSubFolders(), this.nestedFactory) : null;
    }

    @Override
    public final void add(T item) {
        String name = this.serializer.getItemKey(item);
        this.map.put(name, item);
        this.serializer.save(item);
    }

    @Override
    public final void delete(String itemName) {
        try {
            this.serializer.erase(this.map.remove(itemName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public IStorage<IStorage<T>> getFolders() {
        return this.subfolders == null ? super.getFolders() : this.subfolders;
    }

    @Override
    public IStorage<T> tryGetFolder(String path) {
        String[] parts = TextUtil.split(path, '/', 2);
        switch (parts.length) {
            case 0: {
                return this;
            }
            case 1: {
                return parts[0].equals(".") ? this : this.getFolders().get(parts[0]);
            }
            case 2: {
                IStorage<T> subFolder = this.getFolders().get(parts[0]);
                return subFolder == null ? null : subFolder.tryGetFolder(parts[1]);
            }
        }
        throw new IllegalArgumentException(path);
    }

    @Override
    public IStorage<T> getFolderOrCreate(String path) {
        String[] parts = TextUtil.split(path, '/', 2);
        switch (parts.length) {
            case 0: {
                return this;
            }
            case 1: {
                return parts[0].equals(".") ? this : this.getOrCreateSubfolder(parts[0]);
            }
            case 2: {
                return this.getOrCreateSubfolder(parts[0]).getFolderOrCreate(parts[1]);
            }
        }
        throw new IllegalArgumentException(path);
    }

    private IStorage<T> getOrCreateSubfolder(String name) {
        IStorage<T> storage = this.getFolders().get(name);
        if (null == storage) {
            storage = new StorageImmediatelySerialized<T>(name, this.serializer);
            this.subfolders.add(storage);
        }
        return storage;
    }
}

