/*
 * Decompiled with CFR 0.152.
 */
package forge.util.storage;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import forge.util.IItemReader;
import forge.util.storage.IStorage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StorageBase<T>
implements IStorage<T> {
    protected final Map<String, T> map;
    public static final StorageBase<?> emptyMap = new StorageBase("Empty", null, new HashMap());
    public final String name;
    public final String fullPath;

    public StorageBase(String name0, IItemReader<T> io) {
        this(name0, io.getFullPath(), io.readAll());
    }

    public StorageBase(String name0, String fullPath0, Map<String, T> map0) {
        this.name = name0;
        this.fullPath = fullPath0;
        this.map = map0;
    }

    @Override
    public T get(String name) {
        return this.map.get(name);
    }

    @Override
    public final Collection<String> getItemNames() {
        return new ArrayList<String>(this.map.keySet());
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public boolean contains(String name) {
        return name != null && this.map.containsKey(name);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public T find(Predicate<T> condition) {
        return Iterables.tryFind(this.map.values(), condition).orNull();
    }

    @Override
    public void add(String name, T item) {
        throw new UnsupportedOperationException("This is a read-only storage");
    }

    @Override
    public void add(T item) {
        throw new UnsupportedOperationException("This is a read-only storage");
    }

    @Override
    public void delete(String itemName) {
        throw new UnsupportedOperationException("This is a read-only storage");
    }

    @Override
    public IStorage<IStorage<T>> getFolders() {
        return emptyMap;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getFullPath() {
        if (this.fullPath == null) {
            return this.name;
        }
        return this.fullPath;
    }

    @Override
    public IStorage<T> tryGetFolder(String path) {
        throw new UnsupportedOperationException("This storage does not support subfolders");
    }

    @Override
    public IStorage<T> getFolderOrCreate(String path) {
        throw new UnsupportedOperationException("This storage does not support subfolders");
    }

    public static List<File> getAllFilesList(File downloadDir, FilenameFilter filenameFilter) {
        File[] subFolders;
        File[] filesList = downloadDir.listFiles(filenameFilter);
        ArrayList<File> allFilesList = new ArrayList<File>();
        if (filesList != null) {
            allFilesList.addAll(Arrays.asList(filesList));
        }
        if ((subFolders = downloadDir.listFiles(File::isDirectory)) != null) {
            for (File subFolder : subFolders) {
                allFilesList.addAll(StorageBase.getAllFilesList(subFolder, filenameFilter));
            }
        }
        return allFilesList;
    }
}

