/*
 * Decompiled with CFR 0.152.
 */
package forge.util.maps;

import com.google.common.base.Supplier;
import forge.util.maps.MapOfLists;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class EnumMapOfLists<K extends Enum<K>, V>
extends EnumMap<K, Collection<V>>
implements MapOfLists<K, V> {
    private final Supplier<? extends Collection<V>> factory;
    private static final long serialVersionUID = 4107133987205594272L;

    public EnumMapOfLists(Class<K> keyType, Supplier<? extends Collection<V>> factory) {
        super(keyType);
        this.factory = factory;
    }

    public EnumMapOfLists(EnumMap<K, ? extends List<V>> m4, Supplier<? extends Collection<V>> factory) {
        super(m4);
        this.factory = factory;
    }

    public EnumMapOfLists(Map<K, ? extends List<V>> m4, Supplier<? extends Collection<V>> factory) {
        super(m4);
        this.factory = factory;
    }

    @Override
    public Collection<V> ensureCollectionFor(K key) {
        Collection<V> value = (Collection<V>)this.get(key);
        if (value == null) {
            value = this.factory.get();
            this.put(key, value);
        }
        return value;
    }

    @Override
    public void add(K key, V element) {
        this.ensureCollectionFor(key).add(element);
    }

    @Override
    public void addAll(K key, Collection<V> elements) {
        this.ensureCollectionFor(key).addAll(elements);
    }
}

