/*
 * Decompiled with CFR 0.152.
 */
package forge.util.collect;

import forge.util.FileUtil;
import forge.util.collect.FCollection;
import java.io.File;

public abstract class FCollectionReader<T> {
    protected final File file;

    protected FCollectionReader(String filePath) {
        this.file = new File(filePath);
    }

    void readAll(FCollection<T> collection) {
        for (String line : FileUtil.readFile(this.file)) {
            T item;
            if ((line = line.trim()).isEmpty() || (item = this.read(line)) == null) continue;
            collection.add(item);
        }
    }

    protected void alertInvalidLine(String line, String message) {
        System.err.println(message);
        System.err.println(line);
        System.err.println(this.file.getPath());
        System.err.println();
    }

    protected abstract T read(String var1);
}

