/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.item.PaperCard;
import forge.util.XmlUtil;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlWriter {
    private final Document document;
    private final String filename;
    private final Stack<Element> parentElements = new Stack();
    private Element currentElement;

    public XmlWriter(String filename0, String rootName0) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.document = builder.newDocument();
        this.currentElement = this.document.createElement(rootName0);
        this.document.appendChild(this.currentElement);
        this.filename = filename0;
    }

    public void startElement(String name0) {
        this.parentElements.add(this.currentElement);
        this.currentElement = this.document.createElement(name0);
    }

    public void endElement() {
        Element parentElement = this.parentElements.pop();
        if (parentElement == null) {
            return;
        }
        parentElement.appendChild(this.currentElement);
        this.currentElement = parentElement;
    }

    public void write(String key, String value) {
        this.currentElement.setAttribute(key, value);
    }

    public void write(String key, Enum<?> value) {
        this.write(key, value.name());
    }

    public void write(String key, int value) {
        this.write(key, String.valueOf(value));
    }

    public void write(String key, long value) {
        this.write(key, String.valueOf(value));
    }

    public void write(String key, boolean value) {
        this.write(key, String.valueOf(value));
    }

    public void write(String key, PaperCard value) {
        if (value == null) {
            return;
        }
        this.startElement(key);
        this.write("name", value.getName());
        this.write("set", value.getEdition());
        this.write("art", value.getArtIndex());
        this.endElement();
    }

    public void write(String key, HashSet<PaperCard> value) {
        this.startElement(key);
        for (PaperCard card : value) {
            this.write("card", card);
        }
        this.endElement();
    }

    public void write(String key, IXmlWritable value) {
        if (value == null) {
            return;
        }
        this.startElement(key);
        value.saveToXml(this);
        this.endElement();
    }

    public void write(String key, Iterable<? extends IXmlWritable> value) {
        this.startElement(key);
        for (IXmlWritable iXmlWritable : value) {
            this.write("item", iXmlWritable);
        }
        this.endElement();
    }

    public void write(String key, IXmlWritable[] value) {
        this.startElement(key);
        for (int i = 0; i < value.length; ++i) {
            this.write("i" + i, value[i]);
        }
        this.endElement();
    }

    public void write(String key, Map<String, ? extends IXmlWritable> value) {
        this.startElement(key);
        for (Map.Entry<String, ? extends IXmlWritable> entry : value.entrySet()) {
            this.write(entry.getKey(), entry.getValue());
        }
        this.endElement();
    }

    public void write(String key, EnumMap<? extends Enum<?>, ? extends IXmlWritable> value) {
        this.startElement(key);
        for (Map.Entry<Enum<?>, IXmlWritable> entry : value.entrySet()) {
            this.write(entry.getKey().name(), entry.getValue());
        }
        this.endElement();
    }

    public void close() throws Exception {
        XmlUtil.saveDocument(this.document, this.filename);
    }

    public static interface IXmlWritable {
        public void saveToXml(XmlWriter var1);
    }
}

