/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class Utils {
    public static final boolean DEV_SCREEN_LANDSCAPE = false;
    public static final float BASE_WIDTH = 320.0f;
    public static final float BASE_HEIGHT = 480.0f;
    private static final float SCREEN_WIDTH = Gdx.graphics.getWidth();
    private static final float SCREEN_HEIGHT = Gdx.graphics.getHeight();
    private static final float HEIGHT_RATIO = SCREEN_HEIGHT / 480.0f;
    private static final float AVG_FINGER_SIZE_CM = 1.1f;
    private static final float ppcX = Gdx.graphics.getPpcX();
    private static final float ppcY = Gdx.graphics.getPpcY();
    private static final float MIN_FINGER_SIZE = Utils.scale(40.0f);
    private static final float MIN_FINGERS_WIDE = 5.0f;
    private static final float MIN_FINGERS_TALL = 7.5f;
    public static final float AVG_FINGER_WIDTH = Math.round(Math.min(Math.max(Utils.cmToPixelsX(1.1f), MIN_FINGER_SIZE), SCREEN_WIDTH / 5.0f));
    public static final float AVG_FINGER_HEIGHT = Math.round(Math.min(Math.max(Utils.cmToPixelsY(1.1f), MIN_FINGER_SIZE), SCREEN_HEIGHT / 7.5f));

    public static float cmToPixelsX(float cm) {
        return ppcX * cm;
    }

    public static float cmToPixelsY(float cm) {
        return ppcY * cm;
    }

    public static float scale(float value) {
        return Math.round(value * HEIGHT_RATIO);
    }

    public static long secondsToTimeSpan(float seconds) {
        return (long)(seconds * 1.0E9f);
    }

    public static Vector2 getIntersection(Vector2 l1p1, Vector2 l1p2, Vector2 l2p1, Vector2 l2p2) {
        Vector2 result = new Vector2();
        float d = (l2p2.y - l2p1.y) * (l1p2.x - l1p1.x) - (l2p2.x - l2p1.x) * (l1p2.y - l1p1.y);
        float n_a = (l2p2.x - l2p1.x) * (l1p1.y - l2p1.y) - (l2p2.y - l2p1.y) * (l1p1.x - l2p1.x);
        float n_b = (l1p2.x - l1p1.x) * (l1p1.y - l2p1.y) - (l1p2.y - l1p1.y) * (l1p1.x - l2p1.x);
        if (d != 0.0f) {
            float ua = n_a / d;
            float ub = n_b / d;
            if ((double)ua >= 0.0 && (double)ua <= 1.0 && (double)ub >= 0.0 && (double)ub <= 1.0) {
                result.x = l1p1.x + ua * (l1p2.x - l1p1.x);
                result.y = l1p1.y + ua * (l1p2.y - l1p1.y);
                return result;
            }
        }
        return Utils.getMidpoint(l1p1, l1p2);
    }

    public static Vector2 getMidpoint(Vector2 p1, Vector2 p2) {
        Vector2 result = new Vector2();
        result.x = (p1.x + p2.x) / 2.0f;
        result.y = (p1.y + p2.y) / 2.0f;
        return result;
    }

    public static Vector2 getArbitaryPoint(float x1, float y1, float x2, float y2, float percentage) {
        Vector2 result = new Vector2();
        result.x = x1 * (1.0f - percentage) + x2 * percentage;
        result.y = y1 * (1.0f - percentage) + y2 * percentage;
        return result;
    }

    public static Rectangle getTransitionPosition(Rectangle start, Rectangle end, float percentage) {
        Vector2 topLeft = Utils.getArbitaryPoint(start.x, start.y, end.x, end.y, percentage);
        Vector2 bottomRight = Utils.getArbitaryPoint(start.x + start.width, start.y + start.height, end.x + end.width, end.y + end.height, percentage);
        return new Rectangle(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
    }

    public static Rectangle getIntersection(Rectangle r1, Rectangle r2) {
        float left = Math.max(r1.x, r2.x);
        float right = Math.min(r1.x + r1.width, r2.x + r2.width);
        if (right > left) {
            float top = Math.max(r1.y, r2.y);
            float bottom = Math.min(r1.y + r1.height, r2.y + r2.height);
            if (bottom > top) {
                return new Rectangle(left, top, right - left, bottom - top);
            }
        }
        return null;
    }
}

